#!/bin/sh
#pupget (.tar.gz) and PET (.pet) packages can be downloaded from the official
#Unleashed repositories, then this script used to expand them.

[ ! -d ../puppy-unleashed ] && exit 1
[ ! -d ./packages ] && exit 1
cd ./packages
sync

#DIRENTRIES="`ls -1 | grep -v "expandtarballs.sh" | grep --extended-regexp '\.gz$|\.pet$' | tr "\n" " "`"
DIRENTRIES="`ls -1 | grep --extended-regexp '\.gz$|\.pet$' | tr "\n" " "`"

for ONEENTRY in $DIRENTRIES
do
 if [ ! "`echo -n "$ONEENTRY" | grep '\.pet$'`" = "" ];then
  pet2tgz $ONEENTRY
  if [ $? -ne 0 ];then
   echo "${ONEENTRY} failed md5sum checksum test. Skipping."
   rm -f $ONEENTRY
   continue
  fi
  sync
  ONEBASE="`basename $ONEENTRY .pet`"
  ONEDIR="`dirname $ONEENTRY`"
  ONEENTRY="${ONEDIR}/${ONEBASE}.tar.gz"
 else
  ONEBASE="`basename $ONEENTRY .tar.gz`"
 fi
 if [ -e $ONEBASE ];then #in case both .tar.gz and .pet downloaded
  rm -f $ONEENTRY
  continue
 fi
 tar -zxf $ONEENTRY
 sync
 rm -f $ONEENTRY
done
cd ..
echo "Finished"
###END###
