/**************************************************************************
   zlib.h      include file for zlib functions                      v.13
   Free software licensed under GNU General Public License v.2
   source:  http://kornelix.squarespace.com/utilities
***************************************************************************/

#include <sys/time.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdarg.h>
#include <setjmp.h>
#include <pthread.h>
#include <errno.h>
#include <signal.h>

#define  int8   char                                                       //  number types
#define  int16  short
#define  int32  long
#define  int64  long long
#define  uchar  unsigned char
#define  cchar  const char
#define  dub    double

#define  mutex          pthread_mutex_t                                    //  abbreviations
#define  mutex_init     pthread_mutex_init
#define  mutex_lock     pthread_mutex_lock
#define  mutex_unlock   pthread_mutex_unlock
#define  mutex_destroy  pthread_mutex_destroy

#define  idcc   50                                                         //  max. symbol/value cc
#define  maxfcc 1000                                                       //  max. pathname/filename cc tolerated
#define  null   NULL
#define  true   1
#define  false  0

//  system functions ======================================================

char * syserrText(int err = 0);                                            //  get sys error text (err > 0, else errno)
void appcrash(char * pMess, ... );                                         //  fatal exit - works like printf
void apppause();                                                           //  output message and wait for user
void apppause(char * pMess, ... );                                         //    - works like printf
void start_timer(timeval *time0);                                          //  start a timer
double get_timer(timeval *time0);                                          //  get elapsed time in seconds
double CPUtime();                                                          //  get process CPU time used
void start_CPUtimer(double *time0);                                        //  start a process CPU timer
double get_CPUtimer(double *time0);                                        //  get elapsed CPU time, seconds
void synch_threads(int NT = 0);                                            //  synchronize NT threads
void zsleep(double dsecs);                                                 //  sleep specified seconds
char * zmalloc(size_t bytes, int log = 0);                                 //  malloc() with auto crash and log option  v.07
char * zmalloc0(size_t bytes, int log = 0);                                //  zmalloc() and clear to zeros   v.13
void zfree(void *address, int log = 0);                                    //  free() with log option  v.07
int createProc(char * command);                                            //  create subprocess  v.03
int getProcOutput(char * buff, int bcc, int &cstat);                       //  get output record from subprocess
int signalProc(char * pname, char * signal);                               //  pause/resume/kill subprocess
char * fgets_trim(char * buff, int maxcc, FILE *, int bf = 0);             //  fgets + trim trailing \n \r (opt. blanks)
int lrandz(int64 * seed);                                                  //  returns 0 to 0x7fffffff
double drandz(int64 * seed);                                               //  returns 0.0 to 0.99999...
int samedirk(const char *file1, const char *file2);                        //  returns 1 if files in same directory   v.08

//  string macros and functions ===========================================

#define strEqu(str1,str2) (! strcmp((str1),(str2)))                        //  TRUE if strings compare equal
#define strNeq(str1,str2) (strcmp((str1),(str2)))                          //  TRUE if strings compare not-equal
#define strnEqu(str1,str2,cc) (! strncmp((str1),(str2),(cc)))              //  TRUE if strings[cc] compare equal
#define strnNeq(str1,str2,cc) (strncmp((str1),(str2),(cc)))                //  TRUE if strings[cc] compare not-equal

char * strField(const char * string, const char *delims, int Nth);         //  get Nth delimited field from string  v.09
char * strField(const char * string, const char delim, int Nth);           //  get Nth delimited field from string  v.09
int strParms(int &begin, const char *input,                                //  parse string: name1=val1 | name2 ...   v.08
               char *pname, int maxcc, double &pval);
int strHash(const char *string, int max);                                  //  string --> random int 0 to max-1
const char * strHash2(const char *string, int outcc);                      //  string --> random printable string[outcc]
void strncpy0(char * dest, const char * src, int cc);                      //  strncpy + dest[cc-1] = 0
void strnPad(char * dest, const char * src, int cc);                       //  strncpy with blank padding to cc
int strTrim(char * dest, const char * src);                                //  remove trailing blanks
int strTrim(char * string);                                                //  remove trailing blanks
int strCompress(char * dest, const char * sorc);                           //  copy & remove imbedded blanks
int strCompress(char * string);                                            //  remove imbedded blanks
int strncatv(char * dest, int maxcc, const char * source, ...);            //  catenate strings (last = 0L) 
int strcmpv(const char * string, ...);                                     //  compare string to N other strings
void strToUpper(char * dest, const char * source);                         //  move and conv. string to upper case
void strToUpper(char * string);                                            //  conv. string to upper case
void strToLower(char * dest, const char * source);                         //  move and conv. string to lower case
void strToLower(char * string);                                            //  conv. string to lower case
int repl_1str(char *strin, char *strout, char *ssin, char *ssout);         //  copy string and replace 1 substring
int repl_Nstrs(char *strin, char* strout, ...);                            //  copy string and replace N substrings
void strncpyx(char * dest, const char * source, int scc);                  //  conv. string to hex format
void StripZeros(char * pNum);                                              //  1.230000E+12 --> 1.23E+12
int is_blank_null(const char *string);                                     //  test for blank/null string

//  bitmap functions ======================================================  v.09

struct bitmap {
   int      nbits;                                                         //  declare bitmap: bitmap  *bmap
   uchar    *bits;
};

bitmap * bitmap_new(int nbits);                                            //  create and initialize all bits to zero
void bitmap_set(bitmap *bm, int bit, bool value);                          //  set a bit true or false
bool bitmap_get(bitmap *bm, int bit);                                      //  get a bit value, true or false
void bitmap_delete(bitmap *bm);                                            //  delete bitmap, release memory

//  variable string list functions ========================================  v.07

struct  pvlist {
   int      max;                          //  max. entries
   int      act;                          //  actual entries
   char   **list;                         //  entries
};

pvlist * pvlist_create(int max);                                           //  create pvlist
void pvlist_free(pvlist *pv);                                              //  free pvlist
int pvlist_append(pvlist *pv, const char *entry, int unique = 0);          //  append new entry (opt. if unique)
int pvlist_prepend(pvlist *pv, const char *entry, int unique = 0);         //  prepend new entry (opt. if unique)
int pvlist_find(pvlist *pv, const char *entry);                            //  find entry by name
int pvlist_remove(pvlist *pv, const char *entry);                          //  remove entry by name
int pvlist_remove(pvlist *pv, int Nth);                                    //  remove entry by number (0...)
int pvlist_count(pvlist *pv);                                              //  return entry count
int pvlist_replace(pvlist *pv, int Nth, char *entry);                      //  replace Nth entry (0...)     v.09
char * pvlist_get(pvlist *pv, int Nth);                                    //  return Nth entry (0...)
int pvlist_sort(pvlist *pv);                                               //  sort list, ascending         v.09

//  number conversion =====================================================

int convSI (cchar *string, int &inum, cchar **delim = 0);                  //  string to int                delim added  v.11
int convSI (cchar *string, int &inum, int low, int hi, cchar **delim = 0); //  (with low/high limit checking)
int convSD (cchar *string, dub &dnum, cchar **delim = 0);                  //  string to double
int convSD (cchar *string, dub &dnum, dub low, dub hi, cchar **delim = 0); //  (with low/high limit checking)
int convIS (int in, char *out, int &cc);                                   //  int to string, returned cc
int convDS (dub in, int prec, char *out, int &cc);                         //  double to string, digits of precision, returned cc

//  wildcard routines =====================================================

int MatchWild(const char * wildstr, const char * str);                     //  wildcard string match (0)
const char * SearchWild(const char *wpath, int &flag);                     //  wildcard file search

//  search and sort functions =============================================

int bsearch(int element, int nn, int list[]);                              //  binary search sorted list[nn]

typedef int HeapSortUcomp(const char * rec1, const char * rec2);           //  compare recs: return -1/0/+1 if rec1 </=/> rec2
void HeapSort(int vv[], int nn);                                           //  Heap Sort - integer
void HeapSort(float vv[], int nn);                                         //  Heap Sort - float
void HeapSort(double vv[], int nn);                                        //  Heap Sort - double
void HeapSort(char * vv[], int nn);                                        //  Heap Sort - char *, ascending order
void HeapSort(char * vv[], int nn, HeapSortUcomp);                         //  Heap Sort - char *, user-defined order  v.06
void HeapSort(char * recs, int RL, int NR, HeapSortUcomp);                 //  Heap Sort - records, user-defined order
int MemSort(char * RECS, int RL, int NR, int KEYS[][3], int NK);           //  memory sort, records with multiple keys

//  quick math functions ==================================================  v.02
//  (faster than C-lib, reduced accuracy, limited argument range)

double qsine(double);                                                      //  quick sine
double qcosine(double);                                                    //  quick cosine
double qarcsine(double);                                                   //  quick arc sine
double qsqrt(double);                                                      //  quick square root   v.06


/**************************************************************************
   GTK utility functions
***************************************************************************/

#include <gtk/gtk.h>

#define  zdcbmax 50                                                        //  max. combo box drop-down list

void zappcrash(char *pMessage, ...);                                       //  crash with popup message

void zlockInit();                                                          //  for threaded applications
void zlock();  
void zunlock();

void zmainloop();                                                          //  do main loop, process menu events

void zmessageACK(char *pMess, ... );                                       //  display message, wait for OK
int zmessageYN(char *pMess, ... );                                         //  display message, wait for YES or NO

const char * dialogText(const char * title, const char * inittext);        //  get text (1-2 lines) from user

void wprintx(GtkWidget *Win, int line,                                     //  write text to line +-N with
                const char *mess, const char *font = 0);                   //    optional font specification  v.07

void wprintf(GtkWidget *Win, int line, char *mess, ...);                   //  "printf" version
void wprintf(GtkWidget *Win, char *mess, ... );                            //  "printf" to next line, scrolling output

void wclear(GtkWidget *Win);                                               //  clear window
void wclear(GtkWidget *Win, int line);                                     //  clear from line to end

char * wscanf(GtkWidget *Win, int &ftf);                                   //  get text lines from edit widget

int wfiledump(GtkWidget *Win, char *filespec);                             //  dump text window into file
void wfilesave(GtkWidget *Win);                                            //  wfiledump() via file-chooser dialog
void wprintp(GtkWidget *Win);                                              //  print text window to default printer

char * zgetfile(char *title, char *file, char *action, char *buttx = 0);   //  file chooser dialog       v.10

/**************************************************************************/

//  application initialization                                             //  v.07

void initz_appfiles(const char *appfile, ...);                             //  setup application files
char * getz_exedirk();                                                     //  return execution directory
char * getz_appdirk();                                                     //  return app directory (/home/user/.appname/)
void showz_helpfile();                                                     //  show help file in new process

/**************************************************************************/

//  functions to simplify building menus, tool bars, status bars    v.06

typedef void respFunc(GtkWidget *, const char *mname);                     //  menu or button response function

int create_menubar(GtkWidget *vbox);                                       //  create menubar in vertical packing box
int add_menubar_item(int mbar, const char *mname, respFunc func = 0);      //  add menu item to menubar
int add_submenu_item(int mitem, const char *subname, respFunc func = 0);   //  add submenu item to menu item

int create_toolbar(GtkWidget *vbox, int iconsize = 24, int vert = 0);      //  create horiz. toolbar in packing box (or vert.)
int add_toolbar_button(int tbar, const char *lab, const char *tip,         //  add button with stock icon ("gtk-quit")
                                 const char *icon, respFunc func);         //    or custom icon ("iconfile.png")
int add_toolbar_menu(int tbar, const char *lab, const char *icon);         //  add button-activated menu *** no work  v.09

int create_stbar(GtkWidget *box);                                          //  create status bar in packing box
int stbar_message(int stbar, const char *message);                         //  display message in status bar

#define G_SIGNAL(window,event,func,arg)                 \
   g_signal_connect(G_OBJECT(window),event,G_CALLBACK(func),(void *) arg);

/**************************************************************************/

//   functions to implement dialogs with less complexity
//   widgets supported: dialog, hbox, vbox, hsep, vsep, frame, scrwin, label, 
//                      entry, edit, radio, check, button, togbutt, spin, 
//                      combo, hscale, vscale
   
typedef struct zdialog  {
         void        *eventCB;            //  widget event user callback function
         void        *complCB;            //  dialog completion user callback function
         int         zstat;               //  dialog status (from completion button)
      struct  {                           //  widget data structure
         const char  *type;               //  dialog, hbox, vbox, label, entry ...
         const char  *name;               //  widget name
         const char  *pname;              //  parent (container) name
         char        *data;               //  widget data, initial / returned
         pvlist      *cblist;             //  combo box drop-down list
         int         scc;                 //  entry widget: text cc width
         int         homog;               //  hbox/vbox: equal spacing flag
         int         expand;              //  expandable flag
         int         space;               //  extra padding space (pixels)
         GtkWidget   *widget;             //  GTK widget pointer
      }  
      widget[100];                        //  zdialog widgets (eof = type = 0)
};

zdialog *zdialog_new(const char *title, ...);                              //  create a zdialog with opt. buttons

int zdialog_add_widget(zdialog *zd,                                        //  add widget to zdialog
      const char *type, const char *name, const char *pname,               //  required args
      const char *data = 0, int scc = 0, int homog = 0,                    //  optional args
      int expand = 0, int space = 0);

int zdialog_add_widget(zdialog *zd,                                        //  add widget to zdialog
      const char *type, const char *name, const char *pname,               //  (alternative form)                v.08
      const char *data, const char *options);                              //  "scc=nn|homog|expand|space=nn"    v.11

int zdialog_resize(zdialog *zd, int width, int height);                    //  set size > widget sizes
int zdialog_put_data(zdialog *zd, const char *name, const char *data);     //  put data in widget (entry, spin ...)
const char * zdialog_get_data(zdialog *zd, const char *name);              //  get widget data
GtkWidget * zdialog_widget(zdialog *zd, const char *name);                 //  GTK widget from zdialog widget name

typedef int zdialog_event(zdialog *zd, const char * name);                 //  widget event callback function
typedef int zdialog_compl(zdialog *zd, int zstat);                         //  dialog completion callback function
int zdialog_run(zdialog *zd, zdialog_event = 0, zdialog_compl = 0);        //  run dialog (compl func >> non-modal)
int zdialog_destroy(zdialog *zd);                                          //  destroy dialog (caller resp.)
int zdialog_free(zdialog *zd);                                             //  free zdialog memory

int zdialog_stuff(zdialog *zd, const char *name, const char *data);        //  stuff string data into widget
int zdialog_stuff(zdialog *zd, const char *name, int  data);               //  stuff int data
int zdialog_stuff(zdialog *zd, const char *name, double data);             //  stuff double data

int zdialog_fetch(zdialog *zd, const char *name, char *data, int maxcc);   //  get string data from widget
int zdialog_fetch(zdialog *zd, const char *name, int  &data);              //  get int data
int zdialog_fetch(zdialog *zd, const char *name, double &data);            //  get double data

int zdialog_cb_app(zdialog *zd, const char *name, const char *data);       //  append entry to combo drop down list  v.07
int zdialog_cb_prep(zdialog *zd, const char *name, const char *data);      //  prepend entry to combo deop down list
char * zdialog_cb_get(zdialog *zd, const char *name, int Nth);             //  get combo drop down list Nth entry

/**************************************************************************/

//  parameter management functions

int initParmlist(int max);                                                 //  initz. parameter list
int loadParms(char * filename);                                            //  load parameters from a file
int loadParms();                                                           //   + user file select dialog
int saveParms(char * filename);                                            //  save parameters to a file
int saveParms();                                                           //   + user file select dialog
int setParm(const char * parmname, double parmval);                        //  set parameter value
double getParm(const char * parmname);                                     //  get parameter value
char * getParm(int Nth);                                                   //  get Nth parameter name (0-based)
int listParms(GtkWidget *textWin);                                         //  list all parameters in given window  v.06
int editParms(GtkWidget *textWin = 0, int addp = 0);                       //  parameter editor

/**************************************************************************/

//  misc. GTK/GDK utility functions

GdkPixbuf * gdk_pixbuf_rotate(GdkPixbuf *pixbuf, double angle);            //  rotate pixbuf through any angle

char * track_image_files(char *file, char *action, int Nth = 0);           //  get prev/next image file in directory  v.08
void get_image_counts(int &posn, int &count);                              //  get current image position and total count

typedef void txfunc(char *file);                                           //  create thumbnail index window and     v.08
void thumbnail_index(char *file, char * action, txfunc func = 0);          //    receive clicked file selections


/**************************************************************************
   C++ classes
***************************************************************************/

//  dynamic string class ==================================================

class xstring
{
      static int  tcount;                                                  //  total xstring count
      static int  tmem;                                                    //  total memory used
      int         wmi;                                                     //  internal ID
      int         xcc;                                                     //  actal cc (excl. NULL)
      int         xmem;                                                    //  memory allocated cc
      char      * xpp;                                                     //  memory pointer
   public:
      xstring(int cc = 0);                                                 //  default constructor
      xstring(const char * );                                              //  string constructor
      xstring(const xstring &);                                            //  copy constructor
      ~xstring();                                                          //  destructor
      operator const char * () const { return xpp; }                       //  conversion operator (const char *)
      xstring operator= (const xstring &);                                 //  operator =
      xstring operator= (const char *);                                    //  operator =
      friend xstring operator+ (const xstring &, const xstring &);         //  operator +
      friend xstring operator+ (const xstring &, const char *);            //  operator +
      friend xstring operator+ (const char *, const xstring &);            //  operator +
      void insert(int pos, const char * string, int cc = 0);               //  insert substring at position (expand)
      void overlay(int pos, const char * string, int cc = 0);              //  overlay substring (possibly expand)
      static void getStats(int & tcount2, int & tmem2);                    //  get statistics
      void validate() const;                                               //  verify integrity
      int getcc() const { return xcc; }                                    //  return string length
};

//  vector (array) of xstring =============================================

class Vxstring
{
   int        nd;                                                          //  count
   xstring  * pdata;                                                       //  xstring[nd]
public:
   Vxstring(int = 0);                                                      //  constructor
   ~Vxstring();                                                            //  destructor
   Vxstring(const Vxstring &);                                             //  copy constructor
   Vxstring operator= (const Vxstring &);                                  //  operator =
   xstring & operator[] (int);                                             //  operator []
   const xstring & operator[] (int) const;                                 //  operator [] (const)
   int search(const char * string);                                        //  find element in unsorted Vxstring
   int bsearch(const char * string);                                       //  find element in sorted Vxstring
   int sort(int nkeys, int keys[][3]);                                     //  sort elements by designated subfields
   int sort(int pos = 0, int cc = 0);                                      //  sort elements by 1 subfield (cc 0 = all)
   int getCount() const { return nd; }                                     //  get current count
};

//  hash table class ======================================================

class HashTab
{
   static int trys1;                                                       //  insert trys
   static int trys2;                                                       //  find/delete trys
   int     cap;                                                            //  table capacity
   int     count;                                                          //  strings contained
   int     cc;                                                             //  string length
   char  * table;                                                          //  table[cc][cap]
public:
   HashTab(int cc, int cap);                                               //  constructor
   ~HashTab();                                                             //  destructor
   int Add(const char * string);                                           //  add a new string
   int Del(const char * string);                                           //  delete a string
   int Find(const char * string);                                          //  find a string
   int GetCount() { return count; };                                       //  get string count
   int GetNext(int & first, char * string);                                //  get first/next string
   int Dump();                                                             //  dump hash table
};

//  Queue class, FIFO, LIFO or mixed ======================================

class  Queue
{
   char        wmi[8];
   Vxstring  * vd;                                                         //  vector of xstrings
   mutex       qmutex;                                                     //  for multi-thread access
   int         qcap;                                                       //  queue capacity
   int         qcount;                                                     //  curr. queue count
   int         ent1;                                                       //  first entry pointer
   int         entN;                                                       //  last entry pointer
   char      * lastent;                                                    //  last entry retrieved
   int         lcc;                                                        //  last entry cc
private:
   void lock();                                                            //  auto locking and unlocking
   void unlock();                                                          //  (for multi-thread access)
public:
   Queue(int cap);                                                         //  create queue with capacity
   ~Queue();                                                               //  destroy queue
   int getCount();                                                         //  get current entry count
   int push(const xstring * entry, double secs);                           //  add new entry with max. wait time
   xstring * pop1();                                                       //  get 1st entry (oldest)
   xstring * popN();                                                       //  get Nth entry (newest)
};

/*  =======================================================================

       Tree class  

       put(): cc is data length to store
       get(): cc is max. data length to retrieve
              actual length is returned, = 0 if not found
              nn is array count for nodes[] arguments
*/

class  Tree
{
   int         wmi;                                                        //  for ID checking
   char       *tname;                                                      //  tree name
   int         tmem;                                                       //  tree data memory
   void       *tdata;                                                      //  tree data[tmem]
   int         nsub;                                                       //  no. sub-nodes (Trees)
   Tree      **psub;                                                       //  pointer to sub-nodes
public:
   Tree(char * name);                                                      //  create Tree
   ~Tree();                                                                //  destroy Tree
   int put(void * data, int cc, char * nodes[], int nn);                   //  put data by node names[]
   int put(void * data, int cc, int nodes[], int nn);                      //  put data by node numbers[]
   int get(void * data, int cc, char * nodes[], int nn);                   //  get data by node names[]
   int get(void * data, int cc, int nodes[], int nn);                      //  get data by node numbers[]
   void stats(int nnodes[], int ndata[]);                                  //  get nodes and data per level
   void dump(int level = 0);                                               //  diagnostic
private:
   Tree * find(char * nodes[], int nn);                                    //  find a sub-node by names[]
   Tree * find(int nodes[], int nn);                                       //  find a sub-node by numbers[]
   Tree * make(char * nodes[], int nn);                                    //  find/create a sub-node by names[]
   Tree * make(int nodes[], int nn);                                       //  find/create a sub-node by numbers[]
};



