/*
 * ʸδط
 * Copyright (C) 2006 Higashiyama Masahiko (thanks google summer of code program)
 * Copyright (C) 2002-2007 TABATA Yusuke
 *
 * anthy_reorder_candidates_by_relation()
 *
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdlib.h>

#include <anthy/segclass.h>
#include <anthy/segment.h>
#include <anthy/ordering.h>
#include <anthy/dic.h>
#include <anthy/diclib.h>
#include <anthy/feature_set.h>
#include "sorter.h"

static const void *reorder_info;

/** ʸ@seg@from_word_idñȶطˤ
 *  䤬뤫ɤõХ夲롣
 */
static void
reorder_candidate(int from_word_id, struct seg_ent *seg)
{
  int i, pos;
  struct cand_ent *ce = seg->cands[0];
  if (ce->core_elm_index == -1) {
    return ;
  }
  /* 0ܤθʻ */
  pos = anthy_wtype_get_pos(ce->elm[ce->core_elm_index].wt);

  for (i = 0; i < seg->nr_cands; i++) {
    int word_id;
    ce = seg->cands[i];
    if (ce->core_elm_index == -1) {
      continue;
    }
    word_id = ce->elm[ce->core_elm_index].id;
    if (anthy_dic_check_word_relation(from_word_id, word_id) &&
	anthy_wtype_get_pos(ce->elm[ce->core_elm_index].wt) == pos) {
      /* ˥ޥåΤǡΥ򹹿 */
      ce->flag |= CEF_USEDICT;
      ce->score *= 10;
    }
  }
}

static void
reorder_by_use_dict(struct segment_list *sl, int nth)
{
  int i;
  struct seg_ent *cur_seg;
  struct cand_ent *ce;
  int word_id;

  cur_seg = anthy_get_nth_segment(sl, nth);
  if (cur_seg->cands[0]->core_elm_index == -1) {
    /* ܤθ䤬seq_ent줿ǤϤʤ */
    return ;
  }
  ce = cur_seg->cands[0];
  /* ΩidФ */
  word_id = ce->elm[ce->core_elm_index].id;
  if (word_id == -1) {
    /**/
    return ;
  }
  /* ʸ˸Ƥ */
  for (i = nth - 2; i < nth + 2 && i < sl->nr_segments; i++) {
    struct seg_ent *target_seg;
    if (i < 0 || i == nth) {
      continue ;
    }
    /* iܤʸjܤʸФ */
    target_seg = anthy_get_nth_segment(sl, i);
    reorder_candidate(word_id, target_seg);
  }
}

static int
cand_hash(struct cand_ent *cand)
{
  if (cand->core_elm_index == -1) {
    return 0;
  }
  return cand->elm[cand->core_elm_index].id;
}

static void
do_reorder_by_corpus(struct seg_ent *cur_seg, struct seg_ent *ctx)
{
  int hash, ctx_hash;
  int f[3];
  struct feature_freq freq, top_freq;
  struct feature_freq *res;
  int i;
  hash = cand_hash(cur_seg->cands[0]);
  if (ctx) {
    ctx_hash = cand_hash(ctx->cands[0]);
  } else {
    ctx_hash = 0;
  }
  f[0] = hash;
  f[1] = 0;
  f[2] = ctx_hash;
  res = anthy_find_array_freq(reorder_info, f, 3, &top_freq);
  if (!res) {
    return ;
  }
  /**/
  for (i = 1; i < cur_seg->nr_cands; i++) {
    struct cand_ent *ce = cur_seg->cands[i];
    if (ce->mw != cur_seg->cands[0]->mw) {
      continue;
    }
    f[0] = hash;
    f[1] = cand_hash(ce);
    f[2] = ctx_hash;
    res = anthy_find_array_freq(reorder_info, f, 3, &freq);
    if (!res) {
      continue;
    }
    /**/
    if (freq.f[15] > top_freq.f[15]) {
      ce->flag |= CEF_USEDICT;
      ce->score *= 2;
    }
  }
}

static void
reorder_by_corpus(struct segment_list *sl, int nth)
{
  int i;
  struct seg_ent *cur_seg;
  cur_seg = anthy_get_nth_segment(sl, nth);
  for (i = nth - 2; i < sl->nr_segments && i < nth + 3; i++) {
    struct seg_ent *ctx_seg;
    if (i != nth) {
      ctx_seg = anthy_get_nth_segment(sl, i);
    } else {
      ctx_seg = NULL;
    }
    do_reorder_by_corpus(cur_seg, ctx_seg);
  }
}

/*
 * ѤƸ¤ؤ
 *  @nthܰʹߤʸоݤȤ
 */
void
anthy_reorder_candidates_by_relation(struct segment_list *sl, int nth)
{
  int i;
  for (i = nth; i < sl->nr_segments; i++) {
    reorder_by_use_dict(sl, i);
    reorder_by_corpus(sl, i);
  }
}

void
anthy_relation_init(void)
{
  reorder_info = anthy_file_dic_get_section("reorder_info");
}
