#!/bin/sh

# NFS root might have reached here before /tmp/net.ifaces was written
udevadm settle --timeout=30
# Don't write anything if we don't know our bootdev
[ -f /tmp/net.ifaces ] || return 1

read IFACES < /tmp/net.ifaces

for netif in $IFACES ; do
    mkdir -p /tmp/ifcfg/
    # bridge?
    unset bridge
    if [ "$netif" = "$bridgename" ]; then
        bridge=yes
    fi
    cat /sys/class/net/$netif/address > /tmp/net.$netif.hwaddr
    {
	echo "# Generated by dracut initrd" 
	echo "DEVICE=$netif"
	echo "ONBOOT=yes"
	echo "NETBOOT=yes"
	if [ -f /tmp/net.$netif.lease ]; then
	    strstr "$ip" '*:*:*' &&
	    echo "DHCPV6C=yes" 
	    echo "BOOTPROTO=dhcp" 
	else
	    echo "BOOTPROTO=none" 
        # If we've booted with static ip= lines, the override file is there
	    . /tmp/net.$netif.override 
	    echo "IPADDR=$ip"
	    echo "NETMASK=$mask"
	    [ -n "$gw" ] && echo "GATEWAY=$gw"
	fi
    } > /tmp/ifcfg/ifcfg-$netif

    # bridge needs different things written to ifcfg
    if [ -z "$bridge" ]; then
        # standard interface
	{
            echo "HWADDR=$(cat /sys/class/net/$netif/address)"
            echo "TYPE=Ethernet"
            echo "NAME=\"Boot Disk\"" 
	} >> /tmp/ifcfg/ifcfg-$netif
    else
        # bridge
	{
	    echo "TYPE=Bridge"
            echo "NAME=\"Boot Disk\"" 
	} >> /tmp/ifcfg/ifcfg-$netif
        # write separate ifcfg file for the raw eth interface
	{
            echo "DEVICE=$ethname"
            echo "TYPE=Ethernet"
            echo "ONBOOT=yes"
            echo "NETBOOT=yes"
            echo "HWADDR=$(cat /sys/class/net/$ethname/address)"
            echo "BRIDGE=$netif"
            echo "NAME=$ethname" 
	} >> /tmp/ifcfg/ifcfg-$ethname
    fi
done

# Pass network opts
mkdir /dev/.initramfs/
cp /tmp/net.* /dev/.initramfs/ >/dev/null 2>&1
mkdir -p /dev/.initramfs/state/etc/sysconfig/network-scripts/
cp /tmp/net.$netif.resolv.conf /dev/.initramfs/state/etc/ >/dev/null 2>&1
echo "files /etc/sysconfig/network-scripts" > /dev/.initramfs/rwtab
cp -a /tmp/ifcfg/* /dev/.initramfs/state/etc/sysconfig/network-scripts/ >/dev/null 2>&1
