/*
 * $Id$
 *
 * Copyright (c) 1997 Andrew G. Morgan <morgan@parc.power.net>
 *
 * This file contains the functions that manipulate event entries of
 * an audit record
 */

#include "audit.h"

/* p116 - deletes event specific data from event record - 0(success),
   -1(failure) */

int aud_delete_event(aud_evinfo_t aud_event_d)
{
    return __aud_delete_section(__AUD_MAGIC_EVINFO, aud_event_d);
}

/* p117 - deletes an item of data from the set of event specific data
   stored in a record - returns 0(success) -1(failure) */

int aud_delete_event_info(aud_evinfo_t aud_event_d, int item_id)
{
    return __aud_delete_section_info(__AUD_MAGIC_EVINFO, aud_event_d, item_id);
}

/* p128 - obtain descriptor to a set of "event" data from an audit
   record (NULL with failure) - returns number of event specific data
   items in this record or -1 on failure.  A value for index of 1 will
   return the first event item */

int aud_get_event(aud_rec_t ar, int index, aud_evinfo_t *aud_event_p)
{
    return __aud_get_section(__AUD_MAGIC_EVINFO, ar, index,
			     (const void **) aud_event_p);
}

/* p130 - get information from an event - returns non-negative number
   of items in the event specific data. */

int aud_get_event_info(aud_evinfo_t aud_event_d, int item_id,
		       const aud_info_t **aud_event_info_p)
{
    return __aud_get_section_info(__AUD_MAGIC_EVINFO, aud_event_d, item_id,
				  aud_event_info_p);
}

/* p146 - create an empty set of event specific data in an audit
   record - returns 0(success) -1(failure) */

/* XXX - should next_p be a pointer to a descriptor or just a descriptor? */

int aud_put_event(aud_rec_t ar, const aud_evinfo_t *next_p,
		  aud_evinfo_t *new_p)
{
    return __aud_put_section(__AUD_MAGIC_EVINFO, ar,
			     (const struct __aud_section_s **) next_p,
			     (const struct __aud_section_s **) new_p);
}

/* p147 - add a data item to an event specific set - returns
   0(success) -1(failure). */

int aud_put_event_info(aud_evinfo_t aud_evinfo_d, int position, int item_id,
		       const aud_info_t *aud_event_info_p)
{
    return __aud_put_section_info(__AUD_MAGIC_EVINFO, aud_evinfo_d, position,
				  item_id, aud_event_info_p);
}

/*
 * $Log$
 */
