#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "include/syscallmgr.h"
#include "ucmd.h"

int send_entry (struct ucmd *koko) {
	


void printucmd (struct ucmd *koko,int no) {
	
	printf("%d\t",no);
	if (koko->alluids==1) {
		printf("All\t");
	} else {
		printf("%d\t",koko->uid);
	}
	if (koko->allgids==1) {
		printf("All\t");
	} else {
		printf("%d\t",koko->gid);
	}
	
	printf("%c\t",koko->class);
	
	if (koko->allttymaj) {
		printf("All:");
	} else {
		printf("%d:",koko->ttymaj);
	}
	
	if (koko->allttymin) {
		printf("All\t");
	} else {
		printf("%d\t",koko->ttymin);
	}
	
	if ((koko->action & ACT_LOG)!=0) {
		printf("L");
	}
	if ((koko->action & ACT_DENY)!=0) {
		printf("D");
	}
	printf("\t%s\n",koko->cmd);
}

void main (int argc,char *argv[]) {

/*	struct ucmd *temp;*/
	struct ucmd koko;
	int act,i,j;
	
	__NR_ucmd_add_sys=resolve_syscall(UCMD_ADD_ID,0);
	if (__NR_ucmd_add_sys==-1) {
	printf("%d\n",__NR_ucmd_add_sys);
		printf("Error. Probably module not loaded\n");
		exit(2);
	}
	
	__NR_ucmd_get_sys=resolve_syscall(UCMD_GET_ID,0);
	if (__NR_ucmd_get_sys==-1) {
		printf("Error. Probably module not loaded\n");
		exit(2);
	}
	
	__NR_ucmd_del_sys=resolve_syscall(UCMD_DEL_ID,0);
	if (__NR_ucmd_del_sys==-1) {
		printf("Error. Probably module not loaded\n");
		exit(2);
	}
	
/*	__NR_ucmd_match_sys=resolve_syscall(UCMD_MATCH_ID,0);
	if (__NR_ucmd_match_sys==-1) {
		printf("Error. Probably module not loaded\n");
		exit(2);
	}*/
	
	
	if (argc<2) {
		printf("ucmd: too few arguments.\nTry `help' for more information.\n");
		exit(2);
	}
	
	if (strcmp(*(argv+1),"add")==0) {
		act=C_ADD;
	} else if (strcmp(*(argv+1) ,"del")==0) {
		act=C_DEL;
	} else if (strcmp(*(argv+1),"help")==0) {
		act=C_HELP;
	} else if (strcmp(*(argv+1),"list")==0) {
		act=C_LIST;
	} else {
		printf("ucmd: invalid argument %s.\n",*(argv+1));
		exit(2);
	}
	
	
	if (act==C_HELP) {
		printf("Usage:	ucmd help\n");
		printf("	ucmd list\n");
		printf("	ucmd add UID GID TTYMAJ TTYMIN CLASS COMMAND ACTIONS\n");
		printf("	ucmd del IDs\n\n");
		printf("UID	= {gid | all}\n");
		printf("GID	= {uid | all}\n");
		printf("TTYMAJ  = {device major | all}\n");
		printf("TTYMIN  = {device minor | all}\n");
		printf("CLASS	= {command class | all}\n");
		printf("COMMAND	= {command to act on}\n");
		printf("ACTIONS	= deny,log\n");
		printf("IDs	= {id[,id,...] | all}\n\n");
		exit(2);
	}
	
	
	
	if (act==C_ADD) {
		if (argc<9) {
			printf("ucmd: add: too few arguments.\n");
			exit(2);
		}
		
		koko.alluids=0;
		koko.allgids=0;
		koko.ttymaj=0;
		koko.ttymin=0;
		koko.class='C';
		
		
		if (strcasecmp(*(argv+2),"all")==0) {
			koko.alluids=1;
		} else { 
			koko.uid=atoi(*(argv+2));
		}
		

		if (strcasecmp(*(argv+3),"all")==0) {
			koko.allgids=1;
		} else {
			koko.gid=atoi(*(argv+3));
		}
		
		if (strcasecmp(*(argv+4),"all")==0) {
			koko.allttymaj=1;
		} else { 
			koko.ttymaj=atoi(*(argv+4));
		}
		

		if (strcasecmp(*(argv+5),"all")==0) {
			koko.allttymin=1;
		} else {
			koko.ttymin=atoi(*(argv+5));
		}
		
		if (strcasecmp(*(argv+6),"all")==0) {
			koko.class='*';
		} else { 
			koko.class=(*(argv+2))[0];
		}
		
		
		strcpy(koko.cmd,*(argv+7));
		
		koko.action=0;
		
		if (*(argv+8)==NULL) {
			printf("ucmd: ACTION: too few arguments\n");
			exit(2);
		}
		
		i=8;
		
		do {
			if (strcasecmp(*(argv+i),"deny")==0) {
				koko.action=(koko.action|ACT_DENY);
			} else if (strcmp(*(argv+i),"log")==0) {
				koko.action=(koko.action|ACT_LOG);
			} else {
				printf("ucmd: ACTION: invalid arguments\n");
			 	exit(2);
			}
			i++;
			
		} while (i<argc);
		
		send_entry(&koko);
	} 
	
	if (act==C_DEL) {
		
		if (argc<2) {
			printf("ucmd: add: too few arguments.\n");
			exit(2);
		}
		i=2;
		
		do {
			j=atoi(*(argv+i));
			printf("delete entry %d :",j);
/*			if (ucmd_del_sys(j)==1) {
				printf("Failed\n");
			} else {
				printf("Sucessful\n");
			}*/
			i++;
			
		} while (i<argc);
	}
	
	if (act==C_LIST) {
	
		j=i=0;
		printf("ID	UID	GID	C TTY	Action	Command\n");
		printf("-------	------- -------	- ----- -------	---------------------------------------\n");
		
		do {
/*			i=ucmd_get_sys(++j,&koko);*/
			if (i!=1) {
				printucmd(&koko,j);
			}
		} while (koko.next!=NULL);
			
	}
/*	i=0;*/
	
/*	i=ucmd_match_sys(10,20,"ls -l",strlen("ls -l"));*/
	
/*	printf("\n10,20,ls -l matching : %d\n",i);*/

		
		
		
		
	
}
	
	
	
	
#undef koko
#ifdef koko	 
	
	printucmd(&koko);
	koko.no=1;
		
	first=add_entry(&koko,1);
	
	last=first;
	
	last=add_entry(last,0);
	middle=add_entry(last,0);
	last=add_entry(middle,0);
	delete_entry(middle);
	
	for (temp=first;temp!=NULL;temp=temp->next) {
/*		printf("*%d*\n",temp->no);*/
		printucmd(temp);
		
	}
	
/*	printf("%d\n",match_entry(10,20,"ls -l"),strlen("ls -l"));*/
	
}
#endif koko