/*
 * File:         include/asm-blackfin/mach-bf561/cdefBF561.h
 * Based on:
 * Author:
 *
 * Created:
 * Description:  C POINTERS TO SYSTEM MMR REGISTER AND MEMORY MAP FOR ADSP-BF561
 *
 * Rev:
 *
 * Modified:
 *
 * Bugs:         Enter bugs at http://blackfin.uclinux.org/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.
 * If not, write to the Free Software Foundation,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _CDEF_BF561_H
#define _CDEF_BF561_H

#include <asm/blackfin.h>

/* include all Core registers and bit definitions */
#include "defBF561.h"

/*include core specific register pointer definitions*/
#include <asm/cdef_LPBlackfin.h>

#include <asm/system.h>

/*********************************************************************************** */
/* System MMR Register Map */
/*********************************************************************************** */

/* Clock and System Control (0xFFC00000 - 0xFFC000FF) */
#define bfin_read_PLL_CTL()                  bfin_read16(PLL_CTL)
/* Writing to PLL_CTL initiates a PLL relock sequence. */
static __inline__ void bfin_write_PLL_CTL(unsigned int val)
{
	unsigned long flags, iwr0, iwr1;

	if (val == bfin_read_PLL_CTL())
		return;

	local_irq_save(flags);
	/* Enable the PLL Wakeup bit in SIC IWR */
	iwr0 = bfin_read32(SICA_IWR0);
	iwr1 = bfin_read32(SICA_IWR1);
	/* Only allow PPL Wakeup) */
	bfin_write32(SICA_IWR0, IWR_ENABLE(0));
	bfin_write32(SICA_IWR1, 0);

	bfin_write16(PLL_CTL, val);
	SSYNC();
	asm("IDLE;");

	bfin_write32(SICA_IWR0, iwr0);
	bfin_write32(SICA_IWR1, iwr1);
	local_irq_restore(flags);
}
#define bfin_read_PLL_DIV()                  bfin_read16(PLL_DIV)
#define bfin_write_PLL_DIV(val)              bfin_write16(PLL_DIV,val)
#define bfin_read_VR_CTL()                   bfin_read16(VR_CTL)
/* Writing to VR_CTL initiates a PLL relock sequence. */
static __inline__ void bfin_write_VR_CTL(unsigned int val)
{
	unsigned long flags, iwr0, iwr1;

	if (val == bfin_read_VR_CTL())
		return;

	local_irq_save(flags);
	/* Enable the PLL Wakeup bit in SIC IWR */
	iwr0 = bfin_read32(SICA_IWR0);
	iwr1 = bfin_read32(SICA_IWR1);
	/* Only allow PPL Wakeup) */
	bfin_write32(SICA_IWR0, IWR_ENABLE(0));
	bfin_write32(SICA_IWR1, 0);

	bfin_write16(VR_CTL, val);
	SSYNC();
	asm("IDLE;");

	bfin_write32(SICA_IWR0, iwr0);
	bfin_write32(SICA_IWR1, iwr1);
	local_irq_restore(flags);
}
#define bfin_read_PLL_STAT()                 bfin_read16(PLL_STAT)
#define bfin_write_PLL_STAT(val)             bfin_write16(PLL_STAT,val)
#define bfin_read_PLL_LOCKCNT()              bfin_read16(PLL_LOCKCNT)
#define bfin_write_PLL_LOCKCNT(val)          bfin_write16(PLL_LOCKCNT,val)
#define bfin_read_CHIPID()                   bfin_read32(CHIPID)

/* For MMR's that are reserved on Core B, set up defines to better integrate with other ports */
#define bfin_read_SWRST()                    bfin_read_SICA_SWRST()
#define bfin_write_SWRST(val)                bfin_write_SICA_SWRST(val)
#define bfin_read_SYSCR()                    bfin_read_SICA_SYSCR()
#define bfin_write_SYSCR(val)                bfin_write_SICA_SYSCR(val)

/* System Reset and Interrupt Controller registers for core A (0xFFC0 0100-0xFFC0 01FF) */
#define bfin_read_SICA_SWRST()               bfin_read16(SICA_SWRST)
#define bfin_write_SICA_SWRST(val)           bfin_write16(SICA_SWRST,val)
#define bfin_read_SICA_SYSCR()               bfin_read16(SICA_SYSCR)
#define bfin_write_SICA_SYSCR(val)           bfin_write16(SICA_SYSCR,val)
#define bfin_read_SICA_RVECT()               bfin_read16(SICA_RVECT)
#define bfin_write_SICA_RVECT(val)           bfin_write16(SICA_RVECT,val)
#define bfin_read_SICA_IMASK()               bfin_read32(SICA_IMASK)
#define bfin_write_SICA_IMASK(val)           bfin_write32(SICA_IMASK,val)
#define bfin_read_SICA_IMASK0()              bfin_read32(SICA_IMASK0)
#define bfin_write_SICA_IMASK0(val)          bfin_write32(SICA_IMASK0,val)
#define bfin_read_SICA_IMASK1()              bfin_read32(SICA_IMASK1)
#define bfin_write_SICA_IMASK1(val)          bfin_write32(SICA_IMASK1,val)
#define bfin_read_SICA_IAR0()                bfin_read32(SICA_IAR0)
#define bfin_write_SICA_IAR0(val)            bfin_write32(SICA_IAR0,val)
#define bfin_read_SICA_IAR1()                bfin_read32(SICA_IAR1)
#define bfin_write_SICA_IAR1(val)            bfin_write32(SICA_IAR1,val)
#define bfin_read_SICA_IAR2()                bfin_read32(SICA_IAR2)
#define bfin_write_SICA_IAR2(val)            bfin_write32(SICA_IAR2,val)
#define bfin_read_SICA_IAR3()                bfin_read32(SICA_IAR3)
#define bfin_write_SICA_IAR3(val)            bfin_write32(SICA_IAR3,val)
#define bfin_read_SICA_IAR4()                bfin_read32(SICA_IAR4)
#define bfin_write_SICA_IAR4(val)            bfin_write32(SICA_IAR4,val)
#define bfin_read_SICA_IAR5()                bfin_read32(SICA_IAR5)
#define bfin_write_SICA_IAR5(val)            bfin_write32(SICA_IAR5,val)
#define bfin_read_SICA_IAR6()                bfin_read32(SICA_IAR6)
#define bfin_write_SICA_IAR6(val)            bfin_write32(SICA_IAR6,val)
#define bfin_read_SICA_IAR7()                bfin_read32(SICA_IAR7)
#define bfin_write_SICA_IAR7(val)            bfin_write32(SICA_IAR7,val)
#define bfin_read_SICA_ISR0()                bfin_read32(SICA_ISR0)
#define bfin_write_SICA_ISR0(val)            bfin_write32(SICA_ISR0,val)
#define bfin_read_SICA_ISR1()                bfin_read32(SICA_ISR1)
#define bfin_write_SICA_ISR1(val)            bfin_write32(SICA_ISR1,val)
#define bfin_read_SICA_IWR0()                bfin_read32(SICA_IWR0)
#define bfin_write_SICA_IWR0(val)            bfin_write32(SICA_IWR0,val)
#define bfin_read_SICA_IWR1()                bfin_read32(SICA_IWR1)
#define bfin_write_SICA_IWR1(val)            bfin_write32(SICA_IWR1,val)

/* System Reset and Interrupt Controller registers for Core B (0xFFC0 1100-0xFFC0 11FF) */
#define bfin_read_SICB_SWRST()               bfin_read16(SICB_SWRST)
#define bfin_write_SICB_SWRST(val)           bfin_write16(SICB_SWRST,val)
#define bfin_read_SICB_SYSCR()               bfin_read16(SICB_SYSCR)
#define bfin_write_SICB_SYSCR(val)           bfin_write16(SICB_SYSCR,val)
#define bfin_read_SICB_RVECT()               bfin_read16(SICB_RVECT)
#define bfin_write_SICB_RVECT(val)           bfin_write16(SICB_RVECT,val)
#define bfin_read_SICB_IMASK0()              bfin_read32(SICB_IMASK0)
#define bfin_write_SICB_IMASK0(val)          bfin_write32(SICB_IMASK0,val)
#define bfin_read_SICB_IMASK1()              bfin_read32(SICB_IMASK1)
#define bfin_write_SICB_IMASK1(val)          bfin_write32(SICB_IMASK1,val)
#define bfin_read_SICB_IAR0()                bfin_read32(SICB_IAR0)
#define bfin_write_SICB_IAR0(val)            bfin_write32(SICB_IAR0,val)
#define bfin_read_SICB_IAR1()                bfin_read32(SICB_IAR1)
#define bfin_write_SICB_IAR1(val)            bfin_write32(SICB_IAR1,val)
#define bfin_read_SICB_IAR2()                bfin_read32(SICB_IAR2)
#define bfin_write_SICB_IAR2(val)            bfin_write32(SICB_IAR2,val)
#define bfin_read_SICB_IAR3()                bfin_read32(SICB_IAR3)
#define bfin_write_SICB_IAR3(val)            bfin_write32(SICB_IAR3,val)
#define bfin_read_SICB_IAR4()                bfin_read32(SICB_IAR4)
#define bfin_write_SICB_IAR4(val)            bfin_write32(SICB_IAR4,val)
#define bfin_read_SICB_IAR5()                bfin_read32(SICB_IAR5)
#define bfin_write_SICB_IAR5(val)            bfin_write32(SICB_IAR5,val)
#define bfin_read_SICB_IAR6()                bfin_read32(SICB_IAR6)
#define bfin_write_SICB_IAR6(val)            bfin_write32(SICB_IAR6,val)
#define bfin_read_SICB_IAR7()                bfin_read32(SICB_IAR7)
#define bfin_write_SICB_IAR7(val)            bfin_write32(SICB_IAR7,val)
#define bfin_read_SICB_ISR0()                bfin_read32(SICB_ISR0)
#define bfin_write_SICB_ISR0(val)            bfin_write32(SICB_ISR0,val)
#define bfin_read_SICB_ISR1()                bfin_read32(SICB_ISR1)
#define bfin_write_SICB_ISR1(val)            bfin_write32(SICB_ISR1,val)
#define bfin_read_SICB_IWR0()                bfin_read32(SICB_IWR0)
#define bfin_write_SICB_IWR0(val)            bfin_write32(SICB_IWR0,val)
#define bfin_read_SICB_IWR1()                bfin_read32(SICB_IWR1)
#define bfin_write_SICB_IWR1(val)            bfin_write32(SICB_IWR1,val)
/* Watchdog Timer registers for Core A (0xFFC0 0200-0xFFC0 02FF) */
#define bfin_read_WDOGA_CTL()                bfin_read16(WDOGA_CTL)
#define bfin_write_WDOGA_CTL(val)            bfin_write16(WDOGA_CTL,val)
#define bfin_read_WDOGA_CNT()                bfin_read32(WDOGA_CNT)
#define bfin_write_WDOGA_CNT(val)            bfin_write32(WDOGA_CNT,val)
#define bfin_read_WDOGA_STAT()               bfin_read32(WDOGA_STAT)
#define bfin_write_WDOGA_STAT(val)           bfin_write32(WDOGA_STAT,val)

/* Watchdog Timer registers for Core B (0xFFC0 1200-0xFFC0 12FF) */
#define bfin_read_WDOGB_CTL()                bfin_read16(WDOGB_CTL)
#define bfin_write_WDOGB_CTL(val)            bfin_write16(WDOGB_CTL,val)
#define bfin_read_WDOGB_CNT()                bfin_read32(WDOGB_CNT)
#define bfin_write_WDOGB_CNT(val)            bfin_write32(WDOGB_CNT,val)
#define bfin_read_WDOGB_STAT()               bfin_read32(WDOGB_STAT)
#define bfin_write_WDOGB_STAT(val)           bfin_write32(WDOGB_STAT,val)

/* UART Controller (0xFFC00400 - 0xFFC004FF) */
#define bfin_read_UART_THR()                 bfin_read16(UART_THR)
#define bfin_write_UART_THR(val)             bfin_write16(UART_THR,val)
#define bfin_read_UART_RBR()                 bfin_read16(UART_RBR)
#define bfin_write_UART_RBR(val)             bfin_write16(UART_RBR,val)
#define bfin_read_UART_DLL()                 bfin_read16(UART_DLL)
#define bfin_write_UART_DLL(val)             bfin_write16(UART_DLL,val)
#define bfin_read_UART_IER()                 bfin_read16(UART_IER)
#define bfin_write_UART_IER(val)             bfin_write16(UART_IER,val)
#define bfin_read_UART_DLH()                 bfin_read16(UART_DLH)
#define bfin_write_UART_DLH(val)             bfin_write16(UART_DLH,val)
#define bfin_read_UART_IIR()                 bfin_read16(UART_IIR)
#define bfin_write_UART_IIR(val)             bfin_write16(UART_IIR,val)
#define bfin_read_UART_LCR()                 bfin_read16(UART_LCR)
#define bfin_write_UART_LCR(val)             bfin_write16(UART_LCR,val)
#define bfin_read_UART_MCR()                 bfin_read16(UART_MCR)
#define bfin_write_UART_MCR(val)             bfin_write16(UART_MCR,val)
#define bfin_read_UART_LSR()                 bfin_read16(UART_LSR)
#define bfin_write_UART_LSR(val)             bfin_write16(UART_LSR,val)
#define bfin_read_UART_MSR()                 bfin_read16(UART_MSR)
#define bfin_write_UART_MSR(val)             bfin_write16(UART_MSR,val)
#define bfin_read_UART_SCR()                 bfin_read16(UART_SCR)
#define bfin_write_UART_SCR(val)             bfin_write16(UART_SCR,val)
#define bfin_read_UART_GCTL()                bfin_read16(UART_GCTL)
#define bfin_write_UART_GCTL(val)            bfin_write16(UART_GCTL,val)

/* SPI Controller (0xFFC00500 - 0xFFC005FF) */
#define bfin_read_SPI_CTL()                  bfin_read16(SPI_CTL)
#define bfin_write_SPI_CTL(val)              bfin_write16(SPI_CTL,val)
#define bfin_read_SPI_FLG()                  bfin_read16(SPI_FLG)
#define bfin_write_SPI_FLG(val)              bfin_write16(SPI_FLG,val)
#define bfin_read_SPI_STAT()                 bfin_read16(SPI_STAT)
#define bfin_write_SPI_STAT(val)             bfin_write16(SPI_STAT,val)
#define bfin_read_SPI_TDBR()                 bfin_read16(SPI_TDBR)
#define bfin_write_SPI_TDBR(val)             bfin_write16(SPI_TDBR,val)
#define bfin_read_SPI_RDBR()                 bfin_read16(SPI_RDBR)
#define bfin_write_SPI_RDBR(val)             bfin_write16(SPI_RDBR,val)
#define bfin_read_SPI_BAUD()                 bfin_read16(SPI_BAUD)
#define bfin_write_SPI_BAUD(val)             bfin_write16(SPI_BAUD,val)
#define bfin_read_SPI_SHADOW()               bfin_read16(SPI_SHADOW)
#define bfin_write_SPI_SHADOW(val)           bfin_write16(SPI_SHADOW,val)

/* Timer 0-7 registers (0xFFC0 0600-0xFFC0 06FF) */
#define bfin_read_TIMER0_CONFIG()            bfin_read16(TIMER0_CONFIG)
#define bfin_write_TIMER0_CONFIG(val)        bfin_write16(TIMER0_CONFIG,val)
#define bfin_read_TIMER0_COUNTER()           bfin_read32(TIMER0_COUNTER)
#define bfin_write_TIMER0_COUNTER(val)       bfin_write32(TIMER0_COUNTER,val)
#define bfin_read_TIMER0_PERIOD()            bfin_read32(TIMER0_PERIOD)
#define bfin_write_TIMER0_PERIOD(val)        bfin_write32(TIMER0_PERIOD,val)
#define bfin_read_TIMER0_WIDTH()             bfin_read32(TIMER0_WIDTH)
#define bfin_write_TIMER0_WIDTH(val)         bfin_write32(TIMER0_WIDTH,val)
#define bfin_read_TIMER1_CONFIG()            bfin_read16(TIMER1_CONFIG)
#define bfin_write_TIMER1_CONFIG(val)        bfin_write16(TIMER1_CONFIG,val)
#define bfin_read_TIMER1_COUNTER()           bfin_read32(TIMER1_COUNTER)
#define bfin_write_TIMER1_COUNTER(val)       bfin_write32(TIMER1_COUNTER,val)
#define bfin_read_TIMER1_PERIOD()            bfin_read32(TIMER1_PERIOD)
#define bfin_write_TIMER1_PERIOD(val)        bfin_write32(TIMER1_PERIOD,val)
#define bfin_read_TIMER1_WIDTH()             bfin_read32(TIMER1_WIDTH)
#define bfin_write_TIMER1_WIDTH(val)         bfin_write32(TIMER1_WIDTH,val)
#define bfin_read_TIMER2_CONFIG()            bfin_read16(TIMER2_CONFIG)
#define bfin_write_TIMER2_CONFIG(val)        bfin_write16(TIMER2_CONFIG,val)
#define bfin_read_TIMER2_COUNTER()           bfin_read32(TIMER2_COUNTER)
#define bfin_write_TIMER2_COUNTER(val)       bfin_write32(TIMER2_COUNTER,val)
#define bfin_read_TIMER2_PERIOD()            bfin_read32(TIMER2_PERIOD)
#define bfin_write_TIMER2_PERIOD(val)        bfin_write32(TIMER2_PERIOD,val)
#define bfin_read_TIMER2_WIDTH()             bfin_read32(TIMER2_WIDTH)
#define bfin_write_TIMER2_WIDTH(val)         bfin_write32(TIMER2_WIDTH,val)
#define bfin_read_TIMER3_CONFIG()            bfin_read16(TIMER3_CONFIG)
#define bfin_write_TIMER3_CONFIG(val)        bfin_write16(TIMER3_CONFIG,val)
#define bfin_read_TIMER3_COUNTER()           bfin_read32(TIMER3_COUNTER)
#define bfin_write_TIMER3_COUNTER(val)       bfin_write32(TIMER3_COUNTER,val)
#define bfin_read_TIMER3_PERIOD()            bfin_read32(TIMER3_PERIOD)
#define bfin_write_TIMER3_PERIOD(val)        bfin_write32(TIMER3_PERIOD,val)
#define bfin_read_TIMER3_WIDTH()             bfin_read32(TIMER3_WIDTH)
#define bfin_write_TIMER3_WIDTH(val)         bfin_write32(TIMER3_WIDTH,val)
#define bfin_read_TIMER4_CONFIG()            bfin_read16(TIMER4_CONFIG)
#define bfin_write_TIMER4_CONFIG(val)        bfin_write16(TIMER4_CONFIG,val)
#define bfin_read_TIMER4_COUNTER()           bfin_read32(TIMER4_COUNTER)
#define bfin_write_TIMER4_COUNTER(val)       bfin_write32(TIMER4_COUNTER,val)
#define bfin_read_TIMER4_PERIOD()            bfin_read32(TIMER4_PERIOD)
#define bfin_write_TIMER4_PERIOD(val)        bfin_write32(TIMER4_PERIOD,val)
#define bfin_read_TIMER4_WIDTH()             bfin_read32(TIMER4_WIDTH)
#define bfin_write_TIMER4_WIDTH(val)         bfin_write32(TIMER4_WIDTH,val)
#define bfin_read_TIMER5_CONFIG()            bfin_read16(TIMER5_CONFIG)
#define bfin_write_TIMER5_CONFIG(val)        bfin_write16(TIMER5_CONFIG,val)
#define bfin_read_TIMER5_COUNTER()           bfin_read32(TIMER5_COUNTER)
#define bfin_write_TIMER5_COUNTER(val)       bfin_write32(TIMER5_COUNTER,val)
#define bfin_read_TIMER5_PERIOD()            bfin_read32(TIMER5_PERIOD)
#define bfin_write_TIMER5_PERIOD(val)        bfin_write32(TIMER5_PERIOD,val)
#define bfin_read_TIMER5_WIDTH()             bfin_read32(TIMER5_WIDTH)
#define bfin_write_TIMER5_WIDTH(val)         bfin_write32(TIMER5_WIDTH,val)
#define bfin_read_TIMER6_CONFIG()            bfin_read16(TIMER6_CONFIG)
#define bfin_write_TIMER6_CONFIG(val)        bfin_write16(TIMER6_CONFIG,val)
#define bfin_read_TIMER6_COUNTER()           bfin_read32(TIMER6_COUNTER)
#define bfin_write_TIMER6_COUNTER(val)       bfin_write32(TIMER6_COUNTER,val)
#define bfin_read_TIMER6_PERIOD()            bfin_read32(TIMER6_PERIOD)
#define bfin_write_TIMER6_PERIOD(val)        bfin_write32(TIMER6_PERIOD,val)
#define bfin_read_TIMER6_WIDTH()             bfin_read32(TIMER6_WIDTH)
#define bfin_write_TIMER6_WIDTH(val)         bfin_write32(TIMER6_WIDTH,val)
#define bfin_read_TIMER7_CONFIG()            bfin_read16(TIMER7_CONFIG)
#define bfin_write_TIMER7_CONFIG(val)        bfin_write16(TIMER7_CONFIG,val)
#define bfin_read_TIMER7_COUNTER()           bfin_read32(TIMER7_COUNTER)
#define bfin_write_TIMER7_COUNTER(val)       bfin_write32(TIMER7_COUNTER,val)
#define bfin_read_TIMER7_PERIOD()            bfin_read32(TIMER7_PERIOD)
#define bfin_write_TIMER7_PERIOD(val)        bfin_write32(TIMER7_PERIOD,val)
#define bfin_read_TIMER7_WIDTH()             bfin_read32(TIMER7_WIDTH)
#define bfin_write_TIMER7_WIDTH(val)         bfin_write32(TIMER7_WIDTH,val)

/* Timer registers 8-11 (0xFFC0 1600-0xFFC0 16FF) */
#define bfin_read_TMRS8_ENABLE()             bfin_read16(TMRS8_ENABLE)
#define bfin_write_TMRS8_ENABLE(val)         bfin_write16(TMRS8_ENABLE,val)
#define bfin_read_TMRS8_DISABLE()            bfin_read16(TMRS8_DISABLE)
#define bfin_write_TMRS8_DISABLE(val)        bfin_write16(TMRS8_DISABLE,val)
#define bfin_read_TMRS8_STATUS()             bfin_read32(TMRS8_STATUS)
#define bfin_write_TMRS8_STATUS(val)         bfin_write32(TMRS8_STATUS,val)
#define bfin_read_TIMER8_CONFIG()            bfin_read16(TIMER8_CONFIG)
#define bfin_write_TIMER8_CONFIG(val)        bfin_write16(TIMER8_CONFIG,val)
#define bfin_read_TIMER8_COUNTER()           bfin_read32(TIMER8_COUNTER)
#define bfin_write_TIMER8_COUNTER(val)       bfin_write32(TIMER8_COUNTER,val)
#define bfin_read_TIMER8_PERIOD()            bfin_read32(TIMER8_PERIOD)
#define bfin_write_TIMER8_PERIOD(val)        bfin_write32(TIMER8_PERIOD,val)
#define bfin_read_TIMER8_WIDTH()             bfin_read32(TIMER8_WIDTH)
#define bfin_write_TIMER8_WIDTH(val)         bfin_write32(TIMER8_WIDTH,val)
#define bfin_read_TIMER9_CONFIG()            bfin_read16(TIMER9_CONFIG)
#define bfin_write_TIMER9_CONFIG(val)        bfin_write16(TIMER9_CONFIG,val)
#define bfin_read_TIMER9_COUNTER()           bfin_read32(TIMER9_COUNTER)
#define bfin_write_TIMER9_COUNTER(val)       bfin_write32(TIMER9_COUNTER,val)
#define bfin_read_TIMER9_PERIOD()            bfin_read32(TIMER9_PERIOD)
#define bfin_write_TIMER9_PERIOD(val)        bfin_write32(TIMER9_PERIOD,val)
#define bfin_read_TIMER9_WIDTH()             bfin_read32(TIMER9_WIDTH)
#define bfin_write_TIMER9_WIDTH(val)         bfin_write32(TIMER9_WIDTH,val)
#define bfin_read_TIMER10_CONFIG()           bfin_read16(TIMER10_CONFIG)
#define bfin_write_TIMER10_CONFIG(val)       bfin_write16(TIMER10_CONFIG,val)
#define bfin_read_TIMER10_COUNTER()          bfin_read32(TIMER10_COUNTER)
#define bfin_write_TIMER10_COUNTER(val)      bfin_write32(TIMER10_COUNTER,val)
#define bfin_read_TIMER10_PERIOD()           bfin_read32(TIMER10_PERIOD)
#define bfin_write_TIMER10_PERIOD(val)       bfin_write32(TIMER10_PERIOD,val)
#define bfin_read_TIMER10_WIDTH()            bfin_read32(TIMER10_WIDTH)
#define bfin_write_TIMER10_WIDTH(val)        bfin_write32(TIMER10_WIDTH,val)
#define bfin_read_TIMER11_CONFIG()           bfin_read16(TIMER11_CONFIG)
#define bfin_write_TIMER11_CONFIG(val)       bfin_write16(TIMER11_CONFIG,val)
#define bfin_read_TIMER11_COUNTER()          bfin_read32(TIMER11_COUNTER)
#define bfin_write_TIMER11_COUNTER(val)      bfin_write32(TIMER11_COUNTER,val)
#define bfin_read_TIMER11_PERIOD()           bfin_read32(TIMER11_PERIOD)
#define bfin_write_TIMER11_PERIOD(val)       bfin_write32(TIMER11_PERIOD,val)
#define bfin_read_TIMER11_WIDTH()            bfin_read32(TIMER11_WIDTH)
#define bfin_write_TIMER11_WIDTH(val)        bfin_write32(TIMER11_WIDTH,val)
#define bfin_read_TMRS4_ENABLE()             bfin_read16(TMRS4_ENABLE)
#define bfin_write_TMRS4_ENABLE(val)         bfin_write16(TMRS4_ENABLE,val)
#define bfin_read_TMRS4_DISABLE()            bfin_read16(TMRS4_DISABLE)
#define bfin_write_TMRS4_DISABLE(val)        bfin_write16(TMRS4_DISABLE,val)
#define bfin_read_TMRS4_STATUS()             bfin_read32(TMRS4_STATUS)
#define bfin_write_TMRS4_STATUS(val)         bfin_write32(TMRS4_STATUS,val)

/* Programmable Flag 0 registers (0xFFC0 0700-0xFFC0 07FF) */
#define bfin_read_FIO0_FLAG_D()              bfin_read16(FIO0_FLAG_D)
#define bfin_write_FIO0_FLAG_D(val)          bfin_write16(FIO0_FLAG_D,val)
#define bfin_read_FIO0_FLAG_C()              bfin_read16(FIO0_FLAG_C)
#define bfin_write_FIO0_FLAG_C(val)          bfin_write16(FIO0_FLAG_C,val)
#define bfin_read_FIO0_FLAG_S()              bfin_read16(FIO0_FLAG_S)
#define bfin_write_FIO0_FLAG_S(val)          bfin_write16(FIO0_FLAG_S,val)
#define bfin_read_FIO0_FLAG_T()              bfin_read16(FIO0_FLAG_T)
#define bfin_write_FIO0_FLAG_T(val)          bfin_write16(FIO0_FLAG_T,val)
#define bfin_read_FIO0_MASKA_D()             bfin_read16(FIO0_MASKA_D)
#define bfin_write_FIO0_MASKA_D(val)         bfin_write16(FIO0_MASKA_D,val)
#define bfin_read_FIO0_MASKA_C()             bfin_read16(FIO0_MASKA_C)
#define bfin_write_FIO0_MASKA_C(val)         bfin_write16(FIO0_MASKA_C,val)
#define bfin_read_FIO0_MASKA_S()             bfin_read16(FIO0_MASKA_S)
#define bfin_write_FIO0_MASKA_S(val)         bfin_write16(FIO0_MASKA_S,val)
#define bfin_read_FIO0_MASKA_T()             bfin_read16(FIO0_MASKA_T)
#define bfin_write_FIO0_MASKA_T(val)         bfin_write16(FIO0_MASKA_T,val)
#define bfin_read_FIO0_MASKB_D()             bfin_read16(FIO0_MASKB_D)
#define bfin_write_FIO0_MASKB_D(val)         bfin_write16(FIO0_MASKB_D,val)
#define bfin_read_FIO0_MASKB_C()             bfin_read16(FIO0_MASKB_C)
#define bfin_write_FIO0_MASKB_C(val)         bfin_write16(FIO0_MASKB_C,val)
#define bfin_read_FIO0_MASKB_S()             bfin_read16(FIO0_MASKB_S)
#define bfin_write_FIO0_MASKB_S(val)         bfin_write16(FIO0_MASKB_S,val)
#define bfin_read_FIO0_MASKB_T()             bfin_read16(FIO0_MASKB_T)
#define bfin_write_FIO0_MASKB_T(val)         bfin_write16(FIO0_MASKB_T,val)
#define bfin_read_FIO0_DIR()                 bfin_read16(FIO0_DIR)
#define bfin_write_FIO0_DIR(val)             bfin_write16(FIO0_DIR,val)
#define bfin_read_FIO0_POLAR()               bfin_read16(FIO0_POLAR)
#define bfin_write_FIO0_POLAR(val)           bfin_write16(FIO0_POLAR,val)
#define bfin_read_FIO0_EDGE()                bfin_read16(FIO0_EDGE)
#define bfin_write_FIO0_EDGE(val)            bfin_write16(FIO0_EDGE,val)
#define bfin_read_FIO0_BOTH()                bfin_read16(FIO0_BOTH)
#define bfin_write_FIO0_BOTH(val)            bfin_write16(FIO0_BOTH,val)
#define bfin_read_FIO0_INEN()                bfin_read16(FIO0_INEN)
#define bfin_write_FIO0_INEN(val)            bfin_write16(FIO0_INEN,val)
/* Programmable Flag 1 registers (0xFFC0 1500-0xFFC0 15FF) */
#define bfin_read_FIO1_FLAG_D()              bfin_read16(FIO1_FLAG_D)
#define bfin_write_FIO1_FLAG_D(val)          bfin_write16(FIO1_FLAG_D,val)
#define bfin_read_FIO1_FLAG_C()              bfin_read16(FIO1_FLAG_C)
#define bfin_write_FIO1_FLAG_C(val)          bfin_write16(FIO1_FLAG_C,val)
#define bfin_read_FIO1_FLAG_S()              bfin_read16(FIO1_FLAG_S)
#define bfin_write_FIO1_FLAG_S(val)          bfin_write16(FIO1_FLAG_S,val)
#define bfin_read_FIO1_FLAG_T()              bfin_read16(FIO1_FLAG_T)
#define bfin_write_FIO1_FLAG_T(val)          bfin_write16(FIO1_FLAG_T,val)
#define bfin_read_FIO1_MASKA_D()             bfin_read16(FIO1_MASKA_D)
#define bfin_write_FIO1_MASKA_D(val)         bfin_write16(FIO1_MASKA_D,val)
#define bfin_read_FIO1_MASKA_C()             bfin_read16(FIO1_MASKA_C)
#define bfin_write_FIO1_MASKA_C(val)         bfin_write16(FIO1_MASKA_C,val)
#define bfin_read_FIO1_MASKA_S()             bfin_read16(FIO1_MASKA_S)
#define bfin_write_FIO1_MASKA_S(val)         bfin_write16(FIO1_MASKA_S,val)
#define bfin_read_FIO1_MASKA_T()             bfin_read16(FIO1_MASKA_T)
#define bfin_write_FIO1_MASKA_T(val)         bfin_write16(FIO1_MASKA_T,val)
#define bfin_read_FIO1_MASKB_D()             bfin_read16(FIO1_MASKB_D)
#define bfin_write_FIO1_MASKB_D(val)         bfin_write16(FIO1_MASKB_D,val)
#define bfin_read_FIO1_MASKB_C()             bfin_read16(FIO1_MASKB_C)
#define bfin_write_FIO1_MASKB_C(val)         bfin_write16(FIO1_MASKB_C,val)
#define bfin_read_FIO1_MASKB_S()             bfin_read16(FIO1_MASKB_S)
#define bfin_write_FIO1_MASKB_S(val)         bfin_write16(FIO1_MASKB_S,val)
#define bfin_read_FIO1_MASKB_T()             bfin_read16(FIO1_MASKB_T)
#define bfin_write_FIO1_MASKB_T(val)         bfin_write16(FIO1_MASKB_T,val)
#define bfin_read_FIO1_DIR()                 bfin_read16(FIO1_DIR)
#define bfin_write_FIO1_DIR(val)             bfin_write16(FIO1_DIR,val)
#define bfin_read_FIO1_POLAR()               bfin_read16(FIO1_POLAR)
#define bfin_write_FIO1_POLAR(val)           bfin_write16(FIO1_POLAR,val)
#define bfin_read_FIO1_EDGE()                bfin_read16(FIO1_EDGE)
#define bfin_write_FIO1_EDGE(val)            bfin_write16(FIO1_EDGE,val)
#define bfin_read_FIO1_BOTH()                bfin_read16(FIO1_BOTH)
#define bfin_write_FIO1_BOTH(val)            bfin_write16(FIO1_BOTH,val)
#define bfin_read_FIO1_INEN()                bfin_read16(FIO1_INEN)
#define bfin_write_FIO1_INEN(val)            bfin_write16(FIO1_INEN,val)
/* Programmable Flag registers (0xFFC0 1700-0xFFC0 17FF) */
#define bfin_read_FIO2_FLAG_D()              bfin_read16(FIO2_FLAG_D)
#define bfin_write_FIO2_FLAG_D(val)          bfin_write16(FIO2_FLAG_D,val)
#define bfin_read_FIO2_FLAG_C()              bfin_read16(FIO2_FLAG_C)
#define bfin_write_FIO2_FLAG_C(val)          bfin_write16(FIO2_FLAG_C,val)
#define bfin_read_FIO2_FLAG_S()              bfin_read16(FIO2_FLAG_S)
#define bfin_write_FIO2_FLAG_S(val)          bfin_write16(FIO2_FLAG_S,val)
#define bfin_read_FIO2_FLAG_T()              bfin_read16(FIO2_FLAG_T)
#define bfin_write_FIO2_FLAG_T(val)          bfin_write16(FIO2_FLAG_T,val)
#define bfin_read_FIO2_MASKA_D()             bfin_read16(FIO2_MASKA_D)
#define bfin_write_FIO2_MASKA_D(val)         bfin_write16(FIO2_MASKA_D,val)
#define bfin_read_FIO2_MASKA_C()             bfin_read16(FIO2_MASKA_C)
#define bfin_write_FIO2_MASKA_C(val)         bfin_write16(FIO2_MASKA_C,val)
#define bfin_read_FIO2_MASKA_S()             bfin_read16(FIO2_MASKA_S)
#define bfin_write_FIO2_MASKA_S(val)         bfin_write16(FIO2_MASKA_S,val)
#define bfin_read_FIO2_MASKA_T()             bfin_read16(FIO2_MASKA_T)
#define bfin_write_FIO2_MASKA_T(val)         bfin_write16(FIO2_MASKA_T,val)
#define bfin_read_FIO2_MASKB_D()             bfin_read16(FIO2_MASKB_D)
#define bfin_write_FIO2_MASKB_D(val)         bfin_write16(FIO2_MASKB_D,val)
#define bfin_read_FIO2_MASKB_C()             bfin_read16(FIO2_MASKB_C)
#define bfin_write_FIO2_MASKB_C(val)         bfin_write16(FIO2_MASKB_C,val)
#define bfin_read_FIO2_MASKB_S()             bfin_read16(FIO2_MASKB_S)
#define bfin_write_FIO2_MASKB_S(val)         bfin_write16(FIO2_MASKB_S,val)
#define bfin_read_FIO2_MASKB_T()             bfin_read16(FIO2_MASKB_T)
#define bfin_write_FIO2_MASKB_T(val)         bfin_write16(FIO2_MASKB_T,val)
#define bfin_read_FIO2_DIR()                 bfin_read16(FIO2_DIR)
#define bfin_write_FIO2_DIR(val)             bfin_write16(FIO2_DIR,val)
#define bfin_read_FIO2_POLAR()               bfin_read16(FIO2_POLAR)
#define bfin_write_FIO2_POLAR(val)           bfin_write16(FIO2_POLAR,val)
#define bfin_read_FIO2_EDGE()                bfin_read16(FIO2_EDGE)
#define bfin_write_FIO2_EDGE(val)            bfin_write16(FIO2_EDGE,val)
#define bfin_read_FIO2_BOTH()                bfin_read16(FIO2_BOTH)
#define bfin_write_FIO2_BOTH(val)            bfin_write16(FIO2_BOTH,val)
#define bfin_read_FIO2_INEN()                bfin_read16(FIO2_INEN)
#define bfin_write_FIO2_INEN(val)            bfin_write16(FIO2_INEN,val)
/* SPORT0 Controller (0xFFC00800 - 0xFFC008FF) */
#define bfin_read_SPORT0_TCR1()              bfin_read16(SPORT0_TCR1)
#define bfin_write_SPORT0_TCR1(val)          bfin_write16(SPORT0_TCR1,val)
#define bfin_read_SPORT0_TCR2()              bfin_read16(SPORT0_TCR2)
#define bfin_write_SPORT0_TCR2(val)          bfin_write16(SPORT0_TCR2,val)
#define bfin_read_SPORT0_TCLKDIV()           bfin_read16(SPORT0_TCLKDIV)
#define bfin_write_SPORT0_TCLKDIV(val)       bfin_write16(SPORT0_TCLKDIV,val)
#define bfin_read_SPORT0_TFSDIV()            bfin_read16(SPORT0_TFSDIV)
#define bfin_write_SPORT0_TFSDIV(val)        bfin_write16(SPORT0_TFSDIV,val)
#define bfin_read_SPORT0_TX()                bfin_read32(SPORT0_TX)
#define bfin_write_SPORT0_TX(val)            bfin_write32(SPORT0_TX,val)
#define bfin_read_SPORT0_RX()                bfin_read32(SPORT0_RX)
#define bfin_write_SPORT0_RX(val)            bfin_write32(SPORT0_RX,val)
#define bfin_read_SPORT0_TX32()              bfin_read32(SPORT0_TX)
#define bfin_write_SPORT0_TX32(val)          bfin_write32(SPORT0_TX,val)
#define bfin_read_SPORT0_RX32()              bfin_read32(SPORT0_RX)
#define bfin_write_SPORT0_RX32(val)          bfin_write32(SPORT0_RX,val)
#define bfin_read_SPORT0_TX16()              bfin_read16(SPORT0_TX)
#define bfin_write_SPORT0_TX16(val)          bfin_write16(SPORT0_TX,val)
#define bfin_read_SPORT0_RX16()              bfin_read16(SPORT0_RX)
#define bfin_write_SPORT0_RX16(val)          bfin_write16(SPORT0_RX,val)
#define bfin_read_SPORT0_RCR1()              bfin_read16(SPORT0_RCR1)
#define bfin_write_SPORT0_RCR1(val)          bfin_write16(SPORT0_RCR1,val)
#define bfin_read_SPORT0_RCR2()              bfin_read16(SPORT0_RCR2)
#define bfin_write_SPORT0_RCR2(val)          bfin_write16(SPORT0_RCR2,val)
#define bfin_read_SPORT0_RCLKDIV()           bfin_read16(SPORT0_RCLKDIV)
#define bfin_write_SPORT0_RCLKDIV(val)       bfin_write16(SPORT0_RCLKDIV,val)
#define bfin_read_SPORT0_RFSDIV()            bfin_read16(SPORT0_RFSDIV)
#define bfin_write_SPORT0_RFSDIV(val)        bfin_write16(SPORT0_RFSDIV,val)
#define bfin_read_SPORT0_STAT()              bfin_read16(SPORT0_STAT)
#define bfin_write_SPORT0_STAT(val)          bfin_write16(SPORT0_STAT,val)
#define bfin_read_SPORT0_CHNL()              bfin_read16(SPORT0_CHNL)
#define bfin_write_SPORT0_CHNL(val)          bfin_write16(SPORT0_CHNL,val)
#define bfin_read_SPORT0_MCMC1()             bfin_read16(SPORT0_MCMC1)
#define bfin_write_SPORT0_MCMC1(val)         bfin_write16(SPORT0_MCMC1,val)
#define bfin_read_SPORT0_MCMC2()             bfin_read16(SPORT0_MCMC2)
#define bfin_write_SPORT0_MCMC2(val)         bfin_write16(SPORT0_MCMC2,val)
#define bfin_read_SPORT0_MTCS0()             bfin_read32(SPORT0_MTCS0)
#define bfin_write_SPORT0_MTCS0(val)         bfin_write32(SPORT0_MTCS0,val)
#define bfin_read_SPORT0_MTCS1()             bfin_read32(SPORT0_MTCS1)
#define bfin_write_SPORT0_MTCS1(val)         bfin_write32(SPORT0_MTCS1,val)
#define bfin_read_SPORT0_MTCS2()             bfin_read32(SPORT0_MTCS2)
#define bfin_write_SPORT0_MTCS2(val)         bfin_write32(SPORT0_MTCS2,val)
#define bfin_read_SPORT0_MTCS3()             bfin_read32(SPORT0_MTCS3)
#define bfin_write_SPORT0_MTCS3(val)         bfin_write32(SPORT0_MTCS3,val)
#define bfin_read_SPORT0_MRCS0()             bfin_read32(SPORT0_MRCS0)
#define bfin_write_SPORT0_MRCS0(val)         bfin_write32(SPORT0_MRCS0,val)
#define bfin_read_SPORT0_MRCS1()             bfin_read32(SPORT0_MRCS1)
#define bfin_write_SPORT0_MRCS1(val)         bfin_write32(SPORT0_MRCS1,val)
#define bfin_read_SPORT0_MRCS2()             bfin_read32(SPORT0_MRCS2)
#define bfin_write_SPORT0_MRCS2(val)         bfin_write32(SPORT0_MRCS2,val)
#define bfin_read_SPORT0_MRCS3()             bfin_read32(SPORT0_MRCS3)
#define bfin_write_SPORT0_MRCS3(val)         bfin_write32(SPORT0_MRCS3,val)
/* SPORT1 Controller (0xFFC00900 - 0xFFC009FF) */
#define bfin_read_SPORT1_TCR1()              bfin_read16(SPORT1_TCR1)
#define bfin_write_SPORT1_TCR1(val)          bfin_write16(SPORT1_TCR1,val)
#define bfin_read_SPORT1_TCR2()              bfin_read16(SPORT1_TCR2)
#define bfin_write_SPORT1_TCR2(val)          bfin_write16(SPORT1_TCR2,val)
#define bfin_read_SPORT1_TCLKDIV()           bfin_read16(SPORT1_TCLKDIV)
#define bfin_write_SPORT1_TCLKDIV(val)       bfin_write16(SPORT1_TCLKDIV,val)
#define bfin_read_SPORT1_TFSDIV()            bfin_read16(SPORT1_TFSDIV)
#define bfin_write_SPORT1_TFSDIV(val)        bfin_write16(SPORT1_TFSDIV,val)
#define bfin_read_SPORT1_TX()                bfin_read32(SPORT1_TX)
#define bfin_write_SPORT1_TX(val)            bfin_write32(SPORT1_TX,val)
#define bfin_read_SPORT1_RX()                bfin_read32(SPORT1_RX)
#define bfin_write_SPORT1_RX(val)            bfin_write32(SPORT1_RX,val)
#define bfin_read_SPORT1_TX32()              bfin_read32(SPORT1_TX)
#define bfin_write_SPORT1_TX32(val)          bfin_write32(SPORT1_TX,val)
#define bfin_read_SPORT1_RX32()              bfin_read32(SPORT1_RX)
#define bfin_write_SPORT1_RX32(val)          bfin_write32(SPORT1_RX,val)
#define bfin_read_SPORT1_TX16()              bfin_read16(SPORT1_TX)
#define bfin_write_SPORT1_TX16(val)          bfin_write16(SPORT1_TX,val)
#define bfin_read_SPORT1_RX16()              bfin_read16(SPORT1_RX)
#define bfin_write_SPORT1_RX16(val)          bfin_write16(SPORT1_RX,val)
#define bfin_read_SPORT1_RCR1()              bfin_read16(SPORT1_RCR1)
#define bfin_write_SPORT1_RCR1(val)          bfin_write16(SPORT1_RCR1,val)
#define bfin_read_SPORT1_RCR2()              bfin_read16(SPORT1_RCR2)
#define bfin_write_SPORT1_RCR2(val)          bfin_write16(SPORT1_RCR2,val)
#define bfin_read_SPORT1_RCLKDIV()           bfin_read16(SPORT1_RCLKDIV)
#define bfin_write_SPORT1_RCLKDIV(val)       bfin_write16(SPORT1_RCLKDIV,val)
#define bfin_read_SPORT1_RFSDIV()            bfin_read16(SPORT1_RFSDIV)
#define bfin_write_SPORT1_RFSDIV(val)        bfin_write16(SPORT1_RFSDIV,val)
#define bfin_read_SPORT1_STAT()              bfin_read16(SPORT1_STAT)
#define bfin_write_SPORT1_STAT(val)          bfin_write16(SPORT1_STAT,val)
#define bfin_read_SPORT1_CHNL()              bfin_read16(SPORT1_CHNL)
#define bfin_write_SPORT1_CHNL(val)          bfin_write16(SPORT1_CHNL,val)
#define bfin_read_SPORT1_MCMC1()             bfin_read16(SPORT1_MCMC1)
#define bfin_write_SPORT1_MCMC1(val)         bfin_write16(SPORT1_MCMC1,val)
#define bfin_read_SPORT1_MCMC2()             bfin_read16(SPORT1_MCMC2)
#define bfin_write_SPORT1_MCMC2(val)         bfin_write16(SPORT1_MCMC2,val)
#define bfin_read_SPORT1_MTCS0()             bfin_read32(SPORT1_MTCS0)
#define bfin_write_SPORT1_MTCS0(val)         bfin_write32(SPORT1_MTCS0,val)
#define bfin_read_SPORT1_MTCS1()             bfin_read32(SPORT1_MTCS1)
#define bfin_write_SPORT1_MTCS1(val)         bfin_write32(SPORT1_MTCS1,val)
#define bfin_read_SPORT1_MTCS2()             bfin_read32(SPORT1_MTCS2)
#define bfin_write_SPORT1_MTCS2(val)         bfin_write32(SPORT1_MTCS2,val)
#define bfin_read_SPORT1_MTCS3()             bfin_read32(SPORT1_MTCS3)
#define bfin_write_SPORT1_MTCS3(val)         bfin_write32(SPORT1_MTCS3,val)
#define bfin_read_SPORT1_MRCS0()             bfin_read32(SPORT1_MRCS0)
#define bfin_write_SPORT1_MRCS0(val)         bfin_write32(SPORT1_MRCS0,val)
#define bfin_read_SPORT1_MRCS1()             bfin_read32(SPORT1_MRCS1)
#define bfin_write_SPORT1_MRCS1(val)         bfin_write32(SPORT1_MRCS1,val)
#define bfin_read_SPORT1_MRCS2()             bfin_read32(SPORT1_MRCS2)
#define bfin_write_SPORT1_MRCS2(val)         bfin_write32(SPORT1_MRCS2,val)
#define bfin_read_SPORT1_MRCS3()             bfin_read32(SPORT1_MRCS3)
#define bfin_write_SPORT1_MRCS3(val)         bfin_write32(SPORT1_MRCS3,val)
/* Asynchronous Memory Controller - External Bus Interface Unit */
#define bfin_read_EBIU_AMGCTL()              bfin_read16(EBIU_AMGCTL)
#define bfin_write_EBIU_AMGCTL(val)          bfin_write16(EBIU_AMGCTL,val)
#define bfin_read_EBIU_AMBCTL0()             bfin_read32(EBIU_AMBCTL0)
#define bfin_write_EBIU_AMBCTL0(val)         bfin_write32(EBIU_AMBCTL0,val)
#define bfin_read_EBIU_AMBCTL1()             bfin_read32(EBIU_AMBCTL1)
#define bfin_write_EBIU_AMBCTL1(val)         bfin_write32(EBIU_AMBCTL1,val)
/* SDRAM Controller External Bus Interface Unit (0xFFC00A00 - 0xFFC00AFF) */
#define bfin_read_EBIU_SDGCTL()              bfin_read32(EBIU_SDGCTL)
#define bfin_write_EBIU_SDGCTL(val)          bfin_write32(EBIU_SDGCTL,val)
#define bfin_read_EBIU_SDBCTL()              bfin_read32(EBIU_SDBCTL)
#define bfin_write_EBIU_SDBCTL(val)          bfin_write32(EBIU_SDBCTL,val)
#define bfin_read_EBIU_SDRRC()               bfin_read16(EBIU_SDRRC)
#define bfin_write_EBIU_SDRRC(val)           bfin_write16(EBIU_SDRRC,val)
#define bfin_read_EBIU_SDSTAT()              bfin_read16(EBIU_SDSTAT)
#define bfin_write_EBIU_SDSTAT(val)          bfin_write16(EBIU_SDSTAT,val)
/* Parallel Peripheral Interface (PPI) 0 registers (0xFFC0 1000-0xFFC0 10FF) */
#define bfin_read_PPI0_CONTROL()             bfin_read16(PPI0_CONTROL)
#define bfin_write_PPI0_CONTROL(val)         bfin_write16(PPI0_CONTROL,val)
#define bfin_read_PPI0_STATUS()              bfin_read16(PPI0_STATUS)
#define bfin_write_PPI0_STATUS(val)          bfin_write16(PPI0_STATUS,val)
#define bfin_clear_PPI0_STATUS()             bfin_read_PPI0_STATUS()
#define bfin_read_PPI0_COUNT()               bfin_read16(PPI0_COUNT)
#define bfin_write_PPI0_COUNT(val)           bfin_write16(PPI0_COUNT,val)
#define bfin_read_PPI0_DELAY()               bfin_read16(PPI0_DELAY)
#define bfin_write_PPI0_DELAY(val)           bfin_write16(PPI0_DELAY,val)
#define bfin_read_PPI0_FRAME()               bfin_read16(PPI0_FRAME)
#define bfin_write_PPI0_FRAME(val)           bfin_write16(PPI0_FRAME,val)
/* Parallel Peripheral Interface (PPI) 1 registers (0xFFC0 1300-0xFFC0 13FF) */
#define bfin_read_PPI1_CONTROL()             bfin_read16(PPI1_CONTROL)
#define bfin_write_PPI1_CONTROL(val)         bfin_write16(PPI1_CONTROL,val)
#define bfin_read_PPI1_STATUS()              bfin_read16(PPI1_STATUS)
#define bfin_write_PPI1_STATUS(val)          bfin_write16(PPI1_STATUS,val)
#define bfin_clear_PPI1_STATUS()             bfin_read_PPI1_STATUS()
#define bfin_read_PPI1_COUNT()               bfin_read16(PPI1_COUNT)
#define bfin_write_PPI1_COUNT(val)           bfin_write16(PPI1_COUNT,val)
#define bfin_read_PPI1_DELAY()               bfin_read16(PPI1_DELAY)
#define bfin_write_PPI1_DELAY(val)           bfin_write16(PPI1_DELAY,val)
#define bfin_read_PPI1_FRAME()               bfin_read16(PPI1_FRAME)
#define bfin_write_PPI1_FRAME(val)           bfin_write16(PPI1_FRAME,val)
/*DMA traffic control registers */
#define bfin_read_DMA1_TC_PER()              bfin_read16(DMA1_TC_PER)
#define bfin_write_DMA1_TC_PER(val)          bfin_write16(DMA1_TC_PER,val)
#define bfin_read_DMA1_TC_CNT()              bfin_read16(DMA1_TC_CNT)
#define bfin_write_DMA1_TC_CNT(val)          bfin_write16(DMA1_TC_CNT,val)
#define bfin_read_DMA2_TC_PER()              bfin_read16(DMA2_TC_PER)
#define bfin_write_DMA2_TC_PER(val)          bfin_write16(DMA2_TC_PER,val)
#define bfin_read_DMA2_TC_CNT()              bfin_read16(DMA2_TC_CNT)
#define bfin_write_DMA2_TC_CNT(val)          bfin_write16(DMA2_TC_CNT,val)
/* DMA1 Controller registers (0xFFC0 1C00-0xFFC0 1FFF) */
#define bfin_read_DMA1_0_CONFIG()            bfin_read16(DMA1_0_CONFIG)
#define bfin_write_DMA1_0_CONFIG(val)        bfin_write16(DMA1_0_CONFIG,val)
#define bfin_read_DMA1_0_NEXT_DESC_PTR()     bfin_read32(DMA1_0_NEXT_DESC_PTR)
#define bfin_write_DMA1_0_NEXT_DESC_PTR(val) bfin_write32(DMA1_0_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_0_START_ADDR()        bfin_read32(DMA1_0_START_ADDR)
#define bfin_write_DMA1_0_START_ADDR(val)    bfin_write32(DMA1_0_START_ADDR,val)
#define bfin_read_DMA1_0_X_COUNT()           bfin_read16(DMA1_0_X_COUNT)
#define bfin_write_DMA1_0_X_COUNT(val)       bfin_write16(DMA1_0_X_COUNT,val)
#define bfin_read_DMA1_0_Y_COUNT()           bfin_read16(DMA1_0_Y_COUNT)
#define bfin_write_DMA1_0_Y_COUNT(val)       bfin_write16(DMA1_0_Y_COUNT,val)
#define bfin_read_DMA1_0_X_MODIFY()          bfin_read16(DMA1_0_X_MODIFY)
#define bfin_write_DMA1_0_X_MODIFY(val)      bfin_write16(DMA1_0_X_MODIFY,val)
#define bfin_read_DMA1_0_Y_MODIFY()          bfin_read16(DMA1_0_Y_MODIFY)
#define bfin_write_DMA1_0_Y_MODIFY(val)      bfin_write16(DMA1_0_Y_MODIFY,val)
#define bfin_read_DMA1_0_CURR_DESC_PTR()     bfin_read32(DMA1_0_CURR_DESC_PTR)
#define bfin_write_DMA1_0_CURR_DESC_PTR(val) bfin_write32(DMA1_0_CURR_DESC_PTR,val)
#define bfin_read_DMA1_0_CURR_ADDR()         bfin_read32(DMA1_0_CURR_ADDR)
#define bfin_write_DMA1_0_CURR_ADDR(val)     bfin_write32(DMA1_0_CURR_ADDR,val)
#define bfin_read_DMA1_0_CURR_X_COUNT()      bfin_read16(DMA1_0_CURR_X_COUNT)
#define bfin_write_DMA1_0_CURR_X_COUNT(val)  bfin_write16(DMA1_0_CURR_X_COUNT,val)
#define bfin_read_DMA1_0_CURR_Y_COUNT()      bfin_read16(DMA1_0_CURR_Y_COUNT)
#define bfin_write_DMA1_0_CURR_Y_COUNT(val)  bfin_write16(DMA1_0_CURR_Y_COUNT,val)
#define bfin_read_DMA1_0_IRQ_STATUS()        bfin_read16(DMA1_0_IRQ_STATUS)
#define bfin_write_DMA1_0_IRQ_STATUS(val)    bfin_write16(DMA1_0_IRQ_STATUS,val)
#define bfin_read_DMA1_0_PERIPHERAL_MAP()    bfin_read16(DMA1_0_PERIPHERAL_MAP)
#define bfin_write_DMA1_0_PERIPHERAL_MAP(val) bfin_write16(DMA1_0_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_1_CONFIG()            bfin_read16(DMA1_1_CONFIG)
#define bfin_write_DMA1_1_CONFIG(val)        bfin_write16(DMA1_1_CONFIG,val)
#define bfin_read_DMA1_1_NEXT_DESC_PTR()     bfin_read32(DMA1_1_NEXT_DESC_PTR)
#define bfin_write_DMA1_1_NEXT_DESC_PTR(val) bfin_write32(DMA1_1_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_1_START_ADDR()        bfin_read32(DMA1_1_START_ADDR)
#define bfin_write_DMA1_1_START_ADDR(val)    bfin_write32(DMA1_1_START_ADDR,val)
#define bfin_read_DMA1_1_X_COUNT()           bfin_read16(DMA1_1_X_COUNT)
#define bfin_write_DMA1_1_X_COUNT(val)       bfin_write16(DMA1_1_X_COUNT,val)
#define bfin_read_DMA1_1_Y_COUNT()           bfin_read16(DMA1_1_Y_COUNT)
#define bfin_write_DMA1_1_Y_COUNT(val)       bfin_write16(DMA1_1_Y_COUNT,val)
#define bfin_read_DMA1_1_X_MODIFY()          bfin_read16(DMA1_1_X_MODIFY)
#define bfin_write_DMA1_1_X_MODIFY(val)      bfin_write16(DMA1_1_X_MODIFY,val)
#define bfin_read_DMA1_1_Y_MODIFY()          bfin_read16(DMA1_1_Y_MODIFY)
#define bfin_write_DMA1_1_Y_MODIFY(val)      bfin_write16(DMA1_1_Y_MODIFY,val)
#define bfin_read_DMA1_1_CURR_DESC_PTR()     bfin_read32(DMA1_1_CURR_DESC_PTR)
#define bfin_write_DMA1_1_CURR_DESC_PTR(val) bfin_write32(DMA1_1_CURR_DESC_PTR,val)
#define bfin_read_DMA1_1_CURR_ADDR()         bfin_read32(DMA1_1_CURR_ADDR)
#define bfin_write_DMA1_1_CURR_ADDR(val)     bfin_write32(DMA1_1_CURR_ADDR,val)
#define bfin_read_DMA1_1_CURR_X_COUNT()      bfin_read16(DMA1_1_CURR_X_COUNT)
#define bfin_write_DMA1_1_CURR_X_COUNT(val)  bfin_write16(DMA1_1_CURR_X_COUNT,val)
#define bfin_read_DMA1_1_CURR_Y_COUNT()      bfin_read16(DMA1_1_CURR_Y_COUNT)
#define bfin_write_DMA1_1_CURR_Y_COUNT(val)  bfin_write16(DMA1_1_CURR_Y_COUNT,val)
#define bfin_read_DMA1_1_IRQ_STATUS()        bfin_read16(DMA1_1_IRQ_STATUS)
#define bfin_write_DMA1_1_IRQ_STATUS(val)    bfin_write16(DMA1_1_IRQ_STATUS,val)
#define bfin_read_DMA1_1_PERIPHERAL_MAP()    bfin_read16(DMA1_1_PERIPHERAL_MAP)
#define bfin_write_DMA1_1_PERIPHERAL_MAP(val) bfin_write16(DMA1_1_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_2_CONFIG()            bfin_read16(DMA1_2_CONFIG)
#define bfin_write_DMA1_2_CONFIG(val)        bfin_write16(DMA1_2_CONFIG,val)
#define bfin_read_DMA1_2_NEXT_DESC_PTR()     bfin_read32(DMA1_2_NEXT_DESC_PTR)
#define bfin_write_DMA1_2_NEXT_DESC_PTR(val) bfin_write32(DMA1_2_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_2_START_ADDR()        bfin_read32(DMA1_2_START_ADDR)
#define bfin_write_DMA1_2_START_ADDR(val)    bfin_write32(DMA1_2_START_ADDR,val)
#define bfin_read_DMA1_2_X_COUNT()           bfin_read16(DMA1_2_X_COUNT)
#define bfin_write_DMA1_2_X_COUNT(val)       bfin_write16(DMA1_2_X_COUNT,val)
#define bfin_read_DMA1_2_Y_COUNT()           bfin_read16(DMA1_2_Y_COUNT)
#define bfin_write_DMA1_2_Y_COUNT(val)       bfin_write16(DMA1_2_Y_COUNT,val)
#define bfin_read_DMA1_2_X_MODIFY()          bfin_read16(DMA1_2_X_MODIFY)
#define bfin_write_DMA1_2_X_MODIFY(val)      bfin_write16(DMA1_2_X_MODIFY,val)
#define bfin_read_DMA1_2_Y_MODIFY()          bfin_read16(DMA1_2_Y_MODIFY)
#define bfin_write_DMA1_2_Y_MODIFY(val)      bfin_write16(DMA1_2_Y_MODIFY,val)
#define bfin_read_DMA1_2_CURR_DESC_PTR()     bfin_read32(DMA1_2_CURR_DESC_PTR)
#define bfin_write_DMA1_2_CURR_DESC_PTR(val) bfin_write32(DMA1_2_CURR_DESC_PTR,val)
#define bfin_read_DMA1_2_CURR_ADDR()         bfin_read32(DMA1_2_CURR_ADDR)
#define bfin_write_DMA1_2_CURR_ADDR(val)     bfin_write32(DMA1_2_CURR_ADDR,val)
#define bfin_read_DMA1_2_CURR_X_COUNT()      bfin_read16(DMA1_2_CURR_X_COUNT)
#define bfin_write_DMA1_2_CURR_X_COUNT(val)  bfin_write16(DMA1_2_CURR_X_COUNT,val)
#define bfin_read_DMA1_2_CURR_Y_COUNT()      bfin_read16(DMA1_2_CURR_Y_COUNT)
#define bfin_write_DMA1_2_CURR_Y_COUNT(val)  bfin_write16(DMA1_2_CURR_Y_COUNT,val)
#define bfin_read_DMA1_2_IRQ_STATUS()        bfin_read16(DMA1_2_IRQ_STATUS)
#define bfin_write_DMA1_2_IRQ_STATUS(val)    bfin_write16(DMA1_2_IRQ_STATUS,val)
#define bfin_read_DMA1_2_PERIPHERAL_MAP()    bfin_read16(DMA1_2_PERIPHERAL_MAP)
#define bfin_write_DMA1_2_PERIPHERAL_MAP(val) bfin_write16(DMA1_2_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_3_CONFIG()            bfin_read16(DMA1_3_CONFIG)
#define bfin_write_DMA1_3_CONFIG(val)        bfin_write16(DMA1_3_CONFIG,val)
#define bfin_read_DMA1_3_NEXT_DESC_PTR()     bfin_read32(DMA1_3_NEXT_DESC_PTR)
#define bfin_write_DMA1_3_NEXT_DESC_PTR(val) bfin_write32(DMA1_3_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_3_START_ADDR()        bfin_read32(DMA1_3_START_ADDR)
#define bfin_write_DMA1_3_START_ADDR(val)    bfin_write32(DMA1_3_START_ADDR,val)
#define bfin_read_DMA1_3_X_COUNT()           bfin_read16(DMA1_3_X_COUNT)
#define bfin_write_DMA1_3_X_COUNT(val)       bfin_write16(DMA1_3_X_COUNT,val)
#define bfin_read_DMA1_3_Y_COUNT()           bfin_read16(DMA1_3_Y_COUNT)
#define bfin_write_DMA1_3_Y_COUNT(val)       bfin_write16(DMA1_3_Y_COUNT,val)
#define bfin_read_DMA1_3_X_MODIFY()          bfin_read16(DMA1_3_X_MODIFY)
#define bfin_write_DMA1_3_X_MODIFY(val)      bfin_write16(DMA1_3_X_MODIFY,val)
#define bfin_read_DMA1_3_Y_MODIFY()          bfin_read16(DMA1_3_Y_MODIFY)
#define bfin_write_DMA1_3_Y_MODIFY(val)      bfin_write16(DMA1_3_Y_MODIFY,val)
#define bfin_read_DMA1_3_CURR_DESC_PTR()     bfin_read32(DMA1_3_CURR_DESC_PTR)
#define bfin_write_DMA1_3_CURR_DESC_PTR(val) bfin_write32(DMA1_3_CURR_DESC_PTR,val)
#define bfin_read_DMA1_3_CURR_ADDR()         bfin_read32(DMA1_3_CURR_ADDR)
#define bfin_write_DMA1_3_CURR_ADDR(val)     bfin_write32(DMA1_3_CURR_ADDR,val)
#define bfin_read_DMA1_3_CURR_X_COUNT()      bfin_read16(DMA1_3_CURR_X_COUNT)
#define bfin_write_DMA1_3_CURR_X_COUNT(val)  bfin_write16(DMA1_3_CURR_X_COUNT,val)
#define bfin_read_DMA1_3_CURR_Y_COUNT()      bfin_read16(DMA1_3_CURR_Y_COUNT)
#define bfin_write_DMA1_3_CURR_Y_COUNT(val)  bfin_write16(DMA1_3_CURR_Y_COUNT,val)
#define bfin_read_DMA1_3_IRQ_STATUS()        bfin_read16(DMA1_3_IRQ_STATUS)
#define bfin_write_DMA1_3_IRQ_STATUS(val)    bfin_write16(DMA1_3_IRQ_STATUS,val)
#define bfin_read_DMA1_3_PERIPHERAL_MAP()    bfin_read16(DMA1_3_PERIPHERAL_MAP)
#define bfin_write_DMA1_3_PERIPHERAL_MAP(val) bfin_write16(DMA1_3_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_4_CONFIG()            bfin_read16(DMA1_4_CONFIG)
#define bfin_write_DMA1_4_CONFIG(val)        bfin_write16(DMA1_4_CONFIG,val)
#define bfin_read_DMA1_4_NEXT_DESC_PTR()     bfin_read32(DMA1_4_NEXT_DESC_PTR)
#define bfin_write_DMA1_4_NEXT_DESC_PTR(val) bfin_write32(DMA1_4_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_4_START_ADDR()        bfin_read32(DMA1_4_START_ADDR)
#define bfin_write_DMA1_4_START_ADDR(val)    bfin_write32(DMA1_4_START_ADDR,val)
#define bfin_read_DMA1_4_X_COUNT()           bfin_read16(DMA1_4_X_COUNT)
#define bfin_write_DMA1_4_X_COUNT(val)       bfin_write16(DMA1_4_X_COUNT,val)
#define bfin_read_DMA1_4_Y_COUNT()           bfin_read16(DMA1_4_Y_COUNT)
#define bfin_write_DMA1_4_Y_COUNT(val)       bfin_write16(DMA1_4_Y_COUNT,val)
#define bfin_read_DMA1_4_X_MODIFY()          bfin_read16(DMA1_4_X_MODIFY)
#define bfin_write_DMA1_4_X_MODIFY(val)      bfin_write16(DMA1_4_X_MODIFY,val)
#define bfin_read_DMA1_4_Y_MODIFY()          bfin_read16(DMA1_4_Y_MODIFY)
#define bfin_write_DMA1_4_Y_MODIFY(val)      bfin_write16(DMA1_4_Y_MODIFY,val)
#define bfin_read_DMA1_4_CURR_DESC_PTR()     bfin_read32(DMA1_4_CURR_DESC_PTR)
#define bfin_write_DMA1_4_CURR_DESC_PTR(val) bfin_write32(DMA1_4_CURR_DESC_PTR,val)
#define bfin_read_DMA1_4_CURR_ADDR()         bfin_read32(DMA1_4_CURR_ADDR)
#define bfin_write_DMA1_4_CURR_ADDR(val)     bfin_write32(DMA1_4_CURR_ADDR,val)
#define bfin_read_DMA1_4_CURR_X_COUNT()      bfin_read16(DMA1_4_CURR_X_COUNT)
#define bfin_write_DMA1_4_CURR_X_COUNT(val)  bfin_write16(DMA1_4_CURR_X_COUNT,val)
#define bfin_read_DMA1_4_CURR_Y_COUNT()      bfin_read16(DMA1_4_CURR_Y_COUNT)
#define bfin_write_DMA1_4_CURR_Y_COUNT(val)  bfin_write16(DMA1_4_CURR_Y_COUNT,val)
#define bfin_read_DMA1_4_IRQ_STATUS()        bfin_read16(DMA1_4_IRQ_STATUS)
#define bfin_write_DMA1_4_IRQ_STATUS(val)    bfin_write16(DMA1_4_IRQ_STATUS,val)
#define bfin_read_DMA1_4_PERIPHERAL_MAP()    bfin_read16(DMA1_4_PERIPHERAL_MAP)
#define bfin_write_DMA1_4_PERIPHERAL_MAP(val) bfin_write16(DMA1_4_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_5_CONFIG()            bfin_read16(DMA1_5_CONFIG)
#define bfin_write_DMA1_5_CONFIG(val)        bfin_write16(DMA1_5_CONFIG,val)
#define bfin_read_DMA1_5_NEXT_DESC_PTR()     bfin_read32(DMA1_5_NEXT_DESC_PTR)
#define bfin_write_DMA1_5_NEXT_DESC_PTR(val) bfin_write32(DMA1_5_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_5_START_ADDR()        bfin_read32(DMA1_5_START_ADDR)
#define bfin_write_DMA1_5_START_ADDR(val)    bfin_write32(DMA1_5_START_ADDR,val)
#define bfin_read_DMA1_5_X_COUNT()           bfin_read16(DMA1_5_X_COUNT)
#define bfin_write_DMA1_5_X_COUNT(val)       bfin_write16(DMA1_5_X_COUNT,val)
#define bfin_read_DMA1_5_Y_COUNT()           bfin_read16(DMA1_5_Y_COUNT)
#define bfin_write_DMA1_5_Y_COUNT(val)       bfin_write16(DMA1_5_Y_COUNT,val)
#define bfin_read_DMA1_5_X_MODIFY()          bfin_read16(DMA1_5_X_MODIFY)
#define bfin_write_DMA1_5_X_MODIFY(val)      bfin_write16(DMA1_5_X_MODIFY,val)
#define bfin_read_DMA1_5_Y_MODIFY()          bfin_read16(DMA1_5_Y_MODIFY)
#define bfin_write_DMA1_5_Y_MODIFY(val)      bfin_write16(DMA1_5_Y_MODIFY,val)
#define bfin_read_DMA1_5_CURR_DESC_PTR()     bfin_read32(DMA1_5_CURR_DESC_PTR)
#define bfin_write_DMA1_5_CURR_DESC_PTR(val) bfin_write32(DMA1_5_CURR_DESC_PTR,val)
#define bfin_read_DMA1_5_CURR_ADDR()         bfin_read32(DMA1_5_CURR_ADDR)
#define bfin_write_DMA1_5_CURR_ADDR(val)     bfin_write32(DMA1_5_CURR_ADDR,val)
#define bfin_read_DMA1_5_CURR_X_COUNT()      bfin_read16(DMA1_5_CURR_X_COUNT)
#define bfin_write_DMA1_5_CURR_X_COUNT(val)  bfin_write16(DMA1_5_CURR_X_COUNT,val)
#define bfin_read_DMA1_5_CURR_Y_COUNT()      bfin_read16(DMA1_5_CURR_Y_COUNT)
#define bfin_write_DMA1_5_CURR_Y_COUNT(val)  bfin_write16(DMA1_5_CURR_Y_COUNT,val)
#define bfin_read_DMA1_5_IRQ_STATUS()        bfin_read16(DMA1_5_IRQ_STATUS)
#define bfin_write_DMA1_5_IRQ_STATUS(val)    bfin_write16(DMA1_5_IRQ_STATUS,val)
#define bfin_read_DMA1_5_PERIPHERAL_MAP()    bfin_read16(DMA1_5_PERIPHERAL_MAP)
#define bfin_write_DMA1_5_PERIPHERAL_MAP(val) bfin_write16(DMA1_5_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_6_CONFIG()            bfin_read16(DMA1_6_CONFIG)
#define bfin_write_DMA1_6_CONFIG(val)        bfin_write16(DMA1_6_CONFIG,val)
#define bfin_read_DMA1_6_NEXT_DESC_PTR()     bfin_read32(DMA1_6_NEXT_DESC_PTR)
#define bfin_write_DMA1_6_NEXT_DESC_PTR(val) bfin_write32(DMA1_6_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_6_START_ADDR()        bfin_read32(DMA1_6_START_ADDR)
#define bfin_write_DMA1_6_START_ADDR(val)    bfin_write32(DMA1_6_START_ADDR,val)
#define bfin_read_DMA1_6_X_COUNT()           bfin_read16(DMA1_6_X_COUNT)
#define bfin_write_DMA1_6_X_COUNT(val)       bfin_write16(DMA1_6_X_COUNT,val)
#define bfin_read_DMA1_6_Y_COUNT()           bfin_read16(DMA1_6_Y_COUNT)
#define bfin_write_DMA1_6_Y_COUNT(val)       bfin_write16(DMA1_6_Y_COUNT,val)
#define bfin_read_DMA1_6_X_MODIFY()          bfin_read16(DMA1_6_X_MODIFY)
#define bfin_write_DMA1_6_X_MODIFY(val)      bfin_write16(DMA1_6_X_MODIFY,val)
#define bfin_read_DMA1_6_Y_MODIFY()          bfin_read16(DMA1_6_Y_MODIFY)
#define bfin_write_DMA1_6_Y_MODIFY(val)      bfin_write16(DMA1_6_Y_MODIFY,val)
#define bfin_read_DMA1_6_CURR_DESC_PTR()     bfin_read32(DMA1_6_CURR_DESC_PTR)
#define bfin_write_DMA1_6_CURR_DESC_PTR(val) bfin_write32(DMA1_6_CURR_DESC_PTR,val)
#define bfin_read_DMA1_6_CURR_ADDR()         bfin_read32(DMA1_6_CURR_ADDR)
#define bfin_write_DMA1_6_CURR_ADDR(val)     bfin_write32(DMA1_6_CURR_ADDR,val)
#define bfin_read_DMA1_6_CURR_X_COUNT()      bfin_read16(DMA1_6_CURR_X_COUNT)
#define bfin_write_DMA1_6_CURR_X_COUNT(val)  bfin_write16(DMA1_6_CURR_X_COUNT,val)
#define bfin_read_DMA1_6_CURR_Y_COUNT()      bfin_read16(DMA1_6_CURR_Y_COUNT)
#define bfin_write_DMA1_6_CURR_Y_COUNT(val)  bfin_write16(DMA1_6_CURR_Y_COUNT,val)
#define bfin_read_DMA1_6_IRQ_STATUS()        bfin_read16(DMA1_6_IRQ_STATUS)
#define bfin_write_DMA1_6_IRQ_STATUS(val)    bfin_write16(DMA1_6_IRQ_STATUS,val)
#define bfin_read_DMA1_6_PERIPHERAL_MAP()    bfin_read16(DMA1_6_PERIPHERAL_MAP)
#define bfin_write_DMA1_6_PERIPHERAL_MAP(val) bfin_write16(DMA1_6_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_7_CONFIG()            bfin_read16(DMA1_7_CONFIG)
#define bfin_write_DMA1_7_CONFIG(val)        bfin_write16(DMA1_7_CONFIG,val)
#define bfin_read_DMA1_7_NEXT_DESC_PTR()     bfin_read32(DMA1_7_NEXT_DESC_PTR)
#define bfin_write_DMA1_7_NEXT_DESC_PTR(val) bfin_write32(DMA1_7_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_7_START_ADDR()        bfin_read32(DMA1_7_START_ADDR)
#define bfin_write_DMA1_7_START_ADDR(val)    bfin_write32(DMA1_7_START_ADDR,val)
#define bfin_read_DMA1_7_X_COUNT()           bfin_read16(DMA1_7_X_COUNT)
#define bfin_write_DMA1_7_X_COUNT(val)       bfin_write16(DMA1_7_X_COUNT,val)
#define bfin_read_DMA1_7_Y_COUNT()           bfin_read16(DMA1_7_Y_COUNT)
#define bfin_write_DMA1_7_Y_COUNT(val)       bfin_write16(DMA1_7_Y_COUNT,val)
#define bfin_read_DMA1_7_X_MODIFY()          bfin_read16(DMA1_7_X_MODIFY)
#define bfin_write_DMA1_7_X_MODIFY(val)      bfin_write16(DMA1_7_X_MODIFY,val)
#define bfin_read_DMA1_7_Y_MODIFY()          bfin_read16(DMA1_7_Y_MODIFY)
#define bfin_write_DMA1_7_Y_MODIFY(val)      bfin_write16(DMA1_7_Y_MODIFY,val)
#define bfin_read_DMA1_7_CURR_DESC_PTR()     bfin_read32(DMA1_7_CURR_DESC_PTR)
#define bfin_write_DMA1_7_CURR_DESC_PTR(val) bfin_write32(DMA1_7_CURR_DESC_PTR,val)
#define bfin_read_DMA1_7_CURR_ADDR()         bfin_read32(DMA1_7_CURR_ADDR)
#define bfin_write_DMA1_7_CURR_ADDR(val)     bfin_write32(DMA1_7_CURR_ADDR,val)
#define bfin_read_DMA1_7_CURR_X_COUNT()      bfin_read16(DMA1_7_CURR_X_COUNT)
#define bfin_write_DMA1_7_CURR_X_COUNT(val)  bfin_write16(DMA1_7_CURR_X_COUNT,val)
#define bfin_read_DMA1_7_CURR_Y_COUNT()      bfin_read16(DMA1_7_CURR_Y_COUNT)
#define bfin_write_DMA1_7_CURR_Y_COUNT(val)  bfin_write16(DMA1_7_CURR_Y_COUNT,val)
#define bfin_read_DMA1_7_IRQ_STATUS()        bfin_read16(DMA1_7_IRQ_STATUS)
#define bfin_write_DMA1_7_IRQ_STATUS(val)    bfin_write16(DMA1_7_IRQ_STATUS,val)
#define bfin_read_DMA1_7_PERIPHERAL_MAP()    bfin_read16(DMA1_7_PERIPHERAL_MAP)
#define bfin_write_DMA1_7_PERIPHERAL_MAP(val) bfin_write16(DMA1_7_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_8_CONFIG()            bfin_read16(DMA1_8_CONFIG)
#define bfin_write_DMA1_8_CONFIG(val)        bfin_write16(DMA1_8_CONFIG,val)
#define bfin_read_DMA1_8_NEXT_DESC_PTR()     bfin_read32(DMA1_8_NEXT_DESC_PTR)
#define bfin_write_DMA1_8_NEXT_DESC_PTR(val) bfin_write32(DMA1_8_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_8_START_ADDR()        bfin_read32(DMA1_8_START_ADDR)
#define bfin_write_DMA1_8_START_ADDR(val)    bfin_write32(DMA1_8_START_ADDR,val)
#define bfin_read_DMA1_8_X_COUNT()           bfin_read16(DMA1_8_X_COUNT)
#define bfin_write_DMA1_8_X_COUNT(val)       bfin_write16(DMA1_8_X_COUNT,val)
#define bfin_read_DMA1_8_Y_COUNT()           bfin_read16(DMA1_8_Y_COUNT)
#define bfin_write_DMA1_8_Y_COUNT(val)       bfin_write16(DMA1_8_Y_COUNT,val)
#define bfin_read_DMA1_8_X_MODIFY()          bfin_read16(DMA1_8_X_MODIFY)
#define bfin_write_DMA1_8_X_MODIFY(val)      bfin_write16(DMA1_8_X_MODIFY,val)
#define bfin_read_DMA1_8_Y_MODIFY()          bfin_read16(DMA1_8_Y_MODIFY)
#define bfin_write_DMA1_8_Y_MODIFY(val)      bfin_write16(DMA1_8_Y_MODIFY,val)
#define bfin_read_DMA1_8_CURR_DESC_PTR()     bfin_read32(DMA1_8_CURR_DESC_PTR)
#define bfin_write_DMA1_8_CURR_DESC_PTR(val) bfin_write32(DMA1_8_CURR_DESC_PTR,val)
#define bfin_read_DMA1_8_CURR_ADDR()         bfin_read32(DMA1_8_CURR_ADDR)
#define bfin_write_DMA1_8_CURR_ADDR(val)     bfin_write32(DMA1_8_CURR_ADDR,val)
#define bfin_read_DMA1_8_CURR_X_COUNT()      bfin_read16(DMA1_8_CURR_X_COUNT)
#define bfin_write_DMA1_8_CURR_X_COUNT(val)  bfin_write16(DMA1_8_CURR_X_COUNT,val)
#define bfin_read_DMA1_8_CURR_Y_COUNT()      bfin_read16(DMA1_8_CURR_Y_COUNT)
#define bfin_write_DMA1_8_CURR_Y_COUNT(val)  bfin_write16(DMA1_8_CURR_Y_COUNT,val)
#define bfin_read_DMA1_8_IRQ_STATUS()        bfin_read16(DMA1_8_IRQ_STATUS)
#define bfin_write_DMA1_8_IRQ_STATUS(val)    bfin_write16(DMA1_8_IRQ_STATUS,val)
#define bfin_read_DMA1_8_PERIPHERAL_MAP()    bfin_read16(DMA1_8_PERIPHERAL_MAP)
#define bfin_write_DMA1_8_PERIPHERAL_MAP(val) bfin_write16(DMA1_8_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_9_CONFIG()            bfin_read16(DMA1_9_CONFIG)
#define bfin_write_DMA1_9_CONFIG(val)        bfin_write16(DMA1_9_CONFIG,val)
#define bfin_read_DMA1_9_NEXT_DESC_PTR()     bfin_read32(DMA1_9_NEXT_DESC_PTR)
#define bfin_write_DMA1_9_NEXT_DESC_PTR(val) bfin_write32(DMA1_9_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_9_START_ADDR()        bfin_read32(DMA1_9_START_ADDR)
#define bfin_write_DMA1_9_START_ADDR(val)    bfin_write32(DMA1_9_START_ADDR,val)
#define bfin_read_DMA1_9_X_COUNT()           bfin_read16(DMA1_9_X_COUNT)
#define bfin_write_DMA1_9_X_COUNT(val)       bfin_write16(DMA1_9_X_COUNT,val)
#define bfin_read_DMA1_9_Y_COUNT()           bfin_read16(DMA1_9_Y_COUNT)
#define bfin_write_DMA1_9_Y_COUNT(val)       bfin_write16(DMA1_9_Y_COUNT,val)
#define bfin_read_DMA1_9_X_MODIFY()          bfin_read16(DMA1_9_X_MODIFY)
#define bfin_write_DMA1_9_X_MODIFY(val)      bfin_write16(DMA1_9_X_MODIFY,val)
#define bfin_read_DMA1_9_Y_MODIFY()          bfin_read16(DMA1_9_Y_MODIFY)
#define bfin_write_DMA1_9_Y_MODIFY(val)      bfin_write16(DMA1_9_Y_MODIFY,val)
#define bfin_read_DMA1_9_CURR_DESC_PTR()     bfin_read32(DMA1_9_CURR_DESC_PTR)
#define bfin_write_DMA1_9_CURR_DESC_PTR(val) bfin_write32(DMA1_9_CURR_DESC_PTR,val)
#define bfin_read_DMA1_9_CURR_ADDR()         bfin_read32(DMA1_9_CURR_ADDR)
#define bfin_write_DMA1_9_CURR_ADDR(val)     bfin_write32(DMA1_9_CURR_ADDR,val)
#define bfin_read_DMA1_9_CURR_X_COUNT()      bfin_read16(DMA1_9_CURR_X_COUNT)
#define bfin_write_DMA1_9_CURR_X_COUNT(val)  bfin_write16(DMA1_9_CURR_X_COUNT,val)
#define bfin_read_DMA1_9_CURR_Y_COUNT()      bfin_read16(DMA1_9_CURR_Y_COUNT)
#define bfin_write_DMA1_9_CURR_Y_COUNT(val)  bfin_write16(DMA1_9_CURR_Y_COUNT,val)
#define bfin_read_DMA1_9_IRQ_STATUS()        bfin_read16(DMA1_9_IRQ_STATUS)
#define bfin_write_DMA1_9_IRQ_STATUS(val)    bfin_write16(DMA1_9_IRQ_STATUS,val)
#define bfin_read_DMA1_9_PERIPHERAL_MAP()    bfin_read16(DMA1_9_PERIPHERAL_MAP)
#define bfin_write_DMA1_9_PERIPHERAL_MAP(val) bfin_write16(DMA1_9_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_10_CONFIG()           bfin_read16(DMA1_10_CONFIG)
#define bfin_write_DMA1_10_CONFIG(val)       bfin_write16(DMA1_10_CONFIG,val)
#define bfin_read_DMA1_10_NEXT_DESC_PTR()    bfin_read32(DMA1_10_NEXT_DESC_PTR)
#define bfin_write_DMA1_10_NEXT_DESC_PTR(val) bfin_write32(DMA1_10_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_10_START_ADDR()       bfin_read32(DMA1_10_START_ADDR)
#define bfin_write_DMA1_10_START_ADDR(val)   bfin_write32(DMA1_10_START_ADDR,val)
#define bfin_read_DMA1_10_X_COUNT()          bfin_read16(DMA1_10_X_COUNT)
#define bfin_write_DMA1_10_X_COUNT(val)      bfin_write16(DMA1_10_X_COUNT,val)
#define bfin_read_DMA1_10_Y_COUNT()          bfin_read16(DMA1_10_Y_COUNT)
#define bfin_write_DMA1_10_Y_COUNT(val)      bfin_write16(DMA1_10_Y_COUNT,val)
#define bfin_read_DMA1_10_X_MODIFY()         bfin_read16(DMA1_10_X_MODIFY)
#define bfin_write_DMA1_10_X_MODIFY(val)     bfin_write16(DMA1_10_X_MODIFY,val)
#define bfin_read_DMA1_10_Y_MODIFY()         bfin_read16(DMA1_10_Y_MODIFY)
#define bfin_write_DMA1_10_Y_MODIFY(val)     bfin_write16(DMA1_10_Y_MODIFY,val)
#define bfin_read_DMA1_10_CURR_DESC_PTR()    bfin_read32(DMA1_10_CURR_DESC_PTR)
#define bfin_write_DMA1_10_CURR_DESC_PTR(val) bfin_write32(DMA1_10_CURR_DESC_PTR,val)
#define bfin_read_DMA1_10_CURR_ADDR()        bfin_read32(DMA1_10_CURR_ADDR)
#define bfin_write_DMA1_10_CURR_ADDR(val)    bfin_write32(DMA1_10_CURR_ADDR,val)
#define bfin_read_DMA1_10_CURR_X_COUNT()     bfin_read16(DMA1_10_CURR_X_COUNT)
#define bfin_write_DMA1_10_CURR_X_COUNT(val) bfin_write16(DMA1_10_CURR_X_COUNT,val)
#define bfin_read_DMA1_10_CURR_Y_COUNT()     bfin_read16(DMA1_10_CURR_Y_COUNT)
#define bfin_write_DMA1_10_CURR_Y_COUNT(val) bfin_write16(DMA1_10_CURR_Y_COUNT,val)
#define bfin_read_DMA1_10_IRQ_STATUS()       bfin_read16(DMA1_10_IRQ_STATUS)
#define bfin_write_DMA1_10_IRQ_STATUS(val)   bfin_write16(DMA1_10_IRQ_STATUS,val)
#define bfin_read_DMA1_10_PERIPHERAL_MAP()   bfin_read16(DMA1_10_PERIPHERAL_MAP)
#define bfin_write_DMA1_10_PERIPHERAL_MAP(val) bfin_write16(DMA1_10_PERIPHERAL_MAP,val)
#define bfin_read_DMA1_11_CONFIG()           bfin_read16(DMA1_11_CONFIG)
#define bfin_write_DMA1_11_CONFIG(val)       bfin_write16(DMA1_11_CONFIG,val)
#define bfin_read_DMA1_11_NEXT_DESC_PTR()    bfin_read32(DMA1_11_NEXT_DESC_PTR)
#define bfin_write_DMA1_11_NEXT_DESC_PTR(val) bfin_write32(DMA1_11_NEXT_DESC_PTR,val)
#define bfin_read_DMA1_11_START_ADDR()       bfin_read32(DMA1_11_START_ADDR)
#define bfin_write_DMA1_11_START_ADDR(val)   bfin_write32(DMA1_11_START_ADDR,val)
#define bfin_read_DMA1_11_X_COUNT()          bfin_read16(DMA1_11_X_COUNT)
#define bfin_write_DMA1_11_X_COUNT(val)      bfin_write16(DMA1_11_X_COUNT,val)
#define bfin_read_DMA1_11_Y_COUNT()          bfin_read16(DMA1_11_Y_COUNT)
#define bfin_write_DMA1_11_Y_COUNT(val)      bfin_write16(DMA1_11_Y_COUNT,val)
#define bfin_read_DMA1_11_X_MODIFY()         bfin_read16(DMA1_11_X_MODIFY)
#define bfin_write_DMA1_11_X_MODIFY(val)     bfin_write16(DMA1_11_X_MODIFY,val)
#define bfin_read_DMA1_11_Y_MODIFY()         bfin_read16(DMA1_11_Y_MODIFY)
#define bfin_write_DMA1_11_Y_MODIFY(val)     bfin_write16(DMA1_11_Y_MODIFY,val)
#define bfin_read_DMA1_11_CURR_DESC_PTR()    bfin_read32(DMA1_11_CURR_DESC_PTR)
#define bfin_write_DMA1_11_CURR_DESC_PTR(val) bfin_write32(DMA1_11_CURR_DESC_PTR,val)
#define bfin_read_DMA1_11_CURR_ADDR()        bfin_read32(DMA1_11_CURR_ADDR)
#define bfin_write_DMA1_11_CURR_ADDR(val)    bfin_write32(DMA1_11_CURR_ADDR,val)
#define bfin_read_DMA1_11_CURR_X_COUNT()     bfin_read16(DMA1_11_CURR_X_COUNT)
#define bfin_write_DMA1_11_CURR_X_COUNT(val) bfin_write16(DMA1_11_CURR_X_COUNT,val)
#define bfin_read_DMA1_11_CURR_Y_COUNT()     bfin_read16(DMA1_11_CURR_Y_COUNT)
#define bfin_write_DMA1_11_CURR_Y_COUNT(val) bfin_write16(DMA1_11_CURR_Y_COUNT,val)
#define bfin_read_DMA1_11_IRQ_STATUS()       bfin_read16(DMA1_11_IRQ_STATUS)
#define bfin_write_DMA1_11_IRQ_STATUS(val)   bfin_write16(DMA1_11_IRQ_STATUS,val)
#define bfin_read_DMA1_11_PERIPHERAL_MAP()   bfin_read16(DMA1_11_PERIPHERAL_MAP)
#define bfin_write_DMA1_11_PERIPHERAL_MAP(val) bfin_write16(DMA1_11_PERIPHERAL_MAP,val)
/* Memory DMA1 Controller registers (0xFFC0 1E80-0xFFC0 1FFF) */
#define bfin_read_MDMA1_D0_CONFIG()          bfin_read16(MDMA1_D0_CONFIG)
#define bfin_write_MDMA1_D0_CONFIG(val)      bfin_write16(MDMA1_D0_CONFIG,val)
#define bfin_read_MDMA1_D0_NEXT_DESC_PTR()   bfin_read32(MDMA1_D0_NEXT_DESC_PTR)
#define bfin_write_MDMA1_D0_NEXT_DESC_PTR(val) bfin_write32(MDMA1_D0_NEXT_DESC_PTR,val)
#define bfin_read_MDMA1_D0_START_ADDR()      bfin_read32(MDMA1_D0_START_ADDR)
#define bfin_write_MDMA1_D0_START_ADDR(val)  bfin_write32(MDMA1_D0_START_ADDR,val)
#define bfin_read_MDMA1_D0_X_COUNT()         bfin_read16(MDMA1_D0_X_COUNT)
#define bfin_write_MDMA1_D0_X_COUNT(val)     bfin_write16(MDMA1_D0_X_COUNT,val)
#define bfin_read_MDMA1_D0_Y_COUNT()         bfin_read16(MDMA1_D0_Y_COUNT)
#define bfin_write_MDMA1_D0_Y_COUNT(val)     bfin_write16(MDMA1_D0_Y_COUNT,val)
#define bfin_read_MDMA1_D0_X_MODIFY()        bfin_read16(MDMA1_D0_X_MODIFY)
#define bfin_write_MDMA1_D0_X_MODIFY(val)    bfin_write16(MDMA1_D0_X_MODIFY,val)
#define bfin_read_MDMA1_D0_Y_MODIFY()        bfin_read16(MDMA1_D0_Y_MODIFY)
#define bfin_write_MDMA1_D0_Y_MODIFY(val)    bfin_write16(MDMA1_D0_Y_MODIFY,val)
#define bfin_read_MDMA1_D0_CURR_DESC_PTR()   bfin_read32(MDMA1_D0_CURR_DESC_PTR)
#define bfin_write_MDMA1_D0_CURR_DESC_PTR(val) bfin_write32(MDMA1_D0_CURR_DESC_PTR,val)
#define bfin_read_MDMA1_D0_CURR_ADDR()       bfin_read32(MDMA1_D0_CURR_ADDR)
#define bfin_write_MDMA1_D0_CURR_ADDR(val)   bfin_write32(MDMA1_D0_CURR_ADDR,val)
#define bfin_read_MDMA1_D0_CURR_X_COUNT()    bfin_read16(MDMA1_D0_CURR_X_COUNT)
#define bfin_write_MDMA1_D0_CURR_X_COUNT(val) bfin_write16(MDMA1_D0_CURR_X_COUNT,val)
#define bfin_read_MDMA1_D0_CURR_Y_COUNT()    bfin_read16(MDMA1_D0_CURR_Y_COUNT)
#define bfin_write_MDMA1_D0_CURR_Y_COUNT(val) bfin_write16(MDMA1_D0_CURR_Y_COUNT,val)
#define bfin_read_MDMA1_D0_IRQ_STATUS()      bfin_read16(MDMA1_D0_IRQ_STATUS)
#define bfin_write_MDMA1_D0_IRQ_STATUS(val)  bfin_write16(MDMA1_D0_IRQ_STATUS,val)
#define bfin_read_MDMA1_D0_PERIPHERAL_MAP()  bfin_read16(MDMA1_D0_PERIPHERAL_MAP)
#define bfin_write_MDMA1_D0_PERIPHERAL_MAP(val) bfin_write16(MDMA1_D0_PERIPHERAL_MAP,val)
#define bfin_read_MDMA1_S0_CONFIG()          bfin_read16(MDMA1_S0_CONFIG)
#define bfin_write_MDMA1_S0_CONFIG(val)      bfin_write16(MDMA1_S0_CONFIG,val)
#define bfin_read_MDMA1_S0_NEXT_DESC_PTR()   bfin_read32(MDMA1_S0_NEXT_DESC_PTR)
#define bfin_write_MDMA1_S0_NEXT_DESC_PTR(val) bfin_write32(MDMA1_S0_NEXT_DESC_PTR,val)
#define bfin_read_MDMA1_S0_START_ADDR()      bfin_read32(MDMA1_S0_START_ADDR)
#define bfin_write_MDMA1_S0_START_ADDR(val)  bfin_write32(MDMA1_S0_START_ADDR,val)
#define bfin_read_MDMA1_S0_X_COUNT()         bfin_read16(MDMA1_S0_X_COUNT)
#define bfin_write_MDMA1_S0_X_COUNT(val)     bfin_write16(MDMA1_S0_X_COUNT,val)
#define bfin_read_MDMA1_S0_Y_COUNT()         bfin_read16(MDMA1_S0_Y_COUNT)
#define bfin_write_MDMA1_S0_Y_COUNT(val)     bfin_write16(MDMA1_S0_Y_COUNT,val)
#define bfin_read_MDMA1_S0_X_MODIFY()        bfin_read16(MDMA1_S0_X_MODIFY)
#define bfin_write_MDMA1_S0_X_MODIFY(val)    bfin_write16(MDMA1_S0_X_MODIFY,val)
#define bfin_read_MDMA1_S0_Y_MODIFY()        bfin_read16(MDMA1_S0_Y_MODIFY)
#define bfin_write_MDMA1_S0_Y_MODIFY(val)    bfin_write16(MDMA1_S0_Y_MODIFY,val)
#define bfin_read_MDMA1_S0_CURR_DESC_PTR()   bfin_read32(MDMA1_S0_CURR_DESC_PTR)
#define bfin_write_MDMA1_S0_CURR_DESC_PTR(val) bfin_write32(MDMA1_S0_CURR_DESC_PTR,val)
#define bfin_read_MDMA1_S0_CURR_ADDR()       bfin_read32(MDMA1_S0_CURR_ADDR)
#define bfin_write_MDMA1_S0_CURR_ADDR(val)   bfin_write32(MDMA1_S0_CURR_ADDR,val)
#define bfin_read_MDMA1_S0_CURR_X_COUNT()    bfin_read16(MDMA1_S0_CURR_X_COUNT)
#define bfin_write_MDMA1_S0_CURR_X_COUNT(val) bfin_write16(MDMA1_S0_CURR_X_COUNT,val)
#define bfin_read_MDMA1_S0_CURR_Y_COUNT()    bfin_read16(MDMA1_S0_CURR_Y_COUNT)
#define bfin_write_MDMA1_S0_CURR_Y_COUNT(val) bfin_write16(MDMA1_S0_CURR_Y_COUNT,val)
#define bfin_read_MDMA1_S0_IRQ_STATUS()      bfin_read16(MDMA1_S0_IRQ_STATUS)
#define bfin_write_MDMA1_S0_IRQ_STATUS(val)  bfin_write16(MDMA1_S0_IRQ_STATUS,val)
#define bfin_read_MDMA1_S0_PERIPHERAL_MAP()  bfin_read16(MDMA1_S0_PERIPHERAL_MAP)
#define bfin_write_MDMA1_S0_PERIPHERAL_MAP(val) bfin_write16(MDMA1_S0_PERIPHERAL_MAP,val)
#define bfin_read_MDMA1_D1_CONFIG()          bfin_read16(MDMA1_D1_CONFIG)
#define bfin_write_MDMA1_D1_CONFIG(val)      bfin_write16(MDMA1_D1_CONFIG,val)
#define bfin_read_MDMA1_D1_NEXT_DESC_PTR()   bfin_read32(MDMA1_D1_NEXT_DESC_PTR)
#define bfin_write_MDMA1_D1_NEXT_DESC_PTR(val) bfin_write32(MDMA1_D1_NEXT_DESC_PTR,val)
#define bfin_read_MDMA1_D1_START_ADDR()      bfin_read32(MDMA1_D1_START_ADDR)
#define bfin_write_MDMA1_D1_START_ADDR(val)  bfin_write32(MDMA1_D1_START_ADDR,val)
#define bfin_read_MDMA1_D1_X_COUNT()         bfin_read16(MDMA1_D1_X_COUNT)
#define bfin_write_MDMA1_D1_X_COUNT(val)     bfin_write16(MDMA1_D1_X_COUNT,val)
#define bfin_read_MDMA1_D1_Y_COUNT()         bfin_read16(MDMA1_D1_Y_COUNT)
#define bfin_write_MDMA1_D1_Y_COUNT(val)     bfin_write16(MDMA1_D1_Y_COUNT,val)
#define bfin_read_MDMA1_D1_X_MODIFY()        bfin_read16(MDMA1_D1_X_MODIFY)
#define bfin_write_MDMA1_D1_X_MODIFY(val)    bfin_write16(MDMA1_D1_X_MODIFY,val)
#define bfin_read_MDMA1_D1_Y_MODIFY()        bfin_read16(MDMA1_D1_Y_MODIFY)
#define bfin_write_MDMA1_D1_Y_MODIFY(val)    bfin_write16(MDMA1_D1_Y_MODIFY,val)
#define bfin_read_MDMA1_D1_CURR_DESC_PTR()   bfin_read32(MDMA1_D1_CURR_DESC_PTR)
#define bfin_write_MDMA1_D1_CURR_DESC_PTR(val) bfin_write32(MDMA1_D1_CURR_DESC_PTR,val)
#define bfin_read_MDMA1_D1_CURR_ADDR()       bfin_read32(MDMA1_D1_CURR_ADDR)
#define bfin_write_MDMA1_D1_CURR_ADDR(val)   bfin_write32(MDMA1_D1_CURR_ADDR,val)
#define bfin_read_MDMA1_D1_CURR_X_COUNT()    bfin_read16(MDMA1_D1_CURR_X_COUNT)
#define bfin_write_MDMA1_D1_CURR_X_COUNT(val) bfin_write16(MDMA1_D1_CURR_X_COUNT,val)
#define bfin_read_MDMA1_D1_CURR_Y_COUNT()    bfin_read16(MDMA1_D1_CURR_Y_COUNT)
#define bfin_write_MDMA1_D1_CURR_Y_COUNT(val) bfin_write16(MDMA1_D1_CURR_Y_COUNT,val)
#define bfin_read_MDMA1_D1_IRQ_STATUS()      bfin_read16(MDMA1_D1_IRQ_STATUS)
#define bfin_write_MDMA1_D1_IRQ_STATUS(val)  bfin_write16(MDMA1_D1_IRQ_STATUS,val)
#define bfin_read_MDMA1_D1_PERIPHERAL_MAP()  bfin_read16(MDMA1_D1_PERIPHERAL_MAP)
#define bfin_write_MDMA1_D1_PERIPHERAL_MAP(val) bfin_write16(MDMA1_D1_PERIPHERAL_MAP,val)
#define bfin_read_MDMA1_S1_CONFIG()          bfin_read16(MDMA1_S1_CONFIG)
#define bfin_write_MDMA1_S1_CONFIG(val)      bfin_write16(MDMA1_S1_CONFIG,val)
#define bfin_read_MDMA1_S1_NEXT_DESC_PTR()   bfin_read32(MDMA1_S1_NEXT_DESC_PTR)
#define bfin_write_MDMA1_S1_NEXT_DESC_PTR(val) bfin_write32(MDMA1_S1_NEXT_DESC_PTR,val)
#define bfin_read_MDMA1_S1_START_ADDR()      bfin_read32(MDMA1_S1_START_ADDR)
#define bfin_write_MDMA1_S1_START_ADDR(val)  bfin_write32(MDMA1_S1_START_ADDR,val)
#define bfin_read_MDMA1_S1_X_COUNT()         bfin_read16(MDMA1_S1_X_COUNT)
#define bfin_write_MDMA1_S1_X_COUNT(val)     bfin_write16(MDMA1_S1_X_COUNT,val)
#define bfin_read_MDMA1_S1_Y_COUNT()         bfin_read16(MDMA1_S1_Y_COUNT)
#define bfin_write_MDMA1_S1_Y_COUNT(val)     bfin_write16(MDMA1_S1_Y_COUNT,val)
#define bfin_read_MDMA1_S1_X_MODIFY()        bfin_read16(MDMA1_S1_X_MODIFY)
#define bfin_write_MDMA1_S1_X_MODIFY(val)    bfin_write16(MDMA1_S1_X_MODIFY,val)
#define bfin_read_MDMA1_S1_Y_MODIFY()        bfin_read16(MDMA1_S1_Y_MODIFY)
#define bfin_write_MDMA1_S1_Y_MODIFY(val)    bfin_write16(MDMA1_S1_Y_MODIFY,val)
#define bfin_read_MDMA1_S1_CURR_DESC_PTR()   bfin_read32(MDMA1_S1_CURR_DESC_PTR)
#define bfin_write_MDMA1_S1_CURR_DESC_PTR(val) bfin_write32(MDMA1_S1_CURR_DESC_PTR,val)
#define bfin_read_MDMA1_S1_CURR_ADDR()       bfin_read32(MDMA1_S1_CURR_ADDR)
#define bfin_write_MDMA1_S1_CURR_ADDR(val)   bfin_write32(MDMA1_S1_CURR_ADDR,val)
#define bfin_read_MDMA1_S1_CURR_X_COUNT()    bfin_read16(MDMA1_S1_CURR_X_COUNT)
#define bfin_write_MDMA1_S1_CURR_X_COUNT(val) bfin_write16(MDMA1_S1_CURR_X_COUNT,val)
#define bfin_read_MDMA1_S1_CURR_Y_COUNT()    bfin_read16(MDMA1_S1_CURR_Y_COUNT)
#define bfin_write_MDMA1_S1_CURR_Y_COUNT(val) bfin_write16(MDMA1_S1_CURR_Y_COUNT,val)
#define bfin_read_MDMA1_S1_IRQ_STATUS()      bfin_read16(MDMA1_S1_IRQ_STATUS)
#define bfin_write_MDMA1_S1_IRQ_STATUS(val)  bfin_write16(MDMA1_S1_IRQ_STATUS,val)
#define bfin_read_MDMA1_S1_PERIPHERAL_MAP()  bfin_read16(MDMA1_S1_PERIPHERAL_MAP)
#define bfin_write_MDMA1_S1_PERIPHERAL_MAP(val) bfin_write16(MDMA1_S1_PERIPHERAL_MAP,val)
/* DMA2 Controller registers (0xFFC0 0C00-0xFFC0 0DFF) */
#define bfin_read_DMA2_0_CONFIG()            bfin_read16(DMA2_0_CONFIG)
#define bfin_write_DMA2_0_CONFIG(val)        bfin_write16(DMA2_0_CONFIG,val)
#define bfin_read_DMA2_0_NEXT_DESC_PTR()     bfin_read32(DMA2_0_NEXT_DESC_PTR)
#define bfin_write_DMA2_0_NEXT_DESC_PTR(val) bfin_write32(DMA2_0_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_0_START_ADDR()        bfin_read32(DMA2_0_START_ADDR)
#define bfin_write_DMA2_0_START_ADDR(val)    bfin_write32(DMA2_0_START_ADDR,val)
#define bfin_read_DMA2_0_X_COUNT()           bfin_read16(DMA2_0_X_COUNT)
#define bfin_write_DMA2_0_X_COUNT(val)       bfin_write16(DMA2_0_X_COUNT,val)
#define bfin_read_DMA2_0_Y_COUNT()           bfin_read16(DMA2_0_Y_COUNT)
#define bfin_write_DMA2_0_Y_COUNT(val)       bfin_write16(DMA2_0_Y_COUNT,val)
#define bfin_read_DMA2_0_X_MODIFY()          bfin_read16(DMA2_0_X_MODIFY)
#define bfin_write_DMA2_0_X_MODIFY(val)      bfin_write16(DMA2_0_X_MODIFY,val)
#define bfin_read_DMA2_0_Y_MODIFY()          bfin_read16(DMA2_0_Y_MODIFY)
#define bfin_write_DMA2_0_Y_MODIFY(val)      bfin_write16(DMA2_0_Y_MODIFY,val)
#define bfin_read_DMA2_0_CURR_DESC_PTR()     bfin_read32(DMA2_0_CURR_DESC_PTR)
#define bfin_write_DMA2_0_CURR_DESC_PTR(val) bfin_write32(DMA2_0_CURR_DESC_PTR,val)
#define bfin_read_DMA2_0_CURR_ADDR()         bfin_read32(DMA2_0_CURR_ADDR)
#define bfin_write_DMA2_0_CURR_ADDR(val)     bfin_write32(DMA2_0_CURR_ADDR,val)
#define bfin_read_DMA2_0_CURR_X_COUNT()      bfin_read16(DMA2_0_CURR_X_COUNT)
#define bfin_write_DMA2_0_CURR_X_COUNT(val)  bfin_write16(DMA2_0_CURR_X_COUNT,val)
#define bfin_read_DMA2_0_CURR_Y_COUNT()      bfin_read16(DMA2_0_CURR_Y_COUNT)
#define bfin_write_DMA2_0_CURR_Y_COUNT(val)  bfin_write16(DMA2_0_CURR_Y_COUNT,val)
#define bfin_read_DMA2_0_IRQ_STATUS()        bfin_read16(DMA2_0_IRQ_STATUS)
#define bfin_write_DMA2_0_IRQ_STATUS(val)    bfin_write16(DMA2_0_IRQ_STATUS,val)
#define bfin_read_DMA2_0_PERIPHERAL_MAP()    bfin_read16(DMA2_0_PERIPHERAL_MAP)
#define bfin_write_DMA2_0_PERIPHERAL_MAP(val) bfin_write16(DMA2_0_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_1_CONFIG()            bfin_read16(DMA2_1_CONFIG)
#define bfin_write_DMA2_1_CONFIG(val)        bfin_write16(DMA2_1_CONFIG,val)
#define bfin_read_DMA2_1_NEXT_DESC_PTR()     bfin_read32(DMA2_1_NEXT_DESC_PTR)
#define bfin_write_DMA2_1_NEXT_DESC_PTR(val) bfin_write32(DMA2_1_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_1_START_ADDR()        bfin_read32(DMA2_1_START_ADDR)
#define bfin_write_DMA2_1_START_ADDR(val)    bfin_write32(DMA2_1_START_ADDR,val)
#define bfin_read_DMA2_1_X_COUNT()           bfin_read16(DMA2_1_X_COUNT)
#define bfin_write_DMA2_1_X_COUNT(val)       bfin_write16(DMA2_1_X_COUNT,val)
#define bfin_read_DMA2_1_Y_COUNT()           bfin_read16(DMA2_1_Y_COUNT)
#define bfin_write_DMA2_1_Y_COUNT(val)       bfin_write16(DMA2_1_Y_COUNT,val)
#define bfin_read_DMA2_1_X_MODIFY()          bfin_read16(DMA2_1_X_MODIFY)
#define bfin_write_DMA2_1_X_MODIFY(val)      bfin_write16(DMA2_1_X_MODIFY,val)
#define bfin_read_DMA2_1_Y_MODIFY()          bfin_read16(DMA2_1_Y_MODIFY)
#define bfin_write_DMA2_1_Y_MODIFY(val)      bfin_write16(DMA2_1_Y_MODIFY,val)
#define bfin_read_DMA2_1_CURR_DESC_PTR()     bfin_read32(DMA2_1_CURR_DESC_PTR)
#define bfin_write_DMA2_1_CURR_DESC_PTR(val) bfin_write32(DMA2_1_CURR_DESC_PTR,val)
#define bfin_read_DMA2_1_CURR_ADDR()         bfin_read32(DMA2_1_CURR_ADDR)
#define bfin_write_DMA2_1_CURR_ADDR(val)     bfin_write32(DMA2_1_CURR_ADDR,val)
#define bfin_read_DMA2_1_CURR_X_COUNT()      bfin_read16(DMA2_1_CURR_X_COUNT)
#define bfin_write_DMA2_1_CURR_X_COUNT(val)  bfin_write16(DMA2_1_CURR_X_COUNT,val)
#define bfin_read_DMA2_1_CURR_Y_COUNT()      bfin_read16(DMA2_1_CURR_Y_COUNT)
#define bfin_write_DMA2_1_CURR_Y_COUNT(val)  bfin_write16(DMA2_1_CURR_Y_COUNT,val)
#define bfin_read_DMA2_1_IRQ_STATUS()        bfin_read16(DMA2_1_IRQ_STATUS)
#define bfin_write_DMA2_1_IRQ_STATUS(val)    bfin_write16(DMA2_1_IRQ_STATUS,val)
#define bfin_read_DMA2_1_PERIPHERAL_MAP()    bfin_read16(DMA2_1_PERIPHERAL_MAP)
#define bfin_write_DMA2_1_PERIPHERAL_MAP(val) bfin_write16(DMA2_1_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_2_CONFIG()            bfin_read16(DMA2_2_CONFIG)
#define bfin_write_DMA2_2_CONFIG(val)        bfin_write16(DMA2_2_CONFIG,val)
#define bfin_read_DMA2_2_NEXT_DESC_PTR()     bfin_read32(DMA2_2_NEXT_DESC_PTR)
#define bfin_write_DMA2_2_NEXT_DESC_PTR(val) bfin_write32(DMA2_2_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_2_START_ADDR()        bfin_read32(DMA2_2_START_ADDR)
#define bfin_write_DMA2_2_START_ADDR(val)    bfin_write32(DMA2_2_START_ADDR,val)
#define bfin_read_DMA2_2_X_COUNT()           bfin_read16(DMA2_2_X_COUNT)
#define bfin_write_DMA2_2_X_COUNT(val)       bfin_write16(DMA2_2_X_COUNT,val)
#define bfin_read_DMA2_2_Y_COUNT()           bfin_read16(DMA2_2_Y_COUNT)
#define bfin_write_DMA2_2_Y_COUNT(val)       bfin_write16(DMA2_2_Y_COUNT,val)
#define bfin_read_DMA2_2_X_MODIFY()          bfin_read16(DMA2_2_X_MODIFY)
#define bfin_write_DMA2_2_X_MODIFY(val)      bfin_write16(DMA2_2_X_MODIFY,val)
#define bfin_read_DMA2_2_Y_MODIFY()          bfin_read16(DMA2_2_Y_MODIFY)
#define bfin_write_DMA2_2_Y_MODIFY(val)      bfin_write16(DMA2_2_Y_MODIFY,val)
#define bfin_read_DMA2_2_CURR_DESC_PTR()     bfin_read32(DMA2_2_CURR_DESC_PTR)
#define bfin_write_DMA2_2_CURR_DESC_PTR(val) bfin_write32(DMA2_2_CURR_DESC_PTR,val)
#define bfin_read_DMA2_2_CURR_ADDR()         bfin_read32(DMA2_2_CURR_ADDR)
#define bfin_write_DMA2_2_CURR_ADDR(val)     bfin_write32(DMA2_2_CURR_ADDR,val)
#define bfin_read_DMA2_2_CURR_X_COUNT()      bfin_read16(DMA2_2_CURR_X_COUNT)
#define bfin_write_DMA2_2_CURR_X_COUNT(val)  bfin_write16(DMA2_2_CURR_X_COUNT,val)
#define bfin_read_DMA2_2_CURR_Y_COUNT()      bfin_read16(DMA2_2_CURR_Y_COUNT)
#define bfin_write_DMA2_2_CURR_Y_COUNT(val)  bfin_write16(DMA2_2_CURR_Y_COUNT,val)
#define bfin_read_DMA2_2_IRQ_STATUS()        bfin_read16(DMA2_2_IRQ_STATUS)
#define bfin_write_DMA2_2_IRQ_STATUS(val)    bfin_write16(DMA2_2_IRQ_STATUS,val)
#define bfin_read_DMA2_2_PERIPHERAL_MAP()    bfin_read16(DMA2_2_PERIPHERAL_MAP)
#define bfin_write_DMA2_2_PERIPHERAL_MAP(val) bfin_write16(DMA2_2_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_3_CONFIG()            bfin_read16(DMA2_3_CONFIG)
#define bfin_write_DMA2_3_CONFIG(val)        bfin_write16(DMA2_3_CONFIG,val)
#define bfin_read_DMA2_3_NEXT_DESC_PTR()     bfin_read32(DMA2_3_NEXT_DESC_PTR)
#define bfin_write_DMA2_3_NEXT_DESC_PTR(val) bfin_write32(DMA2_3_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_3_START_ADDR()        bfin_read32(DMA2_3_START_ADDR)
#define bfin_write_DMA2_3_START_ADDR(val)    bfin_write32(DMA2_3_START_ADDR,val)
#define bfin_read_DMA2_3_X_COUNT()           bfin_read16(DMA2_3_X_COUNT)
#define bfin_write_DMA2_3_X_COUNT(val)       bfin_write16(DMA2_3_X_COUNT,val)
#define bfin_read_DMA2_3_Y_COUNT()           bfin_read16(DMA2_3_Y_COUNT)
#define bfin_write_DMA2_3_Y_COUNT(val)       bfin_write16(DMA2_3_Y_COUNT,val)
#define bfin_read_DMA2_3_X_MODIFY()          bfin_read16(DMA2_3_X_MODIFY)
#define bfin_write_DMA2_3_X_MODIFY(val)      bfin_write16(DMA2_3_X_MODIFY,val)
#define bfin_read_DMA2_3_Y_MODIFY()          bfin_read16(DMA2_3_Y_MODIFY)
#define bfin_write_DMA2_3_Y_MODIFY(val)      bfin_write16(DMA2_3_Y_MODIFY,val)
#define bfin_read_DMA2_3_CURR_DESC_PTR()     bfin_read32(DMA2_3_CURR_DESC_PTR)
#define bfin_write_DMA2_3_CURR_DESC_PTR(val) bfin_write32(DMA2_3_CURR_DESC_PTR,val)
#define bfin_read_DMA2_3_CURR_ADDR()         bfin_read32(DMA2_3_CURR_ADDR)
#define bfin_write_DMA2_3_CURR_ADDR(val)     bfin_write32(DMA2_3_CURR_ADDR,val)
#define bfin_read_DMA2_3_CURR_X_COUNT()      bfin_read16(DMA2_3_CURR_X_COUNT)
#define bfin_write_DMA2_3_CURR_X_COUNT(val)  bfin_write16(DMA2_3_CURR_X_COUNT,val)
#define bfin_read_DMA2_3_CURR_Y_COUNT()      bfin_read16(DMA2_3_CURR_Y_COUNT)
#define bfin_write_DMA2_3_CURR_Y_COUNT(val)  bfin_write16(DMA2_3_CURR_Y_COUNT,val)
#define bfin_read_DMA2_3_IRQ_STATUS()        bfin_read16(DMA2_3_IRQ_STATUS)
#define bfin_write_DMA2_3_IRQ_STATUS(val)    bfin_write16(DMA2_3_IRQ_STATUS,val)
#define bfin_read_DMA2_3_PERIPHERAL_MAP()    bfin_read16(DMA2_3_PERIPHERAL_MAP)
#define bfin_write_DMA2_3_PERIPHERAL_MAP(val) bfin_write16(DMA2_3_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_4_CONFIG()            bfin_read16(DMA2_4_CONFIG)
#define bfin_write_DMA2_4_CONFIG(val)        bfin_write16(DMA2_4_CONFIG,val)
#define bfin_read_DMA2_4_NEXT_DESC_PTR()     bfin_read32(DMA2_4_NEXT_DESC_PTR)
#define bfin_write_DMA2_4_NEXT_DESC_PTR(val) bfin_write32(DMA2_4_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_4_START_ADDR()        bfin_read32(DMA2_4_START_ADDR)
#define bfin_write_DMA2_4_START_ADDR(val)    bfin_write32(DMA2_4_START_ADDR,val)
#define bfin_read_DMA2_4_X_COUNT()           bfin_read16(DMA2_4_X_COUNT)
#define bfin_write_DMA2_4_X_COUNT(val)       bfin_write16(DMA2_4_X_COUNT,val)
#define bfin_read_DMA2_4_Y_COUNT()           bfin_read16(DMA2_4_Y_COUNT)
#define bfin_write_DMA2_4_Y_COUNT(val)       bfin_write16(DMA2_4_Y_COUNT,val)
#define bfin_read_DMA2_4_X_MODIFY()          bfin_read16(DMA2_4_X_MODIFY)
#define bfin_write_DMA2_4_X_MODIFY(val)      bfin_write16(DMA2_4_X_MODIFY,val)
#define bfin_read_DMA2_4_Y_MODIFY()          bfin_read16(DMA2_4_Y_MODIFY)
#define bfin_write_DMA2_4_Y_MODIFY(val)      bfin_write16(DMA2_4_Y_MODIFY,val)
#define bfin_read_DMA2_4_CURR_DESC_PTR()     bfin_read32(DMA2_4_CURR_DESC_PTR)
#define bfin_write_DMA2_4_CURR_DESC_PTR(val) bfin_write32(DMA2_4_CURR_DESC_PTR,val)
#define bfin_read_DMA2_4_CURR_ADDR()         bfin_read32(DMA2_4_CURR_ADDR)
#define bfin_write_DMA2_4_CURR_ADDR(val)     bfin_write32(DMA2_4_CURR_ADDR,val)
#define bfin_read_DMA2_4_CURR_X_COUNT()      bfin_read16(DMA2_4_CURR_X_COUNT)
#define bfin_write_DMA2_4_CURR_X_COUNT(val)  bfin_write16(DMA2_4_CURR_X_COUNT,val)
#define bfin_read_DMA2_4_CURR_Y_COUNT()      bfin_read16(DMA2_4_CURR_Y_COUNT)
#define bfin_write_DMA2_4_CURR_Y_COUNT(val)  bfin_write16(DMA2_4_CURR_Y_COUNT,val)
#define bfin_read_DMA2_4_IRQ_STATUS()        bfin_read16(DMA2_4_IRQ_STATUS)
#define bfin_write_DMA2_4_IRQ_STATUS(val)    bfin_write16(DMA2_4_IRQ_STATUS,val)
#define bfin_read_DMA2_4_PERIPHERAL_MAP()    bfin_read16(DMA2_4_PERIPHERAL_MAP)
#define bfin_write_DMA2_4_PERIPHERAL_MAP(val) bfin_write16(DMA2_4_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_5_CONFIG()            bfin_read16(DMA2_5_CONFIG)
#define bfin_write_DMA2_5_CONFIG(val)        bfin_write16(DMA2_5_CONFIG,val)
#define bfin_read_DMA2_5_NEXT_DESC_PTR()     bfin_read32(DMA2_5_NEXT_DESC_PTR)
#define bfin_write_DMA2_5_NEXT_DESC_PTR(val) bfin_write32(DMA2_5_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_5_START_ADDR()        bfin_read32(DMA2_5_START_ADDR)
#define bfin_write_DMA2_5_START_ADDR(val)    bfin_write32(DMA2_5_START_ADDR,val)
#define bfin_read_DMA2_5_X_COUNT()           bfin_read16(DMA2_5_X_COUNT)
#define bfin_write_DMA2_5_X_COUNT(val)       bfin_write16(DMA2_5_X_COUNT,val)
#define bfin_read_DMA2_5_Y_COUNT()           bfin_read16(DMA2_5_Y_COUNT)
#define bfin_write_DMA2_5_Y_COUNT(val)       bfin_write16(DMA2_5_Y_COUNT,val)
#define bfin_read_DMA2_5_X_MODIFY()          bfin_read16(DMA2_5_X_MODIFY)
#define bfin_write_DMA2_5_X_MODIFY(val)      bfin_write16(DMA2_5_X_MODIFY,val)
#define bfin_read_DMA2_5_Y_MODIFY()          bfin_read16(DMA2_5_Y_MODIFY)
#define bfin_write_DMA2_5_Y_MODIFY(val)      bfin_write16(DMA2_5_Y_MODIFY,val)
#define bfin_read_DMA2_5_CURR_DESC_PTR()     bfin_read32(DMA2_5_CURR_DESC_PTR)
#define bfin_write_DMA2_5_CURR_DESC_PTR(val) bfin_write32(DMA2_5_CURR_DESC_PTR,val)
#define bfin_read_DMA2_5_CURR_ADDR()         bfin_read32(DMA2_5_CURR_ADDR)
#define bfin_write_DMA2_5_CURR_ADDR(val)     bfin_write32(DMA2_5_CURR_ADDR,val)
#define bfin_read_DMA2_5_CURR_X_COUNT()      bfin_read16(DMA2_5_CURR_X_COUNT)
#define bfin_write_DMA2_5_CURR_X_COUNT(val)  bfin_write16(DMA2_5_CURR_X_COUNT,val)
#define bfin_read_DMA2_5_CURR_Y_COUNT()      bfin_read16(DMA2_5_CURR_Y_COUNT)
#define bfin_write_DMA2_5_CURR_Y_COUNT(val)  bfin_write16(DMA2_5_CURR_Y_COUNT,val)
#define bfin_read_DMA2_5_IRQ_STATUS()        bfin_read16(DMA2_5_IRQ_STATUS)
#define bfin_write_DMA2_5_IRQ_STATUS(val)    bfin_write16(DMA2_5_IRQ_STATUS,val)
#define bfin_read_DMA2_5_PERIPHERAL_MAP()    bfin_read16(DMA2_5_PERIPHERAL_MAP)
#define bfin_write_DMA2_5_PERIPHERAL_MAP(val) bfin_write16(DMA2_5_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_6_CONFIG()            bfin_read16(DMA2_6_CONFIG)
#define bfin_write_DMA2_6_CONFIG(val)        bfin_write16(DMA2_6_CONFIG,val)
#define bfin_read_DMA2_6_NEXT_DESC_PTR()     bfin_read32(DMA2_6_NEXT_DESC_PTR)
#define bfin_write_DMA2_6_NEXT_DESC_PTR(val) bfin_write32(DMA2_6_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_6_START_ADDR()        bfin_read32(DMA2_6_START_ADDR)
#define bfin_write_DMA2_6_START_ADDR(val)    bfin_write32(DMA2_6_START_ADDR,val)
#define bfin_read_DMA2_6_X_COUNT()           bfin_read16(DMA2_6_X_COUNT)
#define bfin_write_DMA2_6_X_COUNT(val)       bfin_write16(DMA2_6_X_COUNT,val)
#define bfin_read_DMA2_6_Y_COUNT()           bfin_read16(DMA2_6_Y_COUNT)
#define bfin_write_DMA2_6_Y_COUNT(val)       bfin_write16(DMA2_6_Y_COUNT,val)
#define bfin_read_DMA2_6_X_MODIFY()          bfin_read16(DMA2_6_X_MODIFY)
#define bfin_write_DMA2_6_X_MODIFY(val)      bfin_write16(DMA2_6_X_MODIFY,val)
#define bfin_read_DMA2_6_Y_MODIFY()          bfin_read16(DMA2_6_Y_MODIFY)
#define bfin_write_DMA2_6_Y_MODIFY(val)      bfin_write16(DMA2_6_Y_MODIFY,val)
#define bfin_read_DMA2_6_CURR_DESC_PTR()     bfin_read32(DMA2_6_CURR_DESC_PTR)
#define bfin_write_DMA2_6_CURR_DESC_PTR(val) bfin_write32(DMA2_6_CURR_DESC_PTR,val)
#define bfin_read_DMA2_6_CURR_ADDR()         bfin_read32(DMA2_6_CURR_ADDR)
#define bfin_write_DMA2_6_CURR_ADDR(val)     bfin_write32(DMA2_6_CURR_ADDR,val)
#define bfin_read_DMA2_6_CURR_X_COUNT()      bfin_read16(DMA2_6_CURR_X_COUNT)
#define bfin_write_DMA2_6_CURR_X_COUNT(val)  bfin_write16(DMA2_6_CURR_X_COUNT,val)
#define bfin_read_DMA2_6_CURR_Y_COUNT()      bfin_read16(DMA2_6_CURR_Y_COUNT)
#define bfin_write_DMA2_6_CURR_Y_COUNT(val)  bfin_write16(DMA2_6_CURR_Y_COUNT,val)
#define bfin_read_DMA2_6_IRQ_STATUS()        bfin_read16(DMA2_6_IRQ_STATUS)
#define bfin_write_DMA2_6_IRQ_STATUS(val)    bfin_write16(DMA2_6_IRQ_STATUS,val)
#define bfin_read_DMA2_6_PERIPHERAL_MAP()    bfin_read16(DMA2_6_PERIPHERAL_MAP)
#define bfin_write_DMA2_6_PERIPHERAL_MAP(val) bfin_write16(DMA2_6_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_7_CONFIG()            bfin_read16(DMA2_7_CONFIG)
#define bfin_write_DMA2_7_CONFIG(val)        bfin_write16(DMA2_7_CONFIG,val)
#define bfin_read_DMA2_7_NEXT_DESC_PTR()     bfin_read32(DMA2_7_NEXT_DESC_PTR)
#define bfin_write_DMA2_7_NEXT_DESC_PTR(val) bfin_write32(DMA2_7_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_7_START_ADDR()        bfin_read32(DMA2_7_START_ADDR)
#define bfin_write_DMA2_7_START_ADDR(val)    bfin_write32(DMA2_7_START_ADDR,val)
#define bfin_read_DMA2_7_X_COUNT()           bfin_read16(DMA2_7_X_COUNT)
#define bfin_write_DMA2_7_X_COUNT(val)       bfin_write16(DMA2_7_X_COUNT,val)
#define bfin_read_DMA2_7_Y_COUNT()           bfin_read16(DMA2_7_Y_COUNT)
#define bfin_write_DMA2_7_Y_COUNT(val)       bfin_write16(DMA2_7_Y_COUNT,val)
#define bfin_read_DMA2_7_X_MODIFY()          bfin_read16(DMA2_7_X_MODIFY)
#define bfin_write_DMA2_7_X_MODIFY(val)      bfin_write16(DMA2_7_X_MODIFY,val)
#define bfin_read_DMA2_7_Y_MODIFY()          bfin_read16(DMA2_7_Y_MODIFY)
#define bfin_write_DMA2_7_Y_MODIFY(val)      bfin_write16(DMA2_7_Y_MODIFY,val)
#define bfin_read_DMA2_7_CURR_DESC_PTR()     bfin_read32(DMA2_7_CURR_DESC_PTR)
#define bfin_write_DMA2_7_CURR_DESC_PTR(val) bfin_write32(DMA2_7_CURR_DESC_PTR,val)
#define bfin_read_DMA2_7_CURR_ADDR()         bfin_read32(DMA2_7_CURR_ADDR)
#define bfin_write_DMA2_7_CURR_ADDR(val)     bfin_write32(DMA2_7_CURR_ADDR,val)
#define bfin_read_DMA2_7_CURR_X_COUNT()      bfin_read16(DMA2_7_CURR_X_COUNT)
#define bfin_write_DMA2_7_CURR_X_COUNT(val)  bfin_write16(DMA2_7_CURR_X_COUNT,val)
#define bfin_read_DMA2_7_CURR_Y_COUNT()      bfin_read16(DMA2_7_CURR_Y_COUNT)
#define bfin_write_DMA2_7_CURR_Y_COUNT(val)  bfin_write16(DMA2_7_CURR_Y_COUNT,val)
#define bfin_read_DMA2_7_IRQ_STATUS()        bfin_read16(DMA2_7_IRQ_STATUS)
#define bfin_write_DMA2_7_IRQ_STATUS(val)    bfin_write16(DMA2_7_IRQ_STATUS,val)
#define bfin_read_DMA2_7_PERIPHERAL_MAP()    bfin_read16(DMA2_7_PERIPHERAL_MAP)
#define bfin_write_DMA2_7_PERIPHERAL_MAP(val) bfin_write16(DMA2_7_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_8_CONFIG()            bfin_read16(DMA2_8_CONFIG)
#define bfin_write_DMA2_8_CONFIG(val)        bfin_write16(DMA2_8_CONFIG,val)
#define bfin_read_DMA2_8_NEXT_DESC_PTR()     bfin_read32(DMA2_8_NEXT_DESC_PTR)
#define bfin_write_DMA2_8_NEXT_DESC_PTR(val) bfin_write32(DMA2_8_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_8_START_ADDR()        bfin_read32(DMA2_8_START_ADDR)
#define bfin_write_DMA2_8_START_ADDR(val)    bfin_write32(DMA2_8_START_ADDR,val)
#define bfin_read_DMA2_8_X_COUNT()           bfin_read16(DMA2_8_X_COUNT)
#define bfin_write_DMA2_8_X_COUNT(val)       bfin_write16(DMA2_8_X_COUNT,val)
#define bfin_read_DMA2_8_Y_COUNT()           bfin_read16(DMA2_8_Y_COUNT)
#define bfin_write_DMA2_8_Y_COUNT(val)       bfin_write16(DMA2_8_Y_COUNT,val)
#define bfin_read_DMA2_8_X_MODIFY()          bfin_read16(DMA2_8_X_MODIFY)
#define bfin_write_DMA2_8_X_MODIFY(val)      bfin_write16(DMA2_8_X_MODIFY,val)
#define bfin_read_DMA2_8_Y_MODIFY()          bfin_read16(DMA2_8_Y_MODIFY)
#define bfin_write_DMA2_8_Y_MODIFY(val)      bfin_write16(DMA2_8_Y_MODIFY,val)
#define bfin_read_DMA2_8_CURR_DESC_PTR()     bfin_read32(DMA2_8_CURR_DESC_PTR)
#define bfin_write_DMA2_8_CURR_DESC_PTR(val) bfin_write32(DMA2_8_CURR_DESC_PTR,val)
#define bfin_read_DMA2_8_CURR_ADDR()         bfin_read32(DMA2_8_CURR_ADDR)
#define bfin_write_DMA2_8_CURR_ADDR(val)     bfin_write32(DMA2_8_CURR_ADDR,val)
#define bfin_read_DMA2_8_CURR_X_COUNT()      bfin_read16(DMA2_8_CURR_X_COUNT)
#define bfin_write_DMA2_8_CURR_X_COUNT(val)  bfin_write16(DMA2_8_CURR_X_COUNT,val)
#define bfin_read_DMA2_8_CURR_Y_COUNT()      bfin_read16(DMA2_8_CURR_Y_COUNT)
#define bfin_write_DMA2_8_CURR_Y_COUNT(val)  bfin_write16(DMA2_8_CURR_Y_COUNT,val)
#define bfin_read_DMA2_8_IRQ_STATUS()        bfin_read16(DMA2_8_IRQ_STATUS)
#define bfin_write_DMA2_8_IRQ_STATUS(val)    bfin_write16(DMA2_8_IRQ_STATUS,val)
#define bfin_read_DMA2_8_PERIPHERAL_MAP()    bfin_read16(DMA2_8_PERIPHERAL_MAP)
#define bfin_write_DMA2_8_PERIPHERAL_MAP(val) bfin_write16(DMA2_8_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_9_CONFIG()            bfin_read16(DMA2_9_CONFIG)
#define bfin_write_DMA2_9_CONFIG(val)        bfin_write16(DMA2_9_CONFIG,val)
#define bfin_read_DMA2_9_NEXT_DESC_PTR()     bfin_read32(DMA2_9_NEXT_DESC_PTR)
#define bfin_write_DMA2_9_NEXT_DESC_PTR(val) bfin_write32(DMA2_9_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_9_START_ADDR()        bfin_read32(DMA2_9_START_ADDR)
#define bfin_write_DMA2_9_START_ADDR(val)    bfin_write32(DMA2_9_START_ADDR,val)
#define bfin_read_DMA2_9_X_COUNT()           bfin_read16(DMA2_9_X_COUNT)
#define bfin_write_DMA2_9_X_COUNT(val)       bfin_write16(DMA2_9_X_COUNT,val)
#define bfin_read_DMA2_9_Y_COUNT()           bfin_read16(DMA2_9_Y_COUNT)
#define bfin_write_DMA2_9_Y_COUNT(val)       bfin_write16(DMA2_9_Y_COUNT,val)
#define bfin_read_DMA2_9_X_MODIFY()          bfin_read16(DMA2_9_X_MODIFY)
#define bfin_write_DMA2_9_X_MODIFY(val)      bfin_write16(DMA2_9_X_MODIFY,val)
#define bfin_read_DMA2_9_Y_MODIFY()          bfin_read16(DMA2_9_Y_MODIFY)
#define bfin_write_DMA2_9_Y_MODIFY(val)      bfin_write16(DMA2_9_Y_MODIFY,val)
#define bfin_read_DMA2_9_CURR_DESC_PTR()     bfin_read32(DMA2_9_CURR_DESC_PTR)
#define bfin_write_DMA2_9_CURR_DESC_PTR(val) bfin_write32(DMA2_9_CURR_DESC_PTR,val)
#define bfin_read_DMA2_9_CURR_ADDR()         bfin_read32(DMA2_9_CURR_ADDR)
#define bfin_write_DMA2_9_CURR_ADDR(val)     bfin_write32(DMA2_9_CURR_ADDR,val)
#define bfin_read_DMA2_9_CURR_X_COUNT()      bfin_read16(DMA2_9_CURR_X_COUNT)
#define bfin_write_DMA2_9_CURR_X_COUNT(val)  bfin_write16(DMA2_9_CURR_X_COUNT,val)
#define bfin_read_DMA2_9_CURR_Y_COUNT()      bfin_read16(DMA2_9_CURR_Y_COUNT)
#define bfin_write_DMA2_9_CURR_Y_COUNT(val)  bfin_write16(DMA2_9_CURR_Y_COUNT,val)
#define bfin_read_DMA2_9_IRQ_STATUS()        bfin_read16(DMA2_9_IRQ_STATUS)
#define bfin_write_DMA2_9_IRQ_STATUS(val)    bfin_write16(DMA2_9_IRQ_STATUS,val)
#define bfin_read_DMA2_9_PERIPHERAL_MAP()    bfin_read16(DMA2_9_PERIPHERAL_MAP)
#define bfin_write_DMA2_9_PERIPHERAL_MAP(val) bfin_write16(DMA2_9_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_10_CONFIG()           bfin_read16(DMA2_10_CONFIG)
#define bfin_write_DMA2_10_CONFIG(val)       bfin_write16(DMA2_10_CONFIG,val)
#define bfin_read_DMA2_10_NEXT_DESC_PTR()    bfin_read32(DMA2_10_NEXT_DESC_PTR)
#define bfin_write_DMA2_10_NEXT_DESC_PTR(val) bfin_write32(DMA2_10_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_10_START_ADDR()       bfin_read32(DMA2_10_START_ADDR)
#define bfin_write_DMA2_10_START_ADDR(val)   bfin_write32(DMA2_10_START_ADDR,val)
#define bfin_read_DMA2_10_X_COUNT()          bfin_read16(DMA2_10_X_COUNT)
#define bfin_write_DMA2_10_X_COUNT(val)      bfin_write16(DMA2_10_X_COUNT,val)
#define bfin_read_DMA2_10_Y_COUNT()          bfin_read16(DMA2_10_Y_COUNT)
#define bfin_write_DMA2_10_Y_COUNT(val)      bfin_write16(DMA2_10_Y_COUNT,val)
#define bfin_read_DMA2_10_X_MODIFY()         bfin_read16(DMA2_10_X_MODIFY)
#define bfin_write_DMA2_10_X_MODIFY(val)     bfin_write16(DMA2_10_X_MODIFY,val)
#define bfin_read_DMA2_10_Y_MODIFY()         bfin_read16(DMA2_10_Y_MODIFY)
#define bfin_write_DMA2_10_Y_MODIFY(val)     bfin_write16(DMA2_10_Y_MODIFY,val)
#define bfin_read_DMA2_10_CURR_DESC_PTR()    bfin_read32(DMA2_10_CURR_DESC_PTR)
#define bfin_write_DMA2_10_CURR_DESC_PTR(val) bfin_write32(DMA2_10_CURR_DESC_PTR,val)
#define bfin_read_DMA2_10_CURR_ADDR()        bfin_read32(DMA2_10_CURR_ADDR)
#define bfin_write_DMA2_10_CURR_ADDR(val)    bfin_write32(DMA2_10_CURR_ADDR,val)
#define bfin_read_DMA2_10_CURR_X_COUNT()     bfin_read16(DMA2_10_CURR_X_COUNT)
#define bfin_write_DMA2_10_CURR_X_COUNT(val) bfin_write16(DMA2_10_CURR_X_COUNT,val)
#define bfin_read_DMA2_10_CURR_Y_COUNT()     bfin_read16(DMA2_10_CURR_Y_COUNT)
#define bfin_write_DMA2_10_CURR_Y_COUNT(val) bfin_write16(DMA2_10_CURR_Y_COUNT,val)
#define bfin_read_DMA2_10_IRQ_STATUS()       bfin_read16(DMA2_10_IRQ_STATUS)
#define bfin_write_DMA2_10_IRQ_STATUS(val)   bfin_write16(DMA2_10_IRQ_STATUS,val)
#define bfin_read_DMA2_10_PERIPHERAL_MAP()   bfin_read16(DMA2_10_PERIPHERAL_MAP)
#define bfin_write_DMA2_10_PERIPHERAL_MAP(val) bfin_write16(DMA2_10_PERIPHERAL_MAP,val)
#define bfin_read_DMA2_11_CONFIG()           bfin_read16(DMA2_11_CONFIG)
#define bfin_write_DMA2_11_CONFIG(val)       bfin_write16(DMA2_11_CONFIG,val)
#define bfin_read_DMA2_11_NEXT_DESC_PTR()    bfin_read32(DMA2_11_NEXT_DESC_PTR)
#define bfin_write_DMA2_11_NEXT_DESC_PTR(val) bfin_write32(DMA2_11_NEXT_DESC_PTR,val)
#define bfin_read_DMA2_11_START_ADDR()       bfin_read32(DMA2_11_START_ADDR)
#define bfin_write_DMA2_11_START_ADDR(val)   bfin_write32(DMA2_11_START_ADDR,val)
#define bfin_read_DMA2_11_X_COUNT()          bfin_read16(DMA2_11_X_COUNT)
#define bfin_write_DMA2_11_X_COUNT(val)      bfin_write16(DMA2_11_X_COUNT,val)
#define bfin_read_DMA2_11_Y_COUNT()          bfin_read16(DMA2_11_Y_COUNT)
#define bfin_write_DMA2_11_Y_COUNT(val)      bfin_write16(DMA2_11_Y_COUNT,val)
#define bfin_read_DMA2_11_X_MODIFY()         bfin_read16(DMA2_11_X_MODIFY)
#define bfin_write_DMA2_11_X_MODIFY(val)     bfin_write16(DMA2_11_X_MODIFY,val)
#define bfin_read_DMA2_11_Y_MODIFY()         bfin_read16(DMA2_11_Y_MODIFY)
#define bfin_write_DMA2_11_Y_MODIFY(val)     bfin_write16(DMA2_11_Y_MODIFY,val)
#define bfin_read_DMA2_11_CURR_DESC_PTR()    bfin_read32(DMA2_11_CURR_DESC_PTR)
#define bfin_write_DMA2_11_CURR_DESC_PTR(val) bfin_write32(DMA2_11_CURR_DESC_PTR,val)
#define bfin_read_DMA2_11_CURR_ADDR()        bfin_read32(DMA2_11_CURR_ADDR)
#define bfin_write_DMA2_11_CURR_ADDR(val)    bfin_write32(DMA2_11_CURR_ADDR,val)
#define bfin_read_DMA2_11_CURR_X_COUNT()     bfin_read16(DMA2_11_CURR_X_COUNT)
#define bfin_write_DMA2_11_CURR_X_COUNT(val) bfin_write16(DMA2_11_CURR_X_COUNT,val)
#define bfin_read_DMA2_11_CURR_Y_COUNT()     bfin_read16(DMA2_11_CURR_Y_COUNT)
#define bfin_write_DMA2_11_CURR_Y_COUNT(val) bfin_write16(DMA2_11_CURR_Y_COUNT,val)
#define bfin_read_DMA2_11_IRQ_STATUS()       bfin_read16(DMA2_11_IRQ_STATUS)
#define bfin_write_DMA2_11_IRQ_STATUS(val)   bfin_write16(DMA2_11_IRQ_STATUS,val)
#define bfin_read_DMA2_11_PERIPHERAL_MAP()   bfin_read16(DMA2_11_PERIPHERAL_MAP)
#define bfin_write_DMA2_11_PERIPHERAL_MAP(val) bfin_write16(DMA2_11_PERIPHERAL_MAP,val)
/* Memory DMA2 Controller registers (0xFFC0 0E80-0xFFC0 0FFF) */
#define bfin_read_MDMA2_D0_CONFIG()          bfin_read16(MDMA2_D0_CONFIG)
#define bfin_write_MDMA2_D0_CONFIG(val)      bfin_write16(MDMA2_D0_CONFIG,val)
#define bfin_read_MDMA2_D0_NEXT_DESC_PTR()   bfin_read32(MDMA2_D0_NEXT_DESC_PTR)
#define bfin_write_MDMA2_D0_NEXT_DESC_PTR(val) bfin_write32(MDMA2_D0_NEXT_DESC_PTR,val)
#define bfin_read_MDMA2_D0_START_ADDR()      bfin_read32(MDMA2_D0_START_ADDR)
#define bfin_write_MDMA2_D0_START_ADDR(val)  bfin_write32(MDMA2_D0_START_ADDR,val)
#define bfin_read_MDMA2_D0_X_COUNT()         bfin_read16(MDMA2_D0_X_COUNT)
#define bfin_write_MDMA2_D0_X_COUNT(val)     bfin_write16(MDMA2_D0_X_COUNT,val)
#define bfin_read_MDMA2_D0_Y_COUNT()         bfin_read16(MDMA2_D0_Y_COUNT)
#define bfin_write_MDMA2_D0_Y_COUNT(val)     bfin_write16(MDMA2_D0_Y_COUNT,val)
#define bfin_read_MDMA2_D0_X_MODIFY()        bfin_read16(MDMA2_D0_X_MODIFY)
#define bfin_write_MDMA2_D0_X_MODIFY(val)    bfin_write16(MDMA2_D0_X_MODIFY,val)
#define bfin_read_MDMA2_D0_Y_MODIFY()        bfin_read16(MDMA2_D0_Y_MODIFY)
#define bfin_write_MDMA2_D0_Y_MODIFY(val)    bfin_write16(MDMA2_D0_Y_MODIFY,val)
#define bfin_read_MDMA2_D0_CURR_DESC_PTR()   bfin_read32(MDMA2_D0_CURR_DESC_PTR)
#define bfin_write_MDMA2_D0_CURR_DESC_PTR(val) bfin_write32(MDMA2_D0_CURR_DESC_PTR,val)
#define bfin_read_MDMA2_D0_CURR_ADDR()       bfin_read32(MDMA2_D0_CURR_ADDR)
#define bfin_write_MDMA2_D0_CURR_ADDR(val)   bfin_write32(MDMA2_D0_CURR_ADDR,val)
#define bfin_read_MDMA2_D0_CURR_X_COUNT()    bfin_read16(MDMA2_D0_CURR_X_COUNT)
#define bfin_write_MDMA2_D0_CURR_X_COUNT(val) bfin_write16(MDMA2_D0_CURR_X_COUNT,val)
#define bfin_read_MDMA2_D0_CURR_Y_COUNT()    bfin_read16(MDMA2_D0_CURR_Y_COUNT)
#define bfin_write_MDMA2_D0_CURR_Y_COUNT(val) bfin_write16(MDMA2_D0_CURR_Y_COUNT,val)
#define bfin_read_MDMA2_D0_IRQ_STATUS()      bfin_read16(MDMA2_D0_IRQ_STATUS)
#define bfin_write_MDMA2_D0_IRQ_STATUS(val)  bfin_write16(MDMA2_D0_IRQ_STATUS,val)
#define bfin_read_MDMA2_D0_PERIPHERAL_MAP()  bfin_read16(MDMA2_D0_PERIPHERAL_MAP)
#define bfin_write_MDMA2_D0_PERIPHERAL_MAP(val) bfin_write16(MDMA2_D0_PERIPHERAL_MAP,val)
#define bfin_read_MDMA2_S0_CONFIG()          bfin_read16(MDMA2_S0_CONFIG)
#define bfin_write_MDMA2_S0_CONFIG(val)      bfin_write16(MDMA2_S0_CONFIG,val)
#define bfin_read_MDMA2_S0_NEXT_DESC_PTR()   bfin_read32(MDMA2_S0_NEXT_DESC_PTR)
#define bfin_write_MDMA2_S0_NEXT_DESC_PTR(val) bfin_write32(MDMA2_S0_NEXT_DESC_PTR,val)
#define bfin_read_MDMA2_S0_START_ADDR()      bfin_read32(MDMA2_S0_START_ADDR)
#define bfin_write_MDMA2_S0_START_ADDR(val)  bfin_write32(MDMA2_S0_START_ADDR,val)
#define bfin_read_MDMA2_S0_X_COUNT()         bfin_read16(MDMA2_S0_X_COUNT)
#define bfin_write_MDMA2_S0_X_COUNT(val)     bfin_write16(MDMA2_S0_X_COUNT,val)
#define bfin_read_MDMA2_S0_Y_COUNT()         bfin_read16(MDMA2_S0_Y_COUNT)
#define bfin_write_MDMA2_S0_Y_COUNT(val)     bfin_write16(MDMA2_S0_Y_COUNT,val)
#define bfin_read_MDMA2_S0_X_MODIFY()        bfin_read16(MDMA2_S0_X_MODIFY)
#define bfin_write_MDMA2_S0_X_MODIFY(val)    bfin_write16(MDMA2_S0_X_MODIFY,val)
#define bfin_read_MDMA2_S0_Y_MODIFY()        bfin_read16(MDMA2_S0_Y_MODIFY)
#define bfin_write_MDMA2_S0_Y_MODIFY(val)    bfin_write16(MDMA2_S0_Y_MODIFY,val)
#define bfin_read_MDMA2_S0_CURR_DESC_PTR()   bfin_read32(MDMA2_S0_CURR_DESC_PTR)
#define bfin_write_MDMA2_S0_CURR_DESC_PTR(val) bfin_write32(MDMA2_S0_CURR_DESC_PTR,val)
#define bfin_read_MDMA2_S0_CURR_ADDR()       bfin_read32(MDMA2_S0_CURR_ADDR)
#define bfin_write_MDMA2_S0_CURR_ADDR(val)   bfin_write32(MDMA2_S0_CURR_ADDR,val)
#define bfin_read_MDMA2_S0_CURR_X_COUNT()    bfin_read16(MDMA2_S0_CURR_X_COUNT)
#define bfin_write_MDMA2_S0_CURR_X_COUNT(val) bfin_write16(MDMA2_S0_CURR_X_COUNT,val)
#define bfin_read_MDMA2_S0_CURR_Y_COUNT()    bfin_read16(MDMA2_S0_CURR_Y_COUNT)
#define bfin_write_MDMA2_S0_CURR_Y_COUNT(val) bfin_write16(MDMA2_S0_CURR_Y_COUNT,val)
#define bfin_read_MDMA2_S0_IRQ_STATUS()      bfin_read16(MDMA2_S0_IRQ_STATUS)
#define bfin_write_MDMA2_S0_IRQ_STATUS(val)  bfin_write16(MDMA2_S0_IRQ_STATUS,val)
#define bfin_read_MDMA2_S0_PERIPHERAL_MAP()  bfin_read16(MDMA2_S0_PERIPHERAL_MAP)
#define bfin_write_MDMA2_S0_PERIPHERAL_MAP(val) bfin_write16(MDMA2_S0_PERIPHERAL_MAP,val)
#define bfin_read_MDMA2_D1_CONFIG()          bfin_read16(MDMA2_D1_CONFIG)
#define bfin_write_MDMA2_D1_CONFIG(val)      bfin_write16(MDMA2_D1_CONFIG,val)
#define bfin_read_MDMA2_D1_NEXT_DESC_PTR()   bfin_read32(MDMA2_D1_NEXT_DESC_PTR)
#define bfin_write_MDMA2_D1_NEXT_DESC_PTR(val) bfin_write32(MDMA2_D1_NEXT_DESC_PTR,val)
#define bfin_read_MDMA2_D1_START_ADDR()      bfin_read32(MDMA2_D1_START_ADDR)
#define bfin_write_MDMA2_D1_START_ADDR(val)  bfin_write32(MDMA2_D1_START_ADDR,val)
#define bfin_read_MDMA2_D1_X_COUNT()         bfin_read16(MDMA2_D1_X_COUNT)
#define bfin_write_MDMA2_D1_X_COUNT(val)     bfin_write16(MDMA2_D1_X_COUNT,val)
#define bfin_read_MDMA2_D1_Y_COUNT()         bfin_read16(MDMA2_D1_Y_COUNT)
#define bfin_write_MDMA2_D1_Y_COUNT(val)     bfin_write16(MDMA2_D1_Y_COUNT,val)
#define bfin_read_MDMA2_D1_X_MODIFY()        bfin_read16(MDMA2_D1_X_MODIFY)
#define bfin_write_MDMA2_D1_X_MODIFY(val)    bfin_write16(MDMA2_D1_X_MODIFY,val)
#define bfin_read_MDMA2_D1_Y_MODIFY()        bfin_read16(MDMA2_D1_Y_MODIFY)
#define bfin_write_MDMA2_D1_Y_MODIFY(val)    bfin_write16(MDMA2_D1_Y_MODIFY,val)
#define bfin_read_MDMA2_D1_CURR_DESC_PTR()   bfin_read32(MDMA2_D1_CURR_DESC_PTR)
#define bfin_write_MDMA2_D1_CURR_DESC_PTR(val) bfin_write32(MDMA2_D1_CURR_DESC_PTR,val)
#define bfin_read_MDMA2_D1_CURR_ADDR()       bfin_read32(MDMA2_D1_CURR_ADDR)
#define bfin_write_MDMA2_D1_CURR_ADDR(val)   bfin_write32(MDMA2_D1_CURR_ADDR,val)
#define bfin_read_MDMA2_D1_CURR_X_COUNT()    bfin_read16(MDMA2_D1_CURR_X_COUNT)
#define bfin_write_MDMA2_D1_CURR_X_COUNT(val) bfin_write16(MDMA2_D1_CURR_X_COUNT,val)
#define bfin_read_MDMA2_D1_CURR_Y_COUNT()    bfin_read16(MDMA2_D1_CURR_Y_COUNT)
#define bfin_write_MDMA2_D1_CURR_Y_COUNT(val) bfin_write16(MDMA2_D1_CURR_Y_COUNT,val)
#define bfin_read_MDMA2_D1_IRQ_STATUS()      bfin_read16(MDMA2_D1_IRQ_STATUS)
#define bfin_write_MDMA2_D1_IRQ_STATUS(val)  bfin_write16(MDMA2_D1_IRQ_STATUS,val)
#define bfin_read_MDMA2_D1_PERIPHERAL_MAP()  bfin_read16(MDMA2_D1_PERIPHERAL_MAP)
#define bfin_write_MDMA2_D1_PERIPHERAL_MAP(val) bfin_write16(MDMA2_D1_PERIPHERAL_MAP,val)
#define bfin_read_MDMA2_S1_CONFIG()          bfin_read16(MDMA2_S1_CONFIG)
#define bfin_write_MDMA2_S1_CONFIG(val)      bfin_write16(MDMA2_S1_CONFIG,val)
#define bfin_read_MDMA2_S1_NEXT_DESC_PTR()   bfin_read32(MDMA2_S1_NEXT_DESC_PTR)
#define bfin_write_MDMA2_S1_NEXT_DESC_PTR(val) bfin_write32(MDMA2_S1_NEXT_DESC_PTR,val)
#define bfin_read_MDMA2_S1_START_ADDR()      bfin_read32(MDMA2_S1_START_ADDR)
#define bfin_write_MDMA2_S1_START_ADDR(val)  bfin_write32(MDMA2_S1_START_ADDR,val)
#define bfin_read_MDMA2_S1_X_COUNT()         bfin_read16(MDMA2_S1_X_COUNT)
#define bfin_write_MDMA2_S1_X_COUNT(val)     bfin_write16(MDMA2_S1_X_COUNT,val)
#define bfin_read_MDMA2_S1_Y_COUNT()         bfin_read16(MDMA2_S1_Y_COUNT)
#define bfin_write_MDMA2_S1_Y_COUNT(val)     bfin_write16(MDMA2_S1_Y_COUNT,val)
#define bfin_read_MDMA2_S1_X_MODIFY()        bfin_read16(MDMA2_S1_X_MODIFY)
#define bfin_write_MDMA2_S1_X_MODIFY(val)    bfin_write16(MDMA2_S1_X_MODIFY,val)
#define bfin_read_MDMA2_S1_Y_MODIFY()        bfin_read16(MDMA2_S1_Y_MODIFY)
#define bfin_write_MDMA2_S1_Y_MODIFY(val)    bfin_write16(MDMA2_S1_Y_MODIFY,val)
#define bfin_read_MDMA2_S1_CURR_DESC_PTR()   bfin_read32(MDMA2_S1_CURR_DESC_PTR)
#define bfin_write_MDMA2_S1_CURR_DESC_PTR(val) bfin_write32(MDMA2_S1_CURR_DESC_PTR,val)
#define bfin_read_MDMA2_S1_CURR_ADDR()       bfin_read32(MDMA2_S1_CURR_ADDR)
#define bfin_write_MDMA2_S1_CURR_ADDR(val)   bfin_write32(MDMA2_S1_CURR_ADDR,val)
#define bfin_read_MDMA2_S1_CURR_X_COUNT()    bfin_read16(MDMA2_S1_CURR_X_COUNT)
#define bfin_write_MDMA2_S1_CURR_X_COUNT(val) bfin_write16(MDMA2_S1_CURR_X_COUNT,val)
#define bfin_read_MDMA2_S1_CURR_Y_COUNT()    bfin_read16(MDMA2_S1_CURR_Y_COUNT)
#define bfin_write_MDMA2_S1_CURR_Y_COUNT(val) bfin_write16(MDMA2_S1_CURR_Y_COUNT,val)
#define bfin_read_MDMA2_S1_IRQ_STATUS()      bfin_read16(MDMA2_S1_IRQ_STATUS)
#define bfin_write_MDMA2_S1_IRQ_STATUS(val)  bfin_write16(MDMA2_S1_IRQ_STATUS,val)
#define bfin_read_MDMA2_S1_PERIPHERAL_MAP()  bfin_read16(MDMA2_S1_PERIPHERAL_MAP)
#define bfin_write_MDMA2_S1_PERIPHERAL_MAP(val) bfin_write16(MDMA2_S1_PERIPHERAL_MAP,val)
/* Internal Memory DMA Registers (0xFFC0_1800 - 0xFFC0_19FF) */
#define bfin_read_IMDMA_D0_CONFIG()          bfin_read16(IMDMA_D0_CONFIG)
#define bfin_write_IMDMA_D0_CONFIG(val)      bfin_write16(IMDMA_D0_CONFIG,val)
#define bfin_read_IMDMA_D0_NEXT_DESC_PTR()   bfin_read32(IMDMA_D0_NEXT_DESC_PTR)
#define bfin_write_IMDMA_D0_NEXT_DESC_PTR(val) bfin_write32(IMDMA_D0_NEXT_DESC_PTR,val)
#define bfin_read_IMDMA_D0_START_ADDR()      bfin_read32(IMDMA_D0_START_ADDR)
#define bfin_write_IMDMA_D0_START_ADDR(val)  bfin_write32(IMDMA_D0_START_ADDR,val)
#define bfin_read_IMDMA_D0_X_COUNT()         bfin_read16(IMDMA_D0_X_COUNT)
#define bfin_write_IMDMA_D0_X_COUNT(val)     bfin_write16(IMDMA_D0_X_COUNT,val)
#define bfin_read_IMDMA_D0_Y_COUNT()         bfin_read16(IMDMA_D0_Y_COUNT)
#define bfin_write_IMDMA_D0_Y_COUNT(val)     bfin_write16(IMDMA_D0_Y_COUNT,val)
#define bfin_read_IMDMA_D0_X_MODIFY()        bfin_read16(IMDMA_D0_X_MODIFY)
#define bfin_write_IMDMA_D0_X_MODIFY(val)    bfin_write16(IMDMA_D0_X_MODIFY,val)
#define bfin_read_IMDMA_D0_Y_MODIFY()        bfin_read16(IMDMA_D0_Y_MODIFY)
#define bfin_write_IMDMA_D0_Y_MODIFY(val)    bfin_write16(IMDMA_D0_Y_MODIFY,val)
#define bfin_read_IMDMA_D0_CURR_DESC_PTR()   bfin_read32(IMDMA_D0_CURR_DESC_PTR)
#define bfin_write_IMDMA_D0_CURR_DESC_PTR(val) bfin_write32(IMDMA_D0_CURR_DESC_PTR,val)
#define bfin_read_IMDMA_D0_CURR_ADDR()       bfin_read32(IMDMA_D0_CURR_ADDR)
#define bfin_write_IMDMA_D0_CURR_ADDR(val)   bfin_write32(IMDMA_D0_CURR_ADDR,val)
#define bfin_read_IMDMA_D0_CURR_X_COUNT()    bfin_read16(IMDMA_D0_CURR_X_COUNT)
#define bfin_write_IMDMA_D0_CURR_X_COUNT(val) bfin_write16(IMDMA_D0_CURR_X_COUNT,val)
#define bfin_read_IMDMA_D0_CURR_Y_COUNT()    bfin_read16(IMDMA_D0_CURR_Y_COUNT)
#define bfin_write_IMDMA_D0_CURR_Y_COUNT(val) bfin_write16(IMDMA_D0_CURR_Y_COUNT,val)
#define bfin_read_IMDMA_D0_IRQ_STATUS()      bfin_read16(IMDMA_D0_IRQ_STATUS)
#define bfin_write_IMDMA_D0_IRQ_STATUS(val)  bfin_write16(IMDMA_D0_IRQ_STATUS,val)
#define bfin_read_IMDMA_S0_CONFIG()          bfin_read16(IMDMA_S0_CONFIG)
#define bfin_write_IMDMA_S0_CONFIG(val)      bfin_write16(IMDMA_S0_CONFIG,val)
#define bfin_read_IMDMA_S0_NEXT_DESC_PTR()   bfin_read32(IMDMA_S0_NEXT_DESC_PTR)
#define bfin_write_IMDMA_S0_NEXT_DESC_PTR(val) bfin_write32(IMDMA_S0_NEXT_DESC_PTR,val)
#define bfin_read_IMDMA_S0_START_ADDR()      bfin_read32(IMDMA_S0_START_ADDR)
#define bfin_write_IMDMA_S0_START_ADDR(val)  bfin_write32(IMDMA_S0_START_ADDR,val)
#define bfin_read_IMDMA_S0_X_COUNT()         bfin_read16(IMDMA_S0_X_COUNT)
#define bfin_write_IMDMA_S0_X_COUNT(val)     bfin_write16(IMDMA_S0_X_COUNT,val)
#define bfin_read_IMDMA_S0_Y_COUNT()         bfin_read16(IMDMA_S0_Y_COUNT)
#define bfin_write_IMDMA_S0_Y_COUNT(val)     bfin_write16(IMDMA_S0_Y_COUNT,val)
#define bfin_read_IMDMA_S0_X_MODIFY()        bfin_read16(IMDMA_S0_X_MODIFY)
#define bfin_write_IMDMA_S0_X_MODIFY(val)    bfin_write16(IMDMA_S0_X_MODIFY,val)
#define bfin_read_IMDMA_S0_Y_MODIFY()        bfin_read16(IMDMA_S0_Y_MODIFY)
#define bfin_write_IMDMA_S0_Y_MODIFY(val)    bfin_write16(IMDMA_S0_Y_MODIFY,val)
#define bfin_read_IMDMA_S0_CURR_DESC_PTR()   bfin_read32(IMDMA_S0_CURR_DESC_PTR)
#define bfin_write_IMDMA_S0_CURR_DESC_PTR(val) bfin_write32(IMDMA_S0_CURR_DESC_PTR,val)
#define bfin_read_IMDMA_S0_CURR_ADDR()       bfin_read32(IMDMA_S0_CURR_ADDR)
#define bfin_write_IMDMA_S0_CURR_ADDR(val)   bfin_write32(IMDMA_S0_CURR_ADDR,val)
#define bfin_read_IMDMA_S0_CURR_X_COUNT()    bfin_read16(IMDMA_S0_CURR_X_COUNT)
#define bfin_write_IMDMA_S0_CURR_X_COUNT(val) bfin_write16(IMDMA_S0_CURR_X_COUNT,val)
#define bfin_read_IMDMA_S0_CURR_Y_COUNT()    bfin_read16(IMDMA_S0_CURR_Y_COUNT)
#define bfin_write_IMDMA_S0_CURR_Y_COUNT(val) bfin_write16(IMDMA_S0_CURR_Y_COUNT,val)
#define bfin_read_IMDMA_S0_IRQ_STATUS()      bfin_read16(IMDMA_S0_IRQ_STATUS)
#define bfin_write_IMDMA_S0_IRQ_STATUS(val)  bfin_write16(IMDMA_S0_IRQ_STATUS,val)
#define bfin_read_IMDMA_D1_CONFIG()          bfin_read16(IMDMA_D1_CONFIG)
#define bfin_write_IMDMA_D1_CONFIG(val)      bfin_write16(IMDMA_D1_CONFIG,val)
#define bfin_read_IMDMA_D1_NEXT_DESC_PTR()   bfin_read32(IMDMA_D1_NEXT_DESC_PTR)
#define bfin_write_IMDMA_D1_NEXT_DESC_PTR(val) bfin_write32(IMDMA_D1_NEXT_DESC_PTR,val)
#define bfin_read_IMDMA_D1_START_ADDR()      bfin_read32(IMDMA_D1_START_ADDR)
#define bfin_write_IMDMA_D1_START_ADDR(val)  bfin_write32(IMDMA_D1_START_ADDR,val)
#define bfin_read_IMDMA_D1_X_COUNT()         bfin_read16(IMDMA_D1_X_COUNT)
#define bfin_write_IMDMA_D1_X_COUNT(val)     bfin_write16(IMDMA_D1_X_COUNT,val)
#define bfin_read_IMDMA_D1_Y_COUNT()         bfin_read16(IMDMA_D1_Y_COUNT)
#define bfin_write_IMDMA_D1_Y_COUNT(val)     bfin_write16(IMDMA_D1_Y_COUNT,val)
#define bfin_read_IMDMA_D1_X_MODIFY()        bfin_read16(IMDMA_D1_X_MODIFY)
#define bfin_write_IMDMA_D1_X_MODIFY(val)    bfin_write16(IMDMA_D1_X_MODIFY,val)
#define bfin_read_IMDMA_D1_Y_MODIFY()        bfin_read16(IMDMA_D1_Y_MODIFY)
#define bfin_write_IMDMA_D1_Y_MODIFY(val)    bfin_write16(IMDMA_D1_Y_MODIFY,val)
#define bfin_read_IMDMA_D1_CURR_DESC_PTR()   bfin_read32(IMDMA_D1_CURR_DESC_PTR)
#define bfin_write_IMDMA_D1_CURR_DESC_PTR(val) bfin_write32(IMDMA_D1_CURR_DESC_PTR,val)
#define bfin_read_IMDMA_D1_CURR_ADDR()       bfin_read32(IMDMA_D1_CURR_ADDR)
#define bfin_write_IMDMA_D1_CURR_ADDR(val)   bfin_write32(IMDMA_D1_CURR_ADDR,val)
#define bfin_read_IMDMA_D1_CURR_X_COUNT()    bfin_read16(IMDMA_D1_CURR_X_COUNT)
#define bfin_write_IMDMA_D1_CURR_X_COUNT(val) bfin_write16(IMDMA_D1_CURR_X_COUNT,val)
#define bfin_read_IMDMA_D1_CURR_Y_COUNT()    bfin_read16(IMDMA_D1_CURR_Y_COUNT)
#define bfin_write_IMDMA_D1_CURR_Y_COUNT(val) bfin_write16(IMDMA_D1_CURR_Y_COUNT,val)
#define bfin_read_IMDMA_D1_IRQ_STATUS()      bfin_read16(IMDMA_D1_IRQ_STATUS)
#define bfin_write_IMDMA_D1_IRQ_STATUS(val)  bfin_write16(IMDMA_D1_IRQ_STATUS,val)
#define bfin_read_IMDMA_S1_CONFIG()          bfin_read16(IMDMA_S1_CONFIG)
#define bfin_write_IMDMA_S1_CONFIG(val)      bfin_write16(IMDMA_S1_CONFIG,val)
#define bfin_read_IMDMA_S1_NEXT_DESC_PTR()   bfin_read32(IMDMA_S1_NEXT_DESC_PTR)
#define bfin_write_IMDMA_S1_NEXT_DESC_PTR(val) bfin_write32(IMDMA_S1_NEXT_DESC_PTR,val)
#define bfin_read_IMDMA_S1_START_ADDR()      bfin_read32(IMDMA_S1_START_ADDR)
#define bfin_write_IMDMA_S1_START_ADDR(val)  bfin_write32(IMDMA_S1_START_ADDR,val)
#define bfin_read_IMDMA_S1_X_COUNT()         bfin_read16(IMDMA_S1_X_COUNT)
#define bfin_write_IMDMA_S1_X_COUNT(val)     bfin_write16(IMDMA_S1_X_COUNT,val)
#define bfin_read_IMDMA_S1_Y_COUNT()         bfin_read16(IMDMA_S1_Y_COUNT)
#define bfin_write_IMDMA_S1_Y_COUNT(val)     bfin_write16(IMDMA_S1_Y_COUNT,val)
#define bfin_read_IMDMA_S1_X_MODIFY()        bfin_read16(IMDMA_S1_X_MODIFY)
#define bfin_write_IMDMA_S1_X_MODIFY(val)    bfin_write16(IMDMA_S1_X_MODIFY,val)
#define bfin_read_IMDMA_S1_Y_MODIFY()        bfin_read16(IMDMA_S1_Y_MODIFY)
#define bfin_write_IMDMA_S1_Y_MODIFY(val)    bfin_write16(IMDMA_S1_Y_MODIFY,val)
#define bfin_read_IMDMA_S1_CURR_DESC_PTR()   bfin_read32(IMDMA_S1_CURR_DESC_PTR)
#define bfin_write_IMDMA_S1_CURR_DESC_PTR(val) bfin_write32(IMDMA_S1_CURR_DESC_PTR,val)
#define bfin_read_IMDMA_S1_CURR_ADDR()       bfin_read32(IMDMA_S1_CURR_ADDR)
#define bfin_write_IMDMA_S1_CURR_ADDR(val)   bfin_write32(IMDMA_S1_CURR_ADDR,val)
#define bfin_read_IMDMA_S1_CURR_X_COUNT()    bfin_read16(IMDMA_S1_CURR_X_COUNT)
#define bfin_write_IMDMA_S1_CURR_X_COUNT(val) bfin_write16(IMDMA_S1_CURR_X_COUNT,val)
#define bfin_read_IMDMA_S1_CURR_Y_COUNT()    bfin_read16(IMDMA_S1_CURR_Y_COUNT)
#define bfin_write_IMDMA_S1_CURR_Y_COUNT(val) bfin_write16(IMDMA_S1_CURR_Y_COUNT,val)
#define bfin_read_IMDMA_S1_IRQ_STATUS()      bfin_read16(IMDMA_S1_IRQ_STATUS)
#define bfin_write_IMDMA_S1_IRQ_STATUS(val)  bfin_write16(IMDMA_S1_IRQ_STATUS,val)

#define bfin_read_MDMA_S0_CONFIG()  bfin_read_MDMA1_S0_CONFIG()
#define bfin_write_MDMA_S0_CONFIG(val) bfin_write_MDMA1_S0_CONFIG(val)
#define bfin_read_MDMA_S0_IRQ_STATUS()  bfin_read_MDMA1_S0_IRQ_STATUS()
#define bfin_write_MDMA_S0_IRQ_STATUS(val) bfin_write_MDMA1_S0_IRQ_STATUS(val)
#define bfin_read_MDMA_S0_X_MODIFY()  bfin_read_MDMA1_S0_X_MODIFY()
#define bfin_write_MDMA_S0_X_MODIFY(val) bfin_write_MDMA1_S0_X_MODIFY(val)
#define bfin_read_MDMA_S0_Y_MODIFY()  bfin_read_MDMA1_S0_Y_MODIFY()
#define bfin_write_MDMA_S0_Y_MODIFY(val) bfin_write_MDMA1_S0_Y_MODIFY(val)
#define bfin_read_MDMA_S0_X_COUNT()  bfin_read_MDMA1_S0_X_COUNT()
#define bfin_write_MDMA_S0_X_COUNT(val) bfin_write_MDMA1_S0_X_COUNT(val)
#define bfin_read_MDMA_S0_Y_COUNT()  bfin_read_MDMA1_S0_Y_COUNT()
#define bfin_write_MDMA_S0_Y_COUNT(val) bfin_write_MDMA1_S0_Y_COUNT(val)
#define bfin_read_MDMA_S0_START_ADDR()  bfin_read_MDMA1_S0_START_ADDR()
#define bfin_write_MDMA_S0_START_ADDR(val) bfin_write_MDMA1_S0_START_ADDR(val)
#define bfin_read_MDMA_D0_CONFIG()  bfin_read_MDMA1_D0_CONFIG()
#define bfin_write_MDMA_D0_CONFIG(val) bfin_write_MDMA1_D0_CONFIG(val)
#define bfin_read_MDMA_D0_IRQ_STATUS()  bfin_read_MDMA1_D0_IRQ_STATUS()
#define bfin_write_MDMA_D0_IRQ_STATUS(val) bfin_write_MDMA1_D0_IRQ_STATUS(val)
#define bfin_read_MDMA_D0_X_MODIFY()  bfin_read_MDMA1_D0_X_MODIFY()
#define bfin_write_MDMA_D0_X_MODIFY(val) bfin_write_MDMA1_D0_X_MODIFY(val)
#define bfin_read_MDMA_D0_Y_MODIFY()  bfin_read_MDMA1_D0_Y_MODIFY()
#define bfin_write_MDMA_D0_Y_MODIFY(val) bfin_write_MDMA1_D0_Y_MODIFY(val)
#define bfin_read_MDMA_D0_X_COUNT()  bfin_read_MDMA1_D0_X_COUNT()
#define bfin_write_MDMA_D0_X_COUNT(val) bfin_write_MDMA1_D0_X_COUNT(val)
#define bfin_read_MDMA_D0_Y_COUNT()  bfin_read_MDMA1_D0_Y_COUNT()
#define bfin_write_MDMA_D0_Y_COUNT(val) bfin_write_MDMA1_D0_Y_COUNT(val)
#define bfin_read_MDMA_D0_START_ADDR()  bfin_read_MDMA1_D0_START_ADDR()
#define bfin_write_MDMA_D0_START_ADDR(val) bfin_write_MDMA1_D0_START_ADDR(val)

#endif				/* _CDEF_BF561_H */
