/*
 * setattr.h
 *
 * Simple set/get-attribute interface to the fsattr syscall
 */

/* From linux/include/fs.h: */

/*
 * This is the inode attributes flag definitions
 */
#define ATTR_FLAG_SYNCRONOUS	1 	/* Syncronous write */
#define ATTR_FLAG_NOATIME	2 	/* Don't update atime */
#define ATTR_FLAG_APPEND	4 	/* Append-only file */
#define ATTR_FLAG_IMMUTABLE	8 	/* Immutable file */
#define ATTR_FLAG_NODIRATIME	16 	/* Don't update atime for directory */
#define ATTR_FLAG_DIRECT	32 	/* Force unbuffered IO */
#define ATTR_FLAG_NODUMP	64 	/* Do not dump(8) this file */
#define ATTR_FLAG_COMPRESS	128 	/* Try to compress this file */
#define ATTR_FLAG_BTREE		256 	/* Use btree format on dir */

extern int getattr(const char *filename);
extern int setattr(const char *filename, int flags);
