/*
 * linux/cache_def.h
 * Handling of caches defined in drivers, filesystems, ...
 *
 * Copyright (C) 2002 by Andreas Gruenbacher, <a.gruenbacher@computer.org>
 */
#ifndef _LINUX_CACHE_DEF_H
#define _LINUX_CACHE_DEF_H

struct cache_definition {
	const char *name;
	int (*shrink)(int, unsigned int);
	struct list_head link;
};

extern void register_cache(struct cache_definition *);
extern void unregister_cache(struct cache_definition *);

#endif /* _LINUX_CACHE_DEF_H */
