/*
 * Network disk client
 * Server RPC info, XDR routines
 *
 * Copyright (c) 1996 Petr Salinger
 * Copyright (c) 1999 Libor Bus <l.bus@sh.cvut.cz>
 * Copyright (c) 2001 Lubomir Bulej <pallas@kadan.cz>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef _NWD_XDR_H
#define _NWD_XDR_H

#include <linux/errno.h>
#include <linux/types.h>


#define NWD_PROGRAM 		0x21050003
#define NWD_VERSION_1 		1
#define NWD_VERSION_2		2

#define	NWD_OK			0
#define NWD_ENOENT		ENOENT
#define NWD_EIO			EIO
#define	NWD_EINVAL		EINVAL
#define NWD_ENOSPC		ENOSPC

#define NWDPROC_NULL 		0
#define NWDPROC_DISPOSE		1
#define NWDPROC_READ 		2
#define NWDPROC_WRITE		3
#define NWDPROC_LOOKUP		4
#define NWDPROC_SYNC		5


typedef __s32  nwd_res;
typedef __s32  nwd_handle;


typedef struct nwd_rwargs {
	nwd_handle	file;
	__u64		offset;
	__u32		count;
	void *		buffer;
} nwd_rwargs;


typedef struct nwd_readres {
	nwd_res		status;
	__u32		count;
} nwd_readres;


typedef struct nwd_lookupres {
	nwd_res		status;
	nwd_handle	file;
	__u64		size;
} nwd_lookupres;


extern struct rpc_stat		nwd_rpcstat;
extern struct rpc_program	nwd_program;

#endif /* _NWD_XDR_H */
