/*======================================================================*/
/*									*/
/*  Immunix CryptoMark Toolkit: 					*/
/*									*/
/*      This code was taken from RedHat's RPM program source. It's been	*/
/*      modified to work in the kernel context.				*/
/*									*/
/*  cm_md5.h:				 				*/
/* 									*/
/*======================================================================*/

#ifndef COD_MD5_H
#define COD_MD5_H

#ifdef __alpha
typedef unsigned int uint32;
#else
typedef unsigned long uint32;
#endif

struct MD5Context {
	uint32 buf[4];
	uint32 bits[2];
	unsigned char in[64];
	int doByteReverse;
};

void MD5Init(struct MD5Context *context, int brokenEndian);
#ifdef __KERNEL__
void MD5Update(struct MD5Context *context, unsigned char const *buf,
	       unsigned len, int from_user);
#else /* __KERNEL__ */
void MD5Update(struct MD5Context *context, unsigned char const *buf,
	       unsigned len);
#endif /* __KERNEL__ */
void MD5Final(unsigned char digest[16], struct MD5Context *context);
void MD5Transform(uint32 buf[4], uint32 const in[16]);

int mdfile(char *fn, unsigned char *digest);
int mdbinfile(char *fn, unsigned char *bindigest);

/* These assume a little endian machine and return incorrect results! 
   They are here for compatibility with old (broken) versions of RPM */
int mdfileBroken(char *fn, unsigned char *digest);
int mdbinfileBroken(char *fn, unsigned char *bindigest);

/*
 * This is needed to make RSAREF happy on some MS-DOS compilers.
 */
typedef struct MD5Context MD5_CTX;

#endif /* !COD_MD5_H */
