
#ifndef __CRYPTOMARK_H
#define __CRYPTOMARK_H

#ifdef __KERNEL__

#define CRYPTOMARK_TITLE	"WireX CryptoMark module"
#define CRYPTOMARK_COPYRIGHT	"Copyright 1998, 1999, 2000 WireX Communications Inc."

extern const char *cryptomark_title;
extern const char *cryptomark_copyright;

#define DIGI_SIG_SIZE 16	/* Number of (unsigned) bytes in a
				 * digital signature - md5 is 16 bytes */
#define CRYPTOMARK_NAME	"CM_MD5Sig"	/* elf section for the signage */

/*======================================================================
 *
 *  prototypes
 *
 *======================================================================*/

extern struct immunix_digital_sig * crypto_compute_elf_sig (struct elf_phdr *elf_phdata, int elf_e_phnum, char *name);
extern int crypto_compare_elf_sig (struct dentry *elf_inode, struct elfhdr *elf_ex, struct immunix_digital_sig *sig, char * name);


extern int crypto_verify_data (unsigned char * inp, unsigned long size, unsigned char **data);


extern void proc_init	(void);
extern void proc_done	(void);

/*======================================================================
 *
 *  Other macros that are useful for us
 *
 *======================================================================*/

#endif /* __KERNEL__ */

#ifndef TRUE
	#define TRUE	(1)
#endif
#ifndef FALSE
	#define FALSE	(0)
#endif
	
#ifdef MAX
	#define MAX(a,b)	(((a)>(b))?(a):(b))
#endif
#ifndef MIN
	#define MIN(a,b)	(((a)<(b))?(a):(b))
#endif

/*======================================================================*/

#endif				/* __CRYPTOMARK_H */
