/*
 * (ext8022.c)-
 * 
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 

#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include <asm/byteorder.h>

typedef int (*func_type)(struct sk_buff *, struct device *, struct packet_type *);

static int P8022_rcv (struct sk_buff *, struct device *, struct packet_type *);

static func_type sap_table[128];
static int p8022_users=0;
static struct packet_type p8022_packet_type = 
{
	0,	/* MUTTER ntohs(ETH_P_8022),*/
	NULL,		/* All devices */
	P8022_rcv,
	NULL,
	NULL,
};
static struct packet_type p8022tr_packet_type = 
{
	0,	/* MUTTER ntohs(ETH_PTR_8022),*/
	NULL,		/* All devices */
	P8022_rcv,
	NULL,
	NULL,
};


static int P8022_rcv (struct sk_buff *skb, struct device *dev, struct packet_type *pt)
{
 unsigned char n= 0;

	n=(*(skb->h.raw)) >> 1;
	if ( sap_table[n] )
            sap_table[n](skb, dev, pt);
        else
            kfree_skb(skb,FREE_READ);
        return (0);
}

void P8022_register_sap(unsigned char sap, func_type rcvfunc)
{
	sap >>= 1;
	sap_table[sap] = rcvfunc;            
	if (p8022_users == 0){
                p8022_packet_type.type = htons(ETH_P_802_2);
		dev_add_pack(&p8022_packet_type);
                p8022tr_packet_type.type = htons(ETH_P_TR_802_2);
		dev_add_pack(&p8022tr_packet_type);
        }
	p8022_users ++;
}

void P8022_unregister_sap(unsigned char sap)
{
	sap >>= 1;
        sap_table[sap] = NULL;
	if ((p8022_users=p8022_users-1) == 0){
           dev_remove_pack(&p8022_packet_type);
	   dev_remove_pack(&p8022tr_packet_type);
        } 
}
