#ident "$Id: mount_bind.c,v 1.1 2000/06/01 19:29:31 hpa Exp $"
/* ----------------------------------------------------------------------- *
 *   
 *  mount_bind.c      - module to mount a local filesystem if possible;
 *			otherwise create a symlink.
 *
 *   Copyright 2000 Transmeta Corporation - All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,
 *   USA; either version 2 of the License, or (at your option) any later
 *   version; incorporated herein by reference.
 *
 * ----------------------------------------------------------------------- */

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <syslog.h>
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

#define MODULE_MOUNT
#include "automount.h"

#define MODPREFIX "mount(bind): "
int mount_version = AUTOFS_MOUNT_VERSION; /* Required by protocol */

int mount_init(void **context)
{
  return 0;
}

int mount_mount(const char *root, const char *name, int name_len,
		const char *what, const char *fstype, const char *options,
		void *context)
{
  char *fullpath;
  int err;

  fullpath = alloca(strlen(root)+name_len+2);
  if ( !fullpath ) {
    syslog(LOG_ERR, MODPREFIX "alloca: %m");
    return 1;
  }
  sprintf(fullpath, "%s/%s", root, name);
    
  syslog(LOG_DEBUG, MODPREFIX "calling mkdir %s", fullpath);
  if ( mkdir(fullpath, 0555) && errno != EEXIST ) {
    syslog(LOG_NOTICE, MODPREFIX "mkdir %s failed: %m", name);
    return 1;
  }
    
  if ( options ) {
    syslog(LOG_DEBUG, MODPREFIX "calling mount -t %s " SLOPPY "-o %s %s %s",
	   fstype, options, what, fullpath);
    err = spawnl(LOG_NOTICE, PATH_MOUNT, PATH_MOUNT, "-t", fstype,
		 SLOPPYOPT "-o", options, what, fullpath, NULL);
  } else {
    syslog(LOG_DEBUG, MODPREFIX "calling mount -t %s %s %s",
	   fstype, what, fullpath);
      err = spawnl(LOG_NOTICE, PATH_MOUNT, PATH_MOUNT, "-t", fstype,
		   what, fullpath, NULL);
  }
  if ( err ) {
    if ( rmdir(fullpath) && errno == EBUSY )
      return 0;

    syslog(LOG_DEBUG, MODPREFIX "failed to mount %s (type %s) on %s, trying symlink",
	   what, fstype, fullpath);
    if ( symlink(what, fullpath) && errno != EEXIST ) {
      syslog(LOG_NOTICE, MODPREFIX "failed to create local mount %s -> %s", fullpath, what);
      
      return 1;
    } else {
      syslog(LOG_DEBUG, MODPREFIX "symlinked %s -> %s", fullpath, what);
      return 0;
    }
  } else {
    syslog(LOG_DEBUG, MODPREFIX "mounted %s type %s on %s",
	   what, fstype, fullpath);
    return 0;
  }
}

int mount_done(void *context)
{
  return 0;
}
