/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.inject.ImplementedBy;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import java.util.List;
import javax.annotation.Nullable;

@ImplementedBy(value=DefaultEurekaClientConfig.class)
public interface EurekaClientConfig {
    public int getRegistryFetchIntervalSeconds();

    public int getInstanceInfoReplicationIntervalSeconds();

    public int getInitialInstanceInfoReplicationIntervalSeconds();

    public int getEurekaServiceUrlPollIntervalSeconds();

    public String getProxyHost();

    public String getProxyPort();

    public String getProxyUserName();

    public String getProxyPassword();

    public boolean shouldGZipContent();

    public int getEurekaServerReadTimeoutSeconds();

    public int getEurekaServerConnectTimeoutSeconds();

    public String getBackupRegistryImpl();

    public int getEurekaServerTotalConnections();

    public int getEurekaServerTotalConnectionsPerHost();

    public String getEurekaServerURLContext();

    public String getEurekaServerPort();

    public String getEurekaServerDNSName();

    public boolean shouldUseDnsForFetchingServiceUrls();

    public boolean shouldRegisterWithEureka();

    default public boolean shouldUnregisterOnShutdown() {
        return true;
    }

    public boolean shouldPreferSameZoneEureka();

    public boolean allowRedirects();

    public boolean shouldLogDeltaDiff();

    public boolean shouldDisableDelta();

    @Nullable
    public String fetchRegistryForRemoteRegions();

    public String getRegion();

    public String[] getAvailabilityZones(String var1);

    public List<String> getEurekaServerServiceUrls(String var1);

    public boolean shouldFilterOnlyUpInstances();

    public int getEurekaConnectionIdleTimeoutSeconds();

    public boolean shouldFetchRegistry();

    default public boolean shouldEnforceFetchRegistryAtInit() {
        return false;
    }

    @Nullable
    public String getRegistryRefreshSingleVipAddress();

    public int getHeartbeatExecutorThreadPoolSize();

    public int getHeartbeatExecutorExponentialBackOffBound();

    public int getCacheRefreshExecutorThreadPoolSize();

    public int getCacheRefreshExecutorExponentialBackOffBound();

    public String getDollarReplacement();

    public String getEscapeCharReplacement();

    public boolean shouldOnDemandUpdateStatusChange();

    default public boolean shouldEnforceRegistrationAtInit() {
        return false;
    }

    public String getEncoderName();

    public String getDecoderName();

    public String getClientDataAccept();

    public String getExperimental(String var1);

    public EurekaTransportConfig getTransportConfig();
}

