
# MSSQL by ODBC

## Overview

For Zabbix version: 5.0 and higher  
The template is developed for monitoring DBMS Microsoft SQL Server via ODBC.

This template was tested on:

- Zabbix, version 5.0
- Microsoft SQL, version 2017, 2019

## Setup

> See [Zabbix template operation](https://www.zabbix.com/documentation/5.0/manual/config/templates_out_of_the_box/odbc_checks) for basic instructions.

1. Create an MSSQL user for monitoring.  
  **View Server State** and **View Any Definition** permissions should be granted to the user.  
  For more information please see the MSSQL documentation:  
    https://docs.microsoft.com/en-us/sql/relational-databases/security/authentication-access/create-a-database-user?view=sql-server-ver15  
    https://docs.microsoft.com/en-us/sql/t-sql/statements/grant-server-permissions-transact-sql?view=sql-server-ver15  
2. Set the user name and password in host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).  
  Do not forget to install the Microsoft ODBC driver on the Zabbix server or the Zabbix proxy.  
  See Microsoft documentation for instructions: https://docs.microsoft.com/en-us/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server?view=sql-server-ver15.  
  **Note! Credentials in the odbc.ini do not work for MSSQL.**  
3. For named instance set the value of {$MSSQL.INSTANCE} macro as MSSQL$instance name, please.  

The "Service's TCP port state" item uses {HOST.CONN} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance.
If you have instance on non-default TCP port, set the port in your section of odbc.ini in line Server = IP or FQDN name, port.


## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$MSSQL.AVERAGE_WAIT_TIME.MAX} |<p>The maximum average wait time in ms for trigger expression.</p> |`500` |
|{$MSSQL.BUFFER_CACHE_RATIO.MIN.CRIT} |<p>The minimum % buffer cache hit ratio for high trigger expression.</p> |`30` |
|{$MSSQL.BUFFER_CACHE_RATIO.MIN.WARN} |<p>The minimum % buffer cache hit ratio for warning trigger expression.</p> |`50` |
|{$MSSQL.DBNAME.MATCHES} |<p>This macro is used in database discovery. It can be overridden on the host or linked template level.</p> |`.*` |
|{$MSSQL.DBNAME.NOT_MATCHES} |<p>This macro is used in database discovery. It can be overridden on the host or linked template level.</p> |`master|tempdb|model|msdb` |
|{$MSSQL.DEADLOCKS.MAX} |<p>The maximum deadlocks per second for trigger expression.</p> |`1` |
|{$MSSQL.DSN} |<p>System data source name.</p> |`<Put your DSN here>` |
|{$MSSQL.FREE_LIST_STALLS.MAX} |<p>The maximum free list stalls per second for trigger expression.</p> |`2` |
|{$MSSQL.INSTANCE} |<p>The instance name for the default instance is SQLServer. For named instance set macro value as MSSQL$instance name.</p> |`SQLServer` |
|{$MSSQL.LAZY_WRITES.MAX} |<p>The maximum lazy writes per second for trigger expression.</p> |`20` |
|{$MSSQL.LOCK_REQUESTS.MAX} |<p>The maximum lock requests per second for trigger expression.</p> |`1000` |
|{$MSSQL.LOCK_TIMEOUTS.MAX} |<p>The maximum lock timeouts per second for trigger expression.</p> |`1` |
|{$MSSQL.LOG_FLUSH_WAITS.MAX} |<p>The maximum log flush waits per second for trigger expression.</p> |`1` |
|{$MSSQL.LOG_FLUSH_WAIT_TIME.MAX} |<p>The maximum log flush wait time in ms for trigger expression.</p> |`1` |
|{$MSSQL.PAGE_LIFE_EXPECTANCY.MIN} |<p>The minimum page life expectancy for trigger expression.</p> |`300` |
|{$MSSQL.PAGE_READS.MAX} |<p>The maximum page reads per second for trigger expression.</p> |`90` |
|{$MSSQL.PAGE_WRITES.MAX} |<p>The maximum page writes per second for trigger expression.</p> |`90` |
|{$MSSQL.PASSWORD} |<p>MSSQL user password.</p> |`<Put your password here>` |
|{$MSSQL.PERCENT_COMPILATIONS.MAX} |<p>The maximum percent of Transact-SQL compilations for trigger expression.</p> |`10` |
|{$MSSQL.PERCENT_LOG_USED.MAX} |<p>The maximum percent log used for trigger expression.</p> |`80` |
|{$MSSQL.PERCENT_READAHEAD.MAX} |<p>The maximum percent of pages read/sec in anticipation of use for trigger expression.</p> |`20` |
|{$MSSQL.PERCENT_RECOMPILATIONS.MAX} |<p>The maximum percent of Transact-SQL recompilations for trigger expression.</p> |`10` |
|{$MSSQL.PORT} |<p>MSSQL TCP port.</p> |`1433` |
|{$MSSQL.USER} |<p>MSSQL username.</p> |`<Put your username here>` |
|{$MSSQL.WORKTABLES_FROM_CACHE_RATIO.MIN.CRIT} |<p>The minimum % worktables from cache ratio for high trigger expression.</p> |`90` |
|{$MSSQL.WORK_FILES.MAX} |<p>The maximum number of work files created per second for trigger expression.</p> |`20` |
|{$MSSQL.WORK_TABLES.MAX} |<p>The maximum number of work tables created per second for trigger expression.</p> |`20` |

## Template links

There are no template links in this template.

## Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|Database discovery |<p>Scanning databases in DBMS.</p> |ODBC |db.odbc.discovery[dbname,"{$MSSQL.DSN}"]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p><p>**Filter**:</p>AND <p>- A: {#DBNAME} MATCHES_REGEX `{$MSSQL.DBNAME.MATCHES}`</p><p>- B: {#DBNAME} NOT_MATCHES_REGEX `{$MSSQL.DBNAME.NOT_MATCHES}`</p> |
|Availability groups discovery |<p>Discovery the existed availability groups.</p> |ODBC |db.odbc.discovery[availability_groups,"{$MSSQL.DSN}"]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Local database discovery |<p>Discovery of the local availability databases.</p> |ODBC |db.odbc.discovery[local_db,"{$MSSQL.DSN}"]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Non-local database discovery |<p>Discovery of the non-local (not local to the SQL Server instance) availability databases.</p> |ODBC |db.odbc.discovery[non-local_db,"{$MSSQL.DSN}"]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Replication discovery |<p>Discovery of the database replicas.</p> |ODBC |db.odbc.discovery[replicas,"{$MSSQL.DSN}"]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Mirroring discovery |<p>To see the row for a database other than master or tempdb, you must</p><p>either be the database owner or have at least ALTER ANY DATABASE or VIEW ANY</p><p>DATABASE server-level permission or CREATE DATABASE permission in the master</p><p>database. To see non-NULL values on a mirror database, you must be a member</p><p>of the sysadmin fixed server role.</p> |ODBC |db.odbc.discovery[mirrors,"{$MSSQL.DSN}"]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |

## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|MSSQL |MSSQL: Service's TCP port state |<p>Test the availability of MS SQL Server on TCP port.</p> |SIMPLE |net.tcp.service[tcp,{HOST.CONN},{$MSSQL.PORT}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `10m`</p> |
|MSSQL |MSSQL: Version |<p>MS SQL Server version.</p> |DEPENDENT |mssql.version<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}' && @.counter_name=='Version')].instance_name.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|MSSQL |MSSQL: Uptime |<p>MS SQL Server uptime in 'N days, hh:mm:ss' format.</p> |DEPENDENT |mssql.uptime<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}' && @.counter_name=='Uptime')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Forwarded records per second |<p>Number of records per second fetched through forwarded record pointers.</p> |DEPENDENT |mssql.forwarded_records_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Access Methods' && @.counter_name=='Forwarded Records/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Full scans per second |<p>Number of unrestricted full scans per second. These can be either base-table or full-index scans. Values greater than 1 or 2 indicate that we are having table / Index page scans. If we see high CPU then we need to investigate this counter, otherwise if the full scans are on small tables we can ignore this counter.</p> |DEPENDENT |mssql.full_scans_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Access Methods' && @.counter_name=='Full Scans/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Index searches per second |<p>Number of index searches per second. These are used to start a range scan, reposition a range scan, revalidate a scan point, fetch a single index record, and search down the index to locate where to insert a new row.</p> |DEPENDENT |mssql.index_searches_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Access Methods' && @.counter_name=='Index Searches/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Page splits per second |<p>Number of page splits per second that occur as the result of overflowing index pages.</p> |DEPENDENT |mssql.page_splits_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Access Methods' && @.counter_name=='Page Splits/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Work files created per second |<p>Number of work files created per second. For example, work files could be used to store temporary results for hash joins and hash aggregates.</p> |DEPENDENT |mssql.workfiles_created_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Access Methods' && @.counter_name=='Workfiles Created/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Work tables created per second |<p>Number of work tables created per second. For example, work tables could be used to store temporary results for query spool, lob variables, XML variables, and cursors.</p> |DEPENDENT |mssql.worktables_created_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Access Methods' && @.counter_name=='Worktables Created/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Table lock escalations per second |<p>Number of times locks on a table were escalated to the TABLE or HoBT granularity.</p> |DEPENDENT |mssql.table_lock_escalations.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Access Methods' && @.counter_name=='Table Lock Escalations/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Worktables from cache ratio |<p>Percentage of work tables created where the initial two pages of the work table were not allocated but were immediately available from the work table cache.</p> |DEPENDENT |mssql.worktables_from_cache_ratio<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Access Methods' && @.counter_name=='WorktablesFromCacheRatio')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Buffer cache hit ratio |<p>Indicates the percentage of pages found in the buffer cache without having to read from disk. The ratio is the total number of cache hits divided by the total number of cache lookups over the last few thousand page accesses. After a long period of time, the ratio moves very little. Because reading from the cache is much less expensive than reading from disk, you want this ratio to be high. Generally, you can increase the buffer cache hit ratio by increasing the amount of memory available to SQL Server or by using the buffer pool extension feature.</p> |DEPENDENT |mssql.buffer_cache_hit_ratio<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='BufferCacheHitRatio')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Checkpoint pages per second |<p>Indicates the number of pages flushed to disk per second by a checkpoint or other operation that require all dirty pages to be flushed.</p> |DEPENDENT |mssql.checkpoint_pages_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='Checkpoint pages/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Database pages |<p>Indicates the number of pages in the buffer pool with database content.</p> |DEPENDENT |mssql.database_pages<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='Database pages')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Free list stalls per second |<p>Indicates the number of requests per second that had to wait for a free page.</p> |DEPENDENT |mssql.free_list_stalls_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='Free list stalls/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Lazy writes per second |<p>Indicates the number of buffers written per second by the buffer manager's lazy writer. The lazy writer is a system process that flushes out batches of dirty, aged buffers (buffers that contain changes that must be written back to disk before the buffer can be reused for a different page) and makes them available to user processes. The lazy writer eliminates the need to perform frequent checkpoints in order to create available buffers.</p> |DEPENDENT |mssql.lazy_writes_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='Lazy writes/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Page life expectancy |<p>Indicates the number of seconds a page will stay in the buffer pool without references.</p> |DEPENDENT |mssql.page_life_expectancy<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='Page life expectancy')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Page lookups per second |<p>Indicates the number of requests per second to find a page in the buffer pool.</p> |DEPENDENT |mssql.page_lookups_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='Page lookups/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Page reads per second |<p>Indicates the number of physical database page reads that are issued per second. This statistic displays the total number of physical page reads across all databases. Because physical I/O is expensive, you may be able to minimize the cost, either by using a larger data cache, intelligent indexes, and more efficient queries, or by changing the database design.</p> |DEPENDENT |mssql.page_reads_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='Page reads/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Page writes per second |<p>Indicates the number of physical database page writes that are issued per second.</p> |DEPENDENT |mssql.page_writes_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='Page writes/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Read-ahead pages per second |<p>Indicates the number of pages read per second in anticipation of use.</p> |DEPENDENT |mssql.readahead_pages_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='Readahead pages/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Target pages |<p>The optimum number of pages in the buffer pool.</p> |DEPENDENT |mssql.target_pages<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Buffer Manager' && @.counter_name=='Target pages')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Total data file size |<p>Total size of all the data files.</p> |DEPENDENT |mssql.data_files_size<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Data File(s) Size (KB)' && @.instance_name=='_Total')].cntr_value.first()`</p><p>- MULTIPLIER: `1024`</p> |
|MSSQL |MSSQL: Total log file size |<p>Total size of all the transaction log files.</p> |DEPENDENT |mssql.log_files_size<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log File(s) Size (KB)' && @.instance_name=='_Total')].cntr_value.first()`</p><p>- MULTIPLIER: `1024`</p> |
|MSSQL |MSSQL: Total log file used size |<p>The cumulative used size of all the log files in the database.</p> |DEPENDENT |mssql.log_files_used_size<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log File(s) Used Size (KB)' && @.instance_name=='_Total')].cntr_value.first()`</p><p>- MULTIPLIER: `1024`</p> |
|MSSQL |MSSQL: Total transactions per second |<p>Total number of transactions started for all databases per second.</p> |DEPENDENT |mssql.transactions_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Transactions/sec' && @.instance_name=='_Total')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Logins per second |<p>Total number of logins started per second. This does not include pooled connections. Any value over 2 may indicate insufcient connection pooling.</p> |DEPENDENT |mssql.logins_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:General Statistics' && @.counter_name=='Logins/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Logouts per second |<p>Total number of logout operations started per second. Any value over 2 may indicate insufcient connection pooling.</p> |DEPENDENT |mssql.logouts_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:General Statistics' && @.counter_name=='Logouts/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Number of blocked processes |<p>Number of currently blocked processes.</p> |DEPENDENT |mssql.processes_blocked<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:General Statistics' && @.counter_name=='Processes blocked')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Number users connected |<p>Number of users connected to MS SQL Server.</p> |DEPENDENT |mssql.user_connections<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:General Statistics' && @.counter_name=='User Connections')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Average latch wait time |<p>Average latch wait time (in milliseconds) for latch requests that had to wait.</p> |CALCULATED |mssql.average_latch_wait_time<p>**Expression**:</p>`(last(mssql.average_latch_wait_time_raw) - prev(mssql.average_latch_wait_time_raw)) / (last(mssql.average_latch_wait_time_base) - prev(mssql.average_latch_wait_time_base) +  (last(mssql.average_latch_wait_time_base) - prev(mssql.average_latch_wait_time_base)=0)) ` |
|MSSQL |MSSQL: Latch waits per second |<p>The number of latch requests that could not be granted immediately. Latches are lightweight means of holding a very transient server resource, such as an address in memory.</p> |DEPENDENT |mssql.latch_waits_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Latches' && @.counter_name=='Latch Waits/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Total latch wait Time |<p>Total latch wait time (in milliseconds) for latch requests in the last second. This value should stay stable compared to the number of latch waits per second.</p> |DEPENDENT |mssql.total_latch_wait_time<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Latches' && @.counter_name=='Total Latch Wait Time (ms)')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Total average wait time |<p>The average wait time, in milliseconds, for each lock request that had to wait.</p> |CALCULATED |mssql.average_wait_time<p>**Expression**:</p>`(last(mssql.average_wait_time_raw) - prev(mssql.average_wait_time_raw)) / (last(mssql.average_wait_time_base) - prev(mssql.average_wait_time_base) +  (last(mssql.average_wait_time_base) - prev(mssql.average_wait_time_base)=0)) ` |
|MSSQL |MSSQL: Total lock requests per second |<p>Number of new locks and lock conversions per second requested from the lock manager.</p> |DEPENDENT |mssql.lock_requests_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Locks' && @.counter_name=='Lock Requests/sec' && @.instance_name=='_Total')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Total lock requests per second that timed out |<p>Number of lock requests per second that timed out, including requests for NOWAIT locks.</p> |DEPENDENT |mssql.lock_timeouts_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Locks' && @.counter_name=='Lock Timeouts/sec' && @.instance_name=='_Total')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Total lock requests per second that required waiting |<p>Number of lock requests per second that required the caller to wait.</p> |DEPENDENT |mssql.lock_waits_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Locks' && @.counter_name=='Lock Waits/sec' && @.instance_name=='_Total')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Lock wait time |<p>Average of total wait time (in milliseconds) for locks in the last second. </p> |DEPENDENT |mssql.lock_wait_time<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Locks' && @.counter_name=='Lock Wait Time (ms)' && @.instance_name=='_Total')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Total lock requests per second that have deadlocks |<p>Number of lock requests per second that resulted in a deadlock.</p> |DEPENDENT |mssql.number_deadlocks_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Locks' && @.counter_name=='Number of Deadlocks/sec' && @.instance_name=='_Total')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Granted Workspace Memory |<p>Specifies the total amount of memory currently granted to executing processes, such as hash, sort, bulk copy, and index creation operations.</p> |DEPENDENT |mssql.granted_workspace_memory<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Memory Manager' && @.counter_name=='Granted Workspace Memory (KB)')].cntr_value.first()`</p><p>- MULTIPLIER: `1024`</p> |
|MSSQL |MSSQL: Maximum workspace memory |<p>Indicates the maximum amount of memory available for executing processes, such as hash, sort, bulk copy, and index creation operations.</p> |DEPENDENT |mssql.maximum_workspace_memory<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Memory Manager' && @.counter_name=='Maximum Workspace Memory (KB)')].cntr_value.first()`</p><p>- MULTIPLIER: `1024`</p> |
|MSSQL |MSSQL: Memory grants outstanding |<p>Specifies the total number of processes that have successfully acquired a workspace memory grant.</p> |DEPENDENT |mssql.memory_grants_outstanding<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Memory Manager' && @.counter_name=='Memory Grants Outstanding')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Memory grants pending |<p>Specifies the total number of processes waiting for a workspace memory grant.</p> |DEPENDENT |mssql.memory_grants_pending<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Memory Manager' && @.counter_name=='Memory Grants Pending')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Target server memory |<p>Indicates the ideal amount of memory the server can consume.</p> |DEPENDENT |mssql.target_server_memory<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Memory Manager' && @.counter_name=='Target Server Memory (KB)')].cntr_value.first()`</p><p>- MULTIPLIER: `1024`</p> |
|MSSQL |MSSQL: Total server memory |<p>Specifies the amount of memory the server has committed using the memory manager.</p> |DEPENDENT |mssql.total_server_memory<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Memory Manager' && @.counter_name=='Total Server Memory (KB)')].cntr_value.first()`</p><p>- MULTIPLIER: `1024`</p> |
|MSSQL |MSSQL: Cache hit ratio |<p>Ratio between cache hits and lookups.</p> |DEPENDENT |mssql.cache_hit_ratio<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Plan Cache' && @.counter_name=='CacheHitRatio' && @.instance_name=='_Total')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Cache object counts |<p>Number of cache objects in the cache.</p> |DEPENDENT |mssql.cache_object_counts<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Plan Cache' && @.counter_name=='Cache Object Counts' && @.instance_name=='_Total')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Cache objects in use |<p>Number of cache objects in use.</p> |DEPENDENT |mssql.cache_objects_in_use<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Plan Cache' && @.counter_name=='Cache Objects in use' && @.instance_name=='_Total')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Cache pages |<p>Number of 8-kilobyte (KB) pages used by cache objects.</p> |DEPENDENT |mssql.cache_pages<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Plan Cache' && @.counter_name=='Cache Pages' && @.instance_name=='_Total')].cntr_value.first()`</p> |
|MSSQL |MSSQL: Errors per second (DB offline errors) |<p>Number of errors per second.</p> |DEPENDENT |mssql.offline_errors_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Errors' && @.counter_name=='Errors/sec' && @.instance_name=='DB Offline Errors')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Errors per second (Info errors) |<p>Number of errors per second.</p> |DEPENDENT |mssql.info_errors_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Errors' && @.counter_name=='Errors/sec' && @.instance_name=='Info Errors')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Errors per second (Kill connection errors) |<p>Number of errors per second.</p> |DEPENDENT |mssql.kill_connection_errors_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Errors' && @.counter_name=='Errors/sec' && @.instance_name=='Kill Connection Errors')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Errors per second (User errors) |<p>Number of errors per second.</p> |DEPENDENT |mssql.user_errors_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Errors' && @.counter_name=='Errors/sec' && @.instance_name=='User Errors')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Total errors per second |<p>Number of errors per second.</p> |DEPENDENT |mssql.errors_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Errors' && @.counter_name=='Errors/sec' && @.instance_name=='_Total')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Auto-param attempts per second |<p>Number of auto-parameterization attempts per second. Total should be the sum of the failed, safe, and unsafe auto-parameterizations. Auto-parameterization occurs when an instance of SQL Server tries to parameterize a Transact-SQL request by replacing some literals with parameters so that reuse of the resulting cached execution plan across multiple similar-looking requests is possible. Note that auto-parameterizations are also known as simple parameterizations in newer versions of SQL Server. This counter does not include forced parameterizations.</p> |DEPENDENT |mssql.autoparam_attempts_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Statistics' && @.counter_name=='Auto-Param Attempts/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Batch requests per second |<p>Number of Transact-SQL command batches received per second. This statistic is affected by all constraints (such as I/O, number of users, cache size, complexity of requests, and so on). High batch requests mean good throughput.</p> |DEPENDENT |mssql.batch_requests_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Statistics' && @.counter_name=='Batch Requests/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Percent of Adhoc queries running |<p>The ratio of SQL compilations per second to Batch requests per second in percent.</p> |CALCULATED |mssql.percent_of_adhoc_queries<p>**Expression**:</p>`last(mssql.sql_compilations_sec.rate) * 100 / (last(mssql.batch_requests_sec.rate) + (last(mssql.batch_requests_sec.rate)=0))` |
|MSSQL |MSSQL: Percent of Recompiled Transact-SQL Objects |<p>The ratio of SQL re-compilations per second to SQL compilations per second in percent.</p> |CALCULATED |mssql.percent_recompilations_to_compilations<p>**Expression**:</p>`last(mssql.sql_recompilations_sec.rate) * 100 / (last(mssql.sql_compilations_sec.rate) + (last(mssql.sql_compilations_sec.rate)=0))` |
|MSSQL |MSSQL: Full scans to Index searches ratio |<p>The ratio of Full scans per second to Index searches per second. The threshold recommendation is strictly for OLTP workloads.</p> |CALCULATED |mssql.scan_to_search<p>**Expression**:</p>`last(mssql.full_scans_sec.rate) / (last(mssql.index_searches_sec.rate) + (last(mssql.index_searches_sec.rate)=0))` |
|MSSQL |MSSQL: Failed auto-params per second |<p>Number of failed auto-parameterization attempts per second. This should be small. Note that auto-parameterizations are also known as simple parameterizations in later versions of SQL Server.</p> |DEPENDENT |mssql.failed_autoparams_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Statistics' && @.counter_name=='Failed Auto-Params/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Safe auto-params per second |<p>Number of safe auto-parameterization attempts per second. Safe refers to a determination that a cached execution plan can be shared between different similar-looking Transact-SQL statements. SQL Server makes many auto-parameterization attempts some of which turn out to be safe and others fail. Note that auto-parameterizations are also known as simple parameterizations in later versions of SQL Server. This does not include forced parameterizations.</p> |DEPENDENT |mssql.safe_autoparams_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Statistics' && @.counter_name=='Safe Auto-Params/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: SQL compilations per second |<p>Number of SQL compilations per second. Indicates the number of times the compile code path is entered. Includes compiles caused by statement-level recompilations in SQL Server. After SQL Server user activity is stable, this value reaches a steady state.</p> |DEPENDENT |mssql.sql_compilations_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Statistics' && @.counter_name=='SQL Compilations/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: SQL re-compilations per second |<p>Number of statement recompiles per second. Counts the number of times statement recompiles are triggered. Generally, you want the recompiles to be low.</p> |DEPENDENT |mssql.sql_recompilations_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Statistics' && @.counter_name=='SQL Re-Compilations/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Unsafe auto-params per second |<p>Number of unsafe auto-parameterization attempts per second. For example, the query has some characteristics that prevent the cached plan from being shared. These are designated as unsafe. This does not count the number of forced parameterizations.</p> |DEPENDENT |mssql.unsafe_autoparams_sec.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:SQL Statistics' && @.counter_name=='Unsafe Auto-Params/sec')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL: Total transactions number |<p>The number of currently active transactions of all types.</p> |DEPENDENT |mssql.transactions<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Transactions' && @.counter_name=='Transactions')].cntr_value.first()`</p> |
|MSSQL |MSSQL DB '{#DBNAME}': State |<p>0 = ONLINE</p><p>1 = RESTORING</p><p>2 = RECOVERING | SQL Server 2008 and later</p><p>3 = RECOVERY_PENDING | SQL Server 2008 and later</p><p>4 = SUSPECT</p><p>5 = EMERGENCY | SQL Server 2008 and later</p><p>6 = OFFLINE | SQL Server 2008 and later</p><p>7 = COPYING | Azure SQL Database Active Geo-Replication</p><p>10 = OFFLINE_SECONDARY | Azure SQL Database Active Geo-Replication</p> |DEPENDENT |mssql.db.state["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='State' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `15m`</p> |
|MSSQL |MSSQL DB '{#DBNAME}': Active transactions |<p>Number of active transactions for the database.</p> |DEPENDENT |mssql.db.active_transactions["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Active Transactions' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p> |
|MSSQL |MSSQL DB '{#DBNAME}': Data file size |<p>Cumulative size of all the data files in the database including any automatic growth. Monitoring this counter is useful, for example, for determining the correct size of tempdb.</p> |DEPENDENT |mssql.db.data_files_size["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Data File(s) Size (KB)' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p><p>- MULTIPLIER: `1024`</p> |
|MSSQL |MSSQL DB '{#DBNAME}': Log bytes flushed per second |<p>Total number of log bytes flushed per second. Useful for determining trends and utilization of the transaction log.</p> |DEPENDENT |mssql.db.log_bytes_flushed_sec.rate["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log Bytes Flushed/sec' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL DB '{#DBNAME}': Log file size |<p>Cumulative size of all the transaction log files in the database.</p> |DEPENDENT |mssql.db.log_files_size["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log File(s) Size (KB)' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p><p>- MULTIPLIER: `1024`</p> |
|MSSQL |MSSQL DB '{#DBNAME}': Log file used size |<p>The cumulative used size of all the log files in the database.</p> |DEPENDENT |mssql.db.log_files_used_size["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log File(s) Used Size (KB)' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p><p>- MULTIPLIER: `1024`</p> |
|MSSQL |MSSQL DB '{#DBNAME}': Log flushes per second |<p>Number of log flushes per second.</p> |DEPENDENT |mssql.db.log_flushes_sec.rate["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log Flushes/sec' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL DB '{#DBNAME}': Log flush waits per second |<p>Number of commits per second waiting for the log flush.</p> |DEPENDENT |mssql.db.log_flush_waits_sec.rate["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log Flush Waits/sec' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL DB '{#DBNAME}': Log flush wait time |<p>Total wait time (in milliseconds) to flush the log. On an AlwaysOn secondary database, this value indicates the wait time for log records to be hardened to disk.</p> |DEPENDENT |mssql.db.log_flush_wait_time["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log Flush Wait Time' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL DB '{#DBNAME}': Log growths |<p>Total number of times the transaction log for the database has been expanded.</p> |DEPENDENT |mssql.db.log_growths["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log Growths' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p> |
|MSSQL |MSSQL DB '{#DBNAME}': Log shrinks |<p>Total number of times the transaction log for the database has been shrunk.</p> |DEPENDENT |mssql.db.log_shrinks["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log Shrinks' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p> |
|MSSQL |MSSQL DB '{#DBNAME}': Log truncations |<p>The number of times the transaction log has been shrunk.</p> |DEPENDENT |mssql.db.log_truncations["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Log Truncations' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p> |
|MSSQL |MSSQL DB '{#DBNAME}': Percent log used |<p>Percentage of space in the log that is in use.</p> |DEPENDENT |mssql.db.percent_log_used["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Percent Log Used' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p> |
|MSSQL |MSSQL DB '{#DBNAME}': Transactions per second |<p>Number of transactions started for the database per second.</p> |DEPENDENT |mssql.db.transactions_sec.rate["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Databases' && @.counter_name=='Transactions/sec' && @.instance_name=='{#DBNAME}')].cntr_value.first()`</p><p>- CHANGE_PER_SECOND |
|MSSQL |MSSQL AG '{#GROUP_NAME}': Primary replica recovery health |<p>Indicates the recovery health of the primary replica:</p><p>0 = In progress</p><p>1 = Online</p><p>2 = Unavailable</p> |DEPENDENT |mssql.primary_recovery_health["{#GROUP_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}')].primary_recovery_health.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}': Primary replica name |<p>Name of the server instance that is hosting the current primary replica.</p> |DEPENDENT |mssql.primary_replica["{#GROUP_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}')].primary_replica.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}': Secondary replica recovery health |<p>Indicates the recovery health of a secondary replica replica:</p><p>0 = In progress</p><p>1 = Online</p><p>2 = Unavailable</p> |DEPENDENT |mssql.secondary_recovery_health["{#GROUP_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}')].secondary_recovery_health.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}': Synchronization health |<p>Reflects a rollup of the synchronization_health of all availability replicas in the availability group:</p><p>0: Not healthy. None of the availability replicas have a healthy.</p><p>1: Partially healthy. The synchronization health of some, but not all, availability replicas is healthy.</p><p>2: Healthy. The synchronization health of every availability replica is healthy.</p> |DEPENDENT |mssql.synchronization_health["{#GROUP_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}')].synchronization_health.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Local DB '{#DBNAME}': State |<p>0 = Online</p><p>1 = Restoring</p><p>2 = Recovering</p><p>3 = Recovery pending</p><p>4 = Suspect</p><p>5 = Emergency</p><p>6 = Offline</p> |DEPENDENT |mssql.local_db.state["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}' && @.dbname=='{#DBNAME}')].database_state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Local DB '{#DBNAME}': Suspended |<p>Database state:</p><p>0 = Resumed</p><p>1 = Suspended</p> |DEPENDENT |mssql.local_db.is_suspended["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}' && @.dbname=='{#DBNAME}')].is_suspended.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Local DB '{#DBNAME}': Synchronization health |<p>Reflects the intersection of the synchronization state of a database that is joined to the availability group on the availability replica and the availability mode of the availability replica (synchronous-commit or asynchronous-commit mode):</p><p>0 = Not healthy. The synchronization_state of the database is 0 (NOT SYNCHRONIZING).</p><p>1 = Partially healthy. A database on a synchronous-commit availability replica is considered </p><p>partially healthy if synchronization_state is 1 (SYNCHRONIZING).</p><p>2 = Healthy. A database on an synchronous-commit availability replica is considered healthy if synchronization_state is 2 (SYNCHRONIZED), and a database on an asynchronous-commit availability replica is considered healthy if synchronization_state is 1 (SYNCHRONIZING).</p> |DEPENDENT |mssql.local_db.synchronization_health["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}' && @.dbname=='{#DBNAME}')].synchronization_health.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Non-Local DB '{#DBNAME}': Log queue size |<p>Amount of log records of the primary database that has not been sent to the secondary databases.</p> |DEPENDENT |mssql.non-local_db.log_send_queue_size["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}' && @.dbname=='{#DBNAME}')].log_send_queue_size.first()`</p><p>- MULTIPLIER: `1024`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Non-Local DB '{#DBNAME}': Redo log queue size |<p>Amount of log records in the log files of the secondary replica that has not yet been redone.</p> |DEPENDENT |mssql.non-local_db.redo_queue_size["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}' && @.dbname=='{#DBNAME}')].redo_queue_size.first()`</p><p>- MULTIPLIER: `1024`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': Connected state |<p>Whether a secondary replica is currently connected to the primary replica:</p><p>0 : Disconnected. The response of an availability replica to the DISCONNECTED state depends on its role:</p><p>On the primary replica, if a secondary replica is disconnected, its secondary databases are marked as NOT SYNCHRONIZED on the primary replica, which waits for the secondary to reconnect;</p><p>On a secondary replica, upon detecting that it is disconnected, the secondary replica attempts to reconnect to the primary replica.</p><p>1 : Connected. Each primary replica tracks the connection state for every secondary replica in the same availability group. Secondary replicas track the connection state of only the primary replica.</p> |DEPENDENT |mssql.replica.connected_state["{#GROUP_NAME}_{#REPLICA_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}')].connected_state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': Is local |<p>Whether the replica is local:</p><p>0 = Indicates a remote secondary replica in an availability group whose primary replica is hosted by the local server instance. This value occurs only on the primary replica location.</p><p>1 = Indicates a local replica. On secondary replicas, this is the only available value for the availability group to which the replica belongs.</p> |DEPENDENT |mssql.replica.is_local["{#GROUP_NAME}_{#REPLICA_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}')].is_local.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': Join state |<p>0 = Not joined</p><p>1 = Joined, standalone instance</p><p>2 = Joined, failover cluster instance</p> |DEPENDENT |mssql.replica.join_state["{#GROUP_NAME}_{#REPLICA_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}')].join_state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': Operational state |<p>Current operational state of the replica:</p><p>0 = Pending failover</p><p>1 = Pending</p><p>2 = Online</p><p>3 = Offline</p><p>4 = Failed</p><p>5 = Failed, no quorum</p><p>6 = Not local</p> |DEPENDENT |mssql.replica.operational_state["{#GROUP_NAME}_{#REPLICA_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}')].operational_state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': Recovery health |<p>Rollup of the database_state column of the sys.dm_hadr_database_replica_states dynamic management view:</p><p>0 : In progress. At least one joined database has a database state other than ONLINE </p><p>(database_state is not 0).</p><p>1 : Online. All the joined databases have a database state of ONLINE (database_state is 0).</p> |DEPENDENT |mssql.replica.recovery_health["{#GROUP_NAME}_{#REPLICA_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}')].recovery_health.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': Role |<p>Current Always On availability groups role of a local replica or a connected remote replica:</p><p>0 = Resolving</p><p>1 = Primary</p><p>2 = Secondary</p> |DEPENDENT |mssql.replica.role["{#GROUP_NAME}_{#REPLICA_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}')].role.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': Sync health |<p>Reflects a rollup of the database synchronization state (synchronization_state)of all joined availability databases (also known as replicas) and the availability mode of the replica (synchronous-commit or asynchronous-commit mode). The rollup will reflect the least healthy accumulated state the databases on the replica:</p><p>0 : Not healthy. At least one joined database is in the NOT SYNCHRONIZING state.</p><p>1 : Partially healthy. Some replicas are not in the target synchronization state: synchronous-commit replicas should be synchronized, and asynchronous-commit replicas should be synchronizing.</p><p>2 : Healthy. All replicas are in the target synchronization state: synchronous-commit replicas are synchronized, and asynchronous-commit replicas are synchronizing.</p> |DEPENDENT |mssql.replica.synchronization_health["{#GROUP_NAME}_{#REPLICA_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.group_name=='{#GROUP_NAME}' && @.replica_name=='{#REPLICA_NAME}')].synchronization_health.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL Mirroring '{#DBNAME}': Role |<p>Current role of the local database plays in the database mirroring session.</p><p>1 = Principal</p><p>2 = Mirror</p> |DEPENDENT |mssql.mirroring.role["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.dbname=='{#DBNAME}')].mirroring_role.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL Mirroring '{#DBNAME}': Role sequence |<p>The number of times that mirroring partners have switched the principal and mirror roles due to a failover or forced service.</p> |DEPENDENT |mssql.mirroring.role_sequence["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.dbname=='{#DBNAME}')].mirroring_role_sequence.first()`</p><p>- SIMPLE_CHANGE |
|MSSQL |MSSQL Mirroring '{#DBNAME}': State |<p>State of the mirror database and of the database mirroring session.</p><p>0 = Suspended</p><p>1 = Disconnected from the other partner</p><p>2 = Synchronizing</p><p>3 = Pending Failover</p><p>4 = Synchronized</p><p>5 = The partners are not synchronized. Failover is not possible now.</p><p>6 = The partners are synchronized. Failover is potentially possible. For information about the requirements for failover see, Database Mirroring Operating Modes.</p> |DEPENDENT |mssql.mirroring.state["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.dbname=='{#DBNAME}')].mirroring_state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL Mirroring '{#DBNAME}': Witness state |<p>State of the witness in the database mirroring session of the database:</p><p>0 = Unknown</p><p>1 = Connected</p><p>2 = Disconnected</p> |DEPENDENT |mssql.mirroring.witness_state["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.dbname=='{#DBNAME}')].mirroring_witness_state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|MSSQL |MSSQL Mirroring '{#DBNAME}': Safety level |<p>Safety setting for updates on the mirror database:</p><p>0 = Unknown state</p><p>1 = Off [asynchronous]</p><p>2 = Full [synchronous]</p> |DEPENDENT |mssql.mirroring.safety_level["{#DBNAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.dbname=='{#DBNAME}')].mirroring_safety_level.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Zabbix_raw_items |MSSQL: Get performance counters |<p>The item gets server global status information.</p> |ODBC |db.odbc.get[get_status_variables,"{$MSSQL.DSN}"]<p>**Expression**:</p>`Text is too long. Please see the template.` |
|Zabbix_raw_items |MSSQL: Average latch wait time raw |<p>Average latch wait time (in milliseconds) for latch requests that had to wait.</p> |DEPENDENT |mssql.average_latch_wait_time_raw<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Latches' && @.counter_name=='Average Latch Wait Time (ms)')].cntr_value.first()`</p> |
|Zabbix_raw_items |MSSQL: Average latch wait time base |<p>For internal use only.</p> |DEPENDENT |mssql.average_latch_wait_time_base<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Latches' && @.counter_name=='Average Latch Wait Time Base')].cntr_value.first()`</p> |
|Zabbix_raw_items |MSSQL: Total average wait time raw |<p>Average amount of wait time (in milliseconds) for each lock request that resulted in a wait. Information for all locks.</p> |DEPENDENT |mssql.average_wait_time_raw<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Locks' && @.counter_name=='Average Wait Time (ms)' && @.instance_name=='_Total')].cntr_value.first()`</p> |
|Zabbix_raw_items |MSSQL: Total average wait time base |<p>For internal use only.</p> |DEPENDENT |mssql.average_wait_time_base<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.object_name=='{$MSSQL.INSTANCE}:Locks' && @.counter_name=='Average Wait Time Base' && @.instance_name=='_Total')].cntr_value.first()`</p> |
|Zabbix_raw_items |MSSQL AG '{#GROUP_NAME}': Get replica states |<p>Getting replica states - name, primary and secondary health, synchronization health.</p> |ODBC |db.odbc.get[{#GROUP_NAME}_replica_states,"{$MSSQL.DSN}"]<p>**Expression**:</p>`Text is too long. Please see the template.` |
|Zabbix_raw_items |MSSQL AG '{#GROUP_NAME}' Local DB '{#DBNAME}': Get local DB states |<p>Getting the states of the local availability database.</p> |ODBC |db.odbc.get["{#GROUP_NAME}_{#DBNAME}_local_db.states","{$MSSQL.DSN}"]<p>**Expression**:</p>`Text is too long. Please see the template.` |
|Zabbix_raw_items |MSSQL AG '{#GROUP_NAME}' Non-Local DB '{#DBNAME}': Get non-local DB states |<p>Getting the states of the non-local availability database.</p> |ODBC |db.odbc.get["{#GROUP_NAME}_{#DBNAME}_non-local_db.states","{$MSSQL.DSN}"]<p>**Expression**:</p>`Text is too long. Please see the template.` |
|Zabbix_raw_items |MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': Get the replica state |<p>Getting the database replica states.</p> |ODBC |db.odbc.get["{#GROUP_NAME}_{#REPLICA_NAME}_replica.state","{$MSSQL.DSN}"]<p>**Expression**:</p>`Text is too long. Please see the template.` |
|Zabbix_raw_items |MSSQL Mirroring '{#DBNAME}': Get the mirror state |<p>Getting mirrors state</p> |ODBC |db.odbc.get["{#DBNAME}_mirroring_state","{$MSSQL.DSN}"]<p>**Expression**:</p>`Text is too long. Please see the template.` |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|MSSQL: Service is unavailable |<p>The TCP port of the MS SQL Server service is currently unavailable.</p> |`{TEMPLATE_NAME:net.tcp.service[tcp,{HOST.CONN},{$MSSQL.PORT}].last()}=0` |DISASTER | |
|MSSQL: Version has changed (new version value received: {ITEM.VALUE}) |<p>MSSQL version has changed. Ack to close.</p> |`{TEMPLATE_NAME:mssql.version.diff()}=1 and {TEMPLATE_NAME:mssql.version.strlen()}>0` |INFO |<p>Manual close: YES</p> |
|MSSQL: has been restarted (uptime < 10m) |<p>Uptime is less than 10 minutes</p> |`{TEMPLATE_NAME:mssql.uptime.last()}<10m` |INFO |<p>Manual close: YES</p> |
|MSSQL: Failed to fetch info data (or no data for 30m) |<p>Zabbix has not received data for items for the last 30 minutes.</p> |`{TEMPLATE_NAME:mssql.uptime.nodata(30m)}=1` |INFO |<p>**Depends on**:</p><p>- MSSQL: Service is unavailable</p> |
|MSSQL: Too frequently pointers using |<p>Rows with varchar columns can experience expansion when varchar values are updated with a longer string.  In the case where the row cannot fit in the existing page, the row migrates and access to the row will traverse a pointer.  This only happens on heaps (tables without clustered indexes). Evaluate clustered index for heap tables.  In cases where clustered indexes cannot be used, drop non-clustered indexes, build a clustered index to reorg pages and rows, drop the clustered index, then recreate non-clustered indexes.</p> |`{TEMPLATE_NAME:mssql.forwarded_records_sec.rate.last()} * 100 > 10 * {MSSQL by ODBC:mssql.batch_requests_sec.rate.last()} ` |WARNING | |
|MSSQL: Number work files created per second is high (over {$MSSQL.WORK_FILES.MAX} for 5m) |<p>Too many work files created per second to store temporary results for hash joins and hash aggregates.</p> |`{TEMPLATE_NAME:mssql.workfiles_created_sec.rate.min(5m)}>{$MSSQL.WORK_FILES.MAX}` |AVERAGE | |
|MSSQL: Number work tables created per second is high (over {$MSSQL.WORK_TABLES.MAX} for 5m) |<p>Too many work tables created per second to store temporary results for query spool, lob variables, XML variables, and cursors.</p> |`{TEMPLATE_NAME:mssql.worktables_created_sec.rate.min(5m)}>{$MSSQL.WORK_TABLES.MAX}` |AVERAGE | |
|MSSQL: Percentage of work tables available from the work table cache is low (below {$MSSQL.WORKTABLES_FROM_CACHE_RATIO.MIN.CRIT}% for 5m) |<p>A value less than 90% may indicate insufcient memory, since execution plans are being dropped, or may indicate, on 32-bit systems, the need for an upgrade to a 64-bit system</p> |`{TEMPLATE_NAME:mssql.worktables_from_cache_ratio.max(5m)}<{$MSSQL.WORKTABLES_FROM_CACHE_RATIO.MIN.CRIT}` |HIGH | |
|MSSQL: Percentage of the buffer cache efficiency is low (below {$MSSQL.BUFFER_CACHE_RATIO.MIN.CRIT}% for 5m) |<p>Too low buffer cache hit ratio.</p> |`{TEMPLATE_NAME:mssql.buffer_cache_hit_ratio.max(5m)}<{$MSSQL.BUFFER_CACHE_RATIO.MIN.CRIT}` |HIGH | |
|MSSQL: Percentage of the buffer cache efficiency is low (below {$MSSQL.BUFFER_CACHE_RATIO.MIN.WARN}% for 5m) |<p>Low buffer cache hit ratio.</p> |`{TEMPLATE_NAME:mssql.buffer_cache_hit_ratio.max(5m)}<{$MSSQL.BUFFER_CACHE_RATIO.MIN.WARN}` |WARNING |<p>**Depends on**:</p><p>- MSSQL: Percentage of the buffer cache efficiency is low (below {$MSSQL.BUFFER_CACHE_RATIO.MIN.CRIT}% for 5m)</p> |
|MSSQL: Number of rps waiting for a free page is high (over {$MSSQL.FREE_LIST_STALLS.MAX} for 5m) |<p>Some requests have to wait for a free page.</p> |`{TEMPLATE_NAME:mssql.free_list_stalls_sec.rate.min(5m)}>{$MSSQL.FREE_LIST_STALLS.MAX}` |WARNING | |
|MSSQL: Number of buffers written per second by the lazy writer is high (over {$MSSQL.LAZY_WRITES.MAX} for 5m) |<p>The number of buffers written per second by the buffer manager's lazy writer exceeds the threshold.</p> |`{TEMPLATE_NAME:mssql.lazy_writes_sec.rate.min(5m)}>{$MSSQL.LAZY_WRITES.MAX}` |WARNING | |
|MSSQL: Page life expectancy is low (less {$MSSQL.PAGE_LIFE_EXPECTANCY.MIN}min for 15m) |<p>The page stays in the buffer pool without references of less time than the threshold value.</p> |`{TEMPLATE_NAME:mssql.page_life_expectancy.max(15m)}<{$MSSQL.PAGE_LIFE_EXPECTANCY.MIN}` |HIGH | |
|MSSQL: Number of physical database page reads per second is high (over {$MSSQL.PAGE_READS.MAX} for 5m) |<p>The physical database page reads are issued too frequently.</p> |`{TEMPLATE_NAME:mssql.page_reads_sec.rate.min(5m)}>{$MSSQL.PAGE_READS.MAX}` |WARNING | |
|MSSQL: Number of physical database page writes per second is high (over {$MSSQL.PAGE_WRITES.MAX} for 5m) |<p>The physical database page writes are issued too frequently.</p> |`{TEMPLATE_NAME:mssql.page_writes_sec.rate.min(5m)}>{$MSSQL.PAGE_WRITES.MAX}` |WARNING | |
|MSSQL: Too many physical reads occurring |<p>If this value is makes up even a sizeable minority of total Page Reads/sec (say, greater than 20% of total page reads), you may have too many physical reads occurring.</p> |`{TEMPLATE_NAME:mssql.readahead_pages_sec.rate.last()} > {$MSSQL.PERCENT_READAHEAD.MAX} / 100 * {MSSQL by ODBC:mssql.page_reads_sec.rate.last()}` |WARNING | |
|MSSQL: Total average wait time for locks is high (over {$MSSQL.AVERAGE_WAIT_TIME.MAX}ms for 5m) |<p>An average wait time longer than 500ms may indicate excessive blocking. This value should generally correlate to 'Lock Waits/sec' and move up or down with it accordingly.</p> |`{TEMPLATE_NAME:mssql.average_wait_time.min(5m)}>{$MSSQL.AVERAGE_WAIT_TIME.MAX}` |WARNING | |
|MSSQL: Total number of locks per second is high (over {$MSSQL.LOCK_REQUESTS.MAX} for 5m) |<p>The number of new locks and lock conversions per second requested from the lock manager is high.</p> |`{TEMPLATE_NAME:mssql.lock_requests_sec.rate.min(5m)}>{$MSSQL.LOCK_REQUESTS.MAX}` |WARNING | |
|MSSQL: Total lock requests per second that timed out is high (over {$MSSQL.LOCK_TIMEOUTS.MAX} for 5m) |<p>The total number of lock requests per second that timed out, including requests for NOWAIT locks is high.</p> |`{TEMPLATE_NAME:mssql.lock_timeouts_sec.rate.min(5m)}>{$MSSQL.LOCK_TIMEOUTS.MAX}` |WARNING | |
|MSSQL: Some blocking is occurring for 5m |<p>Values greater than zero indicate at least some blocking is occurring, while a value of zero can quickly eliminate blocking as a potential root-cause problem.</p> |`{TEMPLATE_NAME:mssql.lock_waits_sec.rate.min(5m)}>0` |AVERAGE | |
|MSSQL: Number of deadlock is high (over {$MSSQL.DEADLOCKS.MAX} for 5m) |<p>Too many deadlocks are occurring currently.</p> |`{TEMPLATE_NAME:mssql.number_deadlocks_sec.rate.min(5m)}>{$MSSQL.DEADLOCKS.MAX}` |AVERAGE | |
|MSSQL: Percent of adhoc queries running is over {$MSSQL.PERCENT_COMPILATIONS.MAX}% for 15m |<p>The lower this value is the better. High values often indicate excessive adhoc querying and should be as low as possible. If excessive adhoc querying is happening, try rewriting the queries as procedures or invoke the queries using sp_executeSQL. When rewriting isn’t possible, consider using a plan guide or setting the database to parameterization forced mode.</p> |`{TEMPLATE_NAME:mssql.percent_of_adhoc_queries.min(15m)} > {$MSSQL.PERCENT_COMPILATIONS.MAX}` |WARNING | |
|MSSQL: Percent of times statement recompiles is over {$MSSQL.PERCENT_RECOMPILATIONS.MAX}% for 15m |<p>This number should be at or near zero, since recompiles can cause deadlocks and exclusive compile locks. This counter’s value should follow in proportion to “Batch Requests/sec” and “SQL Compilations/sec”. This needs to be nil in your system as much as possible.</p> |`{TEMPLATE_NAME:mssql.percent_recompilations_to_compilations.min(15m)} > {$MSSQL.PERCENT_RECOMPILATIONS.MAX}` |WARNING | |
|MSSQL: Index and table scans are often than index searches for 15m |<p>Index searches are preferable to index and table scans. For OLTP applications, optimize for more index searches and less scans (preferably, 1 full scan for every 1000 index searches). Index and table scans are expensive I/O operations.</p> |`{TEMPLATE_NAME:mssql.scan_to_search.min(15m)} > 0.001` |WARNING | |
|MSSQL DB '{#DBNAME}': State is {ITEM.VALUE} |<p>The DB has a non-working state.</p> |`{TEMPLATE_NAME:mssql.db.state["{#DBNAME}"].last()}>1` |HIGH | |
|MSSQL DB '{#DBNAME}': Number of commits waiting for the log flush is high (over {$MSSQL.LOG_FLUSH_WAITS.MAX:"{#DBNAME}"}/sec for 5m) |<p>Too many commits are waiting for the log flush.</p> |`{TEMPLATE_NAME:mssql.db.log_flush_waits_sec.rate["{#DBNAME}"].min(5m)}>{$MSSQL.LOG_FLUSH_WAITS.MAX:"{#DBNAME}"}` |WARNING | |
|MSSQL DB '{#DBNAME}': Total wait time to flush the log is high (over {$MSSQL.LOG_FLUSH_WAIT_TIME.MAX:"{#DBNAME}"}ms for 5m) |<p>The wait time to flush the log is too long.</p> |`{TEMPLATE_NAME:mssql.db.log_flush_wait_time["{#DBNAME}"].min(5m)}>{$MSSQL.LOG_FLUSH_WAIT_TIME.MAX:"{#DBNAME}"}` |WARNING | |
|MSSQL DB '{#DBNAME}': Percent of log using is high (over {$MSSQL.PERCENT_LOG_USED.MAX:"{#DBNAME}"}% for 5m) |<p>There's not enough space left in the log.</p> |`{TEMPLATE_NAME:mssql.db.percent_log_used["{#DBNAME}"].min(5m)}>{$MSSQL.PERCENT_LOG_USED.MAX:"{#DBNAME}"}` |WARNING | |
|MSSQL AG '{#GROUP_NAME}': Primary replica recovery health in progress |<p>The primary replica is in the synchronization process.</p> |`{TEMPLATE_NAME:mssql.primary_recovery_health["{#GROUP_NAME}"].last()}=0` |WARNING | |
|MSSQL AG '{#GROUP_NAME}': Secondary replica recovery health in progress |<p>The secondary replica is in the synchronization process.</p> |`{TEMPLATE_NAME:mssql.secondary_recovery_health["{#GROUP_NAME}"].last()}=0` |WARNING | |
|MSSQL AG '{#GROUP_NAME}': All replicas unhealthy |<p>None of the availability replicas have a healthy.</p> |`{TEMPLATE_NAME:mssql.synchronization_health["{#GROUP_NAME}"].last()}=0` |DISASTER | |
|MSSQL AG '{#GROUP_NAME}': Some replicas unhealthy |<p>The synchronization health of some, but not all, availability replicas is healthy.</p> |`{TEMPLATE_NAME:mssql.synchronization_health["{#GROUP_NAME}"].last()}=1` |HIGH | |
|MSSQL AG '{#GROUP_NAME}' Local DB '{#DBNAME}': "{#DBNAME}" is {ITEM.VALUE} |<p>The local availability database has a non-working state.</p> |`{TEMPLATE_NAME:mssql.local_db.state["{#DBNAME}"].last()}>0` |WARNING | |
|MSSQL AG '{#GROUP_NAME}' Local DB '{#DBNAME}': "{#DBNAME}" is Not healthy |<p>The synchronization state of the local availability database is NOT SYNCHRONIZING.</p> |`{TEMPLATE_NAME:mssql.local_db.synchronization_health["{#DBNAME}"].last()}=0` |HIGH | |
|MSSQL AG '{#GROUP_NAME}' Local DB '{#DBNAME}': "{#DBNAME}" is Partially healthy |<p>A database on a synchronous-commit availability replica is considered partially healthy if synchronization state is SYNCHRONIZING.</p> |`{TEMPLATE_NAME:mssql.local_db.synchronization_health["{#DBNAME}"].last()}=1` |AVERAGE | |
|MSSQL AG '{#GROUP_NAME}' Non-Local DB '{#DBNAME}': Log queue size is growing |<p>The log records of the primary database do not send to the secondary databases.</p> |`{TEMPLATE_NAME:mssql.non-local_db.log_send_queue_size["{#DBNAME}"].last(#1)}>{TEMPLATE_NAME:mssql.non-local_db.log_send_queue_size["{#DBNAME}"].last(#2)} and {TEMPLATE_NAME:mssql.non-local_db.log_send_queue_size["{#DBNAME}"].last(#2)}>{TEMPLATE_NAME:mssql.non-local_db.log_send_queue_size["{#DBNAME}"].last(#3)}` |HIGH | |
|MSSQL AG '{#GROUP_NAME}' Non-Local DB '{#DBNAME}': Redo log queue size is growing |<p>The log records in the log files of the secondary replica have not yet been redone.</p> |`{TEMPLATE_NAME:mssql.non-local_db.redo_queue_size["{#DBNAME}"].last(#1)}>{TEMPLATE_NAME:mssql.non-local_db.redo_queue_size["{#DBNAME}"].last(#2)} and {TEMPLATE_NAME:mssql.non-local_db.redo_queue_size["{#DBNAME}"].last(#2)}>{TEMPLATE_NAME:mssql.non-local_db.redo_queue_size["{#DBNAME}"].last(#3)}` |HIGH | |
|MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': {#REPLICA_NAME} is disconnected |<p>The response of an availability replica to the DISCONNECTED state depends on its role: </p><p>On the primary replica, if a secondary replica is disconnected, its secondary databases are marked as NOT SYNCHRONIZED on the primary replica, which waits for the secondary to reconnect; On a secondary replica, upon detecting that it is disconnected, the secondary replica attempts to reconnect to the primary replica.</p> |`{TEMPLATE_NAME:mssql.replica.connected_state["{#GROUP_NAME}_{#REPLICA_NAME}"].last()}=0 and {MSSQL by ODBC:mssql.replica.role["{#GROUP_NAME}_{#REPLICA_NAME}"].last()}=2` |WARNING | |
|MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': {#REPLICA_NAME} is {ITEM.VALUE} |<p>The operational state of the replica in a given availability group is "Pending" or "Offline".</p> |`{TEMPLATE_NAME:mssql.replica.operational_state["{#GROUP_NAME}_{#REPLICA_NAME}"].last()}=0 or {TEMPLATE_NAME:mssql.replica.operational_state["{#GROUP_NAME}_{#REPLICA_NAME}"].last()}=1 or {TEMPLATE_NAME:mssql.replica.operational_state["{#GROUP_NAME}_{#REPLICA_NAME}"].last()}=3` |WARNING | |
|MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': {#REPLICA_NAME} is {ITEM.VALUE} |<p>The operational state of the replica in a given availability group is "Failed".</p> |`{TEMPLATE_NAME:mssql.replica.operational_state["{#GROUP_NAME}_{#REPLICA_NAME}"].last()}=4` |AVERAGE | |
|MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': {#REPLICA_NAME} is {ITEM.VALUE} |<p>The operational state of the replica in a given availability group is "Failed, no quorum".</p> |`{TEMPLATE_NAME:mssql.replica.operational_state["{#GROUP_NAME}_{#REPLICA_NAME}"].last()}=5` |HIGH | |
|MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': {#REPLICA_NAME} Recovery in progress |<p>At least one joined database has a database state other than ONLINE.</p> |`{TEMPLATE_NAME:mssql.replica.recovery_health["{#GROUP_NAME}_{#REPLICA_NAME}"].last()}=0` |INFO | |
|MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': {#REPLICA_NAME} is Not healthy |<p>At least one joined database is in the NOT SYNCHRONIZING state.</p> |`{TEMPLATE_NAME:mssql.replica.synchronization_health["{#GROUP_NAME}_{#REPLICA_NAME}"].last()}=0` |AVERAGE | |
|MSSQL AG '{#GROUP_NAME}' Replica '{#REPLICA_NAME}': {#REPLICA_NAME} is Partially healthy |<p>Some replicas are not in the target synchronization state: synchronous-commit replicas should be synchronized, and asynchronous-commit replicas should be synchronizing.</p> |`{TEMPLATE_NAME:mssql.replica.synchronization_health["{#GROUP_NAME}_{#REPLICA_NAME}"].last()}=1` |WARNING | |
|MSSQL Mirroring '{#DBNAME}': "{#DBNAME}" is {ITEM.VALUE} |<p>The state of the mirror database and of the database mirroring session is "Suspended", "Disconnected from the other partner", or "Synchronizing".</p> |`{TEMPLATE_NAME:mssql.mirroring.state["{#DBNAME}"].last()}>=0 and {TEMPLATE_NAME:mssql.mirroring.state["{#DBNAME}"].last()}<=2` |INFO | |
|MSSQL Mirroring '{#DBNAME}': "{#DBNAME}" is {ITEM.VALUE} |<p>The state of the mirror database and of the database mirroring session is "Pending Failover".</p> |`{TEMPLATE_NAME:mssql.mirroring.state["{#DBNAME}"].last()}=3` |WARNING | |
|MSSQL Mirroring '{#DBNAME}': "{#DBNAME}" is {ITEM.VALUE} |<p>The state of the mirror database and of the database mirroring session is "Not synchronized". The partners are not synchronized. A failover is not possible now.</p> |`{TEMPLATE_NAME:mssql.mirroring.state["{#DBNAME}"].last()}=5` |HIGH | |
|MSSQL Mirroring '{#DBNAME}': "{#DBNAME}" Witness is disconnected |<p>The state of the witness in the database mirroring session of the database is "Disconnected".</p> |`{TEMPLATE_NAME:mssql.mirroring.witness_state["{#DBNAME}"].last()}=2` |WARNING | |

## Feedback

Please report any issues with the template at https://support.zabbix.com

You can also provide a feedback, discuss the template or ask for help with it at [ZABBIX forums](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/).


## References

http://www.grumpyolddba.co.uk/monitoring/Performance%20Counter%20Guidance%20-%20SQL%20Server.htm  
https://docs.microsoft.com/en-us/sql/relational-databases/performance-monitor/sql-server-access-methods-object?view=sql-server-ver15

