/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import org.jmol.g3d.Platform3D;

final class Awt3D
extends Platform3D
implements ImageProducer {
    Component component;
    ColorModel colorModelRGB;
    ImageConsumer ic;

    Awt3D(Component component) {
        this.component = component;
        this.colorModelRGB = Toolkit.getDefaultToolkit().getColorModel();
    }

    Image allocateImage() {
        return this.component.createImage(this);
    }

    void notifyEndOfRendering() {
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    Image allocateOffscreenImage(int n, int n2) {
        Image image = this.component.createImage(n, n2);
        return image;
    }

    Graphics getGraphics(Image image) {
        return image.getGraphics();
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        if (this.ic == imageConsumer) {
            this.ic = null;
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (this.ic != imageConsumer) {
            this.ic = imageConsumer;
            imageConsumer.setDimensions(this.windowWidth, this.windowHeight);
            imageConsumer.setHints(14);
        }
        imageConsumer.setPixels(0, 0, this.windowWidth, this.windowHeight, this.colorModelRGB, this.pBuffer, 0, this.windowWidth);
        imageConsumer.imageComplete(2);
    }
}

