/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.utils;

import fr.ove.utils.LinkedElement;
import fr.ove.utils.Queueable;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Queue
implements Queueable,
Serializable {
    private LinkedElement head = null;
    private LinkedElement tail = null;
    private int nbElements = 0;

    @Override
    public void enqueue(Object object) {
        LinkedElement linkedElement = new LinkedElement(object);
        if (this.nbElements == 0) {
            this.head = this.tail = linkedElement;
        } else {
            linkedElement.setNext(this.tail);
            this.tail.setPrevious(linkedElement);
            this.tail = linkedElement;
        }
        ++this.nbElements;
    }

    @Override
    public Object dequeue() {
        Object object = null;
        if (this.nbElements != 0) {
            LinkedElement linkedElement = this.head;
            object = linkedElement.getElement();
            this.head = linkedElement.getPrevious();
            linkedElement.remove();
            if (this.nbElements == 1) {
                this.tail = null;
                this.head = null;
            }
            --this.nbElements;
        }
        return object;
    }

    @Override
    public Object peek() {
        if (this.nbElements != 0) {
            return this.head.getElement();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.nbElements == 0;
    }

    @Override
    public void clear() {
        this.tail = null;
        this.head = null;
        this.nbElements = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration elements() {
        Queue queue = this;
        synchronized (queue) {
            return new QueueEnumerator(this);
        }
    }

    public Object[] getElements() {
        Object[] objectArray = null;
        if (this.nbElements != 0) {
            objectArray = new Object[this.nbElements];
            int n = 0;
            for (LinkedElement linkedElement = this.tail; linkedElement != null; linkedElement = linkedElement.getNext()) {
                objectArray[n++] = linkedElement.getElement();
            }
        }
        return objectArray;
    }

    public String toString() {
        String string = "";
        for (LinkedElement linkedElement = this.tail; linkedElement != null; linkedElement = linkedElement.getNext()) {
            string = string + " " + linkedElement.toString();
        }
        return string + " ";
    }

    private class QueueEnumerator
    implements Enumeration,
    Serializable {
        Queue queue;
        LinkedElement next;

        public QueueEnumerator(Queue queue2) {
            this.queue = queue2;
            this.next = queue2.head;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Queue queue = this.queue;
            synchronized (queue) {
                if (this.next != null) {
                    Object object = this.next.getElement();
                    this.next = this.next.getPrevious();
                    return object;
                }
            }
            throw new NoSuchElementException("QueueEnumerator");
        }
    }
}

