/*
 * NodeBackground.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_BACKGROUND_H
#define _NODE_BACKGROUND_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoBackground : public Proto {
public:
                    ProtoBackground(Scene *scene);
    virtual Node   *create(Scene *scene);

    virtual int         getType() const { return VRML_BACKGROUND; }

    FieldIndex groundAngle;
    FieldIndex groundColor;
    FieldIndex frontUrl;
    FieldIndex rightUrl;
    FieldIndex backUrl;
    FieldIndex leftUrl;
    FieldIndex topUrl;
    FieldIndex bottomUrl;
    FieldIndex skyAngle;
    FieldIndex skyColor;
    FieldIndex transparency;
};


class NodeImageTexture;

class NodeBackground : public Node {
public:

                        NodeBackground(Scene *scene, Proto *proto);

    fieldMacros(MFFloat,  groundAngle,  ProtoBackground)
    fieldMacros(MFColor,  groundColor,  ProtoBackground)
    fieldMacros(MFString, frontUrl,     ProtoBackground)
    fieldMacros(MFString, rightUrl,     ProtoBackground)
    fieldMacros(MFString, backUrl,      ProtoBackground)
    fieldMacros(MFString, leftUrl,      ProtoBackground)
    fieldMacros(MFString, topUrl,       ProtoBackground)
    fieldMacros(MFString, bottomUrl,    ProtoBackground)
    fieldMacros(MFFloat,  skyAngle,     ProtoBackground)
    fieldMacros(MFColor,  skyColor,     ProtoBackground)
    fieldMacros(SFFloat,  transparency, ProtoBackground)

protected:
    virtual            ~NodeBackground();

public:
    virtual int         getProfile(void) const;
    virtual const char* getComponentName(void) const;
    virtual int         getComponentLevel(void) const;
    virtual Node       *copy() const { return new NodeBackground(*this); }
    virtual void        setField(int field, FieldValue *value);
    virtual void        preDraw();
    void                apply();
    int                 countPolygons(void);
    int                 countPolygons1Sided(void) { return countPolygons(); }
    void                drawBackgroundTextures();
    void                drawBackgroundSphere();
    void                drawSky(void);
    void                drawGround(void);
    void                drawQuad(float r, float va1, float va2, 
                                 float h1, float h2, const float *newColor);
    void                setColor(const float *newColor);
private:
    NodeImageTexture   *imageTextures[6];
};

#endif // _NODE_BACKGROUND_H
