#! /bin/bash

# compile all examples

for f in $@
do
  body=$(basename $f .cc)
  common_flags="-Ofast -std=c++11 -march=native -pthread"

  for compiler in clang++ g++
  do
  
#     echo compiling $body with:

    echo $compiler $common_flags -otv_${body}_$compiler $f -lvigraimpex
    $compiler $common_flags -otv_${body}_$compiler $f -lvigraimpex
    
    echo $compiler -DUSE_VC $common_flags -o${body}_$compiler $f -lVc -lvigraimpex
    $compiler -DUSE_VC $common_flags -o${body}_$compiler $f -lVc -lvigraimpex

  done

done
