/*   
 *   This is part of Remote System Call (RSC) Library.
 *
 *   rsc_consts.h: __RSC_* constants definition and management functions
 *   
 *   Copyright (C) 2007 Andrea Forni
 *   
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License, version 2, as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
 *
 */
#ifndef __RSC_CONSTS_HEADER__
#define __RSC_CONSTS_HEADER__
#include <stdlib.h>
#include "aconv.h"

/* A struct nr_and_sys that doesn't contain a .sys value has the .sys 
 * field equal to "NO_VALUE".
 * A empty struct nr_and_sys has the .nr field equal to "NO_VALUE",
 * the .sys field could have any value.
 */
#define NO_VALUE	(-1)
struct nr_and_sys {
	int32_t nr;
	int32_t sys;
};

/*########################################################################*/
/*##  __RSC_* CONSTANTS                                                 ##*/
/*########################################################################*/
enum rsc_constant {
	__RSC_ERROR = -1, /* Used when there isn't a valid __RSC_ constant */
	__RSC_FIRST = 0,
  __RSC__exit = __RSC_FIRST,
  __RSC__llseek,
  __RSC__newselect,
  __RSC__sysctl,
  __RSC_accept,
  __RSC_access,
  __RSC_acct,
  __RSC_add_key,
  __RSC_adjtimex,
  __RSC_afs_syscall,
  __RSC_alarm,
  __RSC_arch_prctl,
  __RSC_bdflush,
  __RSC_bind,
  __RSC_break,
  __RSC_brk,
  __RSC_capget,
  __RSC_capset,
  __RSC_chdir,
  __RSC_chmod,
  __RSC_chown,
  __RSC_chown32,
  __RSC_chroot,
  __RSC_clock_getres,
  __RSC_clock_gettime,
  __RSC_clock_nanosleep,
  __RSC_clock_settime,
  __RSC_clone,
  __RSC_close,
  __RSC_connect,
  __RSC_creat,
  __RSC_create_module,
  __RSC_delete_module,
  __RSC_dup,
  __RSC_dup2,
  __RSC_epoll_create,
  __RSC_epoll_ctl,
  __RSC_epoll_ctl_old,
  __RSC_epoll_wait,
  __RSC_epoll_wait_old,
  __RSC_execve,
  __RSC_exit,
  __RSC_exit_group,
  __RSC_fadvise64,
  __RSC_fadvise64_64,
  __RSC_fchdir,
  __RSC_fchmod,
  __RSC_fchown,
  __RSC_fchown32,
  __RSC_fcntl,
  __RSC_fcntl64,
  __RSC_fdatasync,
  __RSC_fgetxattr,
  __RSC_flistxattr,
  __RSC_flock,
  __RSC_fork,
  __RSC_fremovexattr,
  __RSC_fsetxattr,
  __RSC_fstat,
  __RSC_fstat64,
  __RSC_fstatfs,
  __RSC_fstatfs64,
  __RSC_fsync,
  __RSC_ftime,
  __RSC_ftruncate,
  __RSC_ftruncate64,
  __RSC_futex,
  __RSC_get_kernel_syms,
  __RSC_get_mempolicy,
  __RSC_get_thread_area,
  __RSC_getcwd,
  __RSC_getdents,
  __RSC_getdents64,
  __RSC_getegid,
  __RSC_getegid32,
  __RSC_geteuid,
  __RSC_geteuid32,
  __RSC_getgid,
  __RSC_getgid32,
  __RSC_getgroups,
  __RSC_getgroups32,
  __RSC_getitimer,
  __RSC_getpeername,
  __RSC_getpgid,
  __RSC_getpgrp,
  __RSC_getpid,
  __RSC_getpmsg,
  __RSC_getppid,
  __RSC_getpriority,
  __RSC_getresgid,
  __RSC_getresgid32,
  __RSC_getresuid,
  __RSC_getresuid32,
  __RSC_getrlimit,
  __RSC_getrusage,
  __RSC_getsid,
  __RSC_getsockname,
  __RSC_getsockopt,
  __RSC_gettid,
  __RSC_gettimeofday,
  __RSC_getuid,
  __RSC_getuid32,
  __RSC_getxattr,
  __RSC_gtty,
  __RSC_idle,
  __RSC_init_module,
  __RSC_io_cancel,
  __RSC_io_destroy,
  __RSC_io_getevents,
  __RSC_io_setup,
  __RSC_io_submit,
  __RSC_ioctl,
  __RSC_ioperm,
  __RSC_iopl,
  __RSC_ipc,
  __RSC_kexec_load,
  __RSC_keyctl,
  __RSC_kill,
  __RSC_lchown,
  __RSC_lchown32,
  __RSC_lgetxattr,
  __RSC_link,
  __RSC_listen,
  __RSC_listxattr,
  __RSC_llistxattr,
  __RSC_lock,
  __RSC_lookup_dcookie,
  __RSC_lremovexattr,
  __RSC_lseek,
  __RSC_lsetxattr,
  __RSC_lstat,
  __RSC_lstat64,
  __RSC_madvise,
  __RSC_madvise1,
  __RSC_mbind,
  __RSC_mincore,
  __RSC_mkdir,
  __RSC_mknod,
  __RSC_mlock,
  __RSC_mlockall,
  __RSC_mmap,
  __RSC_mmap2,
  __RSC_modify_ldt,
  __RSC_mount,
  __RSC_mprotect,
  __RSC_mpx,
  __RSC_mq_getsetattr,
  __RSC_mq_notify,
  __RSC_mq_open,
  __RSC_mq_timedreceive,
  __RSC_mq_timedsend,
  __RSC_mq_unlink,
  __RSC_mremap,
  __RSC_msgctl,
  __RSC_msgget,
  __RSC_msgrcv,
  __RSC_msgsnd,
  __RSC_msync,
  __RSC_multiplexer,
  __RSC_munlock,
  __RSC_munlockall,
  __RSC_munmap,
  __RSC_nanosleep,
  __RSC_nfsservctl,
  __RSC_nice,
  __RSC_oldfstat,
  __RSC_oldlstat,
  __RSC_oldolduname,
  __RSC_oldstat,
  __RSC_olduname,
  __RSC_open,
  __RSC_pause,
  __RSC_pciconfig_iobase,
  __RSC_pciconfig_read,
  __RSC_pciconfig_write,
  __RSC_personality,
  __RSC_pipe,
  __RSC_pivot_root,
  __RSC_poll,
  __RSC_prctl,
  __RSC_pread64,
  __RSC_prof,
  __RSC_profil,
  __RSC_ptrace,
  __RSC_putpmsg,
  __RSC_pwrite64,
  __RSC_query_module,
  __RSC_quotactl,
  __RSC_read,
  __RSC_readahead,
  __RSC_readdir,
  __RSC_readlink,
  __RSC_readv,
  __RSC_reboot,
  __RSC_recv,
  __RSC_recvfrom,
  __RSC_recvmsg,
  __RSC_remap_file_pages,
  __RSC_removexattr,
  __RSC_rename,
  __RSC_request_key,
  __RSC_restart_syscall,
  __RSC_rmdir,
  __RSC_rt_sigaction,
  __RSC_rt_sigpending,
  __RSC_rt_sigprocmask,
  __RSC_rt_sigqueueinfo,
  __RSC_rt_sigreturn,
  __RSC_rt_sigsuspend,
  __RSC_rt_sigtimedwait,
  __RSC_sched_get_priority_max,
  __RSC_sched_get_priority_min,
  __RSC_sched_getaffinity,
  __RSC_sched_getparam,
  __RSC_sched_getscheduler,
  __RSC_sched_rr_get_interval,
  __RSC_sched_setaffinity,
  __RSC_sched_setparam,
  __RSC_sched_setscheduler,
  __RSC_sched_yield,
  __RSC_security,
  __RSC_select,
  __RSC_semctl,
  __RSC_semget,
  __RSC_semop,
  __RSC_semtimedop,
  __RSC_send,
  __RSC_sendfile,
  __RSC_sendfile64,
  __RSC_sendmsg,
  __RSC_sendto,
  __RSC_set_mempolicy,
  __RSC_set_thread_area,
  __RSC_set_tid_address,
  __RSC_setdomainname,
  __RSC_setfsgid,
  __RSC_setfsgid32,
  __RSC_setfsuid,
  __RSC_setfsuid32,
  __RSC_setgid,
  __RSC_setgid32,
  __RSC_setgroups,
  __RSC_setgroups32,
  __RSC_sethostname,
  __RSC_setitimer,
  __RSC_setpgid,
  __RSC_setpriority,
  __RSC_setregid,
  __RSC_setregid32,
  __RSC_setresgid,
  __RSC_setresgid32,
  __RSC_setresuid,
  __RSC_setresuid32,
  __RSC_setreuid,
  __RSC_setreuid32,
  __RSC_setrlimit,
  __RSC_setsid,
  __RSC_setsockopt,
  __RSC_settimeofday,
  __RSC_setuid,
  __RSC_setuid32,
  __RSC_setxattr,
  __RSC_sgetmask,
  __RSC_shmat,
  __RSC_shmctl,
  __RSC_shmdt,
  __RSC_shmget,
  __RSC_shutdown,
  __RSC_sigaction,
  __RSC_sigaltstack,
  __RSC_signal,
  __RSC_sigpending,
  __RSC_sigprocmask,
  __RSC_sigreturn,
  __RSC_sigsuspend,
  __RSC_socket,
  __RSC_socketcall,
  __RSC_socketpair,
  __RSC_ssetmask,
  __RSC_stat,
  __RSC_stat64,
  __RSC_statfs,
  __RSC_statfs64,
  __RSC_stime,
  __RSC_stty,
  __RSC_swapcontext,
  __RSC_swapoff,
  __RSC_swapon,
  __RSC_symlink,
  __RSC_sync,
  __RSC_sys_kexec_load,
  __RSC_sysfs,
  __RSC_sysinfo,
  __RSC_syslog,
  __RSC_tgkill,
  __RSC_time,
  __RSC_timer_create,
  __RSC_timer_delete,
  __RSC_timer_getoverrun,
  __RSC_timer_gettime,
  __RSC_timer_settime,
  __RSC_times,
  __RSC_tkill,
  __RSC_truncate,
  __RSC_truncate64,
  __RSC_tuxcall,
  __RSC_ugetrlimit,
  __RSC_ulimit,
  __RSC_umask,
  __RSC_umount,
  __RSC_umount2,
  __RSC_uname,
  __RSC_unlink,
  __RSC_uselib,
  __RSC_ustat,
  __RSC_utime,
  __RSC_utimes,
  __RSC_vfork,
  __RSC_vhangup,
  __RSC_vm86,
  __RSC_vm86old,
  __RSC_vserver,
  __RSC_wait4,
  __RSC_waitid,
  __RSC_waitpid,
  __RSC_write,
  __RSC_writev,
	__RSC_LAST = __RSC_writev
};

/*  From __RSC_* to __NR_* constants and vice versa                        */
struct nr_and_sys *rsc2nr(enum rsc_constant rsc_const, enum arch arch);
enum rsc_constant nr2rsc(int32_t nr_const, int32_t sys, enum arch arch);

/*########################################################################*/
/*##  CONSTANTS to STRINGS                                              ##*/
/*########################################################################*/

/* Strings returned when is required a string for a __RSC_* or __NR_*
 * constant that doesn't exist.
 */
extern char *rsc_not_existing;
extern char *nr_not_existing;
extern char *rsc_to_str[];

/*  The following tables are used to convert to string a __NR_* or
 *  __RSC_* constant.        
 */

#define X86_TO_STR_SIZE 289 

extern char * x86_to_str[];

#define X86_64_TO_STR_SIZE 251 

extern char * x86_64_to_str[];

#define PPC_TO_STR_SIZE 255 

extern char * ppc_to_str[];

/* SYS_ values are equal in each architecture, so a single table is
 * sufficient.
 */
#define SYS_TO_STR_SIZE 18
extern char *sys_to_str[];

#endif /* __RSC_CONSTANT_HEADER__ */
