-------------------------------------------------------------------------------
--
-- File: PkgMgCpld.vhd
-- Author: Autogenerated by XmlParse
-- Original Project: --
-- Date: --
--
-------------------------------------------------------------------------------
-- Copyright 2016-2017 Ettus Research, A National Instruments Company
-- SPDX-License-Identifier: GPL-3.0
-------------------------------------------------------------------------------
--
-- Purpose:
--   The constants in this file are autogenerated by XmlParse and should
-- be used by testbench code to access specific register fields.
--
-------------------------------------------------------------------------------

library ieee;
  use ieee.std_logic_1164.all;
  use ieee.numeric_std.all;

package PkgMgCpld is

--===============================================================================
-- A numerically ordered list of registers and their VHDL source files
--===============================================================================

  -- SignatureReg   : 0x0 (TopCpld.vhd)
  -- MinorRevReg    : 0x1 (TopCpld.vhd)
  -- MajorRevReg    : 0x2 (TopCpld.vhd)
  -- BuildCodeLSB   : 0x3 (TopCpld.vhd)
  -- BuildCodeMSB   : 0x4 (TopCpld.vhd)
  -- Scratch        : 0x5 (TopCpld.vhd)
  -- CpldControl    : 0x10 (TopCpld.vhd)
  -- LmkControl     : 0x11 (TopCpld.vhd)
  -- LoStatus       : 0x12 (TopCpld.vhd)
  -- MykonosControl : 0x13 (TopCpld.vhd)
  -- PlScratch      : 0x40 (TopCpld.vhd)
  -- PlCpldControl  : 0x41 (TopCpld.vhd)
  -- TxCh1_Idle     : 0x50 (TopCpld.vhd)
  -- RxCh1_0_Idle   : 0x51 (TopCpld.vhd)
  -- RxCh1_1_Idle   : 0x52 (TopCpld.vhd)
  -- TxCh1_TxOn     : 0x53 (TopCpld.vhd)
  -- RxCh1_0_RxOn   : 0x54 (TopCpld.vhd)
  -- RxCh1_1_RxOn   : 0x55 (TopCpld.vhd)
  -- TxCh2_Idle     : 0x60 (TopCpld.vhd)
  -- RxCh2_0_Idle   : 0x61 (TopCpld.vhd)
  -- RxCh2_1_Idle   : 0x62 (TopCpld.vhd)
  -- TxCh2_TxOn     : 0x63 (TopCpld.vhd)
  -- RxCh2_0_RxOn   : 0x64 (TopCpld.vhd)
  -- RxCh2_1_RxOn   : 0x65 (TopCpld.vhd)

--===============================================================================
-- RegTypes
--===============================================================================

--===============================================================================
-- Register Group PsSpi_CpldRegisters
--===============================================================================

  -- SignatureReg Register (from TopCpld.vhd)
  constant kSignatureReg : integer := 16#0#; -- Register Offset
  constant kSignatureRegSize: integer := 16;  -- register width in bits
  constant kSignatureRegMask : std_logic_vector(15 downto 0) := X"ffff";
  constant kProductSignatureSize       : integer := 16;  --SignatureReg:ProductSignature
  constant kProductSignatureMsb        : integer := 15;  --SignatureReg:ProductSignature
  constant kProductSignature           : integer :=  0;  --SignatureReg:ProductSignature

  -- MinorRevReg Register (from TopCpld.vhd)
  constant kMinorRevReg : integer := 16#1#; -- Register Offset
  constant kMinorRevRegSize: integer := 16;  -- register width in bits
  constant kMinorRevRegMask : std_logic_vector(15 downto 0) := X"ffff";
  constant kCpldMinorRevisionSize       : integer := 16;  --MinorRevReg:CpldMinorRevision
  constant kCpldMinorRevisionMsb        : integer := 15;  --MinorRevReg:CpldMinorRevision
  constant kCpldMinorRevision           : integer :=  0;  --MinorRevReg:CpldMinorRevision

  -- MajorRevReg Register (from TopCpld.vhd)
  constant kMajorRevReg : integer := 16#2#; -- Register Offset
  constant kMajorRevRegSize: integer := 16;  -- register width in bits
  constant kMajorRevRegMask : std_logic_vector(15 downto 0) := X"ffff";
  constant kCpldMajorRevisionSize       : integer := 16;  --MajorRevReg:CpldMajorRevision
  constant kCpldMajorRevisionMsb        : integer := 15;  --MajorRevReg:CpldMajorRevision
  constant kCpldMajorRevision           : integer :=  0;  --MajorRevReg:CpldMajorRevision

  -- BuildCodeLSB Register (from TopCpld.vhd)
  constant kBuildCodeLSB : integer := 16#3#; -- Register Offset
  constant kBuildCodeLSBSize: integer := 16;  -- register width in bits
  constant kBuildCodeLSBMask : std_logic_vector(15 downto 0) := X"ffff";
  constant kBuildCodeHHSize       : integer := 8;  --BuildCodeLSB:BuildCodeHH
  constant kBuildCodeHHMsb        : integer := 7;  --BuildCodeLSB:BuildCodeHH
  constant kBuildCodeHH           : integer := 0;  --BuildCodeLSB:BuildCodeHH
  constant kBuildCodeDDSize       : integer :=  8;  --BuildCodeLSB:BuildCodeDD
  constant kBuildCodeDDMsb        : integer := 15;  --BuildCodeLSB:BuildCodeDD
  constant kBuildCodeDD           : integer :=  8;  --BuildCodeLSB:BuildCodeDD

  -- BuildCodeMSB Register (from TopCpld.vhd)
  constant kBuildCodeMSB : integer := 16#4#; -- Register Offset
  constant kBuildCodeMSBSize: integer := 16;  -- register width in bits
  constant kBuildCodeMSBMask : std_logic_vector(15 downto 0) := X"ffff";
  constant kBuildCodeMMSize       : integer := 8;  --BuildCodeMSB:BuildCodeMM
  constant kBuildCodeMMMsb        : integer := 7;  --BuildCodeMSB:BuildCodeMM
  constant kBuildCodeMM           : integer := 0;  --BuildCodeMSB:BuildCodeMM
  constant kBuildCodeYYSize       : integer :=  8;  --BuildCodeMSB:BuildCodeYY
  constant kBuildCodeYYMsb        : integer := 15;  --BuildCodeMSB:BuildCodeYY
  constant kBuildCodeYY           : integer :=  8;  --BuildCodeMSB:BuildCodeYY

  -- Scratch Register (from TopCpld.vhd)
  constant kScratch : integer := 16#5#; -- Register Offset
  constant kScratchSize: integer := 16;  -- register width in bits
  constant kScratchMask : std_logic_vector(15 downto 0) := X"ffff";
  constant kScratchValSize       : integer := 16;  --Scratch:ScratchVal
  constant kScratchValMsb        : integer := 15;  --Scratch:ScratchVal
  constant kScratchVal           : integer :=  0;  --Scratch:ScratchVal

  -- CpldControl Register (from TopCpld.vhd)
  constant kCpldControl : integer := 16#10#; -- Register Offset
  constant kCpldControlSize: integer := 16;  -- register width in bits
  constant kCpldControlMask : std_logic_vector(15 downto 0) := X"0001";
  constant kCpldResetSize       : integer := 1;  --CpldControl:CpldReset
  constant kCpldResetMsb        : integer := 0;  --CpldControl:CpldReset
  constant kCpldReset           : integer := 0;  --CpldControl:CpldReset

  -- LmkControl Register (from TopCpld.vhd)
  constant kLmkControl : integer := 16#11#; -- Register Offset
  constant kLmkControlSize: integer := 16;  -- register width in bits
  constant kLmkControlMask : std_logic_vector(15 downto 0) := X"0010";
  constant kVcxoControlSize       : integer := 1;  --LmkControl:VcxoControl
  constant kVcxoControlMsb        : integer := 4;  --LmkControl:VcxoControl
  constant kVcxoControl           : integer := 4;  --LmkControl:VcxoControl

  -- LoStatus Register (from TopCpld.vhd)
  constant kLoStatus : integer := 16#12#; -- Register Offset
  constant kLoStatusSize: integer := 16;  -- register width in bits
  constant kLoStatusMask : std_logic_vector(15 downto 0) := X"0011";
  constant kRxLoLockDetectSize       : integer := 1;  --LoStatus:RxLoLockDetect
  constant kRxLoLockDetectMsb        : integer := 0;  --LoStatus:RxLoLockDetect
  constant kRxLoLockDetect           : integer := 0;  --LoStatus:RxLoLockDetect
  constant kTxLoLockDetectSize       : integer := 1;  --LoStatus:TxLoLockDetect
  constant kTxLoLockDetectMsb        : integer := 4;  --LoStatus:TxLoLockDetect
  constant kTxLoLockDetect           : integer := 4;  --LoStatus:TxLoLockDetect

  -- MykonosControl Register (from TopCpld.vhd)
  constant kMykonosControl : integer := 16#13#; -- Register Offset
  constant kMykonosControlSize: integer := 16;  -- register width in bits
  constant kMykonosControlMask : std_logic_vector(15 downto 0) := X"0001";
  constant kMykonosResetSize       : integer := 1;  --MykonosControl:MykonosReset
  constant kMykonosResetMsb        : integer := 0;  --MykonosControl:MykonosReset
  constant kMykonosReset           : integer := 0;  --MykonosControl:MykonosReset

--===============================================================================
-- Register Group PlSpi_FrontEndControl
--===============================================================================

  -- Enumerated type Rx1Switch1
  constant kRx1Switch1Size : integer := 4;
  constant kTxRxInput       : integer := 0;  -- Rx1Switch1:TxRxInput
  constant kRxLoCalInput    : integer := 1;  -- Rx1Switch1:RxLoCalInput
  constant kTrxSwitchOutput : integer := 2;  -- Rx1Switch1:TrxSwitchOutput
  constant kRx2Input        : integer := 3;  -- Rx1Switch1:Rx2Input

  -- Enumerated type Rx1Switch2
  constant kRx1Switch2Size : integer := 4;
  constant kShutdownSw2              : integer := 0;  -- Rx1Switch2:ShutdownSw2
  constant kLowerFilterBankToSwitch3 : integer := 1;  -- Rx1Switch2:LowerFilterBankToSwitch3
  constant kBypassPathToSwitch6      : integer := 2;  -- Rx1Switch2:BypassPathToSwitch6
  constant kUpperFilterBankToSwitch4 : integer := 3;  -- Rx1Switch2:UpperFilterBankToSwitch4

  -- Enumerated type Rx1Switch3
  constant kRx1Switch3Size : integer := 7;
  constant kFilter2100x2850MHz : integer := 0;  -- Rx1Switch3:Filter2100x2850MHz
  constant kFilter0490LpMHz    : integer := 1;  -- Rx1Switch3:Filter0490LpMHz
  constant kFilter1600x2250MHz : integer := 2;  -- Rx1Switch3:Filter1600x2250MHz
  constant kFilter0440x0530MHz : integer := 4;  -- Rx1Switch3:Filter0440x0530MHz
  constant kFilter0650x1000MHz : integer := 5;  -- Rx1Switch3:Filter0650x1000MHz
  constant kFilter1100x1575MHz : integer := 6;  -- Rx1Switch3:Filter1100x1575MHz
  constant kShutdownSw3        : integer := 7;  -- Rx1Switch3:ShutdownSw3

  -- Enumerated type Rx1Switch4
  constant kRx1Switch4Size : integer := 3;
  constant kFilter2100x2850MHzFrom : integer := 1;  -- Rx1Switch4:Filter2100x2850MHzFrom
  constant kFilter1600x2250MHzFrom : integer := 2;  -- Rx1Switch4:Filter1600x2250MHzFrom
  constant kFilter2700HpMHz        : integer := 4;  -- Rx1Switch4:Filter2700HpMHz

  -- Enumerated type Rx1Switch5
  constant kRx1Switch5Size : integer := 4;
  constant kFilter0440x0530MHzFrom : integer := 1;  -- Rx1Switch5:Filter0440x0530MHzFrom
  constant kFilter1100x1575MHzFrom : integer := 2;  -- Rx1Switch5:Filter1100x1575MHzFrom
  constant kFilter0490LpMHzFrom    : integer := 4;  -- Rx1Switch5:Filter0490LpMHzFrom
  constant kFilter0650x1000MHzFrom : integer := 8;  -- Rx1Switch5:Filter0650x1000MHzFrom

  -- Enumerated type Rx1Switch6
  constant kRx1Switch6Size : integer := 3;
  constant kLowerFilterBankFromSwitch5 : integer := 1;  -- Rx1Switch6:LowerFilterBankFromSwitch5
  constant kUpperFilterBankFromSwitch4 : integer := 2;  -- Rx1Switch6:UpperFilterBankFromSwitch4
  constant kBypassPathFromSwitch2      : integer := 4;  -- Rx1Switch6:BypassPathFromSwitch2

  -- Enumerated type TrxSwitch
  constant kTrxSwitchSize : integer := 4;
  constant kFromLowerFilterBankTxSw1       : integer := 0;  -- TrxSwitch:FromLowerFilterBankTxSw1
  constant kFromTxUpperFilterBankLp6400MHz : integer := 1;  -- TrxSwitch:FromTxUpperFilterBankLp6400MHz
  constant kRxChannelPath                  : integer := 2;  -- TrxSwitch:RxChannelPath
  constant kBypassPathToTxSw3              : integer := 3;  -- TrxSwitch:BypassPathToTxSw3

  -- Enumerated type TxSwitch1
  constant kTxSwitch1Size : integer := 4;
  constant kShutdownTxSw1         : integer := 0;  -- TxSwitch1:ShutdownTxSw1
  constant kFromTxFilterLp1700MHz : integer := 1;  -- TxSwitch1:FromTxFilterLp1700MHz
  constant kFromTxFilterLp3400MHz : integer := 2;  -- TxSwitch1:FromTxFilterLp3400MHz
  constant kFromTxFilterLp0800MHz : integer := 3;  -- TxSwitch1:FromTxFilterLp0800MHz

  -- Enumerated type TxSwitch2
  constant kTxSwitch2Size : integer := 4;
  constant kToTxFilterLp3400MHz : integer := 1;  -- TxSwitch2:ToTxFilterLp3400MHz
  constant kToTxFilterLp1700MHz : integer := 2;  -- TxSwitch2:ToTxFilterLp1700MHz
  constant kToTxFilterLp0800MHz : integer := 4;  -- TxSwitch2:ToTxFilterLp0800MHz
  constant kToTxFilterLp6400MHz : integer := 8;  -- TxSwitch2:ToTxFilterLp6400MHz

  -- Enumerated type TxSwitch3
  constant kTxSwitch3Size : integer := 2;
  constant kToTxFilterBanks   : integer := 0;  -- TxSwitch3:ToTxFilterBanks
  constant kBypassPathToTrxSw : integer := 1;  -- TxSwitch3:BypassPathToTrxSw

  -- PlScratch Register (from TopCpld.vhd)
  constant kPlScratch : integer := 16#40#; -- Register Offset
  constant kPlScratchSize: integer := 16;  -- register width in bits
  constant kPlScratchMask : std_logic_vector(15 downto 0) := X"ffff";
  constant kPlScratchValSize       : integer := 16;  --PlScratch:PlScratchVal
  constant kPlScratchValMsb        : integer := 15;  --PlScratch:PlScratchVal
  constant kPlScratchVal           : integer :=  0;  --PlScratch:PlScratchVal

  -- PlCpldControl Register (from TopCpld.vhd)
  constant kPlCpldControl : integer := 16#41#; -- Register Offset
  constant kPlCpldControlSize: integer := 16;  -- register width in bits
  constant kPlCpldControlMask : std_logic_vector(15 downto 0) := X"0001";
  constant kPlCpldResetSize       : integer := 1;  --PlCpldControl:PlCpldReset
  constant kPlCpldResetMsb        : integer := 0;  --PlCpldControl:PlCpldReset
  constant kPlCpldReset           : integer := 0;  --PlCpldControl:PlCpldReset

  -- TxCh1_Idle Register (from TopCpld.vhd)
  constant kTxCh1_Idle : integer := 16#50#; -- Register Offset
  constant kTxCh1_IdleSize: integer := 16;  -- register width in bits
  constant kTxCh1_IdleMask : std_logic_vector(15 downto 0) := X"7fff";
  constant kCh1TxSw1Size       : integer := 2;  --TxCh1_Idle:Ch1TxSw1
  constant kCh1TxSw1Msb        : integer := 1;  --TxCh1_Idle:Ch1TxSw1
  constant kCh1TxSw1           : integer := 0;  --TxCh1_Idle:Ch1TxSw1
  constant kCh1TxSw2Size       : integer := 4;  --TxCh1_Idle:Ch1TxSw2
  constant kCh1TxSw2Msb        : integer := 5;  --TxCh1_Idle:Ch1TxSw2
  constant kCh1TxSw2           : integer := 2;  --TxCh1_Idle:Ch1TxSw2
  constant kCh1TxSw3Size       : integer := 1;  --TxCh1_Idle:Ch1TxSw3
  constant kCh1TxSw3Msb        : integer := 6;  --TxCh1_Idle:Ch1TxSw3
  constant kCh1TxSw3           : integer := 6;  --TxCh1_Idle:Ch1TxSw3
  constant kCh1TxLowbandMixerPathSelectSize       : integer := 1;  --TxCh1_Idle:Ch1TxLowbandMixerPathSelect
  constant kCh1TxLowbandMixerPathSelectMsb        : integer := 7;  --TxCh1_Idle:Ch1TxLowbandMixerPathSelect
  constant kCh1TxLowbandMixerPathSelect           : integer := 7;  --TxCh1_Idle:Ch1TxLowbandMixerPathSelect
  constant kCh1TxMixerEnSize       : integer := 1;  --TxCh1_Idle:Ch1TxMixerEn
  constant kCh1TxMixerEnMsb        : integer := 8;  --TxCh1_Idle:Ch1TxMixerEn
  constant kCh1TxMixerEn           : integer := 8;  --TxCh1_Idle:Ch1TxMixerEn
  constant kCh1TxAmpEnSize       : integer := 1;  --TxCh1_Idle:Ch1TxAmpEn
  constant kCh1TxAmpEnMsb        : integer := 9;  --TxCh1_Idle:Ch1TxAmpEn
  constant kCh1TxAmpEn           : integer := 9;  --TxCh1_Idle:Ch1TxAmpEn
  constant kCh1TxPaEnSize       : integer :=  1;  --TxCh1_Idle:Ch1TxPaEn
  constant kCh1TxPaEnMsb        : integer := 10;  --TxCh1_Idle:Ch1TxPaEn
  constant kCh1TxPaEn           : integer := 10;  --TxCh1_Idle:Ch1TxPaEn
  constant kCh1SwTrxSize       : integer :=  2;  --TxCh1_Idle:Ch1SwTrx
  constant kCh1SwTrxMsb        : integer := 12;  --TxCh1_Idle:Ch1SwTrx
  constant kCh1SwTrx           : integer := 11;  --TxCh1_Idle:Ch1SwTrx
  constant kCh1TxLedSize       : integer :=  1;  --TxCh1_Idle:Ch1TxLed
  constant kCh1TxLedMsb        : integer := 13;  --TxCh1_Idle:Ch1TxLed
  constant kCh1TxLed           : integer := 13;  --TxCh1_Idle:Ch1TxLed
  constant kCh1MykEnTxSize       : integer :=  1;  --TxCh1_Idle:Ch1MykEnTx
  constant kCh1MykEnTxMsb        : integer := 14;  --TxCh1_Idle:Ch1MykEnTx
  constant kCh1MykEnTx           : integer := 14;  --TxCh1_Idle:Ch1MykEnTx

  -- RxCh1_0_Idle Register (from TopCpld.vhd)
  constant kRxCh1_0_Idle : integer := 16#51#; -- Register Offset
  constant kRxCh1_0_IdleSize: integer := 16;  -- register width in bits
  constant kRxCh1_0_IdleMask : std_logic_vector(15 downto 0) := X"3fff";
  constant kCh1RxSw1Size       : integer := 2;  --RxCh1_0_Idle:Ch1RxSw1
  constant kCh1RxSw1Msb        : integer := 1;  --RxCh1_0_Idle:Ch1RxSw1
  constant kCh1RxSw1           : integer := 0;  --RxCh1_0_Idle:Ch1RxSw1
  constant kCh1RxSw2Size       : integer := 2;  --RxCh1_0_Idle:Ch1RxSw2
  constant kCh1RxSw2Msb        : integer := 3;  --RxCh1_0_Idle:Ch1RxSw2
  constant kCh1RxSw2           : integer := 2;  --RxCh1_0_Idle:Ch1RxSw2
  constant kCh1RxSw3Size       : integer := 3;  --RxCh1_0_Idle:Ch1RxSw3
  constant kCh1RxSw3Msb        : integer := 6;  --RxCh1_0_Idle:Ch1RxSw3
  constant kCh1RxSw3           : integer := 4;  --RxCh1_0_Idle:Ch1RxSw3
  constant kCh1RxSw4Size       : integer := 3;  --RxCh1_0_Idle:Ch1RxSw4
  constant kCh1RxSw4Msb        : integer := 9;  --RxCh1_0_Idle:Ch1RxSw4
  constant kCh1RxSw4           : integer := 7;  --RxCh1_0_Idle:Ch1RxSw4
  constant kCh1RxSw5Size       : integer :=  4;  --RxCh1_0_Idle:Ch1RxSw5
  constant kCh1RxSw5Msb        : integer := 13;  --RxCh1_0_Idle:Ch1RxSw5
  constant kCh1RxSw5           : integer := 10;  --RxCh1_0_Idle:Ch1RxSw5

  -- RxCh1_1_Idle Register (from TopCpld.vhd)
  constant kRxCh1_1_Idle : integer := 16#52#; -- Register Offset
  constant kRxCh1_1_IdleSize: integer := 16;  -- register width in bits
  constant kRxCh1_1_IdleMask : std_logic_vector(15 downto 0) := X"07ff";
  constant kCh1RxSw6Size       : integer := 3;  --RxCh1_1_Idle:Ch1RxSw6
  constant kCh1RxSw6Msb        : integer := 2;  --RxCh1_1_Idle:Ch1RxSw6
  constant kCh1RxSw6           : integer := 0;  --RxCh1_1_Idle:Ch1RxSw6
  constant kCh1RxLowbandMixerPathSelectSize       : integer := 1;  --RxCh1_1_Idle:Ch1RxLowbandMixerPathSelect
  constant kCh1RxLowbandMixerPathSelectMsb        : integer := 3;  --RxCh1_1_Idle:Ch1RxLowbandMixerPathSelect
  constant kCh1RxLowbandMixerPathSelect           : integer := 3;  --RxCh1_1_Idle:Ch1RxLowbandMixerPathSelect
  constant kCh1RxMixerEnSize       : integer := 1;  --RxCh1_1_Idle:Ch1RxMixerEn
  constant kCh1RxMixerEnMsb        : integer := 4;  --RxCh1_1_Idle:Ch1RxMixerEn
  constant kCh1RxMixerEn           : integer := 4;  --RxCh1_1_Idle:Ch1RxMixerEn
  constant kCh1RxAmpEnSize       : integer := 1;  --RxCh1_1_Idle:Ch1RxAmpEn
  constant kCh1RxAmpEnMsb        : integer := 5;  --RxCh1_1_Idle:Ch1RxAmpEn
  constant kCh1RxAmpEn           : integer := 5;  --RxCh1_1_Idle:Ch1RxAmpEn
  constant kCh1RxLna1EnSize       : integer := 1;  --RxCh1_1_Idle:Ch1RxLna1En
  constant kCh1RxLna1EnMsb        : integer := 6;  --RxCh1_1_Idle:Ch1RxLna1En
  constant kCh1RxLna1En           : integer := 6;  --RxCh1_1_Idle:Ch1RxLna1En
  constant kCh1RxLna2EnSize       : integer := 1;  --RxCh1_1_Idle:Ch1RxLna2En
  constant kCh1RxLna2EnMsb        : integer := 7;  --RxCh1_1_Idle:Ch1RxLna2En
  constant kCh1RxLna2En           : integer := 7;  --RxCh1_1_Idle:Ch1RxLna2En
  constant kCh1Rx2LedSize       : integer := 1;  --RxCh1_1_Idle:Ch1Rx2Led
  constant kCh1Rx2LedMsb        : integer := 8;  --RxCh1_1_Idle:Ch1Rx2Led
  constant kCh1Rx2Led           : integer := 8;  --RxCh1_1_Idle:Ch1Rx2Led
  constant kCh1RxLedSize       : integer := 1;  --RxCh1_1_Idle:Ch1RxLed
  constant kCh1RxLedMsb        : integer := 9;  --RxCh1_1_Idle:Ch1RxLed
  constant kCh1RxLed           : integer := 9;  --RxCh1_1_Idle:Ch1RxLed
  constant kCh1MykEnRxSize       : integer :=  1;  --RxCh1_1_Idle:Ch1MykEnRx
  constant kCh1MykEnRxMsb        : integer := 10;  --RxCh1_1_Idle:Ch1MykEnRx
  constant kCh1MykEnRx           : integer := 10;  --RxCh1_1_Idle:Ch1MykEnRx

  -- TxCh1_TxOn Register (from TopCpld.vhd)
  constant kTxCh1_TxOn : integer := 16#53#; -- Register Offset
  constant kTxCh1_TxOnSize: integer := 16;  -- register width in bits
  constant kTxCh1_TxOnMask : std_logic_vector(15 downto 0) := X"0000";

  -- RxCh1_0_RxOn Register (from TopCpld.vhd)
  constant kRxCh1_0_RxOn : integer := 16#54#; -- Register Offset
  constant kRxCh1_0_RxOnSize: integer := 16;  -- register width in bits
  constant kRxCh1_0_RxOnMask : std_logic_vector(15 downto 0) := X"0000";

  -- RxCh1_1_RxOn Register (from TopCpld.vhd)
  constant kRxCh1_1_RxOn : integer := 16#55#; -- Register Offset
  constant kRxCh1_1_RxOnSize: integer := 16;  -- register width in bits
  constant kRxCh1_1_RxOnMask : std_logic_vector(15 downto 0) := X"0000";

  -- TxCh2_Idle Register (from TopCpld.vhd)
  constant kTxCh2_Idle : integer := 16#60#; -- Register Offset
  constant kTxCh2_IdleSize: integer := 16;  -- register width in bits
  constant kTxCh2_IdleMask : std_logic_vector(15 downto 0) := X"0000";

  -- RxCh2_0_Idle Register (from TopCpld.vhd)
  constant kRxCh2_0_Idle : integer := 16#61#; -- Register Offset
  constant kRxCh2_0_IdleSize: integer := 16;  -- register width in bits
  constant kRxCh2_0_IdleMask : std_logic_vector(15 downto 0) := X"0000";

  -- RxCh2_1_Idle Register (from TopCpld.vhd)
  constant kRxCh2_1_Idle : integer := 16#62#; -- Register Offset
  constant kRxCh2_1_IdleSize: integer := 16;  -- register width in bits
  constant kRxCh2_1_IdleMask : std_logic_vector(15 downto 0) := X"0000";

  -- TxCh2_TxOn Register (from TopCpld.vhd)
  constant kTxCh2_TxOn : integer := 16#63#; -- Register Offset
  constant kTxCh2_TxOnSize: integer := 16;  -- register width in bits
  constant kTxCh2_TxOnMask : std_logic_vector(15 downto 0) := X"0000";

  -- RxCh2_0_RxOn Register (from TopCpld.vhd)
  constant kRxCh2_0_RxOn : integer := 16#64#; -- Register Offset
  constant kRxCh2_0_RxOnSize: integer := 16;  -- register width in bits
  constant kRxCh2_0_RxOnMask : std_logic_vector(15 downto 0) := X"0000";

  -- RxCh2_1_RxOn Register (from TopCpld.vhd)
  constant kRxCh2_1_RxOn : integer := 16#65#; -- Register Offset
  constant kRxCh2_1_RxOnSize: integer := 16;  -- register width in bits
  constant kRxCh2_1_RxOnMask : std_logic_vector(15 downto 0) := X"0000";

end package;

package body PkgMgCpld is

  -- function kSignatureRegRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kMinorRevRegRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kMajorRevRegRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kBuildCodeLSBRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kBuildCodeMSBRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kScratchRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kCpldControlRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kLmkControlRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kLoStatusRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kMykonosControlRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kPlScratchRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kPlCpldControlRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kTxCh1_IdleRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kRxCh1_0_IdleRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kRxCh1_1_IdleRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kTxCh1_TxOnRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kRxCh1_0_RxOnRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kRxCh1_1_RxOnRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kTxCh2_IdleRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kRxCh2_0_IdleRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kRxCh2_1_IdleRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kTxCh2_TxOnRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kRxCh2_0_RxOnRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kRxCh2_1_RxOnRec not implemented because PkgXReg in this project does not support XReg2_t.

end package body;
