2020-09-21 Triage Log

This was the first week of semi-automated perf triage, and thank goodness:
There was a lot going on. Most regressions are either quite small or already
have a fix published.

[#72412](https://github.com/rust-lang/rust/issues/72412) is probably the most
interesting case. It fixes a pathological problem involving nested closures by
adding cycle detection to what seems to be a relatively hot part of the code.
As a result, most users will see a slight [compile-time
regression](https://perf.rust-lang.org/compare.html?start=2c69266c0697b0c0b34abea62cba1a1d3c59c90c&end=fdc3405c20122fd0f077f5a77addabc873f20e4c&stat=task-clock)
for their crates.

Triage done by **@ecstaticmorse**.
Revision range: [dbb73f8f79ab176a897d5a95e696adb71b957cbe..b01326ab033e41986d4a5c8b96ce4f40f3b38e30](https://perf.rust-lang.org/?start=dbb73f8f79ab176a897d5a95e696adb71b957cbe&end=b01326ab033e41986d4a5c8b96ce4f40f3b38e30&absolute=false&stat=instructions%3Au)

2 Regressions, 5 Improvements, 4 Mixed,
1 of them in rollups

#### Regressions

[#76575](https://github.com/rust-lang/rust/issues/76575) compare generic constants using `AbstractConst`s
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=fdc3405c20122fd0f077f5a77addabc873f20e4c&end=9f8ac718f44e280edb1a7b3266f2c26106ec11a0&stat=instructions:u)
 (up to 2.4% on `full` builds of `inflate-check`)

[#74040](https://github.com/rust-lang/rust/issues/74040) fix unification of const variables
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=956e06c6c85e918524b67503c4d65c7baf539585&end=e0bf356f9e5f6a8cca1eb656e900ffba79340fa1&stat=instructions:u)
  (up to 3.3% on `incr-full` builds of `coercions-debug`)

#### Improvements

[#76656](https://github.com/rust-lang/rust/issues/76656) Don't query stability data when `staged_api` is off
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f9a322a6fdd1e12fbe30441feaa4402e23efe303&end=1eb00abf35b9bb59825edf81d05c2fa2f17cefca&stat=instructions:u)
  (up to -1.5% on `incr-unchanged` builds of `many-assoc-items-check`)

[#76311](https://github.com/rust-lang/rust/issues/76311) Split `core::slice` to smaller mods
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=90b1f5ae59291dd69d72fad41a22277df19dc953&end=4c1966f97e192d6282be935baa163fb58f9b8b27&stat=instructions:u)
  (up to -1.9% on `full` builds of `html5ever-opt`)
- Very odd, since this just split up a file.

[#76880](https://github.com/rust-lang/rust/issues/76880) Update cc crate to 1.0.60 to understand aarch64-apple-darwin with clang
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8e9d5db8392c44a2e94008168fa3506ecddaa357&end=b3aae050cd7e0c9a9eb6085bd49b02f67dc1396f&stat=instructions:u)
(up to -1.0% on `incr-patched: Compiler new` builds of `regex-opt`)

[#76975](https://github.com/rust-lang/rust/issues/76975) Rollup of 15 pull requests
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b873fa6d42cf305131d2583d03b84686e5e40f2e&end=81e02708f1f4760244756548981277d5199baa9a&stat=instructions:u)
on exactly `encoding-check` (-2.0% on `incr-full` builds)

[#76680](https://github.com/rust-lang/rust/issues/76680) Make `ensure_sufficient_stack()` non-generic, using cargo-llvm-lines
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4eff9b0b29a8898c839d46f3c66526710afed68a&end=b01326ab033e41986d4a5c8b96ce4f40f3b38e30&stat=instructions:u)
(up to -3.2% on `incr-full` builds of `coercions-debug`)

#### Mixed

[#76244](https://github.com/rust-lang/rust/issues/76244) Removing the `def_id` field from hot `ParamEnv` to make it smaller
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a055c5a1bd95e029e9b31891db63b6dc8258b472&end=7402a394471a6738a40fea7d4f1891666e5a80c5&stat=instructions:u)
  (up to 3.3% on `full` builds of `unicode_normalization-check`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a055c5a1bd95e029e9b31891db63b6dc8258b472&end=7402a394471a6738a40fea7d4f1891666e5a80c5&stat=instructions:u)
  (up to -1.8% on `full` builds of `ctfe-stress-4-check`)
- A fix has been published as [#76913](https://github.com/rust-lang/rust/pull/76913).

[#72412](https://github.com/rust-lang/rust/issues/72412) Issue 72408 nested closures exponential
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2c69266c0697b0c0b34abea62cba1a1d3c59c90c&end=fdc3405c20122fd0f077f5a77addabc873f20e4c&stat=instructions:u)
  (up to -99.9% on `incr-unchanged` builds of `deeply-nested-closures-opt`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2c69266c0697b0c0b34abea62cba1a1d3c59c90c&end=fdc3405c20122fd0f077f5a77addabc873f20e4c&stat=instructions:u)
  (up to 1.5% on `full` builds of `coercions-check`)
- Fixes a pathological case, but slows down normal builds slightly.
- Might be worth investigating to see if we can do better, although the author seems to have done a pretty thorough job.

[#74949](https://github.com/rust-lang/rust/issues/74949) Validate constants during `const_eval_raw`
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=10b3595ba6a4c658c9dea105488fc562c815e434&end=5e449b9adff463455743291b0c1f76feec092992&stat=instructions:u)
  (up to 515.8% on `incr-unchanged` builds of `ctfe-stress-4-check`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=10b3595ba6a4c658c9dea105488fc562c815e434&end=5e449b9adff463455743291b0c1f76feec092992&stat=instructions:u)
  (up to -2.7% on `incr-patched: add static arr item` builds of `coercions-check`)
- A fix has been published as [#77006](https://github.com/rust-lang/rust/pull/77006).

[#75119](https://github.com/rust-lang/rust/issues/75119)  New MIR optimization pass to reduce branches on match of tuples of enums
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=81e02708f1f4760244756548981277d5199baa9a&end=2e0edc0f28c5647141bedba02e7a222d3a5dc9c3&stat=instructions:u)
  (up to -1.6% on `full` builds of `style-servo-opt`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=81e02708f1f4760244756548981277d5199baa9a&end=2e0edc0f28c5647141bedba02e7a222d3a5dc9c3&stat=instructions:u)
  (up to 1.3% on `full` builds of `wf-projection-stress-65510-check`)
- Seems to have been a regression overall. If there's no improvment in the generated code, we should disable this.

#### Nags requiring follow up

- [#75119](https://github.com/rust-lang/rust/issues/75119)
- [#76575](https://github.com/rust-lang/rust/issues/76575)

