<!--
SPDX-FileCopyrightText: Heiko Schaefer <heiko@schaefer.name>
SPDX-License-Identifier: CC0-1.0
-->

# rsop

`rsop` is a "Stateless OpenPGP" CLI tool. It exposes a simple, standardized CLI interface to perform a set of common OpenPGP operations.

rsop is based on a stack of [rpgp](https://github.com/rpgp/rpgp/) and [rpgpie 🦀️🔐🥧](https://crates.io/crates/rpgpie) (and the [rpgpie-sop](https://crates.io/crates/rpgpie-sop) adapter library).

The sibling project [rsop-oct](https://crates.io/crates/rsop-oct/) natively supports operations using OpenPGP card devices.

## Stateless OpenPGP Command Line Interface

The stateless OpenPGP command line interface (SOP) is an implementation-agnostic standard for handling OpenPGP messages and key material.

Stateless OpenPGP tools - such as `rsop` - are well suited for use in scripting use cases.

For more background and details about SOP, see <https://datatracker.ietf.org/doc/draft-dkg-openpgp-stateless-cli/>.

## Example rsop run

`rsop` can be built and installed from the Rust source code with cargo:

```
$ cargo install rsop
[..]
```

Alternatively, you can check for rsop in your system's packages. It is available for [Arch Linux](https://archlinux.org/packages/extra/x86_64/rsop/).

Once installed, you can use the `rsop` binary, for example to generate a new key and issue a signature with it:

```
$ rsop generate-key "<alice@example.org>" > alice.pgp
$ echo "hello world" | rsop inline-sign alice.pgp
-----BEGIN PGP MESSAGE-----

xA0DAAoWRkwnBKe7uWYByxJiAGXLjm9oZWxsbyB3b3JsZArCdQQAFgoAHRYhBGdn
Wt8kdsJqcSYzsUZMJwSnu7lmBQJly45vAAoJEEZMJwSnu7lmrxYBAIlPPn7R2ScC
Qo9s06ebeI/zilJ9vNB7hi4t3Yw6oxbIAP0ddnO5tP2SJRDx+5eWd0slp3G6+AEz
FhrH5HCHKSvQAg==
=bnER
-----END PGP MESSAGE-----
```

### Running from checked out sources

Alternatively, you can run `rsop` directly from this repository:

```
$ cargo run -- generate-key "<alice@example.org>"
[..]
```

## rsopv, the signature verification subset

As a smaller alternative to `rsop`, it is possible to build the `rsopv` binary. `rsopv` implements the [sopv Subset](https://dkg.gitlab.io/openpgp-stateless-cli/#name-sopv-subset), which only supports OpenPGP signature verification.

### Building the rsopv binary

The `rsopv` binary can be built like this:

```
$ cargo build --release --no-default-features --features="cliv" --bin rsopv
```

## OpenPGP interoperability test suite

`rsop` is included in the [OpenPGP interoperability test suite](https://tests.sequoia-pgp.org/), which tests the features of implementations, adherence to expectations, as well as interoperation between a large set of implementations.

## Rust SOP interface

The `rsop` CLI tool is built using the excellent <https://crates.io/crates/sop> framework. The `rsop` binary is trivially derived from [rpgpie-sop](https://crates.io/crates/rpgpie-sop).

## Overview of building blocks

```mermaid
flowchart TD
    RSOP["rsop <br/> (SOP CLI tool)"] --> RPIESOP
    RPIESOP["rpgpie-sop <br/> (SOP interface wrapper for rpgpie)"] --> RPIE
    RPIE["rpgpie <br/> (Experimental high level OpenPGP API)"] --> RPGP
    RPGP["rPGP <br/> (OpenPGP implementation)"]
```

## License

The (trivial) code of `rsop` is CC0 licensed.

Note, however, that when building a binary package from it, the binary's license is (of course) dictated by the licenses of its dependencies.

# Warning, early-stage project!

rsop and rpgpie are currently in an experimental, early development stage and are *NOT yet intended for production use*.
