// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(feature = "v4_14")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
use crate::AccessibleText;
use crate::{
    ffi, Accessible, AccessibleRole, Align, Buildable, ConstraintTarget, Editable, EntryBuffer,
    InputHints, InputPurpose, LayoutManager, Overflow, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

#[cfg(feature = "v4_14")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
glib::wrapper! {
    #[doc(alias = "GtkText")]
    pub struct Text(Object<ffi::GtkText>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, AccessibleText, Editable;

    match fn {
        type_ => || ffi::gtk_text_get_type(),
    }
}

#[cfg(not(any(feature = "v4_14")))]
glib::wrapper! {
    #[doc(alias = "GtkText")]
    pub struct Text(Object<ffi::GtkText>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, Editable;

    match fn {
        type_ => || ffi::gtk_text_get_type(),
    }
}

impl Text {
    #[doc(alias = "gtk_text_new")]
    pub fn new() -> Text {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_text_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_text_new_with_buffer")]
    #[doc(alias = "new_with_buffer")]
    pub fn with_buffer(buffer: &impl IsA<EntryBuffer>) -> Text {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_text_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Text`] objects.
    ///
    /// This method returns an instance of [`TextBuilder`](crate::builders::TextBuilder) which can be used to create [`Text`] objects.
    pub fn builder() -> TextBuilder {
        TextBuilder::new()
    }

    #[cfg(feature = "v4_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_4")))]
    #[doc(alias = "gtk_text_compute_cursor_extents")]
    pub fn compute_cursor_extents(&self, position: usize) -> (graphene::Rect, graphene::Rect) {
        unsafe {
            let mut strong = graphene::Rect::uninitialized();
            let mut weak = graphene::Rect::uninitialized();
            ffi::gtk_text_compute_cursor_extents(
                self.to_glib_none().0,
                position,
                strong.to_glib_none_mut().0,
                weak.to_glib_none_mut().0,
            );
            (strong, weak)
        }
    }

    #[doc(alias = "gtk_text_get_activates_default")]
    #[doc(alias = "get_activates_default")]
    #[doc(alias = "activates-default")]
    pub fn activates_default(&self) -> bool {
        unsafe { from_glib(ffi::gtk_text_get_activates_default(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_attributes")]
    #[doc(alias = "get_attributes")]
    pub fn attributes(&self) -> Option<pango::AttrList> {
        unsafe { from_glib_none(ffi::gtk_text_get_attributes(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_buffer")]
    #[doc(alias = "get_buffer")]
    pub fn buffer(&self) -> EntryBuffer {
        unsafe { from_glib_none(ffi::gtk_text_get_buffer(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_enable_emoji_completion")]
    #[doc(alias = "get_enable_emoji_completion")]
    #[doc(alias = "enable-emoji-completion")]
    pub fn enables_emoji_completion(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_get_enable_emoji_completion(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_get_extra_menu")]
    #[doc(alias = "get_extra_menu")]
    #[doc(alias = "extra-menu")]
    pub fn extra_menu(&self) -> Option<gio::MenuModel> {
        unsafe { from_glib_none(ffi::gtk_text_get_extra_menu(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_input_hints")]
    #[doc(alias = "get_input_hints")]
    #[doc(alias = "input-hints")]
    pub fn input_hints(&self) -> InputHints {
        unsafe { from_glib(ffi::gtk_text_get_input_hints(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_input_purpose")]
    #[doc(alias = "get_input_purpose")]
    #[doc(alias = "input-purpose")]
    pub fn input_purpose(&self) -> InputPurpose {
        unsafe { from_glib(ffi::gtk_text_get_input_purpose(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_invisible_char")]
    #[doc(alias = "get_invisible_char")]
    #[doc(alias = "invisible-char")]
    pub fn invisible_char(&self) -> char {
        unsafe {
            std::convert::TryFrom::try_from(ffi::gtk_text_get_invisible_char(self.to_glib_none().0))
                .expect("conversion from an invalid Unicode value attempted")
        }
    }

    #[doc(alias = "gtk_text_get_max_length")]
    #[doc(alias = "get_max_length")]
    #[doc(alias = "max-length")]
    pub fn max_length(&self) -> i32 {
        unsafe { ffi::gtk_text_get_max_length(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_get_overwrite_mode")]
    #[doc(alias = "get_overwrite_mode")]
    #[doc(alias = "overwrite-mode")]
    pub fn is_overwrite_mode(&self) -> bool {
        unsafe { from_glib(ffi::gtk_text_get_overwrite_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_placeholder_text")]
    #[doc(alias = "get_placeholder_text")]
    #[doc(alias = "placeholder-text")]
    pub fn placeholder_text(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_text_get_placeholder_text(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_propagate_text_width")]
    #[doc(alias = "get_propagate_text_width")]
    #[doc(alias = "propagate-text-width")]
    pub fn propagates_text_width(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_get_propagate_text_width(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_get_tabs")]
    #[doc(alias = "get_tabs")]
    pub fn tabs(&self) -> Option<pango::TabArray> {
        unsafe { from_glib_none(ffi::gtk_text_get_tabs(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_text_length")]
    #[doc(alias = "get_text_length")]
    pub fn text_length(&self) -> u16 {
        unsafe { ffi::gtk_text_get_text_length(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_get_truncate_multiline")]
    #[doc(alias = "get_truncate_multiline")]
    #[doc(alias = "truncate-multiline")]
    pub fn must_truncate_multiline(&self) -> bool {
        unsafe { from_glib(ffi::gtk_text_get_truncate_multiline(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_visibility")]
    #[doc(alias = "get_visibility")]
    #[doc(alias = "visibility")]
    pub fn is_visible(&self) -> bool {
        unsafe { from_glib(ffi::gtk_text_get_visibility(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_grab_focus_without_selecting")]
    pub fn grab_focus_without_selecting(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_grab_focus_without_selecting(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_set_activates_default")]
    #[doc(alias = "activates-default")]
    pub fn set_activates_default(&self, activates: bool) {
        unsafe {
            ffi::gtk_text_set_activates_default(self.to_glib_none().0, activates.into_glib());
        }
    }

    #[doc(alias = "gtk_text_set_attributes")]
    #[doc(alias = "attributes")]
    pub fn set_attributes(&self, attrs: Option<&pango::AttrList>) {
        unsafe {
            ffi::gtk_text_set_attributes(self.to_glib_none().0, attrs.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_text_set_buffer")]
    #[doc(alias = "buffer")]
    pub fn set_buffer(&self, buffer: &impl IsA<EntryBuffer>) {
        unsafe {
            ffi::gtk_text_set_buffer(self.to_glib_none().0, buffer.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_text_set_enable_emoji_completion")]
    #[doc(alias = "enable-emoji-completion")]
    pub fn set_enable_emoji_completion(&self, enable_emoji_completion: bool) {
        unsafe {
            ffi::gtk_text_set_enable_emoji_completion(
                self.to_glib_none().0,
                enable_emoji_completion.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_text_set_extra_menu")]
    #[doc(alias = "extra-menu")]
    pub fn set_extra_menu(&self, model: Option<&impl IsA<gio::MenuModel>>) {
        unsafe {
            ffi::gtk_text_set_extra_menu(
                self.to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_text_set_input_hints")]
    #[doc(alias = "input-hints")]
    pub fn set_input_hints(&self, hints: InputHints) {
        unsafe {
            ffi::gtk_text_set_input_hints(self.to_glib_none().0, hints.into_glib());
        }
    }

    #[doc(alias = "gtk_text_set_input_purpose")]
    #[doc(alias = "input-purpose")]
    pub fn set_input_purpose(&self, purpose: InputPurpose) {
        unsafe {
            ffi::gtk_text_set_input_purpose(self.to_glib_none().0, purpose.into_glib());
        }
    }

    #[doc(alias = "gtk_text_set_invisible_char")]
    #[doc(alias = "invisible-char")]
    pub fn set_invisible_char(&self, ch: char) {
        unsafe {
            ffi::gtk_text_set_invisible_char(self.to_glib_none().0, ch.into_glib());
        }
    }

    #[doc(alias = "gtk_text_set_max_length")]
    #[doc(alias = "max-length")]
    pub fn set_max_length(&self, length: i32) {
        unsafe {
            ffi::gtk_text_set_max_length(self.to_glib_none().0, length);
        }
    }

    #[doc(alias = "gtk_text_set_overwrite_mode")]
    #[doc(alias = "overwrite-mode")]
    pub fn set_overwrite_mode(&self, overwrite: bool) {
        unsafe {
            ffi::gtk_text_set_overwrite_mode(self.to_glib_none().0, overwrite.into_glib());
        }
    }

    #[doc(alias = "gtk_text_set_placeholder_text")]
    #[doc(alias = "placeholder-text")]
    pub fn set_placeholder_text(&self, text: Option<&str>) {
        unsafe {
            ffi::gtk_text_set_placeholder_text(self.to_glib_none().0, text.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_text_set_propagate_text_width")]
    #[doc(alias = "propagate-text-width")]
    pub fn set_propagate_text_width(&self, propagate_text_width: bool) {
        unsafe {
            ffi::gtk_text_set_propagate_text_width(
                self.to_glib_none().0,
                propagate_text_width.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_text_set_tabs")]
    #[doc(alias = "tabs")]
    pub fn set_tabs(&self, tabs: Option<&pango::TabArray>) {
        unsafe {
            ffi::gtk_text_set_tabs(self.to_glib_none().0, mut_override(tabs.to_glib_none().0));
        }
    }

    #[doc(alias = "gtk_text_set_truncate_multiline")]
    #[doc(alias = "truncate-multiline")]
    pub fn set_truncate_multiline(&self, truncate_multiline: bool) {
        unsafe {
            ffi::gtk_text_set_truncate_multiline(
                self.to_glib_none().0,
                truncate_multiline.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_text_set_visibility")]
    #[doc(alias = "visibility")]
    pub fn set_visibility(&self, visible: bool) {
        unsafe {
            ffi::gtk_text_set_visibility(self.to_glib_none().0, visible.into_glib());
        }
    }

    #[doc(alias = "gtk_text_unset_invisible_char")]
    pub fn unset_invisible_char(&self) {
        unsafe {
            ffi::gtk_text_unset_invisible_char(self.to_glib_none().0);
        }
    }

    #[doc(alias = "im-module")]
    pub fn im_module(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "im-module")
    }

    #[doc(alias = "im-module")]
    pub fn set_im_module(&self, im_module: Option<&str>) {
        ObjectExt::set_property(self, "im-module", im_module)
    }

    #[doc(alias = "invisible-char-set")]
    pub fn is_invisible_char_set(&self) -> bool {
        ObjectExt::property(self, "invisible-char-set")
    }

    #[doc(alias = "scroll-offset")]
    pub fn scroll_offset(&self) -> i32 {
        ObjectExt::property(self, "scroll-offset")
    }

    #[doc(alias = "activates-default")]
    pub fn connect_activates_default_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_activates_default_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::activates-default".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_activates_default_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "attributes")]
    pub fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::attributes".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "buffer")]
    pub fn connect_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::buffer".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_buffer_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-emoji-completion")]
    pub fn connect_enable_emoji_completion_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_emoji_completion_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::enable-emoji-completion".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_emoji_completion_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "extra-menu")]
    pub fn connect_extra_menu_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_menu_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::extra-menu".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_extra_menu_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "im-module")]
    pub fn connect_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_im_module_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::im-module".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_im_module_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-hints")]
    pub fn connect_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_hints_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::input-hints".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_input_hints_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-purpose")]
    pub fn connect_input_purpose_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_purpose_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::input-purpose".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_input_purpose_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "invisible-char")]
    pub fn connect_invisible_char_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::invisible-char".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_invisible_char_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "invisible-char-set")]
    pub fn connect_invisible_char_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_set_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::invisible-char-set".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_invisible_char_set_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-length")]
    pub fn connect_max_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_length_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::max-length".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_max_length_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "overwrite-mode")]
    pub fn connect_overwrite_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overwrite_mode_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::overwrite-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_overwrite_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "placeholder-text")]
    pub fn connect_placeholder_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_placeholder_text_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::placeholder-text".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_placeholder_text_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "propagate-text-width")]
    pub fn connect_propagate_text_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_propagate_text_width_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::propagate-text-width".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_propagate_text_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scroll-offset")]
    pub fn connect_scroll_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_offset_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::scroll-offset".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_scroll_offset_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tabs")]
    pub fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::tabs".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "truncate-multiline")]
    pub fn connect_truncate_multiline_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_truncate_multiline_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::truncate-multiline".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_truncate_multiline_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "visibility")]
    pub fn connect_visibility_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visibility_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::visibility".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_visibility_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Text {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Text`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TextBuilder {
    builder: glib::object::ObjectBuilder<'static, Text>,
}

impl TextBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn activates_default(self, activates_default: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("activates-default", activates_default),
        }
    }

    pub fn attributes(self, attributes: &pango::AttrList) -> Self {
        Self {
            builder: self.builder.property("attributes", attributes.clone()),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<EntryBuffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    pub fn enable_emoji_completion(self, enable_emoji_completion: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-emoji-completion", enable_emoji_completion),
        }
    }

    pub fn extra_menu(self, extra_menu: &impl IsA<gio::MenuModel>) -> Self {
        Self {
            builder: self
                .builder
                .property("extra-menu", extra_menu.clone().upcast()),
        }
    }

    pub fn im_module(self, im_module: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("im-module", im_module.into()),
        }
    }

    pub fn input_hints(self, input_hints: InputHints) -> Self {
        Self {
            builder: self.builder.property("input-hints", input_hints),
        }
    }

    pub fn input_purpose(self, input_purpose: InputPurpose) -> Self {
        Self {
            builder: self.builder.property("input-purpose", input_purpose),
        }
    }

    pub fn invisible_char(self, invisible_char: u32) -> Self {
        Self {
            builder: self.builder.property("invisible-char", invisible_char),
        }
    }

    pub fn invisible_char_set(self, invisible_char_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("invisible-char-set", invisible_char_set),
        }
    }

    pub fn max_length(self, max_length: i32) -> Self {
        Self {
            builder: self.builder.property("max-length", max_length),
        }
    }

    pub fn overwrite_mode(self, overwrite_mode: bool) -> Self {
        Self {
            builder: self.builder.property("overwrite-mode", overwrite_mode),
        }
    }

    pub fn placeholder_text(self, placeholder_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("placeholder-text", placeholder_text.into()),
        }
    }

    pub fn propagate_text_width(self, propagate_text_width: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("propagate-text-width", propagate_text_width),
        }
    }

    pub fn tabs(self, tabs: &pango::TabArray) -> Self {
        Self {
            builder: self.builder.property("tabs", tabs),
        }
    }

    pub fn truncate_multiline(self, truncate_multiline: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("truncate-multiline", truncate_multiline),
        }
    }

    pub fn visibility(self, visibility: bool) -> Self {
        Self {
            builder: self.builder.property("visibility", visibility),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    pub fn editable(self, editable: bool) -> Self {
        Self {
            builder: self.builder.property("editable", editable),
        }
    }

    pub fn enable_undo(self, enable_undo: bool) -> Self {
        Self {
            builder: self.builder.property("enable-undo", enable_undo),
        }
    }

    pub fn max_width_chars(self, max_width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("max-width-chars", max_width_chars),
        }
    }

    pub fn text(self, text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("text", text.into()),
        }
    }

    pub fn width_chars(self, width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("width-chars", width_chars),
        }
    }

    pub fn xalign(self, xalign: f32) -> Self {
        Self {
            builder: self.builder.property("xalign", xalign),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Text`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Text {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
