/*	canvas.h
	Copyright (C) 2004-2007 Mark Tyler and Dmitry Groshev

	This file is part of rgbPaint.

	rgbPaint is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	rgbPaint is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with rgbPaint in the file COPYING.
*/

#include <gtk/gtk.h>

float can_zoom;						// Zoom factor 1..MAX_ZOOM
int margin_main_x, margin_main_y,			// Top left of image from top left of canvas
	margin_view_x, margin_view_y;
int zoom_flag;
int marq_status, marq_x1, marq_y1, marq_x2, marq_y2;	// Selection marquee
int marq_drag_x, marq_drag_y;				// Marquee dragging offset

gboolean text_paste,					// Are we pasting text?
	close_after_save				// Closedown after save
	;

#define MARQUEE_NONE 0
#define MARQUEE_SELECTING 1
#define MARQUEE_DONE 2
#define MARQUEE_PASTE 3
#define MARQUEE_PASTE_DRAG 4

#define MIN_ZOOM 0.1
#define MAX_ZOOM 20

#define FS_PNG_LOAD 1		// File selector codes
#define FS_PNG_SAVE 2

int do_a_load( char *fname );
void align_size( float new_zoom );
int alert_box( char *title, char *message, char *text1, char *text2, char *text3 );
void init_ls_settings(ls_settings *settings, GtkWidget *box);
void file_selector( int action_type );
void init_pal();			// Initialise palette after loading/palette changes
void update_cols();
void set_new_filename( char *fname );

void main_undo( GtkMenuItem *menu_item, gpointer user_data );
void main_redo( GtkMenuItem *menu_item, gpointer user_data );

void tool_action(int event, int x, int y, int button, gdouble pressure);	// Paint some pixels!
void update_menus();					// Update undo/edit menu

int close_to( int x1, int y1 );

void paint_marquee(int action, int new_x, int new_y);	// Draw/clear marquee

void pressed_copy( GtkMenuItem *menu_item, gpointer user_data, gint item );
void pressed_paste( GtkMenuItem *menu_item, gpointer user_data );
void pressed_paste_centre( GtkMenuItem *menu_item, gpointer user_data );

void update_paste_chunk( int x1, int y1, int x2, int y2 );
void check_marquee();
void paste_prepare();
void commit_paste(gboolean undo);
void canvas_undo_chores();

void register_file( char *filename );		// Called after successful load/save

void update_all_views();			// Update whole canvas on all views
void cleanse_txt( char *out, char *in );	// Cleans up non ASCII chars for GTK+2
void create_default_image();			// Create default new image

void fs_set_dir(char *s);
