% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suffix.R
\name{tld_extract}
\alias{tld_extract}
\title{Extract TLDs}
\usage{
tld_extract(domains, tlds = NULL)
}
\arguments{
\item{domains}{a vector of domains, retrieved through \code{\link{url_parse}} or
\code{\link{domain}}.}

\item{tlds}{a dataset of TLDs. If NULL (the default), \code{tld_extract} relies
on urltools' \code{\link{tld_dataset}}; otherwise, you can pass in the result of
\code{\link{tld_refresh}}.}
}
\value{
a data.frame of two columns: \code{domain}, with the original domain names,
and \code{tld}, the identified TLD from the domain.
}
\description{
\code{tld_extract} extracts the top-level domain (TLD) from
a vector of domain names. This is distinct from the suffixes, extracted with
\code{\link{suffix_extract}}; TLDs are \emph{top} level, while suffixes are just
domains through which internet users can publicly register domains (the difference
between \code{.org.uk} and \code{.uk}).
}
\examples{
# Using the inbuilt dataset
domains <- domain("https://en.wikipedia.org/wiki/Main_Page")
tld_extract(domains)

# Using a refreshed one
tld_extract(domains, tld_refresh())

}
\seealso{
\code{\link{suffix_extract}} for retrieving suffixes (distinct from TLDs).
}
