% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot-long.R
\name{pivot_longer_spec}
\alias{pivot_longer_spec}
\alias{build_longer_spec}
\title{Pivot data from wide to long using a spec}
\usage{
pivot_longer_spec(
  data,
  spec,
  ...,
  cols_vary = "fastest",
  names_repair = "check_unique",
  values_drop_na = FALSE,
  values_ptypes = NULL,
  values_transform = NULL,
  error_call = current_env()
)

build_longer_spec(
  data,
  cols,
  ...,
  names_to = "name",
  values_to = "value",
  names_prefix = NULL,
  names_sep = NULL,
  names_pattern = NULL,
  names_ptypes = NULL,
  names_transform = NULL,
  error_call = current_env()
)
}
\arguments{
\item{data}{A data frame to pivot.}

\item{spec}{A specification data frame. This is useful for more complex
pivots because it gives you greater control on how metadata stored in the
column names turns into columns in the result.

Must be a data frame containing character \code{.name} and \code{.value} columns.
Additional columns in \code{spec} should be named to match columns in the
long format of the dataset and contain values corresponding to columns
pivoted from the wide format.
The special \code{.seq} variable is used to disambiguate rows internally;
it is automatically removed after pivoting.}

\item{...}{These dots are for future extensions and must be empty.}

\item{cols_vary}{When pivoting \code{cols} into longer format, how should the
output rows be arranged relative to their original row number?
\itemize{
\item \code{"fastest"}, the default, keeps individual rows from \code{cols} close
together in the output. This often produces intuitively ordered output
when you have at least one key column from \code{data} that is not involved in
the pivoting process.
\item \code{"slowest"} keeps individual columns from \code{cols} close together in the
output. This often produces intuitively ordered output when you utilize
all of the columns from \code{data} in the pivoting process.
}}

\item{names_repair}{What happens if the output has invalid column names?
The default, \code{"check_unique"} is to error if the columns are duplicated.
Use \code{"minimal"} to allow duplicates in the output, or \code{"unique"} to
de-duplicated by adding numeric suffixes. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}
for more options.}

\item{values_drop_na}{If \code{TRUE}, will drop rows that contain only \code{NA}s
in the \code{value_to} column. This effectively converts explicit missing values
to implicit missing values, and should generally be used only when missing
values in \code{data} were created by its structure.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{cols}{<\code{\link[=tidyr_tidy_select]{tidy-select}}> Columns to pivot into
longer format.}

\item{names_to}{A character vector specifying the new column or columns to
create from the information stored in the column names of \code{data} specified
by \code{cols}.
\itemize{
\item If length 0, or if \code{NULL} is supplied, no columns will be created.
\item If length 1, a single column will be created which will contain the
column names specified by \code{cols}.
\item If length >1, multiple columns will be created. In this case, one of
\code{names_sep} or \code{names_pattern} must be supplied to specify how the
column names should be split. There are also two additional character
values you can take advantage of:
\itemize{
\item \code{NA} will discard the corresponding component of the column name.
\item \code{".value"} indicates that the corresponding component of the column
name defines the name of the output column containing the cell values,
overriding \code{values_to} entirely.
}
}}

\item{values_to}{A string specifying the name of the column to create
from the data stored in cell values. If \code{names_to} is a character
containing the special \code{.value} sentinel, this value will be ignored,
and the name of the value column will be derived from part of the
existing column names.}

\item{names_prefix}{A regular expression used to remove matching text
from the start of each variable name.}

\item{names_sep, names_pattern}{If \code{names_to} contains multiple values,
these arguments control how the column name is broken up.

\code{names_sep} takes the same specification as \code{\link[=separate]{separate()}}, and can either
be a numeric vector (specifying positions to break on), or a single string
(specifying a regular expression to split on).

\code{names_pattern} takes the same specification as \code{\link[=extract]{extract()}}, a regular
expression containing matching groups (\verb{()}).

If these arguments do not give you enough control, use
\code{pivot_longer_spec()} to create a spec object and process manually as
needed.}

\item{names_ptypes, values_ptypes}{Optionally, a list of column name-prototype
pairs. Alternatively, a single empty prototype can be supplied, which will
be applied to all columns. A prototype (or ptype for short) is a
zero-length vector (like \code{integer()} or \code{numeric()}) that defines the type,
class, and attributes of a vector. Use these arguments if you want to
confirm that the created columns are the types that you expect. Note that
if you want to change (instead of confirm) the types of specific columns,
you should use \code{names_transform} or \code{values_transform} instead.}

\item{names_transform, values_transform}{Optionally, a list of column
name-function pairs. Alternatively, a single function can be supplied,
which will be applied to all columns. Use these arguments if you need to
change the types of specific columns. For example, \code{names_transform = list(week = as.integer)} would convert a character variable called \code{week}
to an integer.

If not specified, the type of the columns generated from \code{names_to} will
be character, and the type of the variables generated from \code{values_to}
will be the common type of the input columns used to generate them.}
}
\description{
This is a low level interface to pivoting, inspired by the cdata package,
that allows you to describe pivoting with a data frame.
}
\examples{
# See vignette("pivot") for examples and explanation

# Use `build_longer_spec()` to build `spec` using similar syntax to `pivot_longer()`
# and run `pivot_longer_spec()` based on `spec`.
spec <- relig_income \%>\% build_longer_spec(
  cols = !religion,
  names_to = "income",
  values_to = "count"
)
spec

pivot_longer_spec(relig_income, spec)

# Is equivalent to:
relig_income \%>\% pivot_longer(
  cols = !religion,
  names_to = "income",
  values_to = "count"
)
}
\keyword{internal}
