% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-measures.R, R/geom-predicates.R
\name{geos_query}
\alias{geos_query}
\alias{st_dimension}
\alias{st_is_simple}
\alias{st_is_empty}
\title{Dimension, simplicity, validity or is_empty queries on simple feature geometries}
\usage{
st_dimension(x, NA_if_empty = TRUE)

st_is_simple(x)

st_is_empty(x)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{NA_if_empty}{logical; if TRUE, return NA for empty geometries}
}
\value{
st_dimension returns a numeric vector with 0 for points, 1 for lines, 2 for surfaces, and, if \code{NA_if_empty} is \code{TRUE}, \code{NA} for empty geometries.

st_is_simple returns a logical vector, indicating for each geometry whether it is simple (e.g., not self-intersecting)

st_is_empty returns for each geometry whether it is empty
}
\description{
Dimension, simplicity, validity or is_empty queries on simple feature geometries
}
\examples{
x = st_sfc(
	st_point(0:1),
	st_linestring(rbind(c(0,0),c(1,1))),
	st_polygon(list(rbind(c(0,0),c(1,0),c(0,1),c(0,0)))),
	st_multipoint(),
	st_linestring(),
	st_geometrycollection())
st_dimension(x)
st_dimension(x, FALSE)
ls = st_linestring(rbind(c(0,0), c(1,1), c(1,0), c(0,1)))
st_is_simple(st_sfc(ls, st_point(c(0,0))))
ls = st_linestring(rbind(c(0,0), c(1,1), c(1,0), c(0,1)))
st_is_empty(st_sfc(ls, st_point(), st_linestring()))
}
