% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-compose.R
\name{compose_label}
\alias{compose_label}
\title{Compose two or more label formatters together}
\usage{
compose_label(..., call = caller_env())
}
\arguments{
\item{...}{One or more labelling functions. These will be applied to breaks
consecutively.
\link[rlang:as_function]{Lambda syntax} is allowed.}

\item{call}{A call to display in error messages.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
This labeller provides a general mechanism for composing two or more
labellers together.
}
\examples{
demo_continuous(
  c(-100, 100),
  labels = compose_label(abs, number, \(x) paste0(x, " foobar"), toupper)
)

# Same result
demo_continuous(
  c(-100, 100),
  labels = compose_label(abs, label_number(suffix = " FOOBAR"))
)
}
