% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_get_var_names}
\alias{df_get_var_names}
\title{Get User Specified Variable Names}
\usage{
df_get_var_names(data, ..., vars = NULL)
}
\arguments{
\item{data}{a data frame}

\item{...}{One or more unquoted expressions (or variable names) separated by
commas. Used to select a variable of interest.}

\item{vars}{a character vector containing the variable names of interest.}
}
\value{
a character vector
}
\description{
Returns user specified variable names. Supports standard and non standard evaluation.
}
\examples{

# Non standard evaluation
ToothGrowth \%>\%
 df_get_var_names(dose, len)

# Standard evaluation
ToothGrowth \%>\%
 df_get_var_names(vars = c("len", "dose"))
}
