% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_dataset.R
\name{plot.Dataset}
\alias{plot.Dataset}
\title{Dataset Plotting}
\usage{
\method{plot}{Dataset}(
  x,
  y,
  ...,
  main = "Dataset",
  xlab = "Stage",
  ylab = NA_character_,
  legendTitle = "Group",
  palette = "Set1",
  showSource = FALSE
)
}
\arguments{
\item{x}{The \code{\link{Dataset}} object to plot.}

\item{y}{Not available for this kind of plot (is only defined to be compatible 
to the generic plot function).}

\item{...}{Optional plot arguments. At the moment \code{xlim} and \code{ylim} are implemented 
for changing x or y axis limits without dropping data observations.}

\item{main}{The main title, default is \code{"Dataset"}.}

\item{xlab}{The x-axis label, default is \code{"Stage"}.}

\item{ylab}{The y-axis label.}

\item{legendTitle}{The legend title, default is \code{"Group"}.}

\item{palette}{The palette, default is \code{"Set1"}.}

\item{showSource}{If \code{TRUE}, the parameter names of the object will 
be printed which were used to create the plot; that may be, e.g., 
useful to check the values or to create own plots with the base R \code{plot} function.
Alternatively \code{showSource} can be defined as one of the following character values: 
\itemize{
  \item \code{"commands"}: returns a character vector with plot commands
  \item \code{"axes"}: returns a list with the axes definitions
  \item \code{"test"}: all plot commands will be validated with \code{eval(parse())} and 
        returned as character vector (function does not stop if an error occurs)
  \item \code{"validate"}: all plot commands will be validated with \code{eval(parse())} and 
        returned as character vector (function stops if an error occurs)
}
Note: no plot object will be returned if \code{showSource} is a character.}
}
\value{
Returns a \code{ggplot2} object.
}
\description{
Plots a dataset.
}
\details{
Generic function to plot all kinds of datasets.
}
\examples{
# Plot a dataset of means
dataExample <- getDataset(
    n1 = c(22, 11, 22, 11),
    n2 = c(22, 13, 22, 13),
    means1 = c(1, 1.1, 1, 1),
    means2 = c(1.4, 1.5, 3, 2.5),
    stDevs1 = c(1, 2, 2, 1.3),
    stDevs2 = c(1, 2, 2, 1.3))
\donttest{
if (require(ggplot2)) plot(dataExample, main = "Comparison of Means")
}

# Plot a dataset of rates
dataExample <- getDataset(
    n1 = c(8, 10, 9, 11),
    n2 = c(11, 13, 12, 13),
    events1 = c(3, 5, 5, 6),
    events2 = c(8, 10, 12, 12)
)
\donttest{
if (require(ggplot2)) plot(dataExample, main = "Comparison of Rates")
}

}
