% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_draws_df.R
\name{draws_df}
\alias{draws_df}
\alias{as_draws_df}
\alias{as_draws_df.default}
\alias{as_draws_df.data.frame}
\alias{as_draws_df.draws_df}
\alias{as_draws_df.draws_matrix}
\alias{as_draws_df.draws_array}
\alias{as_draws_df.draws_list}
\alias{as_draws_df.draws_rvars}
\alias{as_draws_df.mcmc}
\alias{as_draws_df.mcmc.list}
\alias{is_draws_df}
\title{The \code{draws_df} format}
\usage{
as_draws_df(x, ...)

\method{as_draws_df}{default}(x, ...)

\method{as_draws_df}{data.frame}(x, ...)

\method{as_draws_df}{draws_df}(x, ...)

\method{as_draws_df}{draws_matrix}(x, ...)

\method{as_draws_df}{draws_array}(x, ...)

\method{as_draws_df}{draws_list}(x, ...)

\method{as_draws_df}{draws_rvars}(x, ...)

\method{as_draws_df}{mcmc}(x, ...)

\method{as_draws_df}{mcmc.list}(x, ...)

draws_df(..., .nchains = 1)

is_draws_df(x)
}
\arguments{
\item{x}{An object to convert to a \code{draws_df} object.}

\item{...}{For \code{as_draws_df()}:
Arguments passed to individual methods (if applicable).
For \code{draws_df()}: Named
arguments containing numeric vectors each defining a separate variable.}

\item{.nchains}{(positive integer) The number of chains. The default is \code{1}.}
}
\value{
A \code{draws_df} object, which has classes
\code{c("draws_df", "draws", class(tibble::tibble()))}.
}
\description{
The \code{as_draws_df()} methods convert
objects to the \code{draws_df} format.
The \code{draws_df()} function creates an object of the
\code{draws_df} format based on a set of numeric vectors.
See \strong{Details}.
}
\details{
Objects of class \code{"draws_df"} are \link[tibble:tibble]{tibble} data
frames. They have one column per variable as well as additional metadata
columns \code{".iteration"}, \code{".chain"}, and \code{".draw"}. The difference between
the \code{".iteration"} and \code{".draw"} columns is that the former is relative to
the MCMC chain while the latter ignores the chain information and has all
unique values. See \strong{Examples}.

If a \code{data.frame}-like object is supplied to \code{as_draws_df} that contains
columns named \code{".iteration"} or \code{".chain"}, they will be treated as
iteration and chain indices, respectively. See \strong{Examples}.
}
\examples{
x1 <- as_draws_df(example_draws())
class(x1)
print(x1)
str(x1)

x2 <- draws_df(a = rnorm(10), b = rnorm(10), c = 1)
class(x2)
print(x2)
str(x2)

# the difference between iteration and draw is clearer when contrasting
# the head and tail of the data frame
print(head(x1), reserved = TRUE, max_variables = 2)
print(tail(x1), reserved = TRUE, max_variables = 2)

# manually supply chain information
xnew <- data.frame(mu = rnorm(10), .chain = rep(1:2, each = 5))
xnew <- as_draws_df(xnew)
print(xnew)

}
\seealso{
Other formats: 
\code{\link{draws_array}()},
\code{\link{draws_list}()},
\code{\link{draws_matrix}()},
\code{\link{draws_rvars}()},
\code{\link{draws}}
}
\concept{formats}
