% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/includes.R
\name{include_file}
\alias{include_file}
\alias{include_html}
\alias{include_md}
\alias{include_rmd}
\title{Send File Contents as Response}
\usage{
include_file(file, res, content_type = getContentType(tools::file_ext(file)))

include_html(file, res)

include_md(file, res, format = NULL)

include_rmd(file, res, format = NULL)
}
\arguments{
\item{file}{The path to the file to return}

\item{res}{The response object into which we'll write}

\item{content_type}{If provided, the given value will be sent as the
\code{Content-Type} header in the response. Defaults to the contentType of the file extension.
To disable the \code{Content-Type} header, set \code{content_type = NULL}.}

\item{format}{Passed as the \code{output_format} to \code{rmarkdown::render}}
}
\description{
Returns the file at the given path as the response. If you want an endpoint to return a file as an attachment for user to download see \code{\link[=as_attachment]{as_attachment()}}.
}
\details{
\code{include_html} will merely return the file with the proper
\code{content_type} for HTML. \code{include_md} and \code{include_rmd} will
process the given markdown file through \code{rmarkdown::render} and return
the resultant HTML as a response.
}
