% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon.R
\name{dna2codon}
\alias{dna2codon}
\alias{codon2dna}
\title{Translate nucleic acid sequences into codons}
\usage{
dna2codon(x, codonstart = 1, code = 1, ambiguity = "---", ...)

codon2dna(x)
}
\arguments{
\item{x}{An object containing sequences.}

\item{codonstart}{an integer giving where to start the translation. This
should be 1, 2, or 3, but larger values are accepted and have for effect to
start the translation further within the sequence.}

\item{code}{The ncbi genetic code number for translation (see details).
By default the standard genetic code is used.}

\item{ambiguity}{character for ambiguous character and no contrast is
provided.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The functions return an object of class \code{phyDat}.
}
\description{
The function transforms \code{dna2codon} DNA sequences to codon sequences,
\code{codon2dna} transform the other way.
}
\details{
The following genetic codes are described here. The number preceding each
corresponds to the code argument.
\tabular{rl}{
  1 \tab standard   \cr
  2 \tab vertebrate.mitochondrial \cr
  3 \tab yeast.mitochondrial \cr
  4 \tab protozoan.mitochondrial+mycoplasma \cr
  5 \tab invertebrate.mitochondrial \cr
  6 \tab ciliate+dasycladaceal \cr
  9 \tab echinoderm+flatworm.mitochondrial \cr
  10 \tab euplotid \cr
  11 \tab bacterial+plantplastid \cr
  12 \tab alternativeyeast \cr
  13 \tab ascidian.mitochondrial \cr
  14 \tab alternativeflatworm.mitochondrial \cr
  15 \tab blepharism \cr
  16 \tab chlorophycean.mitochondrial \cr
  21 \tab trematode.mitochondrial \cr
  22 \tab scenedesmus.mitochondrial \cr
  23 \tab thraustochytrium.mitochondria \cr
  24 \tab Pterobranchia.mitochondrial \cr
  25 \tab CandidateDivision.SR1+Gracilibacteria \cr
  26 \tab Pachysolen.tannophilus
}
Alignment gaps and ambiguities are currently ignored and sites containing
these are deleted.
}
\examples{

data(Laurasiatherian)
class(Laurasiatherian)
Laurasiatherian
dna2codon(Laurasiatherian)

}
\references{
\url{https://www.ncbi.nlm.nih.gov/Taxonomy/taxonomyhome.html/index.cgi?chapter=cgencodes}
}
\seealso{
\code{\link{trans}}, \code{\link{phyDat}} and the chapter 4 in the
\code{vignette("phangorn-specials", package="phangorn")}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
