% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_OSLLifeTimes.R
\name{fit_OSLLifeTimes}
\alias{fit_OSLLifeTimes}
\title{Fitting and Deconvolution of OSL Lifetime Components}
\usage{
fit_OSLLifeTimes(
  object,
  tp = 0,
  signal_range = NULL,
  n.components = NULL,
  method_control = list(),
  plot = TRUE,
  plot_simple = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Analysis}, \link{data.frame} or \link{matrix} \strong{(required)}:
Input object containing the data to be analysed. All objects can be provided also as list for an automated
processing. Please note: \code{NA} values are automatically removed and the dataset should comprise at least 5 data points.}

\item{tp}{\link{numeric} (\emph{with default}): option to account for the stimulation pulse width. For off-time measurements
the default value is 0. \code{tp} has the same unit as the measurement data, e.g., µs. Please set this parameter
carefully, if it all, otherwise you may heavily bias your fit results.}

\item{signal_range}{\link{numeric} (\emph{optional}): allows to set a channel range, by default all channels are used, e.g.
\code{signal_range = c(2,100)} considers only channels 2 to 100 and \code{signal_range = c(2)} considers only channels
from channel 2 onwards.}

\item{n.components}{\link{numeric} (\emph{optional}): Fix the number of components. If set the algorithm will try
to fit the number of predefined components. If nothing is set, the algorithm will try to find the best number
of components.}

\item{method_control}{\link{list} (\emph{optonal}): Named to allow a more fine control of the fitting process. See details
for allowed options.}

\item{plot}{\link{logical} (\emph{with default}): Enable/disable plot output}

\item{plot_simple}{\link{logical} (\emph{with default}): Enable/disable reduced plot output. If \code{TRUE}, no
residual plot is shown, however, plot output can be combined using the standard R layout obtions,
such as \code{par(mfrow = c(2,2))}.}

\item{verbose}{\link{logical} (\emph{with default}): Enable/disable terminal feedback}

\item{...}{parameters passed to \link{plot.default} to control the plot output, supported are:
\code{main}, \code{xlab}, \code{ylab}, \code{log}, \code{xlim}, \code{ylim}, \code{col}, \code{lty}, \code{legend.pos}, \code{legend.text}. If the input
object is of type \linkS4class{RLum.Analysis} this arguments can be provided as a \link{list}.}
}
\value{
-----------------------------------\cr
\verb{[ NUMERICAL OUTPUT ]}\cr
-----------------------------------\cr

\strong{\code{RLum.Results}}-object

\strong{slot:} \strong{\verb{@data}}

\tabular{lll}{
\strong{Element} \tab \strong{Type} \tab \strong{Description}\cr
\verb{$data} \tab \code{matrix} \tab the final fit matrix \cr
\verb{$start_matrix} \tab \code{matrix} \tab the start matrix used for the fitting \cr
\verb{$total_counts} \tab \code{integer} \tab Photon count sum \cr
\verb{$fit} \tab \code{nls} \tab the fit object returned by \link[minpack.lm:nls.lm]{minpack.lm::nls.lm} \cr
}

\strong{slot:} \strong{\verb{@info}}

The original function call

------------------------\cr
\verb{[ TERMINAL OUTPUT ]}\cr
------------------------\cr

Terminal output is only shown of the argument \code{verbose = TRUE}.

\emph{(1) Start parameter and component adapation}\cr
Trave of the parameter adaptation process

\emph{(2) Fitting results (sorted by ascending tau)}\cr
The fitting results sorted by ascending tau value. Please note
that if you access the \code{nls} fitting object, the values are not sorted.

\emph{(3) Further information}\cr
\itemize{
\item The photon count sum
\item Durbin-Watson residual statistic to asses whether the residuals are correlated, ideally
the residuals should be not correlated at all. Rough measures are: \cr
D = 0: the residuals are systematically correlated \cr
D = 2: the residuals are randomly distributed \cr
D = 4: the residuals are systematically anticorrelated\cr
}

You should be suspicious if D differs largely from 2.

------------------------\cr
\verb{[ PLOT OUTPUT ]}\cr
------------------------\cr

A plot showing the original data and the fit so far possible. The lower plot shows the
residuals of the fit.
}
\description{
Fitting and Deconvolution of OSL Lifetime Components
}
\details{
The function intends to provide an easy access to pulsed optically stimulated luminescence (POSL) data,
in order determine signal lifetimes. The fitting is currently optimised to work with the off-time flank of POSL measurements
only. For the signal deconvolution, a differential evolution optimisation is combined with nonlinear least-square fitting
following the approach by Bluszcz & Adamiec (2006).

\strong{Component deconvolution algorithm}

The component deconvolution consists of two steps:

(1) Adaption phase

In the adaption phase the function tries to figure out the optimal and statistically justified
number of signal components following roughly the approach suggestd by Bluszcz & Adamiec (2006). In
contrast to their work, for the optimisation by differential evolution here the package 'DEoptim' is used.

The function to be optimized has the form:

\deqn{\chi^2 = \sum(w * (n_i/c - \sum(A_i * exp(-x/(tau_i + t_p))))^2)}

with \eqn{w = 1} for unweighted regression analysis (\code{method_control = list(weights = FALSE)}) or
\eqn{w = c^2/n_i} for weighted regression analysis. The default values is \code{TRUE}.

\deqn{F = (\Delta\chi^2 / 2) / (\chi^2/(N - 2*m - 2))}

(2) Final fitting

\strong{\code{method_control}}

\tabular{lll}{
\strong{Parameter} \tab \strong{Type} \tab \strong{Description}\cr
\code{p} \tab \link{numeric} \tab controls the probability for the F statistic reference values. For a significance level of 5 \% a value of 0.95 (the default) should be added, for 1 \%, a value of 0.99 is sufficient: 1 > p > 0 (cf. \link[stats:Fdist]{stats::FDist})\cr
\code{seed} \tab \link{numeric} \tab set the seed for the random number generator, provide a value here to get reproducible results \cr
\code{DEoptim.trace} \tab \link{logical} \tab enables/disables the tracing of the differential evolution (cf. \link[DEoptim:DEoptim.control]{DEoptim::DEoptim.control}) \cr
\code{DEoptim.itermax} \tab \link{logical} \tab controls the number of the allowed generations (cf. \link[DEoptim:DEoptim.control]{DEoptim::DEoptim.control}) \cr
\code{weights} \tab \link{logical} \tab enables/disables the weighting for the start parameter estimation and fitting (see equations above).
The default values is \code{TRUE} \cr
\code{nlsLM.trace} \tab \link{logical} \tab enables/disables trace mode for the nls fitting (\link[minpack.lm:nlsLM]{minpack.lm::nlsLM}), can be used to identify convergence problems, default is \code{FALSE} \cr
\code{nlsLM.upper} \tab \link{logical} \tab enables/disables upper parameter boundary, default is \code{TRUE} \cr
\code{nlsLM.lower} \tab \link{logical} \tab enables/disables lower parameter boundary, default is \code{TRUE}
}
}
\section{Function version}{
 0.1.5
}

\examples{

##load example data
data(ExampleData.TR_OSL, envir = environment())

##fit lifetimes (short run)
fit_OSLLifeTimes(
 object = ExampleData.TR_OSL,
 n.components = 1)

##long example
\dontrun{
fit_OSLLifeTimes(
object = ExampleData.TR_OSL)
}

} 

\section{How to cite}{
Kreutzer, S., Schmidt, C., 2020. fit_OSLLifeTimes(): Fitting and Deconvolution of OSL Lifetime Components. Function version 0.1.5. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Riedesel, S., Autzen, M., Mittelstrass, D., 2020. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.10. https://CRAN.R-project.org/package=Luminescence
}

\references{
Bluszcz, A., Adamiec, G., 2006. Application of differential evolution to fitting OSL decay curves.
Radiation Measurements 41, 886-891. doi:10.1016/j.radmeas.2006.05.016\cr

Durbin, J., Watson, G.S., 1950. Testing for Serial Correlation in Least Squares Regression: I.
Biometrika 37, 409-21. doi:10.2307/2332391

\strong{Further reading}

Hughes, I., Hase, T., 2010. Measurements and Their Uncertainties. Oxford University Press.

Storn, R., Price, K., 1997. Differential Evolution –
A Simple and Efficient Heuristic for Global Optimization over Continuous Spaces.
Journal of Global Optimization 11, 341–359.
}
\seealso{
\link[minpack.lm:nls.lm]{minpack.lm::nls.lm}, \link[DEoptim:DEoptim]{DEoptim::DEoptim}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University,
Christoph Schmidt, University of Bayreuth (Germany)
, RLum Developer Team}
