% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe_return_linter.R
\name{pipe_return_linter}
\alias{pipe_return_linter}
\title{Block usage of return() in magrittr pipelines}
\usage{
pipe_return_linter()
}
\description{
\code{\link[=return]{return()}} inside a magrittr pipeline does not actually execute \code{return()}
like you'd expect: \verb{\\(x) \{ x \%>\% return(); FALSE \}} will return \code{FALSE}!
It will technically work "as expected" if this is the final statement
in the function body, but such usage is misleading. Instead, assign
the pipe outcome to a variable and return that.
}
\examples{
# will produce lints
lint(
  text = "function(x) x \%>\% return()",
  linters = pipe_return_linter()
)

# okay
code <- "function(x) {\n  y <- sum(x)\n  return(y)\n}"
writeLines(code)
lint(
  text = code,
  linters = pipe_return_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=common_mistakes_linters]{common_mistakes}
}
