% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{voronoi_cells}
\alias{voronoi_cells}
\title{Voronoi partitioning of a graph}
\usage{
voronoi_cells(
  graph,
  generators,
  ...,
  weights = NULL,
  mode = c("out", "in", "all", "total"),
  tiebreaker = c("random", "first", "last")
)
}
\arguments{
\item{graph}{The graph to partition into Voronoi cells.}

\item{generators}{The generator vertices of the Voronoi cells.}

\item{...}{These dots are for future extensions and must be empty.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is
\code{NULL} and the graph has a \code{weight} edge attribute, then the
attribute is used. If this is \code{NA} then no weights are used (even if
the graph has a \code{weight} attribute). In a weighted graph, the length
of a path is the sum of the weights of its constituent edges.}

\item{mode}{Character string. In directed graphs, whether to compute
distances from generator vertices to other vertices (\code{"out"}), to
generator vertices from other vertices (\code{"in"}), or ignore edge
directions entirely (\code{"all"}). Ignored in undirected graphs.}

\item{tiebreaker}{Character string that specifies what to do when a vertex
is at the same distance from multiple generators. \code{"random"} assigns
a minimal-distance generator randomly, \code{"first"} takes the first one,
and \code{"last"} takes the last one.}
}
\value{
A named list with two components:
\describe{
\item{membership}{
numeric vector giving the cluster id to which each vertex belongs.
}
\item{distances}{
numeric vector giving the distance of each vertex from its generator
}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function partitions the vertices of a graph based on a set of generator
vertices. Each vertex is assigned to the generator vertex from (or to) which
it is closest.

\code{\link[=groups]{groups()}} may be used on the output of this function.
}
\examples{

g <- make_lattice(c(10, 10))
clu <- voronoi_cells(g, c(25, 43, 67))
groups(clu)
plot(g, vertex.color = clu$membership)

}
\seealso{
\code{\link[=distances]{distances()}}

Community detection
\code{\link{as_membership}()},
\code{\link{cluster_edge_betweenness}()},
\code{\link{cluster_fast_greedy}()},
\code{\link{cluster_fluid_communities}()},
\code{\link{cluster_infomap}()},
\code{\link{cluster_label_prop}()},
\code{\link{cluster_leading_eigen}()},
\code{\link{cluster_leiden}()},
\code{\link{cluster_louvain}()},
\code{\link{cluster_optimal}()},
\code{\link{cluster_spinglass}()},
\code{\link{cluster_walktrap}()},
\code{\link{compare}()},
\code{\link{groups}()},
\code{\link{make_clusters}()},
\code{\link{membership}()},
\code{\link{modularity.igraph}()},
\code{\link{plot_dendrogram}()},
\code{\link{split_join_distance}()}
}
\concept{community}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Structural.html#igraph_voronoi}{\code{voronoi()}}.}

