% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_node_range.R
\name{geom_node_range}
\alias{geom_node_range}
\title{Show nodes as a line spanning a horizontal range}
\usage{
geom_node_range(
  mapping = NULL,
  data = NULL,
  position = "identity",
  show.legend = NA,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}
or \code{\link[ggplot2:aes_]{ggplot2::aes_()}}. By default x is mapped to xmin, xend is mapped to xmax
and y and yend are mapped to y in the node data.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
This geom is most useful together with the \link[=layout_tbl_graph_fabric]{fabric}
layout for showing the horizontal span of each node.
}
\section{Aesthetics}{

\code{geom_node_point} understand the following aesthetics. Bold aesthetics are
automatically set, but can be overridden.
\itemize{
\item \strong{x}
\item \strong{xend}
\item \strong{y}
\item \strong{yend}
\item alpha
\item colour
\item linetype
\item size
\item filter
}
}

\examples{
require(tidygraph)
gr <- as_tbl_graph(highschool)

ggraph(gr, layout = 'fabric') +
  geom_node_range()
}
\seealso{
Other geom_node_*: 
\code{\link{geom_node_arc_bar}()},
\code{\link{geom_node_circle}()},
\code{\link{geom_node_point}()},
\code{\link{geom_node_text}()},
\code{\link{geom_node_tile}()},
\code{\link{geom_node_voronoi}()}
}
\author{
Thomas Lin Pedersen
}
\concept{geom_node_*}
