% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-dotplot.r
\name{geom_dotplot}
\alias{geom_dotplot}
\title{Dot plot}
\usage{
geom_dotplot(
  mapping = NULL,
  data = NULL,
  position = "identity",
  ...,
  binwidth = NULL,
  binaxis = "x",
  method = "dotdensity",
  binpositions = "bygroup",
  stackdir = "up",
  stackratio = 1,
  dotsize = 1,
  stackgroups = FALSE,
  origin = NULL,
  right = TRUE,
  width = 0.9,
  drop = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{binwidth}{When \code{method} is "dotdensity", this specifies maximum bin
width. When \code{method} is "histodot", this specifies bin width.
Defaults to 1/30 of the range of the data}

\item{binaxis}{The axis to bin along, "x" (default) or "y"}

\item{method}{"dotdensity" (default) for dot-density binning, or
"histodot" for fixed bin widths (like stat_bin)}

\item{binpositions}{When \code{method} is "dotdensity", "bygroup" (default)
determines positions of the bins for each group separately. "all" determines
positions of the bins with all the data taken together; this is used for
aligning dot stacks across multiple groups.}

\item{stackdir}{which direction to stack the dots. "up" (default),
"down", "center", "centerwhole" (centered, but with dots aligned)}

\item{stackratio}{how close to stack the dots. Default is 1, where dots
just touch. Use smaller values for closer, overlapping dots.}

\item{dotsize}{The diameter of the dots relative to \code{binwidth}, default 1.}

\item{stackgroups}{should dots be stacked across groups? This has the effect
that \code{position = "stack"} should have, but can't (because this geom has
some odd properties).}

\item{origin}{When \code{method} is "histodot", origin of first bin}

\item{right}{When \code{method} is "histodot", should intervals be closed
on the right (a, b], or not [a, b)}

\item{width}{When \code{binaxis} is "y", the spacing of the dot stacks
for dodging.}

\item{drop}{If TRUE, remove all bins with zero counts}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}
}
\description{
In a dot plot, the width of a dot corresponds to the bin width
(or maximum width, depending on the binning algorithm), and dots are
stacked, with each dot representing one observation.
}
\details{
There are two basic approaches: \emph{dot-density} and \emph{histodot}.
With dot-density binning, the bin positions are determined by the data and
\code{binwidth}, which is the maximum width of each bin. See Wilkinson
(1999) for details on the dot-density binning algorithm. With histodot
binning, the bins have fixed positions and fixed widths, much like a
histogram.

When binning along the x axis and stacking along the y axis, the numbers on
y axis are not meaningful, due to technical limitations of ggplot2. You can
hide the y axis, as in one of the examples, or manually scale it
to match the number of dots.
}
\section{Aesthetics}{

\code{geom_dotplot()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
\item \code{group}
\item \code{linetype}
\item \code{stroke}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\section{Computed variables}{

These are calculated by the 'stat' part of layers and can be accessed with \link[=aes_eval]{delayed evaluation}.
\itemize{
\item \code{after_stat(x)}\cr center of each bin, if \code{binaxis} is \code{"x"}.
\item \code{after_stat(y)}\cr center of each bin, if \code{binaxis} is \code{"x"}.
\item \code{after_stat(binwidth)}\cr maximum width of each bin if method is \code{"dotdensity"};  width of each bin if method is \code{"histodot"}.
\item \code{after_stat(count)}\cr number of points in bin.
\item \code{after_stat(ncount)}\cr count, scaled to a maximum of 1.
\item \code{after_stat(density)}\cr density of points in bin, scaled to integrate to 1, if method  is \code{"histodot"}.
\item \code{after_stat(ndensity)}\cr density, scaled to maximum of 1, if method is \code{"histodot"}.
}
}

\examples{
ggplot(mtcars, aes(x = mpg)) +
  geom_dotplot()

ggplot(mtcars, aes(x = mpg)) +
  geom_dotplot(binwidth = 1.5)

# Use fixed-width bins
ggplot(mtcars, aes(x = mpg)) +
  geom_dotplot(method="histodot", binwidth = 1.5)

# Some other stacking methods
ggplot(mtcars, aes(x = mpg)) +
  geom_dotplot(binwidth = 1.5, stackdir = "center")

ggplot(mtcars, aes(x = mpg)) +
  geom_dotplot(binwidth = 1.5, stackdir = "centerwhole")

# y axis isn't really meaningful, so hide it
ggplot(mtcars, aes(x = mpg)) + geom_dotplot(binwidth = 1.5) +
  scale_y_continuous(NULL, breaks = NULL)

# Overlap dots vertically
ggplot(mtcars, aes(x = mpg)) +
  geom_dotplot(binwidth = 1.5, stackratio = .7)

# Expand dot diameter
ggplot(mtcars, aes(x = mpg)) +
  geom_dotplot(binwidth = 1.5, dotsize = 1.25)

# Change dot fill colour, stroke width
ggplot(mtcars, aes(x = mpg)) +
  geom_dotplot(binwidth = 1.5, fill = "white", stroke = 2)

\donttest{
# Examples with stacking along y axis instead of x
ggplot(mtcars, aes(x = 1, y = mpg)) +
  geom_dotplot(binaxis = "y", stackdir = "center")

ggplot(mtcars, aes(x = factor(cyl), y = mpg)) +
  geom_dotplot(binaxis = "y", stackdir = "center")

ggplot(mtcars, aes(x = factor(cyl), y = mpg)) +
  geom_dotplot(binaxis = "y", stackdir = "centerwhole")

ggplot(mtcars, aes(x = factor(vs), fill = factor(cyl), y = mpg)) +
  geom_dotplot(binaxis = "y", stackdir = "center", position = "dodge")

# binpositions="all" ensures that the bins are aligned between groups
ggplot(mtcars, aes(x = factor(am), y = mpg)) +
  geom_dotplot(binaxis = "y", stackdir = "center", binpositions="all")

# Stacking multiple groups, with different fill
ggplot(mtcars, aes(x = mpg, fill = factor(cyl))) +
  geom_dotplot(stackgroups = TRUE, binwidth = 1, binpositions = "all")

ggplot(mtcars, aes(x = mpg, fill = factor(cyl))) +
  geom_dotplot(stackgroups = TRUE, binwidth = 1, method = "histodot")

ggplot(mtcars, aes(x = 1, y = mpg, fill = factor(cyl))) +
  geom_dotplot(binaxis = "y", stackgroups = TRUE, binwidth = 1, method = "histodot")
}
}
\references{
Wilkinson, L. (1999) Dot plots. The American Statistician,
53(3), 276-281.
}
