% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthState-class.R
\name{init_AuthState}
\alias{init_AuthState}
\title{Create an AuthState}
\usage{
init_AuthState(
  package = NA_character_,
  client = NULL,
  api_key = NULL,
  auth_active = TRUE,
  cred = NULL,
  app = deprecated()
)
}
\arguments{
\item{package}{Package name, an optional string. It is recommended to record
the name of the package whose auth state is being managed. Ultimately, this
may be used in some downstream messaging.}

\item{client}{A Google OAuth client, preferably constructed via
\code{\link[=gargle_oauth_client_from_json]{gargle_oauth_client_from_json()}}, which returns an instance of
\code{gargle_oauth_client}. For backwards compatibility, for a limited time,
gargle will still accept an "OAuth app" created with \code{\link[httr:oauth_app]{httr::oauth_app()}}.}

\item{api_key}{Optional. API key (a string). Some APIs accept unauthorized,
"token-free" requests for public resources, but only if the request
includes an API key.}

\item{auth_active}{Logical. \code{TRUE} means requests should include a token (and
probably not an API key). \code{FALSE} means requests should include an API key
(and probably not a token).}

\item{cred}{Credentials. Typically populated indirectly via \code{\link[=token_fetch]{token_fetch()}}.}

\item{app}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Replaced by the \code{client}
argument.}
}
\value{
An object of class \link{AuthState}.
}
\description{
Constructor function for objects of class \link{AuthState}.
}
\examples{
my_client <- gargle_oauth_client(
  id = "some_long_client_id",
  secret = "ssshhhhh_its_a_secret",
  name = "my-nifty-oauth-client"
)

init_AuthState(
  package = "my_package",
  client = my_client,
  api_key = "api_key_api_key_api_key",
)
}
