% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future-modify.R
\name{future_modify}
\alias{future_modify}
\alias{future_modify_at}
\alias{future_modify_if}
\title{Modify elements selectively via futures}
\usage{
future_modify(
  .x,
  .f,
  ...,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)

future_modify_at(
  .x,
  .at,
  .f,
  ...,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)

future_modify_if(
  .x,
  .p,
  .f,
  ...,
  .else = NULL,
  .options = furrr_options(),
  .env_globals = parent.frame(),
  .progress = FALSE
)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.options}{The \code{future} specific options to use with the workers. This
must be the result from a call to \code{\link[=furrr_options]{furrr_options()}}.}

\item{.env_globals}{The environment to look for globals required by \code{.x} and
\code{...}. Globals required by \code{.f} are looked up in the function environment
of \code{.f}.}

\item{.progress}{A single logical. Should a progress bar be displayed?
Only works with multisession, multicore, and multiprocess futures. Note
that if a multicore/multisession future falls back to sequential, then
a progress bar will not be displayed.

\strong{Warning:} The \code{.progress} argument will be deprecated and removed
in a future version of furrr in favor of using the more robust
\href{https://CRAN.R-project.org/package=progressr}{progressr}
package.}

\item{.at}{A character vector of names, positive numeric vector of
positions to include, or a negative numeric vector of positions to
exlude. Only those elements corresponding to \code{.at} will be modified.
If the \code{tidyselect} package is installed, you can use \code{vars()} and
the \code{tidyselect} helpers to select elements.}

\item{.p}{A single predicate function, a formula describing such a
predicate function, or a logical vector of the same length as \code{.x}.
Alternatively, if the elements of \code{.x} are themselves lists of
objects, a string indicating the name of a logical element in the
inner lists. Only those elements where \code{.p} evaluates to
\code{TRUE} will be modified.}

\item{.else}{A function applied to elements of \code{.x} for which \code{.p}
returns \code{FALSE}.}
}
\value{
An object the same class as \code{.x}
}
\description{
These functions work exactly the same as \code{\link[purrr:modify]{purrr::modify()}} functions, but
allow you to modify in parallel.
}
\details{
From purrr:

Since the transformation can alter the structure of the input;
it's your responsibility to ensure that the transformation produces a valid
output. For example, if you're modifying a data frame, \code{.f} must preserve the
length of the input.
}
\examples{
library(magrittr)
\donttest{plan(multisession, workers = 2)}

# Convert each col to character, in parallel
future_modify(mtcars, as.character)

iris \%>\%
 future_modify_if(is.factor, as.character) \%>\%
 str()

mtcars \%>\%
  future_modify_at(c(1, 4, 5), as.character) \%>\%
  str()

\dontshow{
# Close open connections for R CMD Check
if (!inherits(plan(), "sequential")) plan(sequential)
}
}
