% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind-rows.R
\name{bind_rows}
\alias{bind_rows}
\alias{bind}
\title{Bind multiple data frames by row}
\usage{
bind_rows(..., .id = NULL)
}
\arguments{
\item{...}{Data frames to combine. Each argument can either be a data frame,
a list that could be a data frame, or a list of data frames. Columns are
matched by name, and any missing columns will be filled with \code{NA}.}

\item{.id}{The name of an optional identifier column. Provide a string to
create an output column that identifies each input. The column will use
names if available, otherwise it will use positions.}
}
\value{
A data frame the same type as the first element of \code{...}.
}
\description{
Bind any number of data frames by row, making a longer result. This is
similar to \code{do.call(rbind, dfs)}, but the output will contain all columns
that appear in any of the inputs.
}
\examples{
df1 <- tibble(x = 1:2, y = letters[1:2])
df2 <- tibble(x = 4:5, z = 1:2)

# You can supply individual data frames as arguments:
bind_rows(df1, df2)

# Or a list of data frames:
bind_rows(list(df1, df2))

# When you supply a column name with the `.id` argument, a new
# column is created to link each row to its original data frame
bind_rows(list(df1, df2), .id = "id")
bind_rows(list(a = df1, b = df2), .id = "id")
}
