% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R, R/generics.R
\name{maxindex.default}
\alias{maxindex.default}
\alias{poslength.default}
\alias{maxindex.logical}
\alias{poslength.logical}
\alias{maxindex.bit}
\alias{poslength.bit}
\alias{maxindex.bitwhich}
\alias{poslength.bitwhich}
\alias{maxindex.which}
\alias{poslength.which}
\alias{maxindex.ri}
\alias{poslength.ri}
\alias{maxindex}
\alias{poslength}
\title{Get maxindex (length of boolean vector) and poslength (number of 'selected' elements)}
\usage{
\method{maxindex}{default}(x, ...)

\method{poslength}{default}(x, ...)

\method{maxindex}{logical}(x, ...)

\method{poslength}{logical}(x, ...)

\method{maxindex}{bit}(x, ...)

\method{poslength}{bit}(x, ...)

\method{maxindex}{bitwhich}(x, ...)

\method{poslength}{bitwhich}(x, ...)

\method{maxindex}{which}(x, ...)

\method{poslength}{which}(x, ...)

\method{maxindex}{ri}(x, ...)

\method{poslength}{ri}(x, ...)

maxindex(x, ...)

poslength(x, ...)
}
\arguments{
\item{x}{an R object, typically a \code{\link[=is.booltype]{is.booltype()}} object.}

\item{...}{further arguments (ignored)}
}
\value{
an integer scalar
}
\description{
For \code{\link[=is.booltype]{is.booltype()}} objects the term \code{\link[=length]{length()}} is ambiguous.
For example the length of \code{\link[=which]{which()}} corresponds to the sum of \code{\link[=logical]{logical()}}.
The generic \code{maxindex} gives \code{length(logical)} for all \code{\link[=booltype]{booltype()}}s.
The generic \code{poslength} gives the number of positively selected elements, i.e.
\code{sum(logical)} for all \code{\link[=booltype]{booltype()}}s (and gives \code{NA} if \code{NAs} are present).
}
\section{Methods (by class)}{
\itemize{
\item \code{maxindex(default)}: default method for \code{maxindex}

\item \code{maxindex(logical)}: \code{maxindex} method for class \code{\link[=logical]{logical()}}

\item \code{maxindex(bit)}: \code{maxindex} method for class \code{\link[=bit]{bit()}}

\item \code{maxindex(bitwhich)}: \code{maxindex} method for class \code{\link[=bitwhich]{bitwhich()}}

\item \code{maxindex(which)}: \code{maxindex} method for class \code{\link[=as.which]{which()}}

\item \code{maxindex(ri)}: \code{maxindex} method for class \code{\link[=ri]{ri()}}

}}
\section{Functions}{
\itemize{
\item \code{poslength(default)}: default method for \code{poslength}

\item \code{poslength(logical)}: \code{poslength} method for class \code{\link[=logical]{logical()}}

\item \code{poslength(bit)}: \code{poslength} method for class \code{\link[=bit]{bit()}}

\item \code{poslength(bitwhich)}: \code{poslength} method for class \code{\link[=bitwhich]{bitwhich()}}

\item \code{poslength(which)}: \code{poslength} method for class \code{\link[=as.which]{which()}}

\item \code{poslength(ri)}: \code{poslength} method for class \code{\link[=ri]{ri()}}

}}
\examples{
r <- ri(1, 2, 12)
i <- as.which(r)
w <- as.bitwhich(r)
b <- as.bit(r)
l <- as.logical(r)
u <- which(l)      # unclassed which

sapply(list(r=r, u=u, i=i, w=w, b=b, l=l), function(x) {
  c(length=length(x), sum=sum(x), maxindex=maxindex(x), poslength=poslength(x))
})
}
