write.csv(file="../../extdata/2.6.0/metadata-zeisel-nervous.csv",
    data.frame(
        Title = sprintf("Zeisel nervous system %s", c("counts", "rowData", "colData", "colPairs", "reducedDims")),
        Description = sprintf("%s for the Zeisel mouse nervous system single-cell RNA-seq dataset", 
            c("Count matrix", "Per-gene metadata", "Per-cell metadata", "Cell-cell pairings", "Reduced dimensions")),
        RDataPath = file.path("scRNAseq", "zeisel-nervous", "2.6.0", 
            c("counts.rds", "rowdata.rds", "coldata.rds", "colpairs.rds", 'reddims.rds')),
        BiocVersion="3.13",
        Genome="mm10",
        SourceType="HDF5",
        SourceUrl="http://mousebrain.org/downloads.html",
        SourceVersion="L5_All.loom",
        Species="Mus musculus",
        TaxonomyId="10090",
        Coordinate_1_based=NA,
        DataProvider="GEO",
        Maintainer="Aaron Lun <infinite.monkeys.with.keyboards@gmail.com>",
        RDataClass=c("dgCMatrix", "DFrame", "DFrame", "list", "list"),
        DispatchClass="Rds",
        stringsAsFactors = FALSE
    ),
    row.names=FALSE)
