% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_filter-methods.R
\docType{methods}
\name{genefilter_sample}
\alias{genefilter_sample}
\alias{genefilter_sample,matrix-method}
\alias{genefilter_sample,otu_table-method}
\alias{genefilter_sample,phyloseq-method}
\title{Filter OTUs with arbitrary function, sample-wise.}
\usage{
genefilter_sample(X, flist, A=1)

\S4method{genefilter_sample}{matrix}(X, flist, A = 1)

\S4method{genefilter_sample}{otu_table}(X, flist, A = 1)

\S4method{genefilter_sample}{phyloseq}(X, flist, A = 1)
}
\arguments{
\item{X}{The object that needs trimming. Can be matrix, otu_table, or higher-
order phyloseq classes that contain an otu_table.}

\item{flist}{An enclosure object, typically created with \code{\link{filterfun_sample}}}

\item{A}{An integer. The number of samples in which a taxa / OTUs passed the filter
for it to be labeled TRUE in the output logical vector.}
}
\value{
A logical vector with names equal to taxa_names (or rownames, if matrix).
}
\description{
A general OTU trimming function for selecting OTUs that satisfy
some criteria within the distribution of each sample, and then
also an additional criteria for number of samples that must pass.
This is a genefilter-like function that only considers sample-wise
criteria. The number of acceptable samples is used
as the final criteria (set by the argument \code{A})
to determine whether or not the taxa should
be retained (\code{TRUE}) or not (\code{FALSE}). Just like with genefilter, a 
logical having length equal to nrow()/\code{\link{ntaxa}} is returned, indicating which
should be kept. This output can be provided
directly to OTU trimming function, \code{\link{prune_taxa}}.
By contrast, \code{\link[genefilter]{genefilter}}, 
of the genefilter package in Bioconductor,
works only on the rows of a matrix. Note that, because \code{\link{otu_table-class}}
inherits directly from the \code{\link{matrix-class}}, an unmodified
otu_table can be provided to \code{genefilter}, but be mindful of the orientation
of the otu_table (use \code{\link{taxa_are_rows}}),
and transpose (\code{\link[phyloseq]{t}}) if needed.
}
\examples{
#
## testOTU <- otu_table(matrix(sample(1:50, 25, replace=TRUE), 5, 5), taxa_are_rows=FALSE)
## f1  <- filterfun_sample(topk(2))
## wh1 <- genefilter_sample(testOTU, f1, A=2)
## wh2 <- c(TRUE, TRUE, TRUE, FALSE, FALSE)
## prune_taxa(wh1, testOTU)
## prune_taxa(wh2, testOTU)
## 
## tax_table1 <- tax_table(matrix("abc", 5, 5))
## prune_taxa(wh1, tax_table1)
## prune_taxa(wh2, tax_table1)
}
\seealso{
\code{\link[genefilter]{genefilter}}, \code{\link{filterfun_sample}},
 \code{\link[phyloseq]{t}},
 \code{\link{prune_taxa}}
}
\keyword{OTU}
\keyword{agglomerate}
\keyword{cluster}
\keyword{tree}
