% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_nmf_signatures.R
\name{rename_nmf_signatures}
\alias{rename_nmf_signatures}
\title{Rename NMF signatures based on previously defined signatures}
\usage{
rename_nmf_signatures(nmf_res, signatures, cutoff = 0.85, base_name = "SBS")
}
\arguments{
\item{nmf_res}{Named list of mutation matrix, signatures and signature contribution}

\item{signatures}{A signature matrix}

\item{cutoff}{Cutoff at which signatures are considered similar. Default: 0.85}

\item{base_name}{The base part of a letter based signature name. Default: "SBS"}
}
\value{
A nmf_res whith changed signature names
}
\description{
This function renames signatures identified with NMF based on previously defined signatures.
If a NMF signature has a cosine similarity with a previously defined signature,
that is higher than the cutoff, then this NMF signature will get the name
of the previously defined signature. If not the NMF signature will receive a letter based name.
For example: SBSA.
This only changes the names of signatures, not their actual values.
This function can be help with identifying whether signatures found with NMF are already known,
which can be usefull for interpretation.
}
\examples{

## Extracting signatures can be computationally intensive, so
## we use pre-computed data generated with the following command:
# nmf_res <- extract_signatures(mut_mat, rank = 2)

nmf_res <- readRDS(system.file("states/nmf_res_data.rds",
  package = "MutationalPatterns"
))

## Get signatures
signatures <- get_known_signatures()

rename_nmf_signatures(nmf_res, signatures)

## You can change how similar the signatures have to be, before they are considered similar.
rename_nmf_signatures(nmf_res, signatures, cutoff = 0.95)

## You can also change the base_name of the signatures that end up with a letter name.
rename_nmf_signatures(nmf_res, signatures, cutoff = 0.95, base_name = "Signature_")
}
