// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_API_DECLARATIVE_NET_REQUEST_DNR_MANIFEST_DATA_H_
#define EXTENSIONS_COMMON_API_DECLARATIVE_NET_REQUEST_DNR_MANIFEST_DATA_H_

#include <vector>

#include "base/files/file_path.h"
#include "base/macros.h"
#include "extensions/common/api/declarative_net_request/constants.h"
#include "extensions/common/extension.h"

namespace extensions {
namespace declarative_net_request {

// Manifest data required for the kDeclarativeNetRequestKey manifest
// key.
struct DNRManifestData : Extension::ManifestData {
  struct RulesetInfo {
    base::FilePath relative_path;

    // An ID uniquely identifying the static ruleset within the extension.
    // Generated by us. Must be >= 1 (kMinValidStaticRulesetID) since 0 is
    // reserved for the dynamic ruleset.
    // TODO(karandeepb): Use a StrongAlias for ruleset ID.
    int id = kInvalidRulesetID;
  };

  explicit DNRManifestData(std::vector<RulesetInfo> ruleset);
  ~DNRManifestData() override;

  // Returns true if the extension specified the kDeclarativeNetRequestKey
  // manifest key.
  static bool HasRuleset(const Extension& extension);

  // Returns the RulesetInfo for the |extension|. This must be called only if
  // HasRuleset returns true for the |extension|.
  static const std::vector<RulesetInfo>& GetRulesets(
      const Extension& extension);

  std::vector<RulesetInfo> rulesets;

  DISALLOW_COPY_AND_ASSIGN(DNRManifestData);
};

}  // namespace declarative_net_request
}  // namespace extensions

#endif  // EXTENSIONS_COMMON_API_DECLARATIVE_NET_REQUEST_DNR_MANIFEST_DATA_H_
