/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.JDBCCallSyntaxTranslator;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.StreamColumns;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamInfo;
import com.microsoft.sqlserver.jdbc.StreamRetStatus;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLServerStatement
implements Statement {
    static final char LEFT_CURLY_BRACKET = '{';
    static final char RIGHT_CURLY_BRACKET = '}';
    private boolean isResponseBufferingAdaptive = false;
    private boolean wasResponseBufferingSet = false;
    static final String identityQuery = " select SCOPE_IDENTITY() AS GENERATED_KEYS";
    String userSQL;
    String procedureName;
    private StreamRetStatus procedureRetStatToken;
    TDSReader tdsReader;
    Parameter[] inOutParam;
    final SQLServerConnection connection;
    int queryTimeout;
    private volatile TDSCommand currentCommand = null;
    private ExecuteProperties execProps;
    boolean moreResults = false;
    SQLServerResultSet resultSet;
    static final int EXECUTE_NOT_SET = 0;
    static final int EXECUTE_QUERY = 1;
    static final int EXECUTE_UPDATE = 2;
    static final int EXECUTE = 3;
    static final int EXECUTE_BATCH = 4;
    static final int EXECUTE_QUERY_INTERNAL = 5;
    int executeMethod = 0;
    int updateCount = -1;
    boolean escapeProcessing;
    int maxRows = 0;
    int maxFieldSize = 0;
    int resultSetConcurrency;
    int appResultSetType;
    int resultSetType;
    boolean isServerSideCursor;
    boolean expectCursorOutParams;
    String cursorName;
    int nFetchSize;
    int defaultFetchSize;
    int nFetchDirection;
    boolean bIsClosed;
    boolean bRequestedGeneratedKeys;
    private ResultSet autoGeneratedKeys;
    boolean sendStringParametersAsUnicode = true;
    StringBuffer batchStatementBuffer;
    int batchSize;
    private static Logger stmtlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerStatement");
    private final int statementID = SQLServerStatement.nextStatementID();
    private static int lastStatementID = 0;
    Vector sqlWarnings;

    final boolean getIsResponseBufferingAdaptive() {
        return this.isResponseBufferingAdaptive;
    }

    final boolean wasResponseBufferingSet() {
        return this.wasResponseBufferingSet;
    }

    String getPreparedSQL() {
        return this.userSQL;
    }

    final ExecuteProperties getExecProps() {
        return this.execProps;
    }

    final void executeStatement(TDSCommand tDSCommand) throws SQLServerException {
        this.processResponse();
        this.execProps = new ExecuteProperties(this);
        this.executeCommand(tDSCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void executeCommand(TDSCommand tDSCommand) throws SQLServerException {
        if (null != this.currentCommand) {
            this.currentCommand.detach();
        }
        boolean bl = false;
        TDSCommand tDSCommand2 = this.currentCommand;
        this.currentCommand = tDSCommand;
        try {
            bl = this.connection.executeCommand(tDSCommand);
        }
        finally {
            if (bl) {
                this.currentCommand = tDSCommand2;
            }
        }
    }

    final int getSQLResultSetType() {
        return this.resultSetType;
    }

    final int getCursorType() {
        return this.getResultSetScrollOpt() & 0xFFFFEFFF;
    }

    String toLogString() {
        String string = this.getClass().getName();
        return string.substring(1 + string.lastIndexOf(46)) + "ID:" + this.statementID + " (" + this.connection.toLogString() + ")";
    }

    private static synchronized int nextStatementID() {
        return ++lastStatementID;
    }

    SQLServerStatement(SQLServerConnection sQLServerConnection, int n, int n2) throws SQLServerException {
        String string;
        this.connection = sQLServerConnection;
        this.bIsClosed = false;
        if (1003 != n && 1005 != n && 1004 != n && 2003 != n && 2004 != n && 1006 != n && 1005 != n && 1004 != n) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedCursor"), null, true);
        }
        if (1007 != n2 && 1008 != n2 && 1009 != n2 && 1008 != n2 && 1010 != n2) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedConcurrency"), null, true);
        }
        this.resultSetConcurrency = n2;
        this.appResultSetType = n;
        this.resultSetType = 1003 == n ? (1007 == n2 ? (null == (string = sQLServerConnection.getSelectMethod()) || !string.equals("cursor") ? 2003 : 2004) : 2004) : (1004 == n ? 1004 : (1005 == n ? 1005 : n));
        this.nFetchDirection = 2003 == this.resultSetType || 2004 == this.resultSetType ? 1000 : 1002;
        this.defaultFetchSize = this.nFetchSize = 1009 == this.resultSetConcurrency ? 8 : 128;
        if (1007 != n2 && (2003 == this.resultSetType || 1004 == this.resultSetType)) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedCursorAndConcurrency"), null, true);
        }
        this.isServerSideCursor = this.resultSetType != 2003;
        this.setResponseBuffering(this.connection.getResponseBuffering());
        stmtlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerStatement");
        if (stmtlogger.isLoggable(Level.FINE)) {
            stmtlogger.fine("Properties for " + this.toLogString() + ":" + " Result type:" + this.appResultSetType + " (" + this.resultSetType + ")" + " Concurrency:" + this.resultSetConcurrency + " Fetchsize:" + this.nFetchSize + " bIsClosed:" + this.bIsClosed + " useLastUpdateCount:" + this.connection.useLastUpdateCount() + " isServerSideCursor:" + this.isServerSideCursor);
        }
    }

    final Logger getStatementLogger() {
        return stmtlogger;
    }

    final void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    public void close() throws SQLServerException {
        if (this.bIsClosed || this.connection.isClosed()) {
            return;
        }
        this.resetForReexecute();
        this.bIsClosed = true;
        this.inOutParam = null;
        if (stmtlogger.isLoggable(Level.FINE)) {
            stmtlogger.fine(this.toLogString() + " Closing statement.");
        }
    }

    public ResultSet executeQuery(String string) throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 1, 2));
        return this.resultSet;
    }

    final SQLServerResultSet executeQueryInternal(String string) throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 5, 2));
        return this.resultSet;
    }

    public int executeUpdate(String string) throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 2, 2));
        return this.updateCount;
    }

    public boolean execute(String string) throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 3, 2));
        return null != this.resultSet;
    }

    private String ensureSQLSyntax(String string) {
        if (string.indexOf(123) >= 0) {
            JDBCCallSyntaxTranslator jDBCCallSyntaxTranslator = new JDBCCallSyntaxTranslator();
            String string2 = jDBCCallSyntaxTranslator.translate(string);
            this.procedureName = jDBCCallSyntaxTranslator.getProcedureName();
            return string2;
        }
        return string;
    }

    void startResults() {
        this.moreResults = true;
        this.procedureRetStatToken = null;
    }

    final void doExecuteStatement(StmtExecCmd stmtExecCmd) throws SQLServerException {
        String string;
        boolean bl = stmtlogger.isLoggable(Level.FINE);
        this.currentCommand = stmtExecCmd;
        this.executeMethod = stmtExecCmd.executeMethod;
        this.resetForReexecute();
        this.userSQL = string = this.ensureSQLSyntax(stmtExecCmd.sql);
        if (2 != this.executeMethod) {
            this.connection.setMaxRows(this.maxRows);
            this.connection.setMaxFieldSize(this.maxFieldSize);
        }
        if ((1 == this.executeMethod || 3 == this.executeMethod) && this.isServerSideCursor && this.isSelect(string)) {
            if (bl) {
                stmtlogger.fine(this.toLogString() + " Executing server side cursor " + string);
            }
            this.doExecuteCursored(stmtExecCmd, string);
        } else {
            TDSWriter tDSWriter = stmtExecCmd.startRequest((byte)1);
            tDSWriter.writeString(string);
            if (1 == stmtExecCmd.autoGeneratedKeys && (2 == this.executeMethod || 3 == this.executeMethod) && string.trim().toUpperCase().startsWith("INSERT")) {
                tDSWriter.writeString(identityQuery);
            }
            if (bl) {
                stmtlogger.fine(this.toLogString() + " Executing (not server cursor) " + string);
            }
            this.tdsReader = stmtExecCmd.startResponse(this.isResponseBufferingAdaptive);
            this.startResults();
            this.getNextResult();
        }
        if (null == this.resultSet) {
            if (1 == this.executeMethod) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noResultset"), null, true);
            }
        } else if (2 == this.executeMethod || 4 == this.executeMethod) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
    }

    final void resetForReexecute() throws SQLServerException {
        this.processResponse();
        this.tdsReader = null;
        this.autoGeneratedKeys = null;
        this.updateCount = -1;
        this.procedureRetStatToken = null;
        this.sqlWarnings = null;
        this.expectCursorOutParams = false;
    }

    final boolean isSelect(String string) throws SQLServerException {
        this.checkClosed();
        String string2 = string.trim();
        char c = string2.charAt(0);
        if (c != 's' && c != 'S') {
            return false;
        }
        return string2.substring(0, 6).equalsIgnoreCase("select");
    }

    private HashMap parseColumns(String string) throws SQLServerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl3;
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf("(") >= 0 && !bl) {
                bl = true;
                bl3 = SQLServerStatement.checkBalancedParenthesis(string3);
                if (!bl3) {
                    string2 = string2 + string3;
                }
                if (!bl3) continue;
                hashMap.put(new Integer(n++), string3);
                continue;
            }
            if (bl) {
                bl3 = SQLServerStatement.checkBalancedParenthesis(string2 = string2 + string3);
                if (!bl3) continue;
                bl = false;
                hashMap.put(new Integer(n++), string2);
                string2 = "";
                continue;
            }
            hashMap.put(new Integer(n++), string3);
        }
        if (bl) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_errorProcessingComplexQuery"), null, true);
        }
        return hashMap;
    }

    private static boolean checkBalancedParenthesis(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n = string.indexOf("(", n + 1)) != -1) {
            ++n3;
        }
        while ((n2 = string.indexOf(")", n2 + 1)) != -1) {
            ++n4;
        }
        return n3 == n4;
    }

    static String replaceParameterWithString(String string, char c, String string2) {
        int n = 0;
        while ((n = string.indexOf("" + c)) >= 0) {
            string = string.substring(0, n) + string2 + string.substring(n + 1, string.length());
        }
        return string;
    }

    static String replaceMarkerWithNull(String string) {
        if (string.indexOf("'") < 0) {
            String string2 = SQLServerStatement.replaceParameterWithString(string, '?', "null");
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "'", true);
        boolean bl = true;
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("'")) {
                string3 = string3 + "'";
                bl = !bl;
                continue;
            }
            if (bl) {
                String string5 = SQLServerStatement.replaceParameterWithString(string4, '?', "null");
                string3 = string3 + string5;
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    void checkClosed() throws SQLServerException {
        if (this.bIsClosed) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementIsClosed"), null, false);
        }
        this.connection.checkClosed();
    }

    public final int getMaxFieldSize() throws SQLServerException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    public final void setMaxFieldSize(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        this.maxFieldSize = n;
    }

    public final int getMaxRows() throws SQLServerException {
        this.checkClosed();
        return this.maxRows;
    }

    public final void setMaxRows(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidRowcount"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        if (1006 != this.resultSetType) {
            this.maxRows = n;
        }
    }

    public final void setEscapeProcessing(boolean bl) throws SQLServerException {
        this.checkClosed();
        this.escapeProcessing = bl;
    }

    public final int getQueryTimeout() throws SQLServerException {
        this.checkClosed();
        return this.queryTimeout;
    }

    public final void setQueryTimeout(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidQueryTimeOutValue"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        this.queryTimeout = n;
    }

    public final void cancel() throws SQLServerException {
        this.checkClosed();
        if (null != this.currentCommand) {
            this.currentCommand.interrupt(SQLServerException.getErrString("R_queryCancelled"));
        }
    }

    public final SQLWarning getWarnings() throws SQLServerException {
        this.checkClosed();
        if (this.sqlWarnings == null) {
            return null;
        }
        return (SQLWarning)this.sqlWarnings.elementAt(0);
    }

    public final void clearWarnings() throws SQLServerException {
        this.checkClosed();
        this.sqlWarnings = null;
    }

    public final void setCursorName(String string) throws SQLServerException {
        this.checkClosed();
        this.cursorName = string;
    }

    final String getCursorName() {
        return this.cursorName;
    }

    public final ResultSet getResultSet() throws SQLServerException {
        this.checkClosed();
        return this.resultSet;
    }

    public final int getUpdateCount() throws SQLServerException {
        this.checkClosed();
        return this.updateCount;
    }

    final void processExecuteResults(TDSReader tDSReader) throws SQLServerException {
        this.tdsReader = tDSReader;
        this.startResults();
        this.processResponse();
    }

    void processResponse() throws SQLServerException {
        if (null != this.tdsReader) {
            this.processBatch();
        }
    }

    void processBatch() throws SQLServerException {
        this.processResults();
    }

    final void processResults() throws SQLServerException {
        while (this.moreResults) {
            try {
                this.getNextResult();
            }
            catch (SQLServerException sQLServerException) {
                if (2 == sQLServerException.getDriverErrorCode()) continue;
                this.moreResults = false;
                throw sQLServerException;
            }
        }
        this.clearLastResult();
    }

    public final boolean getMoreResults() throws SQLServerException {
        this.checkClosed();
        this.getNextResult();
        return null != this.resultSet;
    }

    private final void clearLastResult() {
        if (null != this.resultSet) {
            try {
                this.resultSet.close();
            }
            catch (SQLServerException sQLServerException) {
                stmtlogger.log(Level.WARNING, this.toLogString() + ": Error (ignored) closing " + this.resultSet.toLogString(), sQLServerException);
            }
            this.resultSet = null;
        }
        this.updateCount = -1;
    }

    final boolean getNextResult() throws SQLServerException {
        if (null == this.tdsReader) {
            this.moreResults = false;
            return false;
        }
        this.clearLastResult();
        if (!this.moreResults) {
            return false;
        }
        final class NextResult
        extends TDSTokenHandler {
            StreamColumns columnMetaDataToken;
            int serverCursorId;
            int serverCursorRowCount;
            StreamDone stmtDoneToken;
            boolean executedSqlDirectly;

            NextResult() {
                super("getNextResult");
                this.columnMetaDataToken = null;
                this.serverCursorId = 0;
                this.serverCursorRowCount = -1;
                this.stmtDoneToken = null;
                this.executedSqlDirectly = false;
            }

            boolean onColMetaData(TDSReader tDSReader) throws SQLServerException {
                if (null != this.stmtDoneToken) {
                    return false;
                }
                if (null != this.getDatabaseError()) {
                    return false;
                }
                this.columnMetaDataToken = new StreamColumns();
                this.columnMetaDataToken.setFromTDS(tDSReader);
                return true;
            }

            boolean onRow(TDSReader tDSReader) throws SQLServerException {
                return false;
            }

            boolean onDone(TDSReader tDSReader) throws SQLServerException {
                if (null != this.columnMetaDataToken && (!SQLServerStatement.this.isServerSideCursor || this.executedSqlDirectly)) {
                    return false;
                }
                StreamDone streamDone = new StreamDone();
                streamDone.setFromTDS(tDSReader);
                if (streamDone.isAttnAck()) {
                    return false;
                }
                if (streamDone.hasUpdateCount()) {
                    this.stmtDoneToken = streamDone;
                    if (255 != streamDone.getTokenType()) {
                        return false;
                    }
                    if (4 != SQLServerStatement.this.executeMethod) {
                        if (null != SQLServerStatement.this.procedureName) {
                            return false;
                        }
                        if (3 == SQLServerStatement.this.executeMethod) {
                            return false;
                        }
                        if (!SQLServerStatement.this.connection.useLastUpdateCount()) {
                            return false;
                        }
                    }
                } else {
                    if (streamDone.isFinal()) {
                        SQLServerStatement.this.moreResults = false;
                        return false;
                    }
                    if (4 == SQLServerStatement.this.executeMethod) {
                        if (255 != streamDone.getTokenType() || streamDone.wasRPCInBatch()) {
                            SQLServerStatement.this.moreResults = false;
                            return false;
                        }
                    } else if (224 == streamDone.getCurCmd() && null != this.stmtDoneToken && -1 != this.stmtDoneToken.getUpdateCount()) {
                        return false;
                    }
                }
                return true;
            }

            boolean onRetStatus(TDSReader tDSReader) throws SQLServerException {
                SQLServerStatement.this.procedureRetStatToken = new StreamRetStatus();
                SQLServerStatement.this.procedureRetStatToken.setFromTDS(tDSReader);
                return true;
            }

            boolean onRetValue(TDSReader tDSReader) throws SQLServerException {
                if (null == SQLServerStatement.this.procedureRetStatToken) {
                    Parameter parameter = new Parameter();
                    parameter.skipRetValStatus(tDSReader);
                    parameter.skipValue(tDSReader, true);
                    return true;
                }
                if (SQLServerStatement.this.consumeExecOutParam(tDSReader)) {
                    return true;
                }
                if (SQLServerStatement.this.expectCursorOutParams) {
                    Parameter parameter = new Parameter();
                    parameter.skipRetValStatus(tDSReader);
                    this.serverCursorId = parameter.getInt(tDSReader);
                    parameter.skipValue(tDSReader, true);
                    parameter = new Parameter();
                    parameter.skipRetValStatus(tDSReader);
                    this.serverCursorRowCount = parameter.getInt(tDSReader);
                    parameter.skipValue(tDSReader, true);
                    SQLServerStatement.this.expectCursorOutParams = false;
                    return true;
                }
                SQLServerStatement.this.moreResults = false;
                return false;
            }

            boolean onInfo(TDSReader tDSReader) throws SQLServerException {
                StreamInfo streamInfo = new StreamInfo();
                streamInfo.setFromTDS(tDSReader);
                if (16954 == streamInfo.msg.getErrorNumber()) {
                    this.executedSqlDirectly = true;
                }
                SQLWarning sQLWarning = new SQLWarning(streamInfo.msg.getMessage(), SQLServerException.generateStateCode(SQLServerStatement.this.connection, streamInfo.msg.getErrorNumber(), streamInfo.msg.getErrorState()), streamInfo.msg.getErrorNumber());
                if (SQLServerStatement.this.sqlWarnings == null) {
                    SQLServerStatement.this.sqlWarnings = new Vector();
                } else {
                    int n = SQLServerStatement.this.sqlWarnings.size();
                    SQLWarning sQLWarning2 = (SQLWarning)SQLServerStatement.this.sqlWarnings.elementAt(n - 1);
                    sQLWarning2.setNextWarning(sQLWarning);
                }
                SQLServerStatement.this.sqlWarnings.add(sQLWarning);
                return true;
            }
        }
        NextResult nextResult = new NextResult();
        TDSParser.parse(this.tdsReader, nextResult);
        if (null != nextResult.getDatabaseError()) {
            SQLServerException.makeFromDatabaseError(this.connection, null, nextResult.getDatabaseError().getMessage(), nextResult.getDatabaseError(), false);
        } else {
            if (null != nextResult.columnMetaDataToken) {
                this.resultSet = new SQLServerResultSet(this, nextResult.columnMetaDataToken.columns, nextResult.serverCursorId, nextResult.serverCursorRowCount);
                return true;
            }
            if (null != nextResult.stmtDoneToken) {
                this.updateCount = nextResult.stmtDoneToken.getUpdateCount();
                return true;
            }
        }
        this.updateCount = -1;
        if (!this.moreResults) {
            return true;
        }
        this.moreResults = false;
        return false;
    }

    boolean consumeExecOutParam(TDSReader tDSReader) throws SQLServerException {
        return false;
    }

    public final void setFetchDirection(int n) throws SQLServerException {
        this.checkClosed();
        if (1000 != n && 1001 != n && 1002 != n || 1000 != n && (2003 == this.resultSetType || 2004 == this.resultSetType)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidFetchDirection"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        this.nFetchDirection = n;
    }

    public final int getFetchDirection() throws SQLServerException {
        this.checkClosed();
        return this.nFetchDirection;
    }

    public final void setFetchSize(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 0) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidFetchSize"), null, false);
        }
        this.nFetchSize = 0 == n ? this.defaultFetchSize : n;
    }

    public final int getFetchSize() throws SQLServerException {
        this.checkClosed();
        return this.nFetchSize;
    }

    public final int getResultSetConcurrency() throws SQLServerException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    public final int getResultSetType() throws SQLServerException {
        this.checkClosed();
        return this.appResultSetType;
    }

    public void addBatch(String string) throws SQLServerException {
        this.checkClosed();
        if (null == this.batchStatementBuffer) {
            this.batchStatementBuffer = new StringBuffer(262144);
        }
        if (0 == this.batchSize) {
            this.batchStatementBuffer.append(string);
        } else {
            this.batchStatementBuffer.append(" ; " + string);
        }
        ++this.batchSize;
    }

    public void clearBatch() throws SQLServerException {
        this.checkClosed();
        this.batchStatementBuffer = null;
        this.batchSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLServerException, BatchUpdateException {
        this.checkClosed();
        try {
            this.userSQL = null;
            this.resetForReexecute();
            int[] nArray = new int[this.batchSize];
            for (int i = 0; i < this.batchSize; ++i) {
                nArray[i] = -3;
            }
            Throwable throwable = null;
            for (int i = 0; i < this.batchSize; ++i) {
                boolean bl = this.connection.isInTransaction();
                try {
                    if (0 == i) {
                        this.executeStatement(new StmtExecCmd(this, this.batchStatementBuffer.toString(), 4, 2));
                    } else {
                        this.startResults();
                        if (!this.getNextResult()) break;
                    }
                    if (null != this.resultSet) {
                        SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, true);
                        continue;
                    }
                    nArray[i] = -1 != this.updateCount ? this.updateCount : -2;
                    continue;
                }
                catch (SQLServerException sQLServerException) {
                    if (this.connection.isClosed() || bl && !this.connection.isInTransaction()) {
                        throw sQLServerException;
                    }
                    throwable = sQLServerException;
                }
            }
            if (null != throwable) {
                throw new BatchUpdateException(throwable.getMessage(), ((SQLException)throwable).getSQLState(), ((SQLException)throwable).getErrorCode(), nArray);
            }
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            this.batchStatementBuffer = null;
            this.batchSize = 0;
        }
    }

    public final Connection getConnection() throws SQLServerException {
        if (this.bIsClosed) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementIsClosed"), null, false);
        }
        return this.connection.getConnection();
    }

    final int getResultSetScrollOpt() {
        int n = null == this.inOutParam ? 0 : 4096;
        switch (this.resultSetType) {
            case 2004: {
                return n | (1007 == this.resultSetConcurrency ? 16 : 4);
            }
            case 1006: {
                return n | 2;
            }
            case 1005: {
                return n | 1;
            }
            case 1004: {
                return n | 8;
            }
        }
        return 0;
    }

    final int getResultSetCCOpt() {
        switch (this.resultSetConcurrency) {
            case 1007: {
                return 8193;
            }
            case 1008: {
                return 24580;
            }
            case 1009: {
                return 24578;
            }
            case 1010: {
                return 24584;
            }
        }
        return 0;
    }

    private final void doExecuteCursored(StmtExecCmd stmtExecCmd, String string) throws SQLServerException {
        if (stmtlogger.isLoggable(Level.FINE)) {
            stmtlogger.fine(this.toLogString() + " Execute for cursor open" + " SQL:" + string + " Scrollability:" + this.getResultSetScrollOpt() + " Concurrency:" + this.getResultSetCCOpt());
        }
        this.expectCursorOutParams = true;
        TDSWriter tDSWriter = stmtExecCmd.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)2);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        tDSWriter.writeRPCString(string);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetScrollOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        this.tdsReader = stmtExecCmd.startResponse(this.isResponseBufferingAdaptive);
        this.startResults();
        this.getNextResult();
    }

    public final int getResultSetHoldability() throws SQLServerException {
        this.checkClosed();
        return this.connection.getHoldability();
    }

    public final boolean execute(String string, int n) throws SQLServerException {
        this.checkClosed();
        if (n != 1 && n != 2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidAutoGeneratedKeys"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 3, n));
        return null != this.resultSet;
    }

    public final boolean execute(String string, int[] nArray) throws SQLServerException {
        this.checkClosed();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        return this.execute(string, 1);
    }

    public final boolean execute(String string, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        return this.execute(string, 1);
    }

    public final int executeUpdate(String string, int n) throws SQLServerException {
        this.checkClosed();
        if (n != 1 && n != 2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidAutoGeneratedKeys"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 2, n));
        return this.updateCount;
    }

    public final int executeUpdate(String string, int[] nArray) throws SQLServerException {
        this.checkClosed();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        return this.executeUpdate(string, 1);
    }

    public final int executeUpdate(String string, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        return this.executeUpdate(string, 1);
    }

    public final ResultSet getGeneratedKeys() throws SQLServerException {
        this.checkClosed();
        if (null == this.autoGeneratedKeys) {
            int n = this.updateCount;
            if (!this.getNextResult() || null == this.resultSet) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementMustBeExecuted"), null, false);
            }
            this.autoGeneratedKeys = this.resultSet;
            this.updateCount = n;
        }
        return this.autoGeneratedKeys;
    }

    public final boolean getMoreResults(int n) throws SQLServerException {
        this.checkClosed();
        if (2 == n) {
            this.NotImplemented();
        }
        if (1 != n && 3 != n) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_modeSuppliedNotValid"), null, true);
        }
        SQLServerResultSet sQLServerResultSet = this.resultSet;
        boolean bl = this.getMoreResults();
        if (sQLServerResultSet != null) {
            try {
                sQLServerResultSet.close();
            }
            catch (SQLException sQLException) {
                throw new SQLServerException(null, sQLException.getMessage(), null, 0, false);
            }
        }
        return bl;
    }

    public final void setResponseBuffering(String string) throws SQLServerException {
        this.checkClosed();
        if (string.equalsIgnoreCase("full")) {
            this.isResponseBufferingAdaptive = false;
            this.wasResponseBufferingSet = true;
        } else if (string.equalsIgnoreCase("adaptive")) {
            this.isResponseBufferingAdaptive = true;
            this.wasResponseBufferingSet = true;
        } else {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidresponseBuffering"));
            Object[] objectArray = new Object[]{new String(string)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
    }

    public final String getResponseBuffering() throws SQLServerException {
        this.checkClosed();
        if (this.wasResponseBufferingSet) {
            if (this.isResponseBufferingAdaptive) {
                return "adaptive";
            }
            return "full";
        }
        return this.connection.getResponseBuffering();
    }

    private final class StmtExecCmd
    extends TDSCommand {
        final SQLServerStatement stmt;
        final String sql;
        final int executeMethod;
        final int autoGeneratedKeys;

        StmtExecCmd(SQLServerStatement sQLServerStatement2, String string, int n, int n2) {
            super(sQLServerStatement2.toLogString() + " executeXXX", sQLServerStatement2.queryTimeout);
            this.stmt = sQLServerStatement2;
            this.sql = string;
            this.executeMethod = n;
            this.autoGeneratedKeys = n2;
        }

        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecuteStatement(this);
            return false;
        }

        final void processResponse(TDSReader tDSReader) throws SQLServerException {
            SQLServerStatement.this.processExecuteResults(tDSReader);
        }
    }

    final class ExecuteProperties {
        private final boolean wasResponseBufferingSet;
        private final boolean isResponseBufferingAdaptive;

        final boolean wasResponseBufferingSet() {
            return this.wasResponseBufferingSet;
        }

        final boolean isResponseBufferingAdaptive() {
            return this.isResponseBufferingAdaptive;
        }

        ExecuteProperties(SQLServerStatement sQLServerStatement2) {
            this.wasResponseBufferingSet = sQLServerStatement2.wasResponseBufferingSet();
            this.isResponseBufferingAdaptive = sQLServerStatement2.getIsResponseBufferingAdaptive();
        }
    }
}

