#  Copyright (c) 2022, Manfred Moitzi
#  License: MIT License

import pytest


@pytest.fixture(scope="module")
def cube_sab():
    return CUBE777_SAB_R2013


# fmt: off
CUBE777_SAB_R2013 = bytearray([
    0x41, 0x43, 0x49, 0x53, 0x20, 0x42, 0x69, 0x6E, 0x61, 0x72, 0x79, 0x46,
    0x69, 0x6C, 0x65, 0x28, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
    0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x07, 0x21, 0x4F, 0x70, 0x65,
    0x6E, 0x20, 0x44, 0x65, 0x73, 0x69, 0x67, 0x6E, 0x20, 0x41, 0x6C, 0x6C,
    0x69, 0x61, 0x6E, 0x63, 0x65, 0x20, 0x41, 0x43, 0x49, 0x53, 0x20, 0x42,
    0x75, 0x69, 0x6C, 0x64, 0x65, 0x72, 0x07, 0x0E, 0x41, 0x43, 0x49, 0x53,
    0x20, 0x32, 0x31, 0x38, 0x2E, 0x30, 0x30, 0x20, 0x4E, 0x54, 0x07, 0x18,
    0x4D, 0x6F, 0x6E, 0x20, 0x4D, 0x61, 0x79, 0x20, 0x20, 0x32, 0x20, 0x30,
    0x35, 0x3A, 0x33, 0x33, 0x3A, 0x32, 0x35, 0x20, 0x32, 0x30, 0x32, 0x32,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x06, 0x8D, 0xED,
    0xB5, 0xA0, 0xF7, 0xC6, 0xB0, 0x3E, 0x06, 0xBB, 0xBD, 0xD7, 0xD9, 0xDF,
    0x7C, 0xDB, 0x3D, 0x0D, 0x09, 0x61, 0x73, 0x6D, 0x68, 0x65, 0x61, 0x64,
    0x65, 0x72, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x07, 0x0C, 0x32, 0x30, 0x38, 0x2E, 0x30, 0x2E, 0x34, 0x2E, 0x37, 0x30,
    0x30, 0x39, 0x11, 0x0D, 0x04, 0x62, 0x6F, 0x64, 0x79, 0x0C, 0x02, 0x00,
    0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0x03, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x04,
    0x00, 0x00, 0x00, 0x11, 0x0E, 0x06, 0x72, 0x65, 0x66, 0x5F, 0x76, 0x74,
    0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69,
    0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x01, 0x00,
    0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x11, 0x0D, 0x04, 0x6C, 0x75, 0x6D, 0x70, 0x0C, 0x06, 0x00, 0x00, 0x00,
    0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0x07, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x00, 0x00,
    0x00, 0x11, 0x0D, 0x09, 0x74, 0x72, 0x61, 0x6E, 0x73, 0x66, 0x6F, 0x72,
    0x6D, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x12,
    0x44, 0x00, 0x00, 0x00, 0x31, 0x20, 0x30, 0x20, 0x30, 0x20, 0x30, 0x20,
    0x31, 0x20, 0x30, 0x20, 0x30, 0x20, 0x30, 0x20, 0x31, 0x20, 0x33, 0x38,
    0x38, 0x2E, 0x35, 0x20, 0x33, 0x38, 0x38, 0x2E, 0x35, 0x20, 0x33, 0x38,
    0x38, 0x2E, 0x35, 0x20, 0x31, 0x20, 0x6E, 0x6F, 0x5F, 0x72, 0x6F, 0x74,
    0x61, 0x74, 0x65, 0x20, 0x6E, 0x6F, 0x5F, 0x72, 0x65, 0x66, 0x6C, 0x65,
    0x63, 0x74, 0x20, 0x6E, 0x6F, 0x5F, 0x73, 0x68, 0x65, 0x61, 0x72, 0x20,
    0x11, 0x0D, 0x0E, 0x65, 0x79, 0x65, 0x5F, 0x72, 0x65, 0x66, 0x69, 0x6E,
    0x65, 0x6D, 0x65, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x07, 0x05, 0x67, 0x72, 0x69, 0x64, 0x20, 0x04, 0x01,
    0x00, 0x00, 0x00, 0x07, 0x03, 0x74, 0x72, 0x69, 0x04, 0x01, 0x00, 0x00,
    0x00, 0x07, 0x04, 0x73, 0x75, 0x72, 0x66, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x03, 0x61, 0x64, 0x6A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04,
    0x67, 0x72, 0x61, 0x64, 0x04, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x70,
    0x6F, 0x73, 0x74, 0x63, 0x68, 0x65, 0x63, 0x6B, 0x04, 0x00, 0x00, 0x00,
    0x00, 0x07, 0x04, 0x73, 0x74, 0x6F, 0x6C, 0x06, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x14, 0xC0, 0x07, 0x04, 0x6E, 0x74, 0x6F, 0x6C, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x40, 0x07, 0x04, 0x64, 0x73, 0x69,
    0x6C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08,
    0x66, 0x6C, 0x61, 0x74, 0x6E, 0x65, 0x73, 0x73, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x70, 0x69, 0x78, 0x61, 0x72,
    0x65, 0x61, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
    0x04, 0x68, 0x6D, 0x61, 0x78, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x07, 0x06, 0x67, 0x72, 0x69, 0x64, 0x61, 0x72, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x05, 0x6D, 0x67, 0x72,
    0x69, 0x64, 0x04, 0xB8, 0x0B, 0x00, 0x00, 0x07, 0x05, 0x75, 0x67, 0x72,
    0x69, 0x64, 0x04, 0x00, 0x00, 0x00, 0x00, 0x07, 0x05, 0x76, 0x67, 0x72,
    0x69, 0x64, 0x04, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0A, 0x65, 0x6E, 0x64,
    0x5F, 0x66, 0x69, 0x65, 0x6C, 0x64, 0x73, 0x11, 0x0E, 0x06, 0x72, 0x65,
    0x66, 0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x03, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x05, 0x73, 0x68, 0x65, 0x6C, 0x6C,
    0x0C, 0x08, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x09, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x03, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x06, 0x72, 0x65, 0x66, 0x5F, 0x76,
    0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72,
    0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x07,
    0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x0A, 0x00, 0x00,
    0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x0B, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x0C, 0x07, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0D, 0x00, 0x00, 0x00,
    0x0B, 0x0B, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65, 0x73, 0x68, 0x0E, 0x03,
    0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0E, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x0F, 0x00, 0x00, 0x00,
    0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x10,
    0x00, 0x00, 0x00, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x0C, 0x07, 0x00, 0x00,
    0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x12, 0x00, 0x00, 0x00, 0x0A,
    0x0B, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x13, 0x00, 0x00, 0x00, 0x0C, 0x09, 0x00,
    0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E, 0x65, 0x0D, 0x07,
    0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x14,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
    0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0E, 0x06, 0x72, 0x65, 0x66,
    0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74,
    0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0A, 0x00, 0x00, 0x00,
    0x0C, 0x09, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65, 0x73, 0x68, 0x0E,
    0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x14,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0B, 0x00, 0x00,
    0x00, 0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x15, 0x00, 0x00,
    0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x16, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0x00, 0x0C, 0x07, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x18, 0x00, 0x00, 0x00,
    0x0A, 0x0B, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x19, 0x00, 0x00, 0x00, 0x0C, 0x0B,
    0x00, 0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E, 0x65, 0x0D,
    0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0,
    0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0,
    0x3F, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x1A, 0x00, 0x00, 0x00,
    0x0C, 0x1B, 0x00, 0x00, 0x00, 0x0C, 0x1C, 0x00, 0x00, 0x00, 0x0C, 0x1D,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x06, 0x72, 0x65,
    0x66, 0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0F, 0x00, 0x00,
    0x00, 0x0C, 0x0B, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65, 0x73, 0x68,
    0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69,
    0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x1E, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x10, 0x00,
    0x00, 0x00, 0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x1F, 0x00,
    0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0x20, 0x00, 0x00, 0x00, 0x0C, 0x21, 0x00, 0x00, 0x00, 0x0C, 0x07,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x22, 0x00, 0x00,
    0x00, 0x0A, 0x0B, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x23, 0x00, 0x00, 0x00, 0x0C,
    0x10, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E, 0x65,
    0x0D, 0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xF0, 0x3F, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0D, 0x06, 0x63,
    0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x24, 0x00, 0x00,
    0x00, 0x0C, 0x25, 0x00, 0x00, 0x00, 0x0C, 0x26, 0x00, 0x00, 0x00, 0x0C,
    0x27, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63,
    0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x28, 0x00, 0x00,
    0x00, 0x0C, 0x13, 0x00, 0x00, 0x00, 0x0C, 0x29, 0x00, 0x00, 0x00, 0x0C,
    0x2A, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63,
    0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x13, 0x00, 0x00,
    0x00, 0x0C, 0x28, 0x00, 0x00, 0x00, 0x0C, 0x2B, 0x00, 0x00, 0x00, 0x0C,
    0x2C, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63,
    0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2D, 0x00, 0x00,
    0x00, 0x0C, 0x2E, 0x00, 0x00, 0x00, 0x0C, 0x13, 0x00, 0x00, 0x00, 0x0C,
    0x1D, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x2F, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65,
    0x64, 0x67, 0x65, 0x0C, 0x30, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x31, 0x00, 0x00, 0x00, 0x06,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x32, 0x00, 0x00,
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x1C,
    0x00, 0x00, 0x00, 0x0C, 0x33, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75,
    0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0E, 0x06, 0x72, 0x65, 0x66,
    0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74,
    0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x15, 0x00, 0x00, 0x00,
    0x0C, 0x10, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65, 0x73, 0x68, 0x0E,
    0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x34,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x16, 0x00, 0x00,
    0x00, 0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x35, 0x00, 0x00,
    0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x36, 0x00, 0x00, 0x00, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x0C, 0x07, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x38, 0x00, 0x00, 0x00,
    0x0A, 0x0B, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x39, 0x00, 0x00, 0x00, 0x0C, 0x16,
    0x00, 0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E, 0x65, 0x0D,
    0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xF0, 0xBF, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x3A, 0x00, 0x00, 0x00,
    0x0C, 0x2B, 0x00, 0x00, 0x00, 0x0C, 0x3B, 0x00, 0x00, 0x00, 0x0C, 0x3C,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x17, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x3D, 0x00, 0x00, 0x00,
    0x0C, 0x19, 0x00, 0x00, 0x00, 0x0C, 0x3A, 0x00, 0x00, 0x00, 0x0C, 0x3E,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x19, 0x00, 0x00, 0x00,
    0x0C, 0x3D, 0x00, 0x00, 0x00, 0x0C, 0x3F, 0x00, 0x00, 0x00, 0x0C, 0x40,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2E, 0x00, 0x00, 0x00,
    0x0C, 0x2D, 0x00, 0x00, 0x00, 0x0C, 0x19, 0x00, 0x00, 0x00, 0x0C, 0x27,
    0x00, 0x00, 0x00, 0x0A, 0x0C, 0x2F, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65, 0x64,
    0x67, 0x65, 0x0C, 0x41, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x42, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x43, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x26, 0x00,
    0x00, 0x00, 0x0C, 0x44, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E,
    0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64,
    0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x1B, 0x00, 0x00, 0x00, 0x0C, 0x1A,
    0x00, 0x00, 0x00, 0x0C, 0x45, 0x00, 0x00, 0x00, 0x0C, 0x46, 0x00, 0x00,
    0x00, 0x0B, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64,
    0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x47, 0x00, 0x00, 0x00, 0x0C, 0x48,
    0x00, 0x00, 0x00, 0x0C, 0x1A, 0x00, 0x00, 0x00, 0x0C, 0x2A, 0x00, 0x00,
    0x00, 0x0A, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65, 0x64, 0x67, 0x65,
    0x0C, 0x49, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0x32, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x29, 0x00, 0x00, 0x00,
    0x0C, 0x4B, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E, 0x6B, 0x6E,
    0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64, 0x67, 0x65,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0x23, 0x00, 0x00, 0x00, 0x0C, 0x4C, 0x00, 0x00,
    0x00, 0x0C, 0x1B, 0x00, 0x00, 0x00, 0x0C, 0x2C, 0x00, 0x00, 0x00, 0x0A,
    0x0C, 0x17, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65, 0x64, 0x67, 0x65, 0x0C, 0x4D,
    0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x4E, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0xC0, 0x0C, 0x31, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x2B, 0x00, 0x00, 0x00, 0x0C, 0x4F,
    0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77,
    0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x26, 0x00, 0x00, 0x00, 0x0C, 0x1C, 0x00, 0x00, 0x00, 0x0C,
    0x4C, 0x00, 0x00, 0x00, 0x0C, 0x50, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x2F,
    0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x1C, 0x00, 0x00, 0x00, 0x0C, 0x26, 0x00, 0x00, 0x00, 0x0C,
    0x47, 0x00, 0x00, 0x00, 0x0C, 0x51, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x2F,
    0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2D, 0x00, 0x00, 0x00, 0x0C, 0x36, 0x00,
    0x00, 0x00, 0x11, 0x0E, 0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74, 0x0E,
    0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x1D, 0x00, 0x00,
    0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00, 0x0C,
    0x52, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72, 0x74, 0x65,
    0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00,
    0x00, 0x00, 0x0C, 0x53, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73, 0x74,
    0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72, 0x76,
    0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0x40, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0E, 0x06, 0x72,
    0x65, 0x66, 0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06,
    0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x1F, 0x00,
    0x00, 0x00, 0x0C, 0x16, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65, 0x73,
    0x68, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72,
    0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0x54, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x20,
    0x00, 0x00, 0x00, 0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x55,
    0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2F, 0x00, 0x00, 0x00, 0x0C,
    0x07, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x56, 0x00,
    0x00, 0x00, 0x0A, 0x0B, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x47, 0x00, 0x00, 0x00,
    0x0C, 0x20, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E,
    0x65, 0x0D, 0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0xBF, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0D, 0x06,
    0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x57, 0x00,
    0x00, 0x00, 0x0C, 0x45, 0x00, 0x00, 0x00, 0x0C, 0x48, 0x00, 0x00, 0x00,
    0x0C, 0x58, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x21, 0x00, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06,
    0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x4C, 0x00,
    0x00, 0x00, 0x0C, 0x23, 0x00, 0x00, 0x00, 0x0C, 0x24, 0x00, 0x00, 0x00,
    0x0C, 0x3E, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x17, 0x00, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06,
    0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x45, 0x00,
    0x00, 0x00, 0x0C, 0x57, 0x00, 0x00, 0x00, 0x0C, 0x23, 0x00, 0x00, 0x00,
    0x0C, 0x3C, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x21, 0x00, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0x59, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x4E, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x5A, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C,
    0x3B, 0x00, 0x00, 0x00, 0x0C, 0x5B, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07,
    0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x25, 0x00, 0x00, 0x00,
    0x0C, 0x24, 0x00, 0x00, 0x00, 0x0C, 0x57, 0x00, 0x00, 0x00, 0x0C, 0x5C,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65, 0x64,
    0x67, 0x65, 0x0C, 0x5D, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x43, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x5A, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x3A, 0x00,
    0x00, 0x00, 0x0C, 0x5E, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E,
    0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64,
    0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x48, 0x00, 0x00, 0x00, 0x0C, 0x47,
    0x00, 0x00, 0x00, 0x0C, 0x25, 0x00, 0x00, 0x00, 0x0C, 0x40, 0x00, 0x00,
    0x00, 0x0A, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65, 0x64, 0x67, 0x65,
    0x0C, 0x5F, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0x60, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x42, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x3F, 0x00, 0x00, 0x00,
    0x0C, 0x61, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E, 0x6B, 0x6E,
    0x6F, 0x77, 0x6E, 0x11, 0x0E, 0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74,
    0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69,
    0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x27, 0x00,
    0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0x27, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00,
    0x0C, 0x62, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72, 0x74,
    0x65, 0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x50, 0x00, 0x00, 0x00, 0x04, 0x02,
    0x00, 0x00, 0x00, 0x0C, 0x63, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73,
    0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72,
    0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0D, 0x06,
    0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x39, 0x00,
    0x00, 0x00, 0x0C, 0x3B, 0x00, 0x00, 0x00, 0x0C, 0x28, 0x00, 0x00, 0x00,
    0x0C, 0x46, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x21, 0x00, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0x64, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x4A, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x4E, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C,
    0x45, 0x00, 0x00, 0x00, 0x0C, 0x65, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07,
    0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x3F, 0x00, 0x00, 0x00,
    0x0C, 0x29, 0x00, 0x00, 0x00, 0x0C, 0x2E, 0x00, 0x00, 0x00, 0x0C, 0x51,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x29, 0x00, 0x00, 0x00,
    0x0C, 0x3F, 0x00, 0x00, 0x00, 0x0C, 0x39, 0x00, 0x00, 0x00, 0x0C, 0x58,
    0x00, 0x00, 0x00, 0x0A, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x06, 0x70, 0x74,
    0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x2A, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72,
    0x74, 0x65, 0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2A, 0x00, 0x00, 0x00, 0x04,
    0x02, 0x00, 0x00, 0x00, 0x0C, 0x66, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08,
    0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75,
    0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x14, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0xBF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0D,
    0x06, 0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2B,
    0x00, 0x00, 0x00, 0x0C, 0x3A, 0x00, 0x00, 0x00, 0x0C, 0x2D, 0x00, 0x00,
    0x00, 0x0C, 0x50, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x17, 0x00, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E,
    0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65,
    0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2C, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06,
    0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x46, 0x00,
    0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00, 0x0C, 0x67, 0x00, 0x00, 0x00,
    0x11, 0x0E, 0x08, 0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D,
    0x05, 0x63, 0x75, 0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x14, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B,
    0x0B, 0x11, 0x0D, 0x04, 0x65, 0x64, 0x67, 0x65, 0x0C, 0x68, 0x00, 0x00,
    0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x31, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78,
    0xC0, 0x0C, 0x43, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0x40, 0x0C, 0x2D, 0x00, 0x00, 0x00, 0x0C, 0x69, 0x00, 0x00,
    0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11,
    0x0D, 0x04, 0x65, 0x64, 0x67, 0x65, 0x0C, 0x6A, 0x00, 0x00, 0x00, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x32, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C,
    0x42, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78,
    0x40, 0x0C, 0x2E, 0x00, 0x00, 0x00, 0x0C, 0x6B, 0x00, 0x00, 0x00, 0x0B,
    0x07, 0x07, 0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x05,
    0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78,
    0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x11, 0x0D, 0x05,
    0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x11, 0x0E, 0x06,
    0x72, 0x65, 0x66, 0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D,
    0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x35,
    0x00, 0x00, 0x00, 0x0C, 0x20, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00,
    0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65,
    0x73, 0x68, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74,
    0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x6C, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x36, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E, 0x65,
    0x0D, 0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xF0, 0x3F, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0D, 0x06, 0x63,
    0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x3B, 0x00, 0x00,
    0x00, 0x0C, 0x39, 0x00, 0x00, 0x00, 0x0C, 0x3D, 0x00, 0x00, 0x00, 0x0C,
    0x5C, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x21, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65,
    0x64, 0x67, 0x65, 0x0C, 0x6D, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x4A, 0x00, 0x00, 0x00, 0x06,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x60, 0x00, 0x00,
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x48,
    0x00, 0x00, 0x00, 0x0C, 0x6E, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75,
    0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0E, 0x06, 0x70, 0x74, 0x6C,
    0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74,
    0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0x3C, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72, 0x74,
    0x65, 0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x5C, 0x00, 0x00, 0x00, 0x04, 0x02,
    0x00, 0x00, 0x00, 0x0C, 0x6F, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73,
    0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72,
    0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x0B, 0x0B, 0x11, 0x0D, 0x04,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0x70, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x5A, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x60, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C,
    0x57, 0x00, 0x00, 0x00, 0x0C, 0x71, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07,
    0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0E, 0x06, 0x70, 0x74,
    0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x3E, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73, 0x74, 0x72,
    0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72, 0x76, 0x65,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x48, 0x78, 0xC0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0,
    0xBF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0E, 0x06, 0x70, 0x74,
    0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x40, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72,
    0x74, 0x65, 0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x40, 0x00, 0x00, 0x00, 0x04,
    0x02, 0x00, 0x00, 0x00, 0x0C, 0x72, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08,
    0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75,
    0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x14, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0D,
    0x05, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x11, 0x0D,
    0x05, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x11, 0x0E,
    0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65,
    0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x46, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08,
    0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75,
    0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x14, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0D,
    0x05, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x11, 0x0D,
    0x05, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x11, 0x0E,
    0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65,
    0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x50, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08,
    0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75,
    0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x0B, 0x0B, 0x11, 0x0E,
    0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65,
    0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x51, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08,
    0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75,
    0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x0B, 0x0B, 0x11, 0x0E,
    0x06, 0x72, 0x65, 0x66, 0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65,
    0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x55, 0x00, 0x00, 0x00, 0x0C, 0x36, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x06, 0x70, 0x74,
    0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x58, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73, 0x74, 0x72,
    0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72, 0x76, 0x65,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xF0, 0xBF, 0x0B, 0x0B, 0x11, 0x0D, 0x05, 0x70, 0x6F,
    0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x11, 0x0E, 0x06, 0x70, 0x74,
    0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x5C, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73, 0x74, 0x72,
    0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72, 0x76, 0x65,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x48, 0x78, 0xC0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0D, 0x05, 0x70, 0x6F,
    0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x11, 0x0E, 0x03, 0x45, 0x6E,
    0x64, 0x0E, 0x02, 0x6F, 0x66, 0x0E, 0x03, 0x41, 0x53, 0x4D, 0x0D, 0x04,
    0x64, 0x61, 0x74, 0x61
])

CUBE777_SAB_R2018 = bytearray([
    0x41, 0x53, 0x4D, 0x20, 0x42, 0x69, 0x6E, 0x61, 0x72, 0x79, 0x46, 0x69,
    0x6C, 0x65, 0x34, 0x1C, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
    0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x07, 0x21, 0x4F, 0x70, 0x65,
    0x6E, 0x20, 0x44, 0x65, 0x73, 0x69, 0x67, 0x6E, 0x20, 0x41, 0x6C, 0x6C,
    0x69, 0x61, 0x6E, 0x63, 0x65, 0x20, 0x41, 0x43, 0x49, 0x53, 0x20, 0x42,
    0x75, 0x69, 0x6C, 0x64, 0x65, 0x72, 0x07, 0x0E, 0x41, 0x43, 0x49, 0x53,
    0x20, 0x32, 0x32, 0x33, 0x2E, 0x30, 0x30, 0x20, 0x4E, 0x54, 0x07, 0x18,
    0x4D, 0x6F, 0x6E, 0x20, 0x4D, 0x61, 0x79, 0x20, 0x20, 0x39, 0x20, 0x31,
    0x34, 0x3A, 0x35, 0x34, 0x3A, 0x31, 0x38, 0x20, 0x32, 0x30, 0x32, 0x32,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x06, 0x8D, 0xED,
    0xB5, 0xA0, 0xF7, 0xC6, 0xB0, 0x3E, 0x06, 0xBB, 0xBD, 0xD7, 0xD9, 0xDF,
    0x7C, 0xDB, 0x3D, 0x0D, 0x09, 0x61, 0x73, 0x6D, 0x68, 0x65, 0x61, 0x64,
    0x65, 0x72, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x07, 0x0C, 0x32, 0x30, 0x38, 0x2E, 0x30, 0x2E, 0x34, 0x2E, 0x37, 0x30,
    0x30, 0x39, 0x11, 0x0D, 0x04, 0x62, 0x6F, 0x64, 0x79, 0x0C, 0x02, 0x00,
    0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0x03, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x04,
    0x00, 0x00, 0x00, 0x11, 0x0E, 0x06, 0x72, 0x65, 0x66, 0x5F, 0x76, 0x74,
    0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69,
    0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x01, 0x00,
    0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x11, 0x0D, 0x04, 0x6C, 0x75, 0x6D, 0x70, 0x0C, 0x06, 0x00, 0x00, 0x00,
    0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0x07, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x00, 0x00,
    0x00, 0x11, 0x0D, 0x09, 0x74, 0x72, 0x61, 0x6E, 0x73, 0x66, 0x6F, 0x72,
    0x6D, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x12,
    0x44, 0x00, 0x00, 0x00, 0x31, 0x20, 0x30, 0x20, 0x30, 0x20, 0x30, 0x20,
    0x31, 0x20, 0x30, 0x20, 0x30, 0x20, 0x30, 0x20, 0x31, 0x20, 0x33, 0x38,
    0x38, 0x2E, 0x35, 0x20, 0x33, 0x38, 0x38, 0x2E, 0x35, 0x20, 0x33, 0x38,
    0x38, 0x2E, 0x35, 0x20, 0x31, 0x20, 0x6E, 0x6F, 0x5F, 0x72, 0x6F, 0x74,
    0x61, 0x74, 0x65, 0x20, 0x6E, 0x6F, 0x5F, 0x72, 0x65, 0x66, 0x6C, 0x65,
    0x63, 0x74, 0x20, 0x6E, 0x6F, 0x5F, 0x73, 0x68, 0x65, 0x61, 0x72, 0x20,
    0x11, 0x0D, 0x0E, 0x65, 0x79, 0x65, 0x5F, 0x72, 0x65, 0x66, 0x69, 0x6E,
    0x65, 0x6D, 0x65, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x07, 0x05, 0x67, 0x72, 0x69, 0x64, 0x20, 0x04, 0x01,
    0x00, 0x00, 0x00, 0x07, 0x03, 0x74, 0x72, 0x69, 0x04, 0x01, 0x00, 0x00,
    0x00, 0x07, 0x04, 0x73, 0x75, 0x72, 0x66, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x03, 0x61, 0x64, 0x6A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04,
    0x67, 0x72, 0x61, 0x64, 0x04, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x70,
    0x6F, 0x73, 0x74, 0x63, 0x68, 0x65, 0x63, 0x6B, 0x04, 0x00, 0x00, 0x00,
    0x00, 0x07, 0x04, 0x73, 0x74, 0x6F, 0x6C, 0x06, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x14, 0xC0, 0x07, 0x04, 0x6E, 0x74, 0x6F, 0x6C, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x40, 0x07, 0x04, 0x64, 0x73, 0x69,
    0x6C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08,
    0x66, 0x6C, 0x61, 0x74, 0x6E, 0x65, 0x73, 0x73, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x70, 0x69, 0x78, 0x61, 0x72,
    0x65, 0x61, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
    0x04, 0x68, 0x6D, 0x61, 0x78, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x07, 0x06, 0x67, 0x72, 0x69, 0x64, 0x61, 0x72, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x05, 0x6D, 0x67, 0x72,
    0x69, 0x64, 0x04, 0xB8, 0x0B, 0x00, 0x00, 0x07, 0x05, 0x75, 0x67, 0x72,
    0x69, 0x64, 0x04, 0x00, 0x00, 0x00, 0x00, 0x07, 0x05, 0x76, 0x67, 0x72,
    0x69, 0x64, 0x04, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0A, 0x65, 0x6E, 0x64,
    0x5F, 0x66, 0x69, 0x65, 0x6C, 0x64, 0x73, 0x11, 0x0E, 0x06, 0x72, 0x65,
    0x66, 0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x03, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x05, 0x73, 0x68, 0x65, 0x6C, 0x6C,
    0x0C, 0x08, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x09, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x03, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x06, 0x72, 0x65, 0x66, 0x5F, 0x76,
    0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72,
    0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x07,
    0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x0A, 0x00, 0x00,
    0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x0B, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x0C, 0x07, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0D, 0x00, 0x00, 0x00,
    0x0B, 0x0B, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65, 0x73, 0x68, 0x0E, 0x03,
    0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0E, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x0F, 0x00, 0x00, 0x00,
    0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x10,
    0x00, 0x00, 0x00, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x0C, 0x07, 0x00, 0x00,
    0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x12, 0x00, 0x00, 0x00, 0x0A,
    0x0B, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x13, 0x00, 0x00, 0x00, 0x0C, 0x09, 0x00,
    0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E, 0x65, 0x0D, 0x07,
    0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x14,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
    0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0E, 0x06, 0x72, 0x65, 0x66,
    0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74,
    0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0A, 0x00, 0x00, 0x00,
    0x0C, 0x09, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65, 0x73, 0x68, 0x0E,
    0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x14,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0B, 0x00, 0x00,
    0x00, 0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x15, 0x00, 0x00,
    0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x16, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0x00, 0x0C, 0x07, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x18, 0x00, 0x00, 0x00,
    0x0A, 0x0B, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x19, 0x00, 0x00, 0x00, 0x0C, 0x0B,
    0x00, 0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E, 0x65, 0x0D,
    0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0,
    0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0,
    0x3F, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x1A, 0x00, 0x00, 0x00,
    0x0C, 0x1B, 0x00, 0x00, 0x00, 0x0C, 0x1C, 0x00, 0x00, 0x00, 0x0C, 0x1D,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x06, 0x72, 0x65,
    0x66, 0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0F, 0x00, 0x00,
    0x00, 0x0C, 0x0B, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65, 0x73, 0x68,
    0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69,
    0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x1E, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x10, 0x00,
    0x00, 0x00, 0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x1F, 0x00,
    0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0x20, 0x00, 0x00, 0x00, 0x0C, 0x21, 0x00, 0x00, 0x00, 0x0C, 0x07,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x22, 0x00, 0x00,
    0x00, 0x0A, 0x0B, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x23, 0x00, 0x00, 0x00, 0x0C,
    0x10, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E, 0x65,
    0x0D, 0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xF0, 0x3F, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0D, 0x06, 0x63,
    0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x24, 0x00, 0x00,
    0x00, 0x0C, 0x25, 0x00, 0x00, 0x00, 0x0C, 0x26, 0x00, 0x00, 0x00, 0x0C,
    0x27, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63,
    0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x28, 0x00, 0x00,
    0x00, 0x0C, 0x13, 0x00, 0x00, 0x00, 0x0C, 0x29, 0x00, 0x00, 0x00, 0x0C,
    0x2A, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63,
    0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x13, 0x00, 0x00,
    0x00, 0x0C, 0x28, 0x00, 0x00, 0x00, 0x0C, 0x2B, 0x00, 0x00, 0x00, 0x0C,
    0x2C, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63,
    0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2D, 0x00, 0x00,
    0x00, 0x0C, 0x2E, 0x00, 0x00, 0x00, 0x0C, 0x13, 0x00, 0x00, 0x00, 0x0C,
    0x1D, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x2F, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65,
    0x64, 0x67, 0x65, 0x0C, 0x30, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x31, 0x00, 0x00, 0x00, 0x06,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x32, 0x00, 0x00,
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x1C,
    0x00, 0x00, 0x00, 0x0C, 0x33, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75,
    0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0E, 0x06, 0x72, 0x65, 0x66,
    0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74,
    0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x15, 0x00, 0x00, 0x00,
    0x0C, 0x10, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65, 0x73, 0x68, 0x0E,
    0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x34,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x16, 0x00, 0x00,
    0x00, 0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x35, 0x00, 0x00,
    0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x36, 0x00, 0x00, 0x00, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x0C, 0x07, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x38, 0x00, 0x00, 0x00,
    0x0A, 0x0B, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x39, 0x00, 0x00, 0x00, 0x0C, 0x16,
    0x00, 0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E, 0x65, 0x0D,
    0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xF0, 0xBF, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x3A, 0x00, 0x00, 0x00,
    0x0C, 0x2B, 0x00, 0x00, 0x00, 0x0C, 0x3B, 0x00, 0x00, 0x00, 0x0C, 0x3C,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x17, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x3D, 0x00, 0x00, 0x00,
    0x0C, 0x19, 0x00, 0x00, 0x00, 0x0C, 0x3A, 0x00, 0x00, 0x00, 0x0C, 0x3E,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x19, 0x00, 0x00, 0x00,
    0x0C, 0x3D, 0x00, 0x00, 0x00, 0x0C, 0x3F, 0x00, 0x00, 0x00, 0x0C, 0x40,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2E, 0x00, 0x00, 0x00,
    0x0C, 0x2D, 0x00, 0x00, 0x00, 0x0C, 0x19, 0x00, 0x00, 0x00, 0x0C, 0x27,
    0x00, 0x00, 0x00, 0x0A, 0x0C, 0x2F, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65, 0x64,
    0x67, 0x65, 0x0C, 0x41, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x42, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x43, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x26, 0x00,
    0x00, 0x00, 0x0C, 0x44, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E,
    0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64,
    0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x1B, 0x00, 0x00, 0x00, 0x0C, 0x1A,
    0x00, 0x00, 0x00, 0x0C, 0x45, 0x00, 0x00, 0x00, 0x0C, 0x46, 0x00, 0x00,
    0x00, 0x0B, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64,
    0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x47, 0x00, 0x00, 0x00, 0x0C, 0x48,
    0x00, 0x00, 0x00, 0x0C, 0x1A, 0x00, 0x00, 0x00, 0x0C, 0x2A, 0x00, 0x00,
    0x00, 0x0A, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65, 0x64, 0x67, 0x65,
    0x0C, 0x49, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0x32, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x29, 0x00, 0x00, 0x00,
    0x0C, 0x4B, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E, 0x6B, 0x6E,
    0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64, 0x67, 0x65,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0x23, 0x00, 0x00, 0x00, 0x0C, 0x4C, 0x00, 0x00,
    0x00, 0x0C, 0x1B, 0x00, 0x00, 0x00, 0x0C, 0x2C, 0x00, 0x00, 0x00, 0x0A,
    0x0C, 0x17, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65, 0x64, 0x67, 0x65, 0x0C, 0x4D,
    0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x4E, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0xC0, 0x0C, 0x31, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x2B, 0x00, 0x00, 0x00, 0x0C, 0x4F,
    0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77,
    0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x26, 0x00, 0x00, 0x00, 0x0C, 0x1C, 0x00, 0x00, 0x00, 0x0C,
    0x4C, 0x00, 0x00, 0x00, 0x0C, 0x50, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x2F,
    0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x1C, 0x00, 0x00, 0x00, 0x0C, 0x26, 0x00, 0x00, 0x00, 0x0C,
    0x47, 0x00, 0x00, 0x00, 0x0C, 0x51, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x2F,
    0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2D, 0x00, 0x00, 0x00, 0x0C, 0x36, 0x00,
    0x00, 0x00, 0x11, 0x0E, 0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74, 0x0E,
    0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x1D, 0x00, 0x00,
    0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00, 0x0C,
    0x52, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72, 0x74, 0x65,
    0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00,
    0x00, 0x00, 0x0C, 0x53, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73, 0x74,
    0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72, 0x76,
    0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0x40, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0E, 0x06, 0x72,
    0x65, 0x66, 0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06,
    0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x1F, 0x00,
    0x00, 0x00, 0x0C, 0x16, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00, 0x00,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65, 0x73,
    0x68, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72,
    0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0x54, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x20,
    0x00, 0x00, 0x00, 0x11, 0x0D, 0x04, 0x66, 0x61, 0x63, 0x65, 0x0C, 0x55,
    0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2F, 0x00, 0x00, 0x00, 0x0C,
    0x07, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x56, 0x00,
    0x00, 0x00, 0x0A, 0x0B, 0x11, 0x0D, 0x04, 0x6C, 0x6F, 0x6F, 0x70, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x47, 0x00, 0x00, 0x00,
    0x0C, 0x20, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E,
    0x65, 0x0D, 0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0xBF, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0D, 0x06,
    0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x57, 0x00,
    0x00, 0x00, 0x0C, 0x45, 0x00, 0x00, 0x00, 0x0C, 0x48, 0x00, 0x00, 0x00,
    0x0C, 0x58, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x21, 0x00, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06,
    0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x4C, 0x00,
    0x00, 0x00, 0x0C, 0x23, 0x00, 0x00, 0x00, 0x0C, 0x24, 0x00, 0x00, 0x00,
    0x0C, 0x3E, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x17, 0x00, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06,
    0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x45, 0x00,
    0x00, 0x00, 0x0C, 0x57, 0x00, 0x00, 0x00, 0x0C, 0x23, 0x00, 0x00, 0x00,
    0x0C, 0x3C, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x21, 0x00, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0x59, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x4E, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x5A, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C,
    0x3B, 0x00, 0x00, 0x00, 0x0C, 0x5B, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07,
    0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x25, 0x00, 0x00, 0x00,
    0x0C, 0x24, 0x00, 0x00, 0x00, 0x0C, 0x57, 0x00, 0x00, 0x00, 0x0C, 0x5C,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65, 0x64,
    0x67, 0x65, 0x0C, 0x5D, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x43, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x5A, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x3A, 0x00,
    0x00, 0x00, 0x0C, 0x5E, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E,
    0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F, 0x65, 0x64,
    0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x48, 0x00, 0x00, 0x00, 0x0C, 0x47,
    0x00, 0x00, 0x00, 0x0C, 0x25, 0x00, 0x00, 0x00, 0x0C, 0x40, 0x00, 0x00,
    0x00, 0x0A, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65, 0x64, 0x67, 0x65,
    0x0C, 0x5F, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0x60, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x42, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x3F, 0x00, 0x00, 0x00,
    0x0C, 0x61, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E, 0x6B, 0x6E,
    0x6F, 0x77, 0x6E, 0x11, 0x0E, 0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74,
    0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69,
    0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x27, 0x00,
    0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0x27, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00,
    0x0C, 0x62, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72, 0x74,
    0x65, 0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x50, 0x00, 0x00, 0x00, 0x04, 0x02,
    0x00, 0x00, 0x00, 0x0C, 0x63, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73,
    0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72,
    0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0D, 0x06,
    0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x39, 0x00,
    0x00, 0x00, 0x0C, 0x3B, 0x00, 0x00, 0x00, 0x0C, 0x28, 0x00, 0x00, 0x00,
    0x0C, 0x46, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x21, 0x00, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0x64, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x4A, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x4E, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C,
    0x45, 0x00, 0x00, 0x00, 0x0C, 0x65, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07,
    0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x3F, 0x00, 0x00, 0x00,
    0x0C, 0x29, 0x00, 0x00, 0x00, 0x0C, 0x2E, 0x00, 0x00, 0x00, 0x0C, 0x51,
    0x00, 0x00, 0x00, 0x0B, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x06, 0x63, 0x6F,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x29, 0x00, 0x00, 0x00,
    0x0C, 0x3F, 0x00, 0x00, 0x00, 0x0C, 0x39, 0x00, 0x00, 0x00, 0x0C, 0x58,
    0x00, 0x00, 0x00, 0x0A, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x06, 0x70, 0x74,
    0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x2A, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72,
    0x74, 0x65, 0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2A, 0x00, 0x00, 0x00, 0x04,
    0x02, 0x00, 0x00, 0x00, 0x0C, 0x66, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08,
    0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75,
    0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x14, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0xBF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0D,
    0x06, 0x63, 0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2B,
    0x00, 0x00, 0x00, 0x0C, 0x3A, 0x00, 0x00, 0x00, 0x0C, 0x2D, 0x00, 0x00,
    0x00, 0x0C, 0x50, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x17, 0x00, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E,
    0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65,
    0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x2C, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06,
    0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x46, 0x00,
    0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00, 0x0C, 0x67, 0x00, 0x00, 0x00,
    0x11, 0x0E, 0x08, 0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D,
    0x05, 0x63, 0x75, 0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x14, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B,
    0x0B, 0x11, 0x0D, 0x04, 0x65, 0x64, 0x67, 0x65, 0x0C, 0x68, 0x00, 0x00,
    0x00, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x31, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78,
    0xC0, 0x0C, 0x43, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0x40, 0x0C, 0x2D, 0x00, 0x00, 0x00, 0x0C, 0x69, 0x00, 0x00,
    0x00, 0x0B, 0x07, 0x07, 0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11,
    0x0D, 0x04, 0x65, 0x64, 0x67, 0x65, 0x0C, 0x6A, 0x00, 0x00, 0x00, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x32, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C,
    0x42, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78,
    0x40, 0x0C, 0x2E, 0x00, 0x00, 0x00, 0x0C, 0x6B, 0x00, 0x00, 0x00, 0x0B,
    0x07, 0x07, 0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0D, 0x05,
    0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78,
    0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x11, 0x0D, 0x05,
    0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x11, 0x0E, 0x06,
    0x72, 0x65, 0x66, 0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D,
    0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x35,
    0x00, 0x00, 0x00, 0x0C, 0x20, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00, 0x00,
    0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x05, 0x66, 0x6D, 0x65,
    0x73, 0x68, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74, 0x74,
    0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x6C, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x36, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x05, 0x70, 0x6C, 0x61, 0x6E, 0x65,
    0x0D, 0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x0C, 0xFF, 0xFF,
    0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xF0, 0x3F, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0D, 0x06, 0x63,
    0x6F, 0x65, 0x64, 0x67, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x3B, 0x00, 0x00,
    0x00, 0x0C, 0x39, 0x00, 0x00, 0x00, 0x0C, 0x3D, 0x00, 0x00, 0x00, 0x0C,
    0x5C, 0x00, 0x00, 0x00, 0x0A, 0x0C, 0x21, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0D, 0x04, 0x65,
    0x64, 0x67, 0x65, 0x0C, 0x6D, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x4A, 0x00, 0x00, 0x00, 0x06,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x60, 0x00, 0x00,
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C, 0x48,
    0x00, 0x00, 0x00, 0x0C, 0x6E, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07, 0x75,
    0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0E, 0x06, 0x70, 0x74, 0x6C,
    0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61, 0x74,
    0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0x3C, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72, 0x74,
    0x65, 0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x5C, 0x00, 0x00, 0x00, 0x04, 0x02,
    0x00, 0x00, 0x00, 0x0C, 0x6F, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73,
    0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72,
    0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x0B, 0x0B, 0x11, 0x0D, 0x04,
    0x65, 0x64, 0x67, 0x65, 0x0C, 0x70, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF,
    0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x5A, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x0C, 0x60, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x0C,
    0x57, 0x00, 0x00, 0x00, 0x0C, 0x71, 0x00, 0x00, 0x00, 0x0B, 0x07, 0x07,
    0x75, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x11, 0x0E, 0x06, 0x70, 0x74,
    0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x3E, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73, 0x74, 0x72,
    0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72, 0x76, 0x65,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x48, 0x78, 0xC0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0,
    0xBF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0E, 0x06, 0x70, 0x74,
    0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x40, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x06, 0x76, 0x65, 0x72,
    0x74, 0x65, 0x78, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x40, 0x00, 0x00, 0x00, 0x04,
    0x02, 0x00, 0x00, 0x00, 0x0C, 0x72, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08,
    0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75,
    0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x14, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0D,
    0x05, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x11, 0x0D,
    0x05, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x11, 0x0E,
    0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65,
    0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x46, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08,
    0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75,
    0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x14, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0D,
    0x05, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x11, 0x0D,
    0x05, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
    0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x11, 0x0E,
    0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65,
    0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x50, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08,
    0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75,
    0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x0B, 0x0B, 0x11, 0x0E,
    0x06, 0x70, 0x74, 0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65,
    0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x51, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08,
    0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75,
    0x72, 0x76, 0x65, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF, 0x0B, 0x0B, 0x11, 0x0E,
    0x06, 0x72, 0x65, 0x66, 0x5F, 0x76, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65,
    0x0D, 0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C,
    0x55, 0x00, 0x00, 0x00, 0x0C, 0x36, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x11, 0x0E, 0x06, 0x70, 0x74,
    0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x58, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73, 0x74, 0x72,
    0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72, 0x76, 0x65,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xF0, 0xBF, 0x0B, 0x0B, 0x11, 0x0D, 0x05, 0x70, 0x6F,
    0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x11, 0x0E, 0x06, 0x70, 0x74,
    0x6C, 0x69, 0x73, 0x74, 0x0E, 0x03, 0x65, 0x79, 0x65, 0x0D, 0x06, 0x61,
    0x74, 0x74, 0x72, 0x69, 0x62, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF,
    0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0x5C, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x08, 0x73, 0x74, 0x72,
    0x61, 0x69, 0x67, 0x68, 0x74, 0x0D, 0x05, 0x63, 0x75, 0x72, 0x76, 0x65,
    0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF,
    0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x48, 0x78, 0xC0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x11, 0x0D, 0x05, 0x70, 0x6F,
    0x69, 0x6E, 0x74, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF,
    0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x78, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x78, 0xC0, 0x11, 0x0E, 0x03, 0x45, 0x6E,
    0x64, 0x0E, 0x02, 0x6F, 0x66, 0x0E, 0x03, 0x41, 0x53, 0x4D, 0x0D, 0x04,
    0x64, 0x61, 0x74, 0x61
])
# fmt: on


@pytest.fixture(scope="module")
def prism_sat():
    return PRISM


PRISM = """700 0 1 0 
@33 Open Design Alliance ACIS Builder @12 ACIS 32.0 NT @24 Sat Apr 23 14:32:04 2022 
1 9.9999999999999995e-007 1e-010 
body $-1 -1 $-1 $1 $-1 $-1 #
lump $-1 -1 $-1 $-1 $2 $0 #
shell $-1 -1 $-1 $-1 $-1 $3 $-1 $1 #
face $-1 -1 $-1 $4 $5 $2 $-1 $6 forward single #
face $-1 -1 $-1 $7 $8 $2 $-1 $9 forward single #
loop $-1 -1 $-1 $-1 $10 $3 #
plane-surface $-1 -1 $-1 -1.8993435776584597 -0.34550616434713 2 -0.21225108629643399 -0.6119059387325364 0.76191902359098318 -0.058576759801332381 -0.77031527097506436 -0.63496704364383372 forward_v I I I I #
face $-1 -1 $-1 $11 $12 $2 $-1 $13 forward single #
loop $-1 -1 $-1 $-1 $14 $4 #
plane-surface $-1 -1 $-1 -4.7139395277244951 -1.8595248078233979 0 -0.9152049609788877 0.19252196236278163 -0.3540270800484287 0.35569002591177251 -0.027047586873346612 -0.93421252052796389 forward_v I I I I #
coedge $-1 -1 $-1 $15 $16 $17 $18 reversed $5 $-1 #
face $-1 -1 $-1 $19 $20 $2 $-1 $21 forward single #
loop $-1 -1 $-1 $-1 $22 $7 #
plane-surface $-1 -1 $-1 -1.7432419444535392 2.2983491971566998 2 0.9973445351432173 -0.058886394872714735 -0.042851729473322366 0.042734476776907795 -0.0032496398237411763 0.99908118005276214 forward_v I I I I #
coedge $-1 -1 $-1 $23 $24 $25 $26 forward $8 $-1 #
coedge $-1 -1 $-1 $16 $10 $27 $28 forward $5 $-1 #
coedge $-1 -1 $-1 $10 $15 $29 $30 reversed $5 $-1 #
coedge $-1 -1 $-1 $31 $25 $10 $18 forward $20 $-1 #
edge $-1 -1 $-1 $32 0 $33 3.7701727831654939 $17 $34 forward @7 unknown #
face $-1 -1 $-1 $35 $36 $2 $-1 $37 forward single #
loop $-1 -1 $-1 $-1 $31 $11 #
plane-surface $-1 -1 $-1 -1.8993435776584597 -0.34550616434713 2 0.35424919523921139 -0.91480990045388144 0.19398544714470417 -0.016229036731927417 -0.21342038839667235 -0.97682565291016354 forward_v I I I I #
coedge $-1 -1 $-1 $29 $38 $39 $40 reversed $12 $-1 #
coedge $-1 -1 $-1 $24 $14 $41 $42 reversed $8 $-1 #
coedge $-1 -1 $-1 $14 $23 $43 $44 forward $8 $-1 #
coedge $-1 -1 $-1 $17 $31 $14 $26 reversed $20 $-1 #
edge $-1 -1 $-1 $32 0 $45 2.1386001334682128 $14 $46 forward @7 unknown #
coedge $-1 -1 $-1 $47 $48 $15 $28 reversed $49 $-1 #
edge $-1 -1 $-1 $32 0 $50 2.7374750783627975 $15 $51 forward @7 unknown #
coedge $-1 -1 $-1 $38 $22 $16 $30 forward $12 $-1 #
edge $-1 -1 $-1 $33 0 $50 3.140963148546323 $29 $52 forward @7 unknown #
coedge $-1 -1 $-1 $25 $17 $53 $54 reversed $20 $-1 #
vertex $-1 -1 $-1 $26 $55 #
vertex $-1 -1 $-1 $54 $56 #
straight-curve $-1 -1 $-1 -4.7139395277244951 -1.8595248078233979 0 0.74654296021490529 0.40157805240031325 0.53047966632467436 I I #
face $-1 -1 $-1 $57 $49 $2 $-1 $58 forward single #
loop $-1 -1 $-1 $-1 $59 $19 #
plane-surface $-1 -1 $-1 -4.7139395277244951 1.8182590221721908 2 -0.90029791640739398 -0.20794591431152187 0.38239006058428165 -0.39665189696405329 0.030162433186344435 -0.91747343299906914 forward_v I I I I #
coedge $-1 -1 $-1 $22 $29 $60 $61 forward $12 $-1 #
coedge $-1 -1 $-1 $62 $53 $22 $40 forward $63 $-1 #
edge $-1 -1 $-1 $33 0 $64 2.6484597207512501 $39 $65 forward @7 unknown #
coedge $-1 -1 $-1 $53 $62 $23 $42 forward $63 $-1 #
edge $-1 -1 $-1 $66 0 $45 3.6197563775917776 $41 $67 forward @7 unknown #
coedge $-1 -1 $-1 $59 $68 $24 $44 reversed $36 $-1 #
edge $-1 -1 $-1 $66 0 $32 4.1864177885367599 $24 $69 forward @7 unknown #
vertex $-1 -1 $-1 $54 $70 #
straight-curve $-1 -1 $-1 -4.7139395277244951 -1.8595248078233979 0 -0.34842491355310223 0.063383917862424019 0.93519118824544256 I I #
coedge $-1 -1 $-1 $71 $27 $68 $72 reversed $49 $-1 #
coedge $-1 -1 $-1 $27 $71 $73 $74 reversed $49 $-1 #
loop $-1 -1 $-1 $-1 $27 $35 #
vertex $-1 -1 $-1 $30 $75 #
straight-curve $-1 -1 $-1 -4.7139395277244951 -1.8595248078233979 0 0.94477707880540274 -0.32771370335085087 0 I I #
straight-curve $-1 -1 $-1 -1.8993435776584597 -0.34550616434713 2 -0.072682241539031203 -0.76763929572147338 -0.6367473623259875 I I #
coedge $-1 -1 $-1 $39 $41 $31 $54 forward $63 $-1 #
edge $-1 -1 $-1 $45 0 $33 3.8173156952508518 $53 $76 forward @7 unknown #
point $-1 -1 $-1 -4.7139395277244951 -1.8595248078233979 0 #
point $-1 -1 $-1 -1.8993435776584597 -0.34550616434713 2 #
face $-1 -1 $-1 $77 $78 $2 $-1 $79 forward single #
plane-surface $-1 -1 $-1 -2.1276358198862995 -2.7566329035843307 0 0 0 -1 0.075823670745747404 0.99712124185308604 0 forward_v I I I I #
coedge $-1 -1 $-1 $68 $43 $80 $81 reversed $36 $-1 #
coedge $-1 -1 $-1 $73 $82 $38 $61 reversed $83 $-1 #
edge $-1 -1 $-1 $50 0 $64 5.4498259321085127 $38 $84 forward @7 unknown #
coedge $-1 -1 $-1 $41 $39 $85 $86 reversed $63 $-1 #
loop $-1 -1 $-1 $-1 $53 $87 #
vertex $-1 -1 $-1 $86 $88 #
straight-curve $-1 -1 $-1 -1.8993435776584597 -0.34550616434713 2 0.058940535127580275 0.99826149546041998 0 I I #
vertex $-1 -1 $-1 $86 $89 #
straight-curve $-1 -1 $-1 -4.7139395277244951 1.8182590221721908 2 -0.20585406555013996 -0.97858270151095494 0 I I #
coedge $-1 -1 $-1 $43 $59 $47 $72 forward $36 $-1 #
straight-curve $-1 -1 $-1 -4.7139395277244951 1.8182590221721908 2 1.3877787807814457e-017 -0.87850377477042252 -0.47773540554800709 I I #
point $-1 -1 $-1 -5.4590810943528094 -1.7239719526230797 2 #
coedge $-1 -1 $-1 $48 $47 $90 $91 reversed $49 $-1 #
edge $-1 -1 $-1 $92 0 $32 2.567633724072949 $68 $93 forward @7 unknown #
coedge $-1 -1 $-1 $82 $60 $48 $74 forward $83 $-1 #
edge $-1 -1 $-1 $50 0 $94 4.9460245004234666 $73 $95 forward @7 unknown #
point $-1 -1 $-1 -2.1276358198862995 -2.7566329035843307 0 #
straight-curve $-1 -1 $-1 -5.4590810943528094 -1.7239719526230797 2 0.93252374204288202 0.36110866858376633 0 I I #
face $-1 -1 $-1 $87 $83 $2 $-1 $96 forward single #
loop $-1 -1 $-1 $-1 $97 $57 #
plane-surface $-1 -1 $-1 -4.7139395277244951 1.8182590221721908 2 -0.26318198707465013 0.86293276999111279 -0.43137254914389711 0.03462186912272304 0.45529583038369054 0.88966681011133308 forward_v I I I I #
coedge $-1 -1 $-1 $97 $90 $59 $81 forward $78 $-1 #
edge $-1 -1 $-1 $92 0 $66 2.3910080886789973 $80 $98 forward @7 unknown #
coedge $-1 -1 $-1 $60 $73 $99 $100 reversed $83 $-1 #
loop $-1 -1 $-1 $-1 $60 $77 #
straight-curve $-1 -1 $-1 -2.1276358198862995 -2.7566329035843307 0 0.070533239083480248 0.9275492765665786 0.36698419819552092 I I #
coedge $-1 -1 $-1 $99 $101 $62 $86 forward $102 $-1 #
edge $-1 -1 $-1 $66 0 $64 3.0092408855670816 $85 $103 forward @7 unknown #
face $-1 -1 $-1 $104 $63 $2 $-1 $105 forward single #
point $-1 -1 $-1 -1.7432419444535392 2.2983491971566998 2 #
point $-1 -1 $-1 -4.7139395277244951 1.8182590221721908 2 #
coedge $-1 -1 $-1 $80 $97 $71 $91 forward $78 $-1 #
edge $-1 -1 $-1 $94 0 $92 4.6883381143041722 $90 $106 forward @7 unknown #
vertex $-1 -1 $-1 $91 $107 #
straight-curve $-1 -1 $-1 -5.2917840802536293 0.64224229047115067 0 0.22504944810139033 -0.9743473435635055 0 I I #
vertex $-1 -1 $-1 $100 $108 #
straight-curve $-1 -1 $-1 -2.1276358198862995 -2.7566329035843307 0 0.26693459672279263 0.96371464711938482 0 I I #
plane-surface $-1 -1 $-1 -1.7432419444535392 2.2983491971566998 2 0.86559381815832204 -0.23975658922117712 0.43961815236762641 -0.44509782675002491 0.033846386626385921 0.89484207921551284 forward_v I I I I #
coedge $-1 -1 $-1 $90 $80 $101 $109 reversed $78 $-1 #
straight-curve $-1 -1 $-1 -5.2917840802536293 0.64224229047115067 0 0.24167402664387749 0.4918497504334145 0.83646726645118774 I I #
coedge $-1 -1 $-1 $101 $85 $82 $100 forward $102 $-1 #
edge $-1 -1 $-1 $64 0 $94 2.2268911813042807 $99 $110 forward @7 unknown #
coedge $-1 -1 $-1 $85 $99 $97 $109 forward $102 $-1 #
loop $-1 -1 $-1 $-1 $85 $104 #
straight-curve $-1 -1 $-1 -4.7139395277244951 1.8182590221721908 2 0.98719168595608686 0.1595386322467959 0 I I #
face $-1 -1 $-1 $-1 $102 $2 $-1 $111 forward single #
plane-surface $-1 -1 $-1 -5.4590810943528094 -1.7239719526230797 2 0 0 1 -0.075823670745747404 -0.99712124185308604 0 forward_v I I I I #
straight-curve $-1 -1 $-1 -0.80737076448470901 2.0099233524851008 0 -0.95650381999688194 -0.2917198010615189 0 I I #
point $-1 -1 $-1 -5.2917840802536293 0.64224229047115067 0 #
point $-1 -1 $-1 -0.80737076448470901 2.0099233524851008 0 #
edge $-1 -1 $-1 $94 0 $66 4.3929505707935217 $101 $112 forward @7 unknown #
straight-curve $-1 -1 $-1 -1.7432419444535392 2.2983491971566998 2 0.42025905344000414 -0.12951950552997801 -0.89811303614243443 I I #
plane-surface $-1 -1 $-1 -4.7139395277244951 1.8182590221721908 2 -0.15590940046942497 0.96473475883710602 -0.21208277614359863 0.016518332808874978 0.21722478431515085 0.97598183270000038 forward_v I I I I #
straight-curve $-1 -1 $-1 -0.80737076448470901 2.0099233524851008 0 -0.88928129289971092 -0.043629976532672143 0.45527486999215883 I I #
End-of-ACIS-data 
"""


@pytest.fixture(scope="module")
def cube_sat():
    return CUBE777_SAT_700


CUBE777_SAT_700 = """700 0 1 0 
@33 Open Design Alliance ACIS Builder @12 ACIS 32.0 NT @24 Sat Apr 23 14:35:11 2022 
1 9.9999999999999995e-007 1e-010 
body $1 -1 $-1 $2 $-1 $3 #
ref_vt-eye-attrib $-1 -1 $-1 $-1 $0 $4 $-1 #
lump $5 -1 $-1 $-1 $6 $0 #
transform $-1 -1 1 0 0 0 1 0 0 0 1 388.5 388.5 388.5 1 no_rotate no_reflect no_shear #
eye_refinement $-1 -1 @5 grid  1 @3 tri 1 @4 surf 0 @3 adj 0 @4 grad 0 @9 postcheck 0 @4 stol -5 @4 ntol 40 @4 dsil 0 @8 flatness 0 @7 pixarea 0 @4 hmax 0 @6 gridar 0 @5 mgrid 3000 @5 ugrid 0 @5 vgrid 0 @10 end_fields #
ref_vt-eye-attrib $-1 -1 $-1 $-1 $2 $4 $-1 #
shell $7 -1 $-1 $-1 $-1 $8 $-1 $2 #
ref_vt-eye-attrib $-1 -1 $-1 $-1 $6 $4 $-1 #
face $9 -1 $-1 $10 $11 $6 $-1 $12 forward single #
fmesh-eye-attrib $-1 -1 $13 $-1 $8 #
face $14 -1 $-1 $15 $16 $6 $-1 $17 reversed single #
loop $-1 -1 $-1 $-1 $18 $8 #
plane-surface $-1 -1 $-1 0 0 388.5 0 0 1 1 0 0 forward_v I I I I #
ref_vt-eye-attrib $-1 -1 $-1 $9 $8 $4 $-1 #
fmesh-eye-attrib $-1 -1 $19 $-1 $10 #
face $20 -1 $-1 $21 $22 $6 $-1 $23 reversed single #
loop $-1 -1 $-1 $-1 $24 $10 #
plane-surface $-1 -1 $-1 0 0 -388.5 0 0 1 1 0 0 forward_v I I I I #
coedge $-1 -1 $-1 $25 $26 $27 $28 forward $11 $-1 #
ref_vt-eye-attrib $-1 -1 $-1 $14 $10 $4 $-1 #
fmesh-eye-attrib $-1 -1 $29 $-1 $15 #
face $30 -1 $-1 $31 $32 $6 $-1 $33 reversed single #
loop $-1 -1 $-1 $-1 $34 $15 #
plane-surface $-1 -1 $-1 0 -388.5 0 0 1 0 0 0 1 forward_v I I I I #
coedge $-1 -1 $-1 $35 $36 $37 $38 forward $16 $-1 #
coedge $-1 -1 $-1 $39 $18 $40 $41 forward $11 $-1 #
coedge $-1 -1 $-1 $18 $39 $42 $43 forward $11 $-1 #
coedge $-1 -1 $-1 $44 $45 $18 $28 reversed $46 $-1 #
edge $47 -1 $-1 $48 -388.5 $49 388.5 $27 $50 forward @7 unknown #
ref_vt-eye-attrib $-1 -1 $-1 $20 $15 $4 $-1 #
fmesh-eye-attrib $-1 -1 $51 $-1 $21 #
face $52 -1 $-1 $53 $54 $6 $-1 $55 reversed single #
loop $-1 -1 $-1 $-1 $56 $21 #
plane-surface $-1 -1 $-1 -388.5 0 0 1 0 0 0 0 -1 forward_v I I I I #
coedge $-1 -1 $-1 $57 $42 $58 $59 forward $22 $-1 #
coedge $-1 -1 $-1 $60 $24 $57 $61 forward $16 $-1 #
coedge $-1 -1 $-1 $24 $60 $62 $63 forward $16 $-1 #
coedge $-1 -1 $-1 $45 $44 $24 $38 reversed $46 $-1 #
edge $64 -1 $-1 $65 -388.5 $66 388.5 $37 $67 forward @7 unknown #
coedge $-1 -1 $-1 $26 $25 $68 $69 forward $11 $-1 #
coedge $-1 -1 $-1 $70 $71 $25 $41 reversed $54 $-1 #
edge $72 -1 $-1 $49 -388.5 $73 388.5 $40 $74 forward @7 unknown #
coedge $-1 -1 $-1 $34 $75 $26 $43 reversed $22 $-1 #
edge $76 -1 $-1 $77 -388.5 $48 388.5 $42 $78 forward @7 unknown #
coedge $-1 -1 $-1 $37 $27 $75 $79 forward $46 $-1 #
coedge $-1 -1 $-1 $27 $37 $70 $80 reversed $46 $-1 #
loop $-1 -1 $-1 $-1 $44 $53 #
ptlist-eye-attrib $-1 -1 $-1 $-1 $28 #
vertex $-1 -1 $-1 $28 $81 #
vertex $-1 -1 $-1 $28 $82 #
straight-curve $-1 -1 $-1 388.5 0 388.5 0 1 0 I I #
ref_vt-eye-attrib $-1 -1 $-1 $30 $21 $4 $-1 #
fmesh-eye-attrib $-1 -1 $83 $-1 $31 #
face $84 -1 $-1 $-1 $46 $6 $-1 $85 reversed single #
loop $-1 -1 $-1 $-1 $70 $31 #
plane-surface $-1 -1 $-1 0 388.5 0 0 -1 0 0 0 -1 forward_v I I I I #
coedge $-1 -1 $-1 $86 $68 $71 $87 forward $32 $-1 #
coedge $-1 -1 $-1 $75 $34 $35 $61 reversed $22 $-1 #
coedge $-1 -1 $-1 $68 $86 $34 $59 reversed $32 $-1 #
edge $88 -1 $-1 $77 -388.5 $89 388.5 $58 $90 forward @7 unknown #
coedge $-1 -1 $-1 $36 $35 $86 $91 forward $16 $-1 #
edge $92 -1 $-1 $66 -388.5 $89 388.5 $57 $93 forward @7 unknown #
coedge $-1 -1 $-1 $71 $70 $36 $63 reversed $54 $-1 #
edge $94 -1 $-1 $95 -388.5 $65 388.5 $62 $96 forward @7 unknown #
ptlist-eye-attrib $-1 -1 $-1 $-1 $38 #
vertex $-1 -1 $-1 $38 $97 #
vertex $-1 -1 $-1 $79 $98 #
straight-curve $-1 -1 $-1 388.5 0 -388.5 0 -1 0 I I #
coedge $-1 -1 $-1 $56 $58 $39 $69 reversed $32 $-1 #
edge $99 -1 $-1 $73 -388.5 $77 388.5 $68 $100 forward @7 unknown #
coedge $-1 -1 $-1 $62 $40 $45 $80 forward $54 $-1 #
coedge $-1 -1 $-1 $40 $62 $56 $87 reversed $54 $-1 #
ptlist-eye-attrib $-1 -1 $-1 $-1 $41 #
vertex $-1 -1 $-1 $41 $101 #
straight-curve $-1 -1 $-1 0 388.5 388.5 -1 0 0 I I #
coedge $-1 -1 $-1 $42 $57 $44 $79 reversed $22 $-1 #
ptlist-eye-attrib $-1 -1 $-1 $-1 $43 #
vertex $-1 -1 $-1 $69 $102 #
straight-curve $-1 -1 $-1 0 -388.5 388.5 1 0 0 I I #
edge $103 -1 $-1 $48 -388.5 $66 388.5 $44 $104 forward @7 unknown #
edge $105 -1 $-1 $49 -388.5 $65 388.5 $45 $106 forward @7 unknown #
point $-1 -1 $-1 388.5 -388.5 388.5 #
point $-1 -1 $-1 388.5 388.5 388.5 #
ref_vt-eye-attrib $-1 -1 $-1 $52 $31 $4 $-1 #
fmesh-eye-attrib $-1 -1 $107 $-1 $53 #
plane-surface $-1 -1 $-1 388.5 0 0 -1 0 0 0 0 1 forward_v I I I I #
coedge $-1 -1 $-1 $58 $56 $60 $91 reversed $32 $-1 #
edge $108 -1 $-1 $73 -388.5 $95 388.5 $71 $109 forward @7 unknown #
ptlist-eye-attrib $-1 -1 $-1 $-1 $59 #
vertex $-1 -1 $-1 $91 $110 #
straight-curve $-1 -1 $-1 -388.5 -388.5 0 0 0 -1 I I #
edge $111 -1 $-1 $89 -388.5 $95 388.5 $86 $112 forward @7 unknown #
ptlist-eye-attrib $-1 -1 $-1 $-1 $61 #
straight-curve $-1 -1 $-1 0 -388.5 -388.5 -1 0 0 I I #
ptlist-eye-attrib $-1 -1 $-1 $-1 $63 #
vertex $-1 -1 $-1 $63 $113 #
straight-curve $-1 -1 $-1 0 388.5 -388.5 1 0 0 I I #
point $-1 -1 $-1 388.5 388.5 -388.5 #
point $-1 -1 $-1 388.5 -388.5 -388.5 #
ptlist-eye-attrib $-1 -1 $-1 $-1 $69 #
straight-curve $-1 -1 $-1 -388.5 0 388.5 0 -1 0 I I #
point $-1 -1 $-1 -388.5 388.5 388.5 #
point $-1 -1 $-1 -388.5 -388.5 388.5 #
ptlist-eye-attrib $-1 -1 $-1 $-1 $79 #
straight-curve $-1 -1 $-1 388.5 -388.5 0 0 0 -1 I I #
ptlist-eye-attrib $-1 -1 $-1 $-1 $80 #
straight-curve $-1 -1 $-1 388.5 388.5 0 0 0 -1 I I #
ref_vt-eye-attrib $-1 -1 $-1 $84 $53 $4 $-1 #
ptlist-eye-attrib $-1 -1 $-1 $-1 $87 #
straight-curve $-1 -1 $-1 -388.5 388.5 0 0 0 -1 I I #
point $-1 -1 $-1 -388.5 -388.5 -388.5 #
ptlist-eye-attrib $-1 -1 $-1 $-1 $91 #
straight-curve $-1 -1 $-1 -388.5 0 -388.5 0 1 0 I I #
point $-1 -1 $-1 -388.5 388.5 -388.5 #
End-of-ACIS-data 
"""

CUBE777_SAT_400 = """400 0 1 0 
33 Open Design Alliance ACIS Builder 12 ACIS 32.0 NT 24 Thu May 12 15:03:31 2022 
1 9.9999999999999995e-007 1e-010 
body $1 $2 $-1 $3 #
ref_vt-eye-attrib $-1 $-1 $-1 $0 $4 $-1 #
lump $5 $-1 $6 $0 #
transform $-1 1 0 0 0 1 0 0 0 1 388.5 388.5 388.5 1 no_rotate no_reflect no_shear #
eye_refinement $-1 5 grid  1 3 tri 1 4 surf 0 3 adj 0 4 grad 0 9 postcheck 0 4 stol -5 4 ntol 40 4 dsil 0 8 flatness 0 7 pixarea 0 4 hmax 0 6 gridar 0 5 mgrid 3000 5 ugrid 0 5 vgrid 0 10 end_fields #
ref_vt-eye-attrib $-1 $-1 $-1 $2 $4 $-1 #
shell $7 $-1 $-1 $8 $-1 $2 #
ref_vt-eye-attrib $-1 $-1 $-1 $6 $4 $-1 #
face $9 $10 $11 $6 $-1 $12 forward single #
fmesh-eye-attrib $-1 $13 $-1 $8 #
face $14 $15 $16 $6 $-1 $17 reversed single #
loop $-1 $-1 $18 $8 #
plane-surface $-1 0 0 388.5 0 0 1 1 0 0 forward_v I I I I #
ref_vt-eye-attrib $-1 $-1 $9 $8 $4 $-1 #
fmesh-eye-attrib $-1 $19 $-1 $10 #
face $20 $21 $22 $6 $-1 $23 reversed single #
loop $-1 $-1 $24 $10 #
plane-surface $-1 0 0 -388.5 0 0 1 1 0 0 forward_v I I I I #
coedge $-1 $25 $26 $27 $28 forward $11 $-1 #
ref_vt-eye-attrib $-1 $-1 $14 $10 $4 $-1 #
fmesh-eye-attrib $-1 $29 $-1 $15 #
face $30 $31 $32 $6 $-1 $33 reversed single #
loop $-1 $-1 $34 $15 #
plane-surface $-1 0 -388.5 0 0 1 0 0 0 1 forward_v I I I I #
coedge $-1 $35 $36 $37 $38 forward $16 $-1 #
coedge $-1 $39 $18 $40 $41 forward $11 $-1 #
coedge $-1 $18 $39 $42 $43 forward $11 $-1 #
coedge $-1 $44 $45 $18 $28 reversed $46 $-1 #
edge $47 $48 $49 $27 $50 forward #
ref_vt-eye-attrib $-1 $-1 $20 $15 $4 $-1 #
fmesh-eye-attrib $-1 $51 $-1 $21 #
face $52 $53 $54 $6 $-1 $55 reversed single #
loop $-1 $-1 $56 $21 #
plane-surface $-1 -388.5 0 0 1 0 0 0 0 -1 forward_v I I I I #
coedge $-1 $57 $42 $58 $59 forward $22 $-1 #
coedge $-1 $60 $24 $57 $61 forward $16 $-1 #
coedge $-1 $24 $60 $62 $63 forward $16 $-1 #
coedge $-1 $45 $44 $24 $38 reversed $46 $-1 #
edge $64 $65 $66 $37 $67 forward #
coedge $-1 $26 $25 $68 $69 forward $11 $-1 #
coedge $-1 $70 $71 $25 $41 reversed $54 $-1 #
edge $72 $49 $73 $40 $74 forward #
coedge $-1 $34 $75 $26 $43 reversed $22 $-1 #
edge $76 $77 $48 $42 $78 forward #
coedge $-1 $37 $27 $75 $79 forward $46 $-1 #
coedge $-1 $27 $37 $70 $80 reversed $46 $-1 #
loop $-1 $-1 $44 $53 #
ptlist-eye-attrib $-1 $-1 $-1 $28 #
vertex $-1 $28 $81 #
vertex $-1 $28 $82 #
straight-curve $-1 388.5 0 388.5 0 1 0 I I #
ref_vt-eye-attrib $-1 $-1 $30 $21 $4 $-1 #
fmesh-eye-attrib $-1 $83 $-1 $31 #
face $84 $-1 $46 $6 $-1 $85 reversed single #
loop $-1 $-1 $70 $31 #
plane-surface $-1 0 388.5 0 0 -1 0 0 0 -1 forward_v I I I I #
coedge $-1 $86 $68 $71 $87 forward $32 $-1 #
coedge $-1 $75 $34 $35 $61 reversed $22 $-1 #
coedge $-1 $68 $86 $34 $59 reversed $32 $-1 #
edge $88 $77 $89 $58 $90 forward #
coedge $-1 $36 $35 $86 $91 forward $16 $-1 #
edge $92 $66 $89 $57 $93 forward #
coedge $-1 $71 $70 $36 $63 reversed $54 $-1 #
edge $94 $95 $65 $62 $96 forward #
ptlist-eye-attrib $-1 $-1 $-1 $38 #
vertex $-1 $38 $97 #
vertex $-1 $79 $98 #
straight-curve $-1 388.5 0 -388.5 0 -1 0 I I #
coedge $-1 $56 $58 $39 $69 reversed $32 $-1 #
edge $99 $73 $77 $68 $100 forward #
coedge $-1 $62 $40 $45 $80 forward $54 $-1 #
coedge $-1 $40 $62 $56 $87 reversed $54 $-1 #
ptlist-eye-attrib $-1 $-1 $-1 $41 #
vertex $-1 $41 $101 #
straight-curve $-1 0 388.5 388.5 -1 0 0 I I #
coedge $-1 $42 $57 $44 $79 reversed $22 $-1 #
ptlist-eye-attrib $-1 $-1 $-1 $43 #
vertex $-1 $69 $102 #
straight-curve $-1 0 -388.5 388.5 1 0 0 I I #
edge $103 $48 $66 $44 $104 forward #
edge $105 $49 $65 $45 $106 forward #
point $-1 388.5 -388.5 388.5 #
point $-1 388.5 388.5 388.5 #
ref_vt-eye-attrib $-1 $-1 $52 $31 $4 $-1 #
fmesh-eye-attrib $-1 $107 $-1 $53 #
plane-surface $-1 388.5 0 0 -1 0 0 0 0 1 forward_v I I I I #
coedge $-1 $58 $56 $60 $91 reversed $32 $-1 #
edge $108 $73 $95 $71 $109 forward #
ptlist-eye-attrib $-1 $-1 $-1 $59 #
vertex $-1 $91 $110 #
straight-curve $-1 -388.5 -388.5 0 0 0 -1 I I #
edge $111 $89 $95 $86 $112 forward #
ptlist-eye-attrib $-1 $-1 $-1 $61 #
straight-curve $-1 0 -388.5 -388.5 -1 0 0 I I #
ptlist-eye-attrib $-1 $-1 $-1 $63 #
vertex $-1 $63 $113 #
straight-curve $-1 0 388.5 -388.5 1 0 0 I I #
point $-1 388.5 388.5 -388.5 #
point $-1 388.5 -388.5 -388.5 #
ptlist-eye-attrib $-1 $-1 $-1 $69 #
straight-curve $-1 -388.5 0 388.5 0 -1 0 I I #
point $-1 -388.5 388.5 388.5 #
point $-1 -388.5 -388.5 388.5 #
ptlist-eye-attrib $-1 $-1 $-1 $79 #
straight-curve $-1 388.5 -388.5 0 0 0 -1 I I #
ptlist-eye-attrib $-1 $-1 $-1 $80 #
straight-curve $-1 388.5 388.5 0 0 0 -1 I I #
ref_vt-eye-attrib $-1 $-1 $84 $53 $4 $-1 #
ptlist-eye-attrib $-1 $-1 $-1 $87 #
straight-curve $-1 -388.5 388.5 0 0 0 -1 I I #
point $-1 -388.5 -388.5 -388.5 #
ptlist-eye-attrib $-1 $-1 $-1 $91 #
straight-curve $-1 -388.5 0 -388.5 0 1 0 I I #
point $-1 -388.5 388.5 -388.5 #
End-of-ACIS-data 
"""


@pytest.fixture(
    scope="module",
    params=[
        CUBE777_SAT_400,
        CUBE777_SAT_700,
        CUBE777_SAB_R2013,
        CUBE777_SAB_R2018,
    ],
    ids=["SAT_400", "SAT_700", "SAB_R2013", "SAB_R2018"],
)
def any_cube(request):
    yield request.param
